/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.RangeOfValues;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class GearDAOAbstract<E extends Gear> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Gear.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Metier> list = getContext()
                                                    .getDAO(Metier.class)
                                                    .findAllByProperties(Metier.GEAR, entity);
                        //                            .findAllByProperties("gear", entity);
                                            for (Metier item : list) {
                                                item.setGear(null);
                        
                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Gear.NAME, v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Gear.NAME, v);
        return result;
    }

    /**
     * findByEffortUnit :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut effortUnit le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByEffortUnit(String v) throws TopiaException {
        E result = findByProperty(Gear.EFFORT_UNIT, v);
        return result;
    }

    /**
     * findAllByEffortUnit :
     * Retourne les éléments ayant comme valeur pour l'attribut effortUnit le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByEffortUnit(String v) throws TopiaException {
        List<E> result = findAllByProperty(Gear.EFFORT_UNIT, v);
        return result;
    }

    /**
     * findByStandardisationFactor :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut standardisationFactor le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByStandardisationFactor(double v) throws TopiaException {
        E result = findByProperty(Gear.STANDARDISATION_FACTOR, v);
        return result;
    }

    /**
     * findAllByStandardisationFactor :
     * Retourne les éléments ayant comme valeur pour l'attribut standardisationFactor le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByStandardisationFactor(double v) throws TopiaException {
        List<E> result = findAllByProperty(Gear.STANDARDISATION_FACTOR, v);
        return result;
    }

    /**
     * findByParameterName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut parameterName le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByParameterName(String v) throws TopiaException {
        E result = findByProperty(Gear.PARAMETER_NAME, v);
        return result;
    }

    /**
     * findAllByParameterName :
     * Retourne les éléments ayant comme valeur pour l'attribut parameterName le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByParameterName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Gear.PARAMETER_NAME, v);
        return result;
    }

    /**
     * findByCost :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut cost le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCost(double v) throws TopiaException {
        E result = findByProperty(Gear.COST, v);
        return result;
    }

    /**
     * findAllByCost :
     * Retourne les éléments ayant comme valeur pour l'attribut cost le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCost(double v) throws TopiaException {
        List<E> result = findAllByProperty(Gear.COST, v);
        return result;
    }

    /**
     * findByPossibleValue :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut possibleValue le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPossibleValue(RangeOfValues v) throws TopiaException {
        E result = findByProperty(Gear.POSSIBLE_VALUE, v);
        return result;
    }

    /**
     * findAllByPossibleValue :
     * Retourne les éléments ayant comme valeur pour l'attribut possibleValue le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPossibleValue(RangeOfValues v) throws TopiaException {
        List<E> result = findAllByProperty(Gear.POSSIBLE_VALUE, v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(Gear.COMMENT, v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Gear.COMMENT, v);
        return result;
    }

    /**
     * findContainsPopulation :
     * Retourne le premier élément trouvé dont l'attribut population contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsPopulation(Population... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(Gear.POPULATION, Arrays.asList(v));
        E result = findContainsProperties("population", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsPopulation :
     * Retourne les éléments trouvé dont l'attribut population contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsPopulation(Population... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(Gear.POPULATION, Arrays.asList(v));
        List<E> results = findAllContainsProperties("population", Arrays.asList(v));
        return results;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Metier.class) {
            MetierDAO dao = (MetierDAO)
                getContext().getDAO(Metier.class);
            tmp = dao.findAllByGear(entity);
//            tmp = dao.findAllByProperties(Metier.GEAR, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);
        
        List<? extends TopiaEntity> list;

        list = findUsages(Metier.class, entity);
        if (!list.isEmpty()) {
            result.put(Metier.class, list);
        }

        return result;
    }


} //GearDAOAbstract<E extends Gear>
