/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.RangeOfValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class GearAbstract extends TopiaEntityAbstract implements Gear {

    protected String name;
    protected String effortUnit;
    protected double standardisationFactor;
    protected String parameterName;
    /**
     * <p>Co&ucirc;t d'achat de l'engin</p>


     */
    protected double cost;
    protected RangeOfValues possibleValue;
    protected String comment;
    protected Collection<Selectivity> populationSelectivity;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Gear.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Gear.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, EFFORT_UNIT, String.class, effortUnit);
        visitor.visit(this, STANDARDISATION_FACTOR, double.class, standardisationFactor);
        visitor.visit(this, PARAMETER_NAME, String.class, parameterName);
        visitor.visit(this, COST, double.class, cost);
        visitor.visit(this, POSSIBLE_VALUE, RangeOfValues.class, possibleValue);
        visitor.visit(this, COMMENT, String.class, comment);
        visitor.visit(this, POPULATION_SELECTIVITY, java.util.Collection.class, Selectivity.class, populationSelectivity);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        {
            org.nuiton.topia.persistence.TopiaDAO<Selectivity> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(Selectivity.class);
            List<Selectivity> findAllByProperties = dao.findAllByProperties("gear", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite(NAME, _oldValue, value);
        this.name = value;
        fireOnPostWrite(NAME, _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
}

    /**
     * setEffortUnit :
     * @param value 
     */

    public void setEffortUnit(String value) {
        String _oldValue = this.effortUnit;
        fireOnPreWrite(EFFORT_UNIT, _oldValue, value);
        this.effortUnit = value;
        fireOnPostWrite(EFFORT_UNIT, _oldValue, value);
}

    /**
     * getEffortUnit :
     * @return String 
     */

    public String getEffortUnit() {
        fireOnPreRead(EFFORT_UNIT, effortUnit);
        String result = this.effortUnit;
        fireOnPostRead(EFFORT_UNIT, effortUnit);
        return result;
}

    /**
     * setStandardisationFactor :
     * @param value 
     */

    public void setStandardisationFactor(double value) {
        double _oldValue = this.standardisationFactor;
        fireOnPreWrite(STANDARDISATION_FACTOR, _oldValue, value);
        this.standardisationFactor = value;
        fireOnPostWrite(STANDARDISATION_FACTOR, _oldValue, value);
}

    /**
     * getStandardisationFactor :
     * @return double 
     */

    public double getStandardisationFactor() {
        fireOnPreRead(STANDARDISATION_FACTOR, standardisationFactor);
        double result = this.standardisationFactor;
        fireOnPostRead(STANDARDISATION_FACTOR, standardisationFactor);
        return result;
}

    /**
     * setParameterName :
     * @param value 
     */

    public void setParameterName(String value) {
        String _oldValue = this.parameterName;
        fireOnPreWrite(PARAMETER_NAME, _oldValue, value);
        this.parameterName = value;
        fireOnPostWrite(PARAMETER_NAME, _oldValue, value);
}

    /**
     * getParameterName :
     * @return String 
     */

    public String getParameterName() {
        fireOnPreRead(PARAMETER_NAME, parameterName);
        String result = this.parameterName;
        fireOnPostRead(PARAMETER_NAME, parameterName);
        return result;
}

    /**
     * setCost :
     * @param value 
     */

    public void setCost(double value) {
        double _oldValue = this.cost;
        fireOnPreWrite(COST, _oldValue, value);
        this.cost = value;
        fireOnPostWrite(COST, _oldValue, value);
}

    /**
     * getCost :
     * @return double 
     */

    public double getCost() {
        fireOnPreRead(COST, cost);
        double result = this.cost;
        fireOnPostRead(COST, cost);
        return result;
}

    /**
     * setPossibleValue :
     * @param value 
     */

    public void setPossibleValue(RangeOfValues value) {
        RangeOfValues _oldValue = this.possibleValue;
        fireOnPreWrite(POSSIBLE_VALUE, _oldValue, value);
        this.possibleValue = value;
        fireOnPostWrite(POSSIBLE_VALUE, _oldValue, value);
}

    /**
     * getPossibleValue :
     * @return RangeOfValues 
     */

    public RangeOfValues getPossibleValue() {
        fireOnPreRead(POSSIBLE_VALUE, possibleValue);
        RangeOfValues result = this.possibleValue;
        fireOnPostRead(POSSIBLE_VALUE, possibleValue);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite(COMMENT, _oldValue, value);
        this.comment = value;
        fireOnPostWrite(COMMENT, _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead(COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(COMMENT, comment);
        return result;
}

    /**
     * addPopulationSelectivity :
     * @param value 
     */

    public void addPopulationSelectivity(Selectivity value) {
        fireOnPreWrite(POPULATION_SELECTIVITY, null, value);
        if (this.populationSelectivity == null) {
            this.populationSelectivity = new ArrayList<fr.ifremer.isisfish.entities.Selectivity>();
        }
        this.populationSelectivity.add(value);
        fireOnPostWrite(POPULATION_SELECTIVITY, this.populationSelectivity.size(), null, value);
}

    /**
     * getPopulationSelectivityByTopiaId :
     * @param topiaId 
     * @return Selectivity 
     */

    public Selectivity getPopulationSelectivityByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(populationSelectivity, topiaId);
}

    /**
     * addAllPopulationSelectivity :
     * @param values 
     */

    public void addAllPopulationSelectivity(Collection<Selectivity> values) {
        if (values == null) {
            return;
        }
        for (fr.ifremer.isisfish.entities.Selectivity item : values) {
            addPopulationSelectivity(item);
        }
}

    /**
     * setPopulationSelectivity :
     * @param values 
     */

    public void setPopulationSelectivity(Collection<Selectivity> values) {
//        clearPopulationSelectivity();
//        addAllPopulationSelectivity(values);
// FIXME
        Collection<fr.ifremer.isisfish.entities.Selectivity> _oldValue = populationSelectivity;
        fireOnPreWrite(POPULATION_SELECTIVITY, _oldValue, values);
        populationSelectivity = values;
        fireOnPostWrite(POPULATION_SELECTIVITY, _oldValue, values);
}

    /**
     * removePopulationSelectivity :
     * @param value 
     */

    public void removePopulationSelectivity(Selectivity value) {
        fireOnPreWrite(POPULATION_SELECTIVITY, value, null);
        if ((this.populationSelectivity == null) || (!this.populationSelectivity.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite(POPULATION_SELECTIVITY, this.populationSelectivity.size()+1, value, null);
}

    /**
     * clearPopulationSelectivity :
     */

    public void clearPopulationSelectivity() {
        if (this.populationSelectivity == null) {
            return;
        }
        Collection<fr.ifremer.isisfish.entities.Selectivity> _oldValue = new ArrayList<fr.ifremer.isisfish.entities.Selectivity>(this.populationSelectivity);
        fireOnPreWrite(POPULATION_SELECTIVITY, _oldValue, null);
        this.populationSelectivity.clear();
        fireOnPostWrite(POPULATION_SELECTIVITY, _oldValue, null);
}

    /**
     * getPopulationSelectivity :
     * @return Collection<Selectivity> 
     */

    public Collection<Selectivity> getPopulationSelectivity() {
        return populationSelectivity;
}

    /**
     * getPopulationSelectivity :
     * @param value 
     * @return Selectivity 
     */

    public Selectivity getPopulationSelectivity(Population value) {
        if (value == null || populationSelectivity == null) {
            return null;
        }
        for (fr.ifremer.isisfish.entities.Selectivity item : populationSelectivity) {
            if (value.equals(item.getPopulation())) {
                return item;
            }
        }
        return null;
}

    /**
     * sizePopulationSelectivity :
     * @return int 
     */

    public int sizePopulationSelectivity() {
        if (populationSelectivity == null) {
            return 0;
        }
        return populationSelectivity.size();
}

    /**
     * isPopulationSelectivityEmpty :
     * @return boolean 
     */

    public boolean isPopulationSelectivityEmpty() {
        int size = sizePopulationSelectivity();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NAME, this.name).
            append(EFFORT_UNIT, this.effortUnit).
            append(STANDARDISATION_FACTOR, this.standardisationFactor).
            append(PARAMETER_NAME, this.parameterName).
            append(COST, this.cost).
            append(POSSIBLE_VALUE, this.possibleValue).
            append(COMMENT, this.comment).
         toString();
        return result;
}


} //GearAbstract
