/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.TimeUnit;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class EffortDescriptionAbstract extends TopiaEntityAbstract implements EffortDescription {

    /**
     * <p>Nombre d'op&eacute;ration de p&ecirc;che par jour</p>


     */
    protected int fishingOperation;
    protected TimeUnit fishingOperationDuration;
    protected int gearsNumberPerOperation;
    /**
     * <p>Taille de l'&eacute;quipage pour le m&eacute;tier. Ne peut-&ecirc;tre inf&eacute;rieur &agrave; VesselType.minCrewSize.</p>


     */
    protected int crewSize;
    /**
     * <p>Co&ucirc;t de fonctionnement li&eacute; &agrave; une op&eacute;ration de p&ecirc;che: carburant, huile, app&acirc;t, glace (hors transport sur zone)</p>


     */
    protected double unitCostOfFishing;
    /**
     * <p>Salaire fixe pour l'ensemble de l'&eacute;quipage pour un mois</p>


     */
    protected double fixedCrewSalary;
    /**
     * <p>Taux de part de l'&eacute;quipage</p>


     */
    protected double crewShareRate;
    /**
     * <p>Frais de vivres pour l'ensemble de l'&eacute;quipage par jour.</p>


     */
    protected double crewFoodCost;
    /**
     * <p>Co&ucirc;t de maintenance et de r&eacute;paration par jour d'utilisation</p>


     */
    protected double repairAndMaintenanceGearCost;
    /**
     * <p>autres co&ucirc;ts par jour</p>


     */
    protected double otherRunningCost;
    protected double landingCosts;
    public SetOfVessels setOfVessels;
    public Metier possibleMetiers;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(EffortDescription.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(EffortDescription.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, FISHING_OPERATION, int.class, fishingOperation);
        visitor.visit(this, FISHING_OPERATION_DURATION, TimeUnit.class, fishingOperationDuration);
        visitor.visit(this, GEARS_NUMBER_PER_OPERATION, int.class, gearsNumberPerOperation);
        visitor.visit(this, CREW_SIZE, int.class, crewSize);
        visitor.visit(this, UNIT_COST_OF_FISHING, double.class, unitCostOfFishing);
        visitor.visit(this, FIXED_CREW_SALARY, double.class, fixedCrewSalary);
        visitor.visit(this, CREW_SHARE_RATE, double.class, crewShareRate);
        visitor.visit(this, CREW_FOOD_COST, double.class, crewFoodCost);
        visitor.visit(this, REPAIR_AND_MAINTENANCE_GEAR_COST, double.class, repairAndMaintenanceGearCost);
        visitor.visit(this, OTHER_RUNNING_COST, double.class, otherRunningCost);
        visitor.visit(this, LANDING_COSTS, double.class, landingCosts);
        visitor.visit(this, SET_OF_VESSELS, SetOfVessels.class, setOfVessels);
        visitor.visit(this, POSSIBLE_METIERS, Metier.class, possibleMetiers);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setFishingOperation :
     * @param value 
     */

    public void setFishingOperation(int value) {
        int _oldValue = this.fishingOperation;
        fireOnPreWrite(FISHING_OPERATION, _oldValue, value);
        this.fishingOperation = value;
        fireOnPostWrite(FISHING_OPERATION, _oldValue, value);
}

    /**
     * getFishingOperation :
     * @return int 
     */

    public int getFishingOperation() {
        fireOnPreRead(FISHING_OPERATION, fishingOperation);
        int result = this.fishingOperation;
        fireOnPostRead(FISHING_OPERATION, fishingOperation);
        return result;
}

    /**
     * setFishingOperationDuration :
     * @param value 
     */

    public void setFishingOperationDuration(TimeUnit value) {
        TimeUnit _oldValue = this.fishingOperationDuration;
        fireOnPreWrite(FISHING_OPERATION_DURATION, _oldValue, value);
        this.fishingOperationDuration = value;
        fireOnPostWrite(FISHING_OPERATION_DURATION, _oldValue, value);
}

    /**
     * getFishingOperationDuration :
     * @return TimeUnit 
     */

    public TimeUnit getFishingOperationDuration() {
        fireOnPreRead(FISHING_OPERATION_DURATION, fishingOperationDuration);
        TimeUnit result = this.fishingOperationDuration;
        fireOnPostRead(FISHING_OPERATION_DURATION, fishingOperationDuration);
        return result;
}

    /**
     * setGearsNumberPerOperation :
     * @param value 
     */

    public void setGearsNumberPerOperation(int value) {
        int _oldValue = this.gearsNumberPerOperation;
        fireOnPreWrite(GEARS_NUMBER_PER_OPERATION, _oldValue, value);
        this.gearsNumberPerOperation = value;
        fireOnPostWrite(GEARS_NUMBER_PER_OPERATION, _oldValue, value);
}

    /**
     * getGearsNumberPerOperation :
     * @return int 
     */

    public int getGearsNumberPerOperation() {
        fireOnPreRead(GEARS_NUMBER_PER_OPERATION, gearsNumberPerOperation);
        int result = this.gearsNumberPerOperation;
        fireOnPostRead(GEARS_NUMBER_PER_OPERATION, gearsNumberPerOperation);
        return result;
}

    /**
     * setCrewSize :
     * @param value 
     */

    public void setCrewSize(int value) {
        int _oldValue = this.crewSize;
        fireOnPreWrite(CREW_SIZE, _oldValue, value);
        this.crewSize = value;
        fireOnPostWrite(CREW_SIZE, _oldValue, value);
}

    /**
     * getCrewSize :
     * @return int 
     */

    public int getCrewSize() {
        fireOnPreRead(CREW_SIZE, crewSize);
        int result = this.crewSize;
        fireOnPostRead(CREW_SIZE, crewSize);
        return result;
}

    /**
     * setUnitCostOfFishing :
     * @param value 
     */

    public void setUnitCostOfFishing(double value) {
        double _oldValue = this.unitCostOfFishing;
        fireOnPreWrite(UNIT_COST_OF_FISHING, _oldValue, value);
        this.unitCostOfFishing = value;
        fireOnPostWrite(UNIT_COST_OF_FISHING, _oldValue, value);
}

    /**
     * getUnitCostOfFishing :
     * @return double 
     */

    public double getUnitCostOfFishing() {
        fireOnPreRead(UNIT_COST_OF_FISHING, unitCostOfFishing);
        double result = this.unitCostOfFishing;
        fireOnPostRead(UNIT_COST_OF_FISHING, unitCostOfFishing);
        return result;
}

    /**
     * setFixedCrewSalary :
     * @param value 
     */

    public void setFixedCrewSalary(double value) {
        double _oldValue = this.fixedCrewSalary;
        fireOnPreWrite(FIXED_CREW_SALARY, _oldValue, value);
        this.fixedCrewSalary = value;
        fireOnPostWrite(FIXED_CREW_SALARY, _oldValue, value);
}

    /**
     * getFixedCrewSalary :
     * @return double 
     */

    public double getFixedCrewSalary() {
        fireOnPreRead(FIXED_CREW_SALARY, fixedCrewSalary);
        double result = this.fixedCrewSalary;
        fireOnPostRead(FIXED_CREW_SALARY, fixedCrewSalary);
        return result;
}

    /**
     * setCrewShareRate :
     * @param value 
     */

    public void setCrewShareRate(double value) {
        double _oldValue = this.crewShareRate;
        fireOnPreWrite(CREW_SHARE_RATE, _oldValue, value);
        this.crewShareRate = value;
        fireOnPostWrite(CREW_SHARE_RATE, _oldValue, value);
}

    /**
     * getCrewShareRate :
     * @return double 
     */

    public double getCrewShareRate() {
        fireOnPreRead(CREW_SHARE_RATE, crewShareRate);
        double result = this.crewShareRate;
        fireOnPostRead(CREW_SHARE_RATE, crewShareRate);
        return result;
}

    /**
     * setCrewFoodCost :
     * @param value 
     */

    public void setCrewFoodCost(double value) {
        double _oldValue = this.crewFoodCost;
        fireOnPreWrite(CREW_FOOD_COST, _oldValue, value);
        this.crewFoodCost = value;
        fireOnPostWrite(CREW_FOOD_COST, _oldValue, value);
}

    /**
     * getCrewFoodCost :
     * @return double 
     */

    public double getCrewFoodCost() {
        fireOnPreRead(CREW_FOOD_COST, crewFoodCost);
        double result = this.crewFoodCost;
        fireOnPostRead(CREW_FOOD_COST, crewFoodCost);
        return result;
}

    /**
     * setRepairAndMaintenanceGearCost :
     * @param value 
     */

    public void setRepairAndMaintenanceGearCost(double value) {
        double _oldValue = this.repairAndMaintenanceGearCost;
        fireOnPreWrite(REPAIR_AND_MAINTENANCE_GEAR_COST, _oldValue, value);
        this.repairAndMaintenanceGearCost = value;
        fireOnPostWrite(REPAIR_AND_MAINTENANCE_GEAR_COST, _oldValue, value);
}

    /**
     * getRepairAndMaintenanceGearCost :
     * @return double 
     */

    public double getRepairAndMaintenanceGearCost() {
        fireOnPreRead(REPAIR_AND_MAINTENANCE_GEAR_COST, repairAndMaintenanceGearCost);
        double result = this.repairAndMaintenanceGearCost;
        fireOnPostRead(REPAIR_AND_MAINTENANCE_GEAR_COST, repairAndMaintenanceGearCost);
        return result;
}

    /**
     * setOtherRunningCost :
     * @param value 
     */

    public void setOtherRunningCost(double value) {
        double _oldValue = this.otherRunningCost;
        fireOnPreWrite(OTHER_RUNNING_COST, _oldValue, value);
        this.otherRunningCost = value;
        fireOnPostWrite(OTHER_RUNNING_COST, _oldValue, value);
}

    /**
     * getOtherRunningCost :
     * @return double 
     */

    public double getOtherRunningCost() {
        fireOnPreRead(OTHER_RUNNING_COST, otherRunningCost);
        double result = this.otherRunningCost;
        fireOnPostRead(OTHER_RUNNING_COST, otherRunningCost);
        return result;
}

    /**
     * setLandingCosts :
     * @param value 
     */

    public void setLandingCosts(double value) {
        double _oldValue = this.landingCosts;
        fireOnPreWrite(LANDING_COSTS, _oldValue, value);
        this.landingCosts = value;
        fireOnPostWrite(LANDING_COSTS, _oldValue, value);
}

    /**
     * getLandingCosts :
     * @return double 
     */

    public double getLandingCosts() {
        fireOnPreRead(LANDING_COSTS, landingCosts);
        double result = this.landingCosts;
        fireOnPostRead(LANDING_COSTS, landingCosts);
        return result;
}

    /**
     * setSetOfVessels :
     * @param value La valeur de l'attribut setOfVessels à positionner.
     */

    public void setSetOfVessels(SetOfVessels value) {
        SetOfVessels _oldValue = this.setOfVessels;
        fireOnPreWrite("setOfVessels", _oldValue, value);
        this.setOfVessels = value;
        fireOnPostWrite("setOfVessels", _oldValue, value);
}

    /**
     * getSetOfVessels :
     * @return SetOfVessels 
     */

    public SetOfVessels getSetOfVessels() {    
        return setOfVessels;
}

    /**
     * setPossibleMetiers :
     * @param value La valeur de l'attribut possibleMetiers à positionner.
     */

    public void setPossibleMetiers(Metier value) {
        Metier _oldValue = this.possibleMetiers;
        fireOnPreWrite("possibleMetiers", _oldValue, value);
        this.possibleMetiers = value;
        fireOnPostWrite("possibleMetiers", _oldValue, value);
}

    /**
     * getPossibleMetiers :
     * @return Metier 
     */

    public Metier getPossibleMetiers() {    
        return possibleMetiers;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(FISHING_OPERATION, this.fishingOperation).
            append(FISHING_OPERATION_DURATION, this.fishingOperationDuration).
            append(GEARS_NUMBER_PER_OPERATION, this.gearsNumberPerOperation).
            append(CREW_SIZE, this.crewSize).
            append(UNIT_COST_OF_FISHING, this.unitCostOfFishing).
            append(FIXED_CREW_SALARY, this.fixedCrewSalary).
            append(CREW_SHARE_RATE, this.crewShareRate).
            append(CREW_FOOD_COST, this.crewFoodCost).
            append(REPAIR_AND_MAINTENANCE_GEAR_COST, this.repairAndMaintenanceGearCost).
            append(OTHER_RUNNING_COST, this.otherRunningCost).
            append(LANDING_COSTS, this.landingCosts).
         toString();
        return result;
}


} //EffortDescriptionAbstract
