/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util;

import com.sun.tools.javac.api.JavacTool;
import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.util.ArgTypes;
import fr.ifremer.isisfish.util.Args;
import info.monitorenter.cpdetector.io.ASCIIDetector;
import info.monitorenter.cpdetector.io.ByteOrderMarkDetector;
import info.monitorenter.cpdetector.io.CodepageDetectorProxy;
import info.monitorenter.cpdetector.io.ICodepageDetector;
import info.monitorenter.cpdetector.io.JChardetFacade;
import info.monitorenter.cpdetector.io.ParsingDetector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;

public class CompileHelper {
    private static final Log log = LogFactory.getLog(CompileHelper.class);
    protected static CodepageDetectorProxy detector;

    public static List<File> searchSrcToCompile(File srcDir, File destDir) {
        ArrayList<File> result = new ArrayList<File>();
        for (File src : srcDir.listFiles()) {
            File dest = new File(FileUtil.basename((File)src, (String[])new String[]{".java"}), ".class");
            if (!src.getName().endsWith(".java") || !FileUtil.isNewer((File)src, (File)dest)) continue;
            result.add(src);
        }
        return result;
    }

    public static Class loadClass(String fqn) {
        Class<?> result = null;
        try {
            ClassLoader cl = IsisFish.config.getScriptClassLoader();
            result = cl.loadClass(fqn);
        }
        catch (ClassNotFoundException eee) {
            log.info((Object)I18n._((String)"isisfish.error.load.class", (Object[])new Object[]{fqn}), (Throwable)eee);
        }
        return result;
    }

    public static Object newInstance(String fqn) {
        Object result = null;
        try {
            Class clazz = CompileHelper.loadClass(fqn);
            if (clazz != null) {
                result = clazz.newInstance();
            }
        }
        catch (Exception eee) {
            log.warn((Object)I18n._((String)"isisfish.error.instanciate", (Object[])new Object[]{fqn}), (Throwable)eee);
        }
        return result;
    }

    public static int compile(JavaSourceStorage source, File destDir, boolean force, PrintWriter out) {
        File src = source.getFile();
        File dst = new File(destDir, source.getFQN().replace('.', File.separatorChar) + ".class");
        if (force || FileUtil.isNewer((File)src, (File)dst)) {
            return CompileHelper.compile(source.getRoot(), src, destDir, out);
        }
        return 0;
    }

    public static int compile(File rootSrc, File src, File dest, PrintWriter out) {
        int result = CompileHelper.compile(rootSrc, Collections.singletonList(src), dest, out);
        return result;
    }

    public static int compile(File rootSrc, Collection<File> src, File dest, PrintWriter out) {
        int result;
        block2: {
            result = -10000;
            try {
                ArrayList<File> classpath = new ArrayList<File>();
                classpath.add(rootSrc.getAbsoluteFile());
                result = CompileHelper.compile(classpath, src, dest, out);
            }
            catch (Exception eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"Compilation failed", (Throwable)eee);
            }
        }
        return result;
    }

    protected static int compile(List<File> classpath, Collection<File> src, File dest, PrintWriter out) {
        int result;
        block2: {
            dest.mkdirs();
            result = -1000;
            try {
                JavacTool compiler = JavacTool.create();
                StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
                Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(src);
                String classpathAsString = CompileHelper.getClassPathAsString(classpath);
                ArrayList<String> args = new ArrayList<String>();
                args.add("-g");
                args.add("-deprecation");
                args.add("-classpath");
                args.add(classpathAsString);
                args.add("-d");
                args.add(dest.getAbsolutePath());
                boolean b = compiler.getTask((Writer)out, (JavaFileManager)fileManager, null, args, null, compilationUnits).call();
                result = b ? 0 : -1;
                fileManager.close();
            }
            catch (Exception eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"Can't get compiler", (Throwable)eee);
            }
        }
        return result;
    }

    public static String getClassPathAsString(List<File> classpath) throws Exception {
        String[] systemClassPathes;
        String result = StringUtils.join(classpath.iterator(), (String)File.pathSeparator);
        Enumeration<URL> e = CompileHelper.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (e.hasMoreElements()) {
            String jarName;
            URL url = e.nextElement();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found manifest : " + url));
            }
            if (url == null || !url.getFile().startsWith("file:/") || result.contains(jarName = url.getPath().substring(5, url.getPath().indexOf("!")))) continue;
            result = result + File.pathSeparator + jarName;
        }
        String systemClassPath = System.getProperty("java.class.path");
        for (String path : systemClassPathes = systemClassPath.split(File.pathSeparator)) {
            String absolutePath = new File(path).getCanonicalPath();
            if (result.contains(absolutePath)) continue;
            result = result + File.pathSeparator + absolutePath;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CLASSPATH : " + result));
        }
        return result;
    }

    public static String extractDoc(String category, String name, Class javaInterface) {
        String content;
        block6: {
            content = "";
            content = "<p>Equation : " + CompileHelper.createHREF(javaInterface.getName(), category) + " - " + name + "</p>";
            content = content + "<h3>Parameter: name and type</h3>";
            Method[] methods = javaInterface.getDeclaredMethods();
            Method interfaceMethod = methods[0];
            Args args = interfaceMethod.getAnnotation(Args.class);
            String[] names = args.value();
            String[] stringTypes = null;
            ArgTypes argTypes = interfaceMethod.getAnnotation(ArgTypes.class);
            if (argTypes != null) {
                stringTypes = argTypes.value();
            } else {
                stringTypes = new String[names.length];
                Class<?>[] types = interfaceMethod.getParameterTypes();
                for (int i = 0; i < types.length; ++i) {
                    stringTypes[i] = types[i].getName();
                }
            }
            for (int i = 0; i < names.length; ++i) {
                content = content + "<li>" + names[i] + " : " + CompileHelper.createHREF(stringTypes[i], new String[0]);
            }
            try {
                FileUtil.writeString((File)new File("/tmp/testDoc.html"), (String)content);
            }
            catch (IOException eee) {
                if (!log.isWarnEnabled()) break block6;
                log.warn((Object)"TODO untreated error", (Throwable)eee);
            }
        }
        return content;
    }

    private static String createHREF(String type, String ... texts) {
        String ref = IsisFish.config.getJavadocURL() + type.replaceAll("\\.", "/") + ".html";
        String text = type;
        if (texts.length > 0) {
            text = texts[0];
        }
        String result = "<a href='" + ref + "'>" + text + "</a>";
        return result;
    }

    protected static CodepageDetectorProxy getCodepageDetector() {
        if (detector == null) {
            detector = CodepageDetectorProxy.getInstance();
            detector.add((ICodepageDetector)new ByteOrderMarkDetector());
            detector.add((ICodepageDetector)new ParsingDetector(true));
            detector.add((ICodepageDetector)JChardetFacade.getInstance());
            detector.add(ASCIIDetector.getInstance());
        }
        return detector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> convertToUnicode(List<File> files) {
        CodepageDetectorProxy myDetector = CompileHelper.getCodepageDetector();
        for (File file : files) {
            try {
                Charset charset = myDetector.detectCodepage(file.toURI().toURL());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Charset for " + file.getAbsolutePath() + " is " + charset));
                }
                if (charset != null && !charset.name().equalsIgnoreCase("utf-8")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Convert " + file.getAbsolutePath() + " to unicode"));
                    }
                    File tmpFile = File.createTempFile(file.getName(), ".copy");
                    tmpFile.deleteOnExit();
                    FileInputStream is = new FileInputStream(file);
                    FileOutputStream os = new FileOutputStream(tmpFile);
                    try {
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                    }
                    finally {
                        ((InputStream)is).close();
                        ((OutputStream)os).close();
                    }
                    is = new FileInputStream(tmpFile);
                    os = new FileOutputStream(file);
                    InputStreamReader ir = new InputStreamReader((InputStream)is, charset);
                    OutputStreamWriter ow = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8");
                    try {
                        IOUtils.copy((Reader)ir, (Writer)ow);
                        continue;
                    }
                    finally {
                        ((Reader)ir).close();
                        ((Writer)ow).close();
                        ((InputStream)is).close();
                        ((OutputStream)os).close();
                        continue;
                    }
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("File " + file.getAbsolutePath() + " already in unicode : skip"));
            }
            catch (MalformedURLException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't convert file in unicode", (Throwable)e);
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't convert file in unicode", (Throwable)e);
            }
        }
        return files;
    }
}

