/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.widget.filter;

import fr.ifremer.isisfish.ui.widget.filter.Acceptor;
import fr.ifremer.isisfish.ui.widget.filter.AcceptorFactory;
import fr.ifremer.isisfish.ui.widget.filter.FilterAcceptor;
import fr.ifremer.isisfish.ui.widget.filter.ValueGetter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeFilterAcceptor<M, T>
implements FilterAcceptor<M, T> {
    private static Log log = LogFactory.getLog(CompositeFilterAcceptor.class);
    protected Acceptor<T> acceptor;
    protected ValueGetter<M, T> getter;

    public CompositeFilterAcceptor(Class<T> klazz, ValueGetter<M, T> getter) {
        this(AcceptorFactory.getAcceptor(klazz), getter);
    }

    public CompositeFilterAcceptor(Acceptor<T> acceptor, ValueGetter<M, T> getter) {
        this.acceptor = acceptor;
        this.getter = getter;
    }

    @Override
    public boolean acceptParam(M item, T value) {
        return this.accept(this.getValue(item), value);
    }

    @Override
    public T getValue(M model) {
        return this.extract(this.getter.getValue(model));
    }

    @Override
    public Class<T> getKlazz() {
        return this.acceptor.getKlazz();
    }

    @Override
    public boolean canUse(Object[] val) {
        return this.acceptor.canUse(val);
    }

    @Override
    public boolean accept(T meta, T value) {
        return this.acceptor.accept(meta, value);
    }

    @Override
    public T extract(Object args) {
        return (T)(args == null || this.getKlazz().isAssignableFrom(args.getClass()) ? args : this.acceptor.extract(args));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(' ').append(this.acceptor);
        sb.append(' ').append(this.getter);
        return sb.toString();
    }
}

