/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.widget.editor;

import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.types.Date;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.util.ConverterUtil;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import jaxx.runtime.swing.editor.EnumEditor;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.MonthEnum;

public class ParameterTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 6860330126841984303L;
    private static Log log = LogFactory.getLog(ParameterTableCellEditor.class);
    protected RegionStorage region = null;
    protected Component editor = null;
    protected Class<?> type = null;

    public RegionStorage getRegion() {
        return this.region;
    }

    public void setRegion(RegionStorage region) {
        this.region = region;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.type = this.getType(value, row, column);
        TypeClassMapping mapping = TypeClassMapping.getMapping(this.type);
        switch (mapping) {
            case Topia: {
                try {
                    if (this.region == null) {
                        return null;
                    }
                    TopiaContext context = this.region.getStorage().beginTransaction();
                    if (context == null) break;
                    List list = context.find("from " + this.type.getName(), new Object[0]);
                    JComboBox<Object> c = new JComboBox<Object>(list.toArray());
                    c.setSelectedItem(value);
                    this.editor = c;
                    context.closeContext();
                }
                catch (Exception eee) {
                    if (!log.isWarnEnabled()) break;
                    log.warn((Object)"Can't get entity object for combobox", (Throwable)eee);
                }
                break;
            }
            case Boolean: {
                ArrayList<Boolean> listB = new ArrayList<Boolean>();
                listB.add(Boolean.TRUE);
                listB.add(Boolean.FALSE);
                JComboBox<Object> c = new JComboBox<Object>(listB.toArray());
                listB.clear();
                c.setSelectedItem(value);
                this.editor = c;
                break;
            }
            case Date: {
                Date date = (Date)value;
                if (date == null) {
                    date = new Date(0);
                }
                int month = date.getMonth().getMonthNumber();
                int yea = date.getYear();
                this.editor = new DateComponent(month, yea, this.region == null ? null : this.region.getStorage());
                break;
            }
            case Mounth: {
                this.editor = DateComponent.createMounthCombo(((Month)value).getMonthNumber(), this.region == null ? null : this.region.getStorage());
                break;
            }
            default: {
                this.editor = new JTextField(value.toString());
            }
        }
        if (this.editor != null) {
            if (JComboBox.class.isInstance(this.editor)) {
                ((JComboBox)this.editor).addActionListener(this.getComboListener());
            } else if (JTextField.class.isInstance(this.editor)) {
                ((JTextField)this.editor).addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Stop cell editing");
                        }
                        ParameterTableCellEditor.this.stopCellEditing();
                    }
                });
            } else if (DateComponent.class.isInstance(this.editor)) {
                DateComponent date = (DateComponent)this.editor;
                if (date.getMounthCombo() != null) {
                    date.getMounthCombo().addActionListener(this.getComboListener());
                }
                if (date.getYearCombo() != null) {
                    date.getYearCombo().addActionListener(this.getComboListener());
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCellEditorValue [" + this.type + "] [mapping:" + (Object)((Object)mapping) + "=" + this.editor));
        }
        return this.editor;
    }

    protected Class<?> getType(Object value, int row, int column) {
        return value.getClass();
    }

    protected ActionListener getComboListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterTableCellEditor.this.stopCellEditing();
            }
        };
    }

    @Override
    public Object getCellEditorValue() {
        Object result = null;
        TopiaContext context = null;
        if (this.editor == null) {
            return "";
        }
        TypeClassMapping mapping = TypeClassMapping.getMapping(this.type);
        switch (mapping) {
            case Topia: {
                result = this.getComboBoxValue(this.editor);
                break;
            }
            case Boolean: {
                result = this.getComboBoxValue(this.editor);
                break;
            }
            case Mounth: {
                result = this.getComboBoxIndex(this.editor) + "";
                break;
            }
            case Date: {
                result = ((DateComponent)this.editor).getSelectedValue() + "";
                break;
            }
            default: {
                if (this.editor instanceof JTextField) {
                    result = ((JTextField)this.editor).getText();
                    break;
                }
                if (!(this.editor instanceof JComboBox)) break;
                result = ((JComboBox)this.editor).getSelectedItem();
            }
        }
        if (result instanceof String && !String.class.equals(this.type)) {
            if (this.region != null) {
                context = this.region.getStorage();
            }
            ConvertUtilsBean cub = ConverterUtil.getConverter(context);
            result = cub.convert((String)result, this.type);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCellEditorValue [" + this.type + "] [mapping:" + (Object)((Object)mapping) + "]= " + result));
        }
        return result;
    }

    protected Object getTextFieldValue(Component editor) {
        return ((JTextField)editor).getText();
    }

    protected Object getComboBoxValue(Component editor) {
        return ((JComboBox)editor).getSelectedItem();
    }

    protected int getComboBoxIndex(Component editor) {
        return ((JComboBox)editor).getSelectedIndex();
    }

    public static class DateComponent
    extends JPanel {
        private static final long serialVersionUID = -6694461572642939712L;
        protected JComboBox mounth;
        protected JComboBox year;

        public DateComponent(int mounth, int year, TopiaContext context) {
            super(new GridLayout(0, 2));
            this.mounth = DateComponent.createMounthCombo(mounth, context);
            this.year = DateComponent.createYearCombo(200, year);
            this.add(this.mounth);
            this.add(this.year);
        }

        public JComboBox getYearCombo() {
            return this.year;
        }

        public JComboBox getMounthCombo() {
            return this.mounth;
        }

        public int getSelectedMounth() {
            return this.mounth.getSelectedIndex();
        }

        public int getSelectedYear() {
            return this.year.getSelectedIndex();
        }

        public void setSelectedValue(int year, int mounth) {
            this.mounth.setSelectedIndex(mounth);
            this.year.setSelectedIndex(year);
        }

        public int getSelectedValue() {
            int selectedYear = this.getSelectedYear();
            int selectedMounth = this.getSelectedMounth();
            if (log.isInfoEnabled()) {
                log.info((Object)("selected mounth " + selectedMounth));
                log.info((Object)("selected year   " + selectedYear));
            }
            return selectedMounth + selectedYear * 12;
        }

        public static JComboBox createMounthCombo(int mounth, TopiaContext context) {
            EnumEditor combo = EnumEditor.newEditor(MonthEnum.class);
            combo.setSelectedIndex(mounth);
            return combo;
        }

        public static JComboBox createYearCombo(int nb, int selectedYear) {
            ArrayList<Integer> listI = new ArrayList<Integer>();
            for (int i = 0; i < nb; ++i) {
                listI.add(i);
            }
            JComboBox<Object> year = new JComboBox<Object>(listI.toArray());
            listI.clear();
            year.setSelectedIndex(selectedYear);
            return year;
        }
    }

    private static enum TypeClassMapping {
        Int(Integer.TYPE, Integer.class),
        Topia(TopiaEntity.class),
        Mounth(Month.class),
        Date(Date.class),
        Double(java.lang.Double.TYPE, Double.class),
        Boolean(java.lang.Boolean.TYPE, Boolean.class),
        File(File.class),
        String(String.class);

        private final Class<?>[] klazz;

        private TypeClassMapping(Class<?> ... klazz) {
            this.klazz = klazz;
        }

        protected static TypeClassMapping getMapping(Class<?> klazz) {
            for (TypeClassMapping t : TypeClassMapping.values()) {
                for (Class<?> loopKlazz : t.klazz) {
                    if (!loopKlazz.isAssignableFrom(klazz)) continue;
                    return t;
                }
            }
            throw new RuntimeException("could not found a TypeClassMapping for this class " + klazz);
        }
    }
}

