/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.vcs;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.KeyPair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import jaxx.runtime.DefaultJAXXContext;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXInitialContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.Util;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class VCSGenerateSshKeyUI
extends JDialog
implements JAXXObject {
    public static final Log log = LogFactory.getLog(VCSGenerateSshKeyUI.class);
    private static String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUz08TQRTHh0pbyg/lR0FCICIQjQe3KkaiEJQfKYpFUZAQe3G6O6WD0911ZrYsHoyJV2M4efCi3j16N8ajJ6/+D8b4H/hmd/tjay1N2sNu+3585vte571Pv1BUcHR2H7uuxh1T0iLR1pd2d+/n9okuV4nQObWlxZH/6YigSBb1GBW7kGg6m1HpqSA9tWIVbcskZk32fAZ1C3nIiCgQIiUa9jN0IVJbFfO8azu8TKuIaUT78Od35Mh4+TGCkGuDqj4oYfK4rGoFnRkUoYZEg3BSCacYNvdABqfmHujsU7YVhoW4h4vkGXqB4hkUszEHmERTrZfqMbx815YoMbO+SjGz9i5JpOW5RvOcFAm8BRV5KgqaQ7WSLrSdla01YhKOJdkShbvk8NEd2/YwMYniM9s4x8hliUZD1YoD0K55PhWZqCR0zaxncI6wK1CsqssNQn2rCuqtxCYF4SXCNzktweFwcpoyItFIKG+buDJNCTPCueVzZtXvgbBvKOA6OUb1AKtcyXDYcBAGTdsscCxIRWIdr78+UKKxkEblObC40UDnuJ+7Ypl5yovHn3X6P/HKPfFPCzaxSdjV+lZ71nBsxHoKfQlFLTtSWqbyT1XCenVs6oQt6ZL6rvOBn6tk+P9hfrTq/FQveEcWRbkDZuhWtjpqD8HkD1lg9QCe9f2rd6W3n7/cKE/UIJzRFwqpWQBww21u2YRLqo445Y+RIylLbWB7PosSgjDYHt52SNYI2ArMIAL4AypNU2nabSwKkBqN//z6beTJjxMokkbdzMJGGqv4OyghCxyqtJjh2jdveUp6D7rg2a80SRQtWgZm0PoFajJqkkksYaBzjiSLLtSbrKm3IuL70euN8TcTc+WaO3xNdWHVuqOPUcyne/sjWA0N90WPLYhjWNUV0GgpdKh3tx2Md8p7zjYsTlLpz8w111GvOU+t+na9ZUinhNFtwuhvgRHXLeYUTdEEM9QCposYVJaXVRucRN4y5UVBn7cLihUI3Ss0687xFGVebkIYaYmw1oQw2hIh0zbhQduEnbYJzTo51jbhTCt3guFDC5YyOrlgYIknc9Q0YFMvNiZOtzI9xFSX3mgi7FzbpbVPuACEv4FBXOsXCgAA";
    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected JButton cancelAction;
    protected final JAXXContext delegateContext = new DefaultJAXXContext((JAXXObject)this);
    protected JButton ok;
    protected JPasswordField serverConfirmPassPhrase;
    protected JLabel serverConfirmPassPhraseLabel;
    protected JPasswordField serverPassPhrase;
    protected JLabel serverPassPhraseLabel;
    protected JTextField serverPrivateKeyFile;
    protected JTextField serverPublicKeyFile;
    private VCSGenerateSshKeyUI $JDialog0 = this;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JPanel $JPanel4;
    private Table $Table1;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    Map $previousValues = new HashMap();
    private static VCSGenerateSshKeyUI instance;
    public boolean cancel;
    public boolean noPassPhrase;
    public Exception error;
    protected boolean invalidPassPhrase;
    protected String vcsLogin;

    public static VCSGenerateSshKeyUI getInstance(JDialog parent) {
        if (instance == null) {
            instance = new VCSGenerateSshKeyUI(parent);
        }
        return instance;
    }

    private VCSGenerateSshKeyUI(JDialog instance) {
        super(instance);
        this.$initialize();
        this.setDefaultCloseOperation(0);
        this.$initialize();
    }

    public void setData(String vcsLogin, File privateKeyFile) {
        this.vcsLogin = vcsLogin;
        this.serverPrivateKeyFile.setText(privateKeyFile.getAbsolutePath());
        this.serverPublicKeyFile.setText(privateKeyFile.getAbsolutePath() + ".pub");
        this.noPassPhrase = true;
        Util.assignment((boolean)true, (String)"noPassPhrase", (JAXXObject)this);
        this.error = null;
        Util.assignment(null, (String)"error", (JAXXObject)this);
        this.doCheck();
    }

    protected boolean doGenerate() {
        File privateKeyFile = new File(this.getServerPrivateKeyFile().getText());
        File publicKeyFile = new File(this.serverPublicKeyFile.getText());
        if (privateKeyFile.getParentFile() != null && !privateKeyFile.getParentFile().exists()) {
            privateKeyFile.getParentFile().mkdirs();
        }
        try {
            char[] password = this.getServerPassPhrase().getPassword();
            JSch jsch = new JSch();
            KeyPair kpair = KeyPair.genKeyPair((JSch)jsch, (int)2, (int)2048);
            if (password.length > 0) {
                kpair.setPassphrase(Arrays.toString(password));
            }
            kpair.writePrivateKey(privateKeyFile.getAbsolutePath());
            kpair.writePublicKey(publicKeyFile.getAbsolutePath(), this.vcsLogin + "@forIsisFish");
            if (log.isInfoEnabled()) {
                log.info((Object)("Finger print: " + kpair.getFingerPrint()));
            }
            kpair.dispose();
        }
        catch (Exception e) {
            this.error = e;
            Util.assignment((Object)this.error, (String)"error", (JAXXObject)this);
            return true;
        }
        return false;
    }

    protected boolean check() {
        this.invalidPassPhrase = !Arrays.equals(this.serverPassPhrase.getPassword(), this.serverConfirmPassPhrase.getPassword());
        Util.assignment((boolean)this.invalidPassPhrase, (String)"invalidPassPhrase", (JAXXObject)this);
        return !this.invalidPassPhrase;
    }

    protected void doCheck() {
        this.ok.setEnabled(this.check());
        this.setColor(this.invalidPassPhrase, this.serverPassPhraseLabel);
        this.setColor(this.invalidPassPhrase, this.serverConfirmPassPhraseLabel);
    }

    protected void setColor(boolean invalid, JComponent component) {
        component.setForeground(invalid ? Color.red : Color.black);
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public VCSGenerateSshKeyUI() {
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext) {
        if (parentContext instanceof JAXXInitialContext) {
            ((JAXXInitialContext)parentContext).to((JAXXContext)this);
        } else {
            this.setContextValue(parentContext);
        }
        this.$initialize();
    }

    public void applyDataBinding(String $binding) {
        this.processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String, Object> get$objectMap() {
        return this.$objectMap;
    }

    public Object getObjectById(String id) {
        return this.$objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        this.processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
    }

    public void removeDataBinding(String $binding) {
    }

    public <T> T getContextValue(Class<T> clazz) {
        return (T)this.delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return (T)this.delegateContext.getContextValue(clazz, name);
    }

    public JAXXContext getDelegateContext() {
        return this.delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return (O)this.delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return (O)this.delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        this.delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        this.delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        this.delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        this.delegateContext.setContextValue(o, name);
    }

    public void doActionPerformed__on__cancelAction(ActionEvent event) {
        this.cancel = true;
        Util.assignment((boolean)true, (String)"cancel", (JAXXObject)this);
        this.dispose();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        this.cancel = this.doGenerate();
        Util.assignment((boolean)this.cancel, (String)"cancel", (JAXXObject)this);
        this.dispose();
    }

    public void doKeyReleased__on__serverConfirmPassPhrase(KeyEvent event) {
        this.doCheck();
    }

    public void doKeyReleased__on__serverPassPhrase(KeyEvent event) {
        this.doCheck();
    }

    public List<Object> get$activeBindings() {
        return this.$activeBindings;
    }

    public Map<String, Object> get$bindingSources() {
        return this.$bindingSources;
    }

    public JButton getCancelAction() {
        return this.cancelAction;
    }

    public JButton getOk() {
        return this.ok;
    }

    public JPasswordField getServerConfirmPassPhrase() {
        return this.serverConfirmPassPhrase;
    }

    public JLabel getServerConfirmPassPhraseLabel() {
        return this.serverConfirmPassPhraseLabel;
    }

    public JPasswordField getServerPassPhrase() {
        return this.serverPassPhrase;
    }

    public JLabel getServerPassPhraseLabel() {
        return this.serverPassPhraseLabel;
    }

    public JTextField getServerPrivateKeyFile() {
        return this.serverPrivateKeyFile;
    }

    public JTextField getServerPublicKeyFile() {
        return this.serverPublicKeyFile;
    }

    protected VCSGenerateSshKeyUI get$JDialog0() {
        return this.$JDialog0;
    }

    protected JLabel get$JLabel2() {
        return this.$JLabel2;
    }

    protected JLabel get$JLabel3() {
        return this.$JLabel3;
    }

    protected JPanel get$JPanel4() {
        return this.$JPanel4;
    }

    protected Table get$Table1() {
        return this.$Table1;
    }

    protected String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected Map get$previousValues() {
        return this.$previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return this.allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return this.contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        this.$JDialog0.getContentPane().add((Component)this.$Table1);
        this.$Table1.add((Component)this.$JLabel2, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.serverPrivateKeyFile, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.$JLabel3, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.serverPublicKeyFile, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.serverPassPhraseLabel, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.serverPassPhrase, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.serverConfirmPassPhraseLabel, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.serverConfirmPassPhrase, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.$JPanel4, (Object)new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$JPanel4.add(this.ok);
        this.$JPanel4.add(this.cancelAction);
        this.$JDialog0.pack();
    }

    private void $initialize() {
        if (this.allComponentsCreated || !this.contextInitialized) {
            return;
        }
        this.$objectMap.put("$JDialog0", this);
        this.$Table1 = new Table();
        this.$objectMap.put("$Table1", this.$Table1);
        this.$Table1.setName("$Table1");
        this.$JLabel2 = new JLabel();
        this.$objectMap.put("$JLabel2", this.$JLabel2);
        this.$JLabel2.setName("$JLabel2");
        this.$JLabel2.setText(I18n._((String)"isisfish.launch.server.ssh.privateKeyFile"));
        this.createServerPrivateKeyFile();
        this.$JLabel3 = new JLabel();
        this.$objectMap.put("$JLabel3", this.$JLabel3);
        this.$JLabel3.setName("$JLabel3");
        this.$JLabel3.setText(I18n._((String)"isisfish.launch.server.ssh.publicKeyFile"));
        this.createServerPublicKeyFile();
        this.createServerPassPhraseLabel();
        this.createServerPassPhrase();
        this.createServerConfirmPassPhraseLabel();
        this.createServerConfirmPassPhrase();
        this.$JPanel4 = new JPanel();
        this.$objectMap.put("$JPanel4", this.$JPanel4);
        this.$JPanel4.setName("$JPanel4");
        this.$JPanel4.setLayout(new GridLayout(0, 2, 2, 2));
        this.createOk();
        this.createCancelAction();
        this.$JDialog0.setName("$JDialog0");
        this.$JDialog0.setModal(true);
        this.$JDialog0.setTitle(I18n._((String)"isisfish.server.ssh.generateKey.title"));
        this.$completeSetup();
    }

    protected void createCancelAction() {
        this.cancelAction = new JButton();
        this.$objectMap.put("cancelAction", this.cancelAction);
        this.cancelAction.setName("cancelAction");
        this.cancelAction.setText(I18n._((String)"isisfish.common.cancel"));
        this.cancelAction.addActionListener((ActionListener)Util.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this.$JDialog0, (String)"doActionPerformed__on__cancelAction"));
    }

    protected void createOk() {
        this.ok = new JButton();
        this.$objectMap.put("ok", this.ok);
        this.ok.setName("ok");
        this.ok.setEnabled(false);
        this.ok.setText(I18n._((String)"isisfish.common.apply"));
        this.ok.addActionListener((ActionListener)Util.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this.$JDialog0, (String)"doActionPerformed__on__ok"));
    }

    protected void createServerConfirmPassPhrase() {
        this.serverConfirmPassPhrase = new JPasswordField();
        this.$objectMap.put("serverConfirmPassPhrase", this.serverConfirmPassPhrase);
        this.serverConfirmPassPhrase.setName("serverConfirmPassPhrase");
        this.serverConfirmPassPhrase.setColumns(15);
        this.serverConfirmPassPhrase.addKeyListener((KeyListener)Util.getEventListener(KeyListener.class, (String)"keyReleased", (Object)this.$JDialog0, (String)"doKeyReleased__on__serverConfirmPassPhrase"));
    }

    protected void createServerConfirmPassPhraseLabel() {
        this.serverConfirmPassPhraseLabel = new JLabel();
        this.$objectMap.put("serverConfirmPassPhraseLabel", this.serverConfirmPassPhraseLabel);
        this.serverConfirmPassPhraseLabel.setName("serverConfirmPassPhraseLabel");
        this.serverConfirmPassPhraseLabel.setText(I18n._((String)"isisfish.launch.server.ssh.confirm.passphrase"));
    }

    protected void createServerPassPhrase() {
        this.serverPassPhrase = new JPasswordField();
        this.$objectMap.put("serverPassPhrase", this.serverPassPhrase);
        this.serverPassPhrase.setName("serverPassPhrase");
        this.serverPassPhrase.setColumns(15);
        this.serverPassPhrase.addKeyListener((KeyListener)Util.getEventListener(KeyListener.class, (String)"keyReleased", (Object)this.$JDialog0, (String)"doKeyReleased__on__serverPassPhrase"));
    }

    protected void createServerPassPhraseLabel() {
        this.serverPassPhraseLabel = new JLabel();
        this.$objectMap.put("serverPassPhraseLabel", this.serverPassPhraseLabel);
        this.serverPassPhraseLabel.setName("serverPassPhraseLabel");
        this.serverPassPhraseLabel.setText(I18n._((String)"isisfish.launch.server.ssh.passphrase"));
    }

    protected void createServerPrivateKeyFile() {
        this.serverPrivateKeyFile = new JTextField();
        this.$objectMap.put("serverPrivateKeyFile", this.serverPrivateKeyFile);
        this.serverPrivateKeyFile.setName("serverPrivateKeyFile");
        this.serverPrivateKeyFile.setColumns(15);
        this.serverPrivateKeyFile.setColumns(28);
        this.serverPrivateKeyFile.setEditable(false);
        if (this.serverPrivateKeyFile.getFont() != null) {
            this.serverPrivateKeyFile.setFont(this.serverPrivateKeyFile.getFont().deriveFont(12.0f));
        }
        Util.setComponentHeight((Component)this.serverPrivateKeyFile, (int)25);
    }

    protected void createServerPublicKeyFile() {
        this.serverPublicKeyFile = new JTextField();
        this.$objectMap.put("serverPublicKeyFile", this.serverPublicKeyFile);
        this.serverPublicKeyFile.setName("serverPublicKeyFile");
        this.serverPublicKeyFile.setColumns(15);
        this.serverPublicKeyFile.setColumns(28);
        this.serverPublicKeyFile.setEditable(false);
        if (this.serverPublicKeyFile.getFont() != null) {
            this.serverPublicKeyFile.setFont(this.serverPublicKeyFile.getFont().deriveFont(12.0f));
        }
        Util.setComponentHeight((Component)this.serverPublicKeyFile, (int)25);
    }
}

