/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.AnalysePlanStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.datastore.ScriptStorage;
import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.datastore.SensitivityStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.datastore.SimulatorStorage;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.mexico.MexicoHelper;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.AnalysePlan;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.SimulationParameterImpl;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulatorLauncher;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityCalculator;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityException;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.MatrixContinuousDomain;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.JComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;

public class SimulAction {
    private static Log log = LogFactory.getLog(SimulAction.class);
    private static final SimpleDateFormat DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
    protected SimulationParameter param = null;
    protected RegionStorage regionStorage = null;
    protected SimulationStorage simulStorage = null;
    protected List<String> oldSimulNames = null;
    protected String simulName = null;
    protected SensitivityStorage sensitivityStorage = null;
    protected Map<String, Factor> factors;
    protected Map<String, JComponent> factorComponent = new HashMap<String, JComponent>();
    protected DesignPlan designPlan = new DesignPlan();

    public SimulAction() {
        this.init();
    }

    public void init() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Init ");
        }
        try {
            this.param = new SimulationParameterImpl();
            List<String> resultNames = this.getResultNames();
            this.param.setSimulatorName(IsisFish.config.getSimulatorClassfile());
            this.param.setTagValue(IsisFish.config.getDefaultTagValueAsMap());
            this.param.setExportNames(IsisFish.config.getDefaultExportNamesAsList());
            List<String> defaultResultNames = IsisFish.config.getDefaultResultNamesAsList();
            if (defaultResultNames != null) {
                this.param.setResultEnabled(defaultResultNames);
            } else {
                this.param.setResultEnabled(resultNames);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't init SimulationParameter", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.initsimulaction"), eee);
        }
        this.factors = new HashMap<String, Factor>();
    }

    protected void setName(String name) {
        this.simulName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importSimulation(File f) {
        FileInputStream fos = null;
        try {
            fos = new FileInputStream(f);
            Properties proper = new Properties();
            proper.load(fos);
            this.param.fromProperties(proper);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't import simulation", (Throwable)e);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.importparameter"), e);
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't import simulation", (Throwable)e);
                }
                ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.importparameter"), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSimulation(File f) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            this.param.toProperties().store(fos, this.simulName);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't save simulation", (Throwable)e);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.savesimulation"), e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't save simulation", (Throwable)e);
                }
                ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.savesimulation"), e);
            }
        }
    }

    protected List<String> getResultNames() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Field[] fields;
            ScriptStorage storage = ScriptStorage.getScript("ResultName.java");
            Class<?> resultNameClass = storage.getCodeClass();
            for (Field f : fields = resultNameClass.getFields()) {
                String fieldName = (String)f.get(null);
                result.add(fieldName);
            }
        }
        catch (Exception eee) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Can't find result name script", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.getresultname"), eee);
        }
        return result;
    }

    public void regionChange(String regionName) {
        try {
            this.regionStorage = RegionStorage.getRegion(regionName);
            this.param.setRegionName(regionName);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't change region", (Throwable)e);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.openregion"), e);
        }
    }

    public void loadOldSimulation(String simulName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("call loadOldSimulation: " + simulName));
        }
        try {
            this.simulName = simulName;
            this.simulStorage = SimulationStorage.getSimulation(simulName);
            this.param = this.simulStorage.getParameter().copy();
            this.param.setAnalysePlanNumber(-1);
            this.regionStorage = this.param.getRegion();
            this.factors.clear();
            File f = SimulationStorage.getMexicoDesignPlan(SimulationStorage.getSimulationDirectory(simulName));
            if (f != null && f.canRead()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Import design plan from : " + f.getAbsolutePath()));
                }
                TopiaContext topiaContext = this.regionStorage.getStorage();
                this.designPlan = MexicoHelper.getDesignPlanFromXML(f, topiaContext);
                for (Factor<?, ?> factor : this.designPlan.getFactors()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Find factor : " + factor.getName()));
                    }
                    this.factors.put(factor.getPath() + factor.getName(), factor);
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)"No xml design plan file found");
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can't load old Simulation: " + simulName), (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.loadoldsimulation"), eee);
        }
    }

    public List<Rule> getRules() {
        return this.param.getRules();
    }

    public void addNewRule(String ruleName) {
        try {
            RuleStorage ruleStorage = RuleStorage.getRule(ruleName);
            Rule ruleTmp = ruleStorage.getNewRuleInstance();
            this.param.addRule(ruleTmp);
        }
        catch (IsisFishException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't add rule", (Throwable)e);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.addrule"), e);
        }
    }

    public boolean removeRule(Rule rule) {
        return this.param.removeRule(rule);
    }

    public List<String> getAvailableRuleNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (String ruleName : RuleStorage.getRuleNames()) {
            String shortRuleName = ruleName.substring(0, ruleName.length() - 5);
            result.add(shortRuleName);
        }
        return result;
    }

    public List<Strategy> getStrategies() {
        ArrayList<Strategy> result = new ArrayList();
        try {
            TopiaContext tx = this.param.getRegion().getStorage().beginTransaction();
            result = RegionStorage.getFisheryRegion(tx).getStrategy();
            tx.rollbackTransaction();
            tx.closeContext();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get strategies", (Throwable)e);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.liststrategies"), e);
        }
        return result;
    }

    public void setStrategies(Object[] strategies) {
        ArrayList<Strategy> result = new ArrayList<Strategy>();
        for (Object o : strategies) {
            result.add((Strategy)o);
        }
        this.param.setStrategies(result);
    }

    public List<Population> getPopulations() {
        ArrayList<Population> result = new ArrayList<Population>();
        try {
            TopiaContext tx = this.param.getRegion().getStorage().beginTransaction();
            List<Species> species = RegionStorage.getFisheryRegion(tx).getSpecies();
            for (Species s : species) {
                Collection<Population> populations = s.getPopulation();
                for (Population p : populations) {
                    p.getPopulationGroup().size();
                    p.getPopulationZone().size();
                }
                result.addAll(populations);
            }
            tx.rollbackTransaction();
            tx.closeContext();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get population", (Throwable)e);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.listpopulation"), e);
        }
        return result;
    }

    public void setPopulations(Object[] populations) {
        ArrayList<Population> result = new ArrayList<Population>();
        for (Object o : populations) {
            result.add((Population)o);
        }
        this.param.setPopulations(result);
    }

    public int getNumberOfYear() {
        return this.param.getNumberOfYear();
    }

    public void setNumberOfYear(String years) {
        this.param.setNumberOfYear(Integer.parseInt(years));
    }

    public List<String> getSimulatorNames() {
        return SimulatorStorage.getSimulatorNames();
    }

    public List<String> getOldSimulationItem() {
        this.oldSimulNames = new ArrayList<String>();
        this.oldSimulNames.addAll(SimulationStorage.getSimulationNames());
        this.oldSimulNames.add(0, " ");
        return this.oldSimulNames;
    }

    public List<String> getFilteredOldSimulatorNames(boolean force) {
        if (this.oldSimulNames == null || force) {
            this.oldSimulNames = this.getOldSimulationItem();
        }
        return this.oldSimulNames;
    }

    public void setOldSimulatorNames(List<String> sn) {
        this.oldSimulNames = sn;
    }

    public void resetOldSimulatorNames() {
        this.oldSimulNames = this.getOldSimulationItem();
    }

    public void addTagValue(String tag, String value) {
        this.param.getTagValue().put(tag, value);
    }

    public void removeTagValue(String tag) {
        log.debug((Object)("removeTagValue: " + tag));
        this.param.getTagValue().remove(tag);
    }

    public void saveTagValue(String simulatorName) {
        Map<String, String> tagValues = this.param.getTagValue();
        log.debug((Object)("call saveTagValue: " + tagValues));
        IsisFish.config.setDefaultTagValues(tagValues);
        IsisFish.config.setSimulatorClassfile(simulatorName);
    }

    public List<String> getExportNames() {
        ArrayList<String> result = new ArrayList<String>();
        List<String> exportNames = ExportStorage.getExportNames();
        for (String export : exportNames) {
            result.add(export);
        }
        return result;
    }

    public void saveExport() {
        if (this.param.getExportNames() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set exports in configuration : " + this.param.getExportNames()));
            }
            IsisFish.config.setDefaultExportNames(this.param.getExportNames());
        }
    }

    public void saveParametersResultNames(Object[] resultNames) {
        ArrayList<String> resultNamesString = new ArrayList<String>();
        for (Object o : resultNames) {
            resultNamesString.add(o.toString());
        }
        this.param.setResultEnabled(resultNamesString);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set simulation result names : " + resultNamesString));
        }
    }

    public void saveConfigurationResultNames(Object[] resultNames) {
        ArrayList<String> resultNamesString = new ArrayList<String>();
        for (Object o : resultNames) {
            resultNamesString.add(o.toString());
        }
        IsisFish.config.setDefaultResultNames(resultNamesString);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set configuration result names : " + resultNamesString));
        }
    }

    public List<String> getDefaultResultNames() {
        return IsisFish.config.getDefaultResultNamesAsList();
    }

    public List<String> getAnalysePlanNames() {
        return AnalysePlanStorage.getAnalysePlanNames();
    }

    public List<AnalysePlan> getParamAnalysePlans() {
        return this.param.getAnalysePlans();
    }

    public void addAnalysePlan(String name) {
        try {
            AnalysePlan ap = AnalysePlanStorage.getAnalysePlan(name).getNewAnalysePlanInstance();
            this.getSimulationParameter().addAnalysePlan(ap);
        }
        catch (IsisFishException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't add analyse plan", (Throwable)e);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.addanalyseplan"), e);
        }
    }

    public void removeAnalysePlan(AnalysePlan ap) {
        this.getSimulationParameter().removeAnalysePlan(ap);
    }

    public void clearAnalysePlans() {
        this.getSimulationParameter().clearPlans();
    }

    public Map<String, Class<?>> getAnalysePlanParameterName(AnalysePlan ap) {
        Map<String, Class<?>> result = null;
        if (ap != null) {
            result = AnalysePlanStorage.getParameterNames(ap);
        }
        return result;
    }

    public Object getAnalysePlanParameterValue(String paramName, AnalysePlan ap) {
        Object result = null;
        if (ap != null) {
            try {
                result = AnalysePlanStorage.getParameterValue(ap, paramName);
            }
            catch (IsisFishException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't get analyse plan param value", (Throwable)e);
                }
                ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.getparametervalue"), e);
            }
        }
        return result;
    }

    public void setAnalysePlanParameterValue(String paramName, AnalysePlan ap, Object value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("paramName : " + paramName + " analysePlanName : " + ap + " value : " + value));
        }
        try {
            AnalysePlanStorage.setParameterValue(ap, paramName, value);
        }
        catch (IsisFishException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't set analyse plan param value", (Throwable)e);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.setparametervalue"), e);
        }
    }

    public List<String> getSensitivityExportNames() {
        ArrayList<String> result = new ArrayList<String>();
        List<String> exportNames = SensitivityExportStorage.getSensitivityExportNames();
        for (String export : exportNames) {
            result.add(export);
        }
        return result;
    }

    public List<SensitivityExport> getSensitivityExports() {
        List<SensitivityExport> result = this.param.getSensitivityExport();
        return result;
    }

    public void addSensitivityExport(String name) {
        block2: {
            try {
                SensitivityExportStorage storage = SensitivityExportStorage.getSensitivityExport(name);
                SensitivityExport sensitivityExport = storage.getNewSensitivityExportInstance();
                this.param.getSensitivityExport().add(sensitivityExport);
            }
            catch (IsisFishException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't add sensitivity export", (Throwable)e);
            }
        }
    }

    public void removeSensitivityExport(SensitivityExport export) {
        this.param.getSensitivityExport().remove(export);
    }

    public void clearSensitivityExport() {
        this.param.getSensitivityExport().clear();
    }

    public Map<String, Class<?>> getSensitivityExportParameterNames(SensitivityExport export) {
        return SensitivityExportStorage.getParameterNames(export);
    }

    public void setSensitivityExportParameterValue(Export export, String paramName, Object value) {
        block3: {
            if (value != null) {
                try {
                    SensitivityExportStorage.setParameterValue(export, paramName, value);
                }
                catch (IsisFishException e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)"Can't set sensitivity export param value", (Throwable)e);
                }
            }
        }
    }

    public Object getSensitivityExportParameterValue(SensitivityExport sensitivityExport, String paramName) {
        Object result;
        block2: {
            result = null;
            try {
                result = SensitivityExportStorage.getParameterValue(sensitivityExport, paramName);
            }
            catch (IsisFishException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't get sensitivity export param value", (Throwable)e);
            }
        }
        return result;
    }

    public List<String> getSensitivityNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (String r : SensitivityStorage.getSensitivityNames()) {
            if (!r.endsWith(".java")) continue;
            result.add(r.substring(0, r.length() - 5));
        }
        return result;
    }

    public SensitivityCalculator getSensitivityCalculator() {
        return this.param.getSensitivityCalculator();
    }

    public SensitivityCalculator getSensivitityCalculatorInstance(String name) {
        SensitivityCalculator sensitivityCalculator;
        block2: {
            sensitivityCalculator = null;
            try {
                this.sensitivityStorage = SensitivityStorage.getSensitivity(name);
                sensitivityCalculator = this.sensitivityStorage.getNewSensitivityInstance();
            }
            catch (IsisFishException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't set sensitivity", (Throwable)e);
            }
        }
        return sensitivityCalculator;
    }

    public void setSensitivityCalculator(SensitivityCalculator sensitivityCalculator) {
        this.param.setSensitivityCalculator(sensitivityCalculator);
    }

    public List<Factor<?, ?>> getFactors() {
        ArrayList result = new ArrayList();
        for (Map.Entry<String, Factor> entry : this.factors.entrySet()) {
            result.add(entry.getValue());
        }
        Collections.sort(result, new Comparator<Factor<?, ?>>(){

            @Override
            public int compare(Factor<?, ?> o1, Factor<?, ?> o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return result;
    }

    public void addFactor(Factor<?, ?> f, JComponent c) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add factor (" + f.getName() + ") : " + f.getPath()));
        }
        this.factors.put(f.getPath() + f.getName(), f);
        this.factorComponent.put(f.getPath() + f.getName(), c);
        this.designPlan.setFactors(this.getFactors());
    }

    public void addContinuousFactor(String name, String comment, String path, Double min, Double max, JComponent c, boolean exist) {
        Factor f = new Factor(name);
        ContinuousDomain domain = new ContinuousDomain();
        domain.setMinBound(min);
        domain.setMaxBound(max);
        f.setDomain(domain);
        f.setComment(comment);
        f.setPath(path);
        if (exist) {
            this.removeFactor(f);
        }
        this.addFactor(f, c);
    }

    public void addDiscreteFactor(String name, String comment, String path, List<Serializable> values, JComponent c, boolean exist) {
        Factor f = new Factor(name);
        DiscreteDomain domain = new DiscreteDomain();
        int i = 0;
        for (Serializable value : values) {
            domain.getValues().put(i, value);
            ++i;
        }
        f.setDomain(domain);
        f.setComment(comment);
        f.setPath(path);
        if (exist) {
            this.removeFactor(f);
        }
        this.addFactor(f, c);
    }

    public void addContinuousEquationFactor(String name, String comment, String path, EquationContinuousDomain domain, JComponent c, boolean exist) {
        Factor<Double, Double> f = new Factor<Double, Double>(name + "." + domain.getVariableName());
        f.setDomain(domain);
        f.setComment(comment);
        f.setPath(path);
        if (exist) {
            this.removeFactor(f);
        }
        this.addFactor(f, c);
    }

    public void addContinuousMatrixFactor(String name, String comment, String path, Double coef, MatrixND matrix, String operateur, JComponent c, boolean exist) {
        Factor<MatrixND, Double> f = new Factor<MatrixND, Double>(name);
        MatrixContinuousDomain domain = new MatrixContinuousDomain();
        domain.setMatrix(matrix);
        domain.setOperator(operateur);
        domain.setCoefficient(coef);
        f.setComment(comment);
        f.setDomain(domain);
        f.setPath(path);
        if (exist) {
            this.removeFactor(f);
        }
        this.addFactor(f, c);
    }

    public JComponent getFactorComponent(Factor<?, ?> f) {
        return this.factorComponent.get(f.getPath() + f.getName());
    }

    public void removeFactor(Factor<?, ?> f) {
        this.factors.remove(f.getPath() + f.getName());
        this.factorComponent.remove(f.getPath() + f.getName());
        this.designPlan.setFactors(this.getFactors());
    }

    public SimulationParameter getSimulationParameter() {
        return this.param;
    }

    public void setSimulationParameter(SimulationParameter p) {
        this.param = p;
    }

    public SimulationStorage getSimulationStorage() {
        return this.simulStorage;
    }

    public RegionStorage getRegionStorage() {
        return this.regionStorage;
    }

    public List<SimulatorLauncher> getSimulationLauncher() {
        return SimulationService.getService().getSimulationLaunchers();
    }

    public void launchSimulation(String simulationId, SimulatorLauncher launcher) {
        String fullSimulationId = "sim_" + simulationId + "_" + DATEFORMAT.format(new Date());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Launch simulation with custom launcher " + launcher.toString()));
        }
        try {
            if ("".equals(fullSimulationId) || SimulationStorage.localyExists(fullSimulationId) || SimulationService.getService().exists(fullSimulationId)) {
                ErrorHelper.showErrorDialog(I18n._((String)"isisfish.simulator.simulaction.badid", (Object[])new Object[]{fullSimulationId}), null);
            } else {
                SimulationService.getService().submit(fullSimulationId, this.param, launcher, 0);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't start simulation", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.launchsimulation"), eee);
        }
    }

    public void launchSimulation(String simulationId, SimulatorLauncher launcher, SensitivityCalculator sensitivityCalculator, DesignPlan designPlan) {
        String fullSimulationId = "as_" + simulationId + "_" + DATEFORMAT.format(new Date());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Launch factor simulation with custom launcher " + launcher.toString()));
            log.debug((Object)("Using sensitivityCalculator : " + sensitivityCalculator.getDescription()));
        }
        try {
            if ("".equals(fullSimulationId) || SimulationStorage.localyExists(fullSimulationId) || SimulationService.getService().exists(fullSimulationId)) {
                ErrorHelper.showErrorDialog(I18n._((String)"isisfish.simulator.simulaction.badid", (Object[])new Object[]{fullSimulationId}), null);
            } else {
                SimulationService.getService().submit(fullSimulationId, this.param, launcher, 0, sensitivityCalculator, designPlan);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't start simulation", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.simulation.launchsimulation"), eee);
        }
    }

    public void launchSimulationWithSensibility(String simulationId, SimulatorLauncher launcher) {
        this.launchSimulation(simulationId, launcher, this.getSensitivityCalculator(), this.designPlan);
    }

    public void runSensitivitySecondPass(String masterSensitivitySimulationName) {
        SensitivityCalculator sensitivityCalculator = null;
        TreeMap<Integer, SimulationStorage> simulationStorageForAnalyze = new TreeMap<Integer, SimulationStorage>();
        File simuationDirectory = SimulationStorage.getSimulationDirectory();
        for (File simuation : simuationDirectory.listFiles()) {
            if (!simuation.isDirectory() || !simuation.getName().startsWith(masterSensitivitySimulationName + "_")) continue;
            SimulationStorage storage = SimulationStorage.getSimulation(simuation.getName());
            String suffix = simuation.getName().substring(simuation.getName().lastIndexOf("_") + 1);
            simulationStorageForAnalyze.put(Integer.valueOf(suffix), storage);
            if (sensitivityCalculator != null) continue;
            SimulationParameter params = storage.getParameter();
            sensitivityCalculator = params.getSensitivityCalculator();
        }
        if (sensitivityCalculator != null) {
            try {
                File masterExportDirectory = new File(SimulationStorage.getSensitivityResultsDirectory(), masterSensitivitySimulationName);
                if (!masterExportDirectory.isDirectory()) {
                    masterExportDirectory.mkdirs();
                }
                ArrayList<SimulationStorage> simulationStorageForAnalyzeList = new ArrayList<SimulationStorage>(simulationStorageForAnalyze.values());
                sensitivityCalculator.analyzeResult(simulationStorageForAnalyzeList, masterExportDirectory);
            }
            catch (SensitivityException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't call analyse result", (Throwable)e);
                }
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Can't run sensitivity second pass");
        }
    }

    public List<File> getSensitivitySecondPassResults(String masterSensitivitySimulationName) {
        ArrayList<File> result = new ArrayList<File>();
        File masterExportDirectory = new File(SimulationStorage.getSensitivityResultsDirectory(), masterSensitivitySimulationName);
        if (masterExportDirectory.isDirectory()) {
            for (File exportFile : masterExportDirectory.listFiles()) {
                if (!exportFile.isFile() || exportFile.getName().startsWith(".")) continue;
                result.add(exportFile);
            }
        }
        return result;
    }
}

