/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.sensitivity;

import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityTableModel;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityUtils;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;
import org.nuiton.topia.persistence.TopiaEntity;

public class TableBlockingLayerUI
extends AbstractLayerUI<JComponent> {
    private static final long serialVersionUID = 1877010363682882308L;
    private static Log log = LogFactory.getLog(TableBlockingLayerUI.class);
    protected InputContentUI parent;

    public TableBlockingLayerUI(InputContentUI parent) {
        this.parent = parent;
    }

    protected void processMouseEvent(MouseEvent event, JXLayer<JComponent> layer) {
        JTable tableSource;
        TableModel model;
        if (!(event.getSource() instanceof JScrollBar)) {
            event.consume();
        }
        if (event.getSource() instanceof JTable && (model = (tableSource = (JTable)event.getSource()).getModel()) instanceof SensitivityTableModel) {
            SensitivityTableModel sensitivityTableModel = (SensitivityTableModel)((Object)model);
            if (event.getID() == 505) {
                Cursor cursor = new Cursor(0);
                tableSource.setCursor(cursor);
            } else {
                int rowIndex = tableSource.rowAtPoint(event.getPoint());
                int columnIndex = tableSource.columnAtPoint(event.getPoint());
                if (rowIndex >= 0 && columnIndex >= 0) {
                    SensitivityTableModel sensitivityModel = (SensitivityTableModel)((Object)model);
                    TopiaEntity value = (TopiaEntity)sensitivityTableModel.getBeanAtRow(rowIndex);
                    Class<?> beanClass = value.getClass();
                    String property = sensitivityModel.getPropertyAtColumn(columnIndex);
                    String sensitivityName = beanClass.getSimpleName().replaceFirst("Impl", "") + "." + property;
                    if (SensitivityUtils.isSensitivityFactorEnabled(sensitivityName)) {
                        if (event.getID() == 500) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Clic done on an enabled factor : " + sensitivityName));
                            }
                            this.parent.displayFactorWizard(tableSource, beanClass, value.getTopiaId(), property);
                        } else if (event.getID() == 503) {
                            Cursor cursor = new Cursor(1);
                            tableSource.setCursor(cursor);
                        }
                    } else {
                        Cursor cursor = new Cursor(0);
                        tableSource.setCursor(cursor);
                    }
                }
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent e, JXLayer<JComponent> l) {
        this.processMouseEvent(e, l);
    }
}

