/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.sensitivity;

import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Port;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.TripType;
import fr.ifremer.isisfish.entities.VesselType;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.ui.input.CellUI;
import fr.ifremer.isisfish.ui.input.FisheryRegionUI;
import fr.ifremer.isisfish.ui.input.GearUI;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.InputSaveVerifier;
import fr.ifremer.isisfish.ui.input.MetierUI;
import fr.ifremer.isisfish.ui.input.PopulationUI;
import fr.ifremer.isisfish.ui.input.PortUI;
import fr.ifremer.isisfish.ui.input.SetOfVesselsUI;
import fr.ifremer.isisfish.ui.input.SpeciesUI;
import fr.ifremer.isisfish.ui.input.StrategyUI;
import fr.ifremer.isisfish.ui.input.TripTypeUI;
import fr.ifremer.isisfish.ui.input.VesselTypeUI;
import fr.ifremer.isisfish.ui.input.ZoneUI;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityTabUI;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import jaxx.runtime.Decorator;
import jaxx.runtime.JAXXContextEntryDef;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.PropertyDecorator;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationTreeModelBuilder;
import jaxx.runtime.swing.navigation.NavigationTreeSelectionAdapter;
import jaxx.runtime.swing.navigation.NavigationTreeSelectionAdapterWithCardLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;

public class SensitivityNavigationTreeSelectionAdapter
extends NavigationTreeSelectionAdapterWithCardLayout {
    private static final Log log = LogFactory.getLog(SensitivityNavigationTreeSelectionAdapter.class);
    protected NavigationTreeModel.NavigationTreeNode currentNode = null;
    protected InputContentUI currentUI = null;
    protected TopiaEntity currentEntity = null;

    public SensitivityNavigationTreeSelectionAdapter(SensitivityTabUI context) {
        super(SensitivityTabUI.class, null, (JAXXObject)context, NavigationTreeSelectionAdapter.Strategy.PER_UI_TYPE);
        if (context.getNavigation() == null) {
            throw new IllegalArgumentException("could not have a null 'navigation' in ui " + context);
        }
        context.getNavigation().addTreeSelectionListener((TreeSelectionListener)((Object)this));
    }

    protected JPanel getContentContainer() {
        return ((SensitivityTabUI)this.context).getInputPane();
    }

    protected CardLayout2 getContentLayout() {
        return ((SensitivityTabUI)this.context).getCardlayout();
    }

    protected NavigationTreeModel getNavigationTreeModel() {
        return (NavigationTreeModel)((SensitivityTabUI)this.context).getNavigation().getModel();
    }

    protected void goBackToPreviousNode(TreeSelectionEvent event, Exception e) {
        if (e != null && log.isErrorEnabled()) {
            log.error((Object)"Go bak to previous node", (Throwable)e);
        }
    }

    protected JAXXTree getNavigationTree() {
        return ((SensitivityTabUI)this.context).getNavigation();
    }

    protected void openUI(Component newUI, NavigationTreeModel.NavigationTreeNode node) throws Exception {
        super.openUI(newUI, node);
        try {
            this.currentUI = (InputContentUI)newUI;
            if (this.currentUI != null) {
                this.currentUI.setSensitivity(true);
                ((InputSaveVerifier)this.context.getContextValue(InputSaveVerifier.class)).addCurrentPanel(this.currentUI);
                this.currentUI.setLayer(true);
                this.currentUI.setActionButtons();
            }
            this.currentNode = node;
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected boolean closeUI(TreeSelectionEvent event, Component component) throws Exception {
        boolean exit = true;
        return exit;
    }

    protected void addSelectedBeanInContext(NavigationTreeModel.NavigationTreeNode node, Object data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("find data for contextPath <" + node.getContextPath() + "> : " + (data == null ? null : data.getClass())));
        }
        InputSaveVerifier verif = (InputSaveVerifier)this.context.getContextValue(InputSaveVerifier.class);
        verif.removeAllEntity();
        if (TopiaEntity.class.isInstance(data)) {
            verif.addCurrentEntity((TopiaEntity)data);
        } else {
            verif.addCurrentEntity(null);
        }
        verif.setCurrentNode(node);
    }

    public static NavigationTreeModel getTreeModel(String regionName, FisheryRegion fisheryRegion) {
        NavigationTreeModelBuilder builder = new NavigationTreeModelBuilder("/");
        if (regionName == null) {
            return null;
        }
        NavigationTreeModelBuilder.ChildBuilder<TopiaEntity> childBuilder = new NavigationTreeModelBuilder.ChildBuilder<TopiaEntity>(builder){
            Decorator<? extends TopiaEntity> decorator;

            public void init(Class<? extends TopiaEntity> klass) {
                this.decorator = PropertyDecorator.newDecorator(klass, (String)"name");
            }

            public Decorator<? extends TopiaEntity> getDecorator(TopiaEntity child) {
                return this.decorator;
            }

            public String getJXPath(TopiaEntity child) {
                return "..[@topiaId=\"" + child.getTopiaId() + "\"]";
            }

            public String getNavigationPath(TopiaEntity child) {
                return child.getTopiaId();
            }
        };
        try {
            NavigationTreeModel.NavigationTreeNode root = builder.build(null, regionName, JAXXContextEntryDef.newDef(FisheryRegion.class), "$root", FisheryRegionUI.class, null);
            childBuilder.build(builder.build(root, I18n._((String)"isisfish.input.tree.cells"), "../cell", "$cells", CellUI.class, null), true, Cell.class, fisheryRegion.getCell(), CellUI.class, null);
            childBuilder.build(builder.build(root, I18n._((String)"isisfish.input.tree.zones"), "../zone", "$zones", ZoneUI.class, null), true, Zone.class, fisheryRegion.getZone(), ZoneUI.class, null);
            childBuilder.build(builder.build(root, I18n._((String)"isisfish.input.tree.ports"), "../port", "$ports", PortUI.class, null), true, Port.class, fisheryRegion.getPort(), PortUI.class, null);
            NavigationTreeModel.NavigationTreeNode species = builder.build(root, I18n._((String)"isisfish.input.tree.species"), "../species", "$species", SpeciesUI.class, null);
            for (Species specie : fisheryRegion.getSpecies()) {
                NavigationTreeModel.NavigationTreeNode speciesChild = builder.build(species, (Decorator)PropertyDecorator.newDecorator(Species.class, (String)"name"), "..[@topiaId=\"" + specie.getTopiaId() + "\"]", specie.getTopiaId(), SpeciesUI.class, null);
                NavigationTreeModel.NavigationTreeNode populations = builder.build(speciesChild, I18n._((String)"isisfish.input.tree.populations"), "../population", "$populations", PopulationUI.class, null);
                childBuilder.build(populations, true, Population.class, specie.getPopulation(), PopulationUI.class, null);
            }
            childBuilder.build(builder.build(root, I18n._((String)"isisfish.input.tree.gears"), "../gear", "$gears", GearUI.class, null), true, Gear.class, fisheryRegion.getGear(), GearUI.class, null);
            childBuilder.build(builder.build(root, I18n._((String)"isisfish.input.tree.metiers"), "../metier", "$metiers", MetierUI.class, null), true, Metier.class, fisheryRegion.getMetier(), MetierUI.class, null);
            childBuilder.build(builder.build(root, I18n._((String)"isisfish.input.tree.triptypes"), "../tripType", "$tripTypes", TripTypeUI.class, null), true, TripType.class, fisheryRegion.getTripType(), TripTypeUI.class, null);
            childBuilder.build(builder.build(root, I18n._((String)"isisfish.input.tree.vesseltypes"), "../vesselType", "$vesselTypes", VesselTypeUI.class, null), true, VesselType.class, fisheryRegion.getVesselType(), VesselTypeUI.class, null);
            childBuilder.build(builder.build(root, I18n._((String)"isisfish.input.tree.setofvessels"), "../setOfVessels", "$setOfVessels", SetOfVesselsUI.class, null), true, SetOfVessels.class, fisheryRegion.getSetOfVessels(), SetOfVesselsUI.class, null);
            childBuilder.build(builder.build(root, I18n._((String)"isisfish.input.tree.strategies"), "../strategy", "$strategies", StrategyUI.class, null), true, Strategy.class, fisheryRegion.getStrategy(), StrategyUI.class, null);
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return builder.getModel();
    }
}

