/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.result;

import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.map.ResultatLayer;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.types.Date;
import fr.ifremer.isisfish.ui.result.DataResult;
import fr.ifremer.isisfish.ui.result.GraphBean;
import fr.ifremer.isisfish.ui.result.GraphBeanModel;
import fr.ifremer.isisfish.ui.result.InfoItem;
import fr.ifremer.isisfish.ui.result.InfoItemDate;
import fr.ifremer.isisfish.ui.result.InfoPanelable;
import fr.ifremer.isisfish.ui.result.ResultEditUI;
import fr.ifremer.isisfish.ui.result.ResumePanel;
import fr.ifremer.isisfish.ui.result.SimpleResultatMapBean;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.util.FileUtil;
import org.nuiton.util.Resource;

public class ResultEdit
extends ResultEditUI {
    private static Log log = LogFactory.getLog(ResultEdit.class);
    static final String ABONDANCE_STRING = I18n._((String)"isisfish.result.abundance");
    static final String CAPTUREPARMETIER_STRING = I18n._((String)"isisfish.result.capture.metier");
    static final String REJETPARMETIER_STRING = I18n._((String)"isisfish.result.reject.metier");
    static final String DEBARQUEMENTPARMETIER_STRING = I18n._((String)"isisfish.result.unload.metier");
    static final String EFFORTPARMETIER_STRING = I18n._((String)"isisfish.result.stress.metier");
    static final String CAPTURE_STRING = I18n._((String)"isisfish.result.capture");
    SimulationStorage simulation = null;
    ResultStorage resultManager = null;
    DataResult dataBean;
    SimpleResultatMapBean mapBean;
    GraphBean graphBean;
    ResumePanel resumeBean;
    TopiaContext tx;
    InfoPanelable[] infoItemTab = null;

    public ResultEdit(SimulationStorage simulation) {
        this.setStatusOK(false);
        this.init();
        this.initObjet();
        this.setSimulation(simulation);
        this.setStatusOK(true);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.tx != null) {
            this.tx.closeContext();
        }
    }

    private void initObjet() {
        this.getResultat().setEditable(false);
        this.mapBean = new SimpleResultatMapBean();
        this.graphBean = new GraphBean();
        this.graphBean.setModel(new GraphBeanModel());
        this.dataBean = new DataResult();
        this.resumeBean = new ResumePanel();
        ButtonGroup group = new ButtonGroup();
        group.add(this.getMapRadioButton());
        group.add(this.getGraphRadioButton());
        group.add(this.getDonneeRadioButton());
        group.add(this.getResumeRadioButton());
        this.getAjoutRendu().setText(null);
        this.getAjoutRendu().setIcon(Resource.getIcon((String)"images/Right.gif"));
        this.getAjoutRendu().setMargin(new Insets(0, 0, 0, 0));
        this.getStatusImage().setMargin(new Insets(0, 0, 0, 0));
        this.getViewPanel().setLayout(new GridBagLayout());
    }

    void setStatusOK(boolean state) {
        if (state) {
            this.getStatusImage().setIcon(Resource.getIcon((String)"images/BulbG.gif"));
        } else {
            this.getStatusImage().setIcon(Resource.getIcon((String)"images/BulbR.gif"));
        }
        this.getStatusImage().paintImmediately(0, 0, 25, 25);
    }

    protected InfoPanelable[] createInfoPanel(MatrixND group) {
        if (group == null) {
            return new InfoPanelable[0];
        }
        InfoPanelable[] result = new InfoPanelable[group.getNbDim()];
        InfoItemDate infoItemDate = new InfoItemDate();
        infoItemDate.getList().setListData(group.getSemantics(0).toArray());
        result[0] = infoItemDate;
        for (int i = 1; i < group.getNbDim(); ++i) {
            InfoItem item = new InfoItem();
            if (group.getDimensionName(i).equals("")) {
                item.getLabel().setText(I18n._((String)"isisfish.result.dimension") + " " + i);
            } else {
                item.getLabel().setText(I18n._((String)group.getDimensionName(i)));
            }
            List elems = group.getSemantics(i);
            item.getList().setListData(elems.toArray());
            result[i] = item;
        }
        return result;
    }

    void redrawInfoPanel(InfoPanelable[] infoItems) {
        this.getInfoPanel().removeAll();
        this.getInfoPanel().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 1;
        for (int i = 0; i < infoItems.length; ++i) {
            c.gridy = i;
            this.getInfoPanel().add((Component)((Object)infoItems[i]), c);
        }
        this.getScroll().invalidate();
        this.getScroll().validate();
        this.repaint();
    }

    public SimulationStorage getSimulation() {
        return this.simulation;
    }

    public void setSimulation(SimulationStorage simulation) {
        try {
            this.simulation = simulation;
            if (this.tx != null) {
                this.tx.closeContext();
            }
            this.tx = simulation.getStorage().beginTransaction();
            FisheryRegion region = SimulationStorage.getFisheryRegion(this.tx);
            this.mapBean.setRegion(region);
            this.resultManager = simulation.getResultStorage();
            this.getResultat().removeAllItems();
            for (String item : this.resultManager.getResultName()) {
                this.getResultat().addItem(item);
            }
            this.loadResume(simulation, this.resultManager);
        }
        catch (Exception eee) {
            log.warn((Object)"Can't change simulation storage", (Throwable)eee);
        }
    }

    public void loadResume(SimulationStorage simulation, ResultStorage resultManager) {
        SimulationParameter sp = simulation.getParameter();
        StringBuffer resume = new StringBuffer(((Object)sp).toString());
        resume.append("\n");
        for (String name : resultManager.getResultName()) {
            try {
                MatrixND mat1;
                if (name.startsWith(ABONDANCE_STRING)) {
                    mat1 = resultManager.getMatrix(new Date(0), name, this.tx);
                    mat1 = mat1.sumOverDim(0);
                    mat1 = mat1.sumOverDim(1);
                    mat1 = mat1.reduce();
                    resume.append(I18n._((String)"isisfish.result.begin.simulation")).append(mat1.getName()).append(": ").append(mat1.getValue(0)).append("\n");
                    mat1 = resultManager.getMatrix(resultManager.getLastDate(), name, this.tx);
                    mat1 = mat1.sumOverDim(0);
                    mat1 = mat1.sumOverDim(1);
                    mat1 = mat1.reduce();
                    resume.append(I18n._((String)"isisfish.result.end.simulation")).append(mat1.getName()).append(": ").append(mat1.getValue(0)).append("\n");
                    continue;
                }
                if (name.startsWith(REJETPARMETIER_STRING)) {
                    mat1 = resultManager.getMatrix(name, this.tx);
                    mat1 = mat1.sumOverDim(0);
                    mat1 = mat1.sumOverDim(1);
                    mat1 = mat1.sumOverDim(2);
                    mat1 = mat1.sumOverDim(3);
                    mat1 = mat1.reduce();
                    resume.append(I18n._((String)"isisfish.common.sum")).append(mat1.getName()).append(": ").append(mat1.getValue(0)).append("\n");
                    continue;
                }
                if (name.startsWith(CAPTUREPARMETIER_STRING) || !name.startsWith(CAPTURE_STRING)) continue;
                mat1 = resultManager.getMatrix(name, this.tx);
                mat1 = mat1.sumOverDim(0);
                mat1 = mat1.sumOverDim(1);
                mat1 = mat1.sumOverDim(2);
                mat1 = mat1.reduce();
                resume.append(I18n._((String)"isisfish.common.sum")).append(mat1.getName()).append(": ").append(mat1.getValue(0)).append("\n");
            }
            catch (Exception eee) {
                resume.append(I18n._((String)"isisfish.error.no.matrix", (Object[])new Object[]{name}));
            }
        }
        resume.append("\n\n");
        resume.append(simulation.getInformation().toString());
        this.resumeBean.setResume(resume.toString());
        this.getResumeRadioButton().setSelected(true);
    }

    protected MatrixND createAndReduce(MatrixND matrix, InfoPanelable[] infoItems) {
        for (int i = 0; i < infoItems.length; ++i) {
            InfoPanelable item = infoItems[i];
            JList list = item.getList();
            int[] indList = list.getSelectedIndices();
            if (indList.length == 0) {
                list.setSelectionInterval(0, list.getModel().getSize() - 1);
                indList = list.getSelectedIndices();
            }
            log.debug((Object)("matrice avant submatrice de la dim " + i + " :" + matrix));
            if (0 < indList.length && indList.length < matrix.getDim(i)) {
                matrix = matrix.getSubMatrix(i, indList);
            }
            log.debug((Object)("matrice apres submatrice de la dim " + i + " :" + matrix));
            if (item.getSumStep() != 1) {
                if ((matrix = matrix.sumOverDim(i, item.getSumStep())).getDim(i) == 1) {
                    matrix.setDimensionName(i, I18n._((String)"isisfish.common.sum"));
                } else {
                    String name = matrix.getDimensionName(i) + " " + I18n._((String)"isisfish.common.sum");
                    if (item instanceof InfoItemDate) {
                        name = I18n._((String)"isisfish.common.year");
                    }
                    matrix.setDimensionName(i, name);
                }
                List sem = matrix.getSemantics(i);
                if (sem instanceof List) {
                    List semList = sem;
                    ArrayList<Date> newList = new ArrayList<Date>();
                    for (int index = 0; index < semList.size(); ++index) {
                        Object semObject = semList.get(index);
                        if (semObject instanceof Date) {
                            Date semDate = (Date)semObject;
                            Date newDate = new Date(semDate.getDate() * item.getSumStep());
                            newList.add(newDate);
                            continue;
                        }
                        newList.add((Date)semObject);
                    }
                    matrix.setSemantics(i, newList);
                }
            }
            log.debug((Object)("matrice apres sum de la dim " + i + " :" + matrix));
        }
        log.debug((Object)("Matrice avant le reduce: " + matrix));
        MatrixND result = matrix.reduce(2);
        return result;
    }

    public void addRendu(MatrixND matrix, InfoPanelable[] infoItems) {
        this.setStatusOK(false);
        log.debug((Object)("La matrice avant r\u00e9duction est: " + matrix));
        MatrixND matInfo = this.createAndReduce(matrix, infoItems);
        log.debug((Object)("La matrice apr\u00e8s r\u00e9duction est: " + matInfo));
        if (matInfo.getNbDim() > 2) {
            JOptionPane.showMessageDialog(null, I18n._((String)"isisfish.error.matrix.more.2d"), I18n._((String)"isisfish.common.alert"), 0);
            return;
        }
        if (matInfo.getNbDim() == 2) {
            try {
                ResultatLayer layer = new ResultatLayer();
                layer.setMatriceInfo(matInfo);
                this.mapBean.removeAllResultatLayer();
                this.mapBean.addResultatLayer(matInfo.getName(), layer);
            }
            catch (Exception eee) {
                log.warn((Object)"Erreur lors de l'ajout du r\u00e9sultat \u00e0 la carte. ", (Throwable)eee);
                JOptionPane.showMessageDialog(null, I18n._((String)"isisfish.error.add.card"), I18n._((String)"isisfish.common.alert"), 0);
            }
        }
        try {
            this.graphBean.getModel().setMatrix(matInfo);
        }
        catch (Exception eee) {
            log.warn((Object)"Erreur lors de l'ajout du r\u00e9sultat au graph.", (Throwable)eee);
            JOptionPane.showMessageDialog(null, I18n._((String)"isisfish.error.add.result.graph"), I18n._((String)"isisfish.common.alert"), 0);
        }
        try {
            this.dataBean.setMatrix(matInfo);
        }
        catch (Exception eee) {
            log.warn((Object)"Erreur lors de l'ajout du r\u00e9sultat au data.", (Throwable)eee);
            JOptionPane.showMessageDialog(null, I18n._((String)"isisfish.error.add.result.data"), I18n._((String)"isisfish.common.alert"), 0);
        }
        this.setStatusOK(true);
    }

    @Override
    public void on_ajoutRendu_clicked() {
        String resultName = (String)this.getResultat().getSelectedItem();
        if (resultName != null) {
            if (this.getViewPanel().getComponentCount() == 1 && this.getViewPanel().getComponent(0) == this.resumeBean) {
                this.graphBean.getGraphSplitPane().setDividerLocation(1.0);
                this.getGraphRadioButton().setSelected(true);
            }
            this.addRendu(this.resultManager.getMatrix(resultName, this.tx), this.infoItemTab);
        }
    }

    @Override
    public void on_resultat_selection_notify_event(ItemEvent e) {
        if (e.getStateChange() == 1) {
            String resultName = (String)e.getItem();
            MatrixND matrix = this.resultManager.getMatrix(resultName, this.tx);
            this.infoItemTab = this.createInfoPanel(matrix);
            this.redrawInfoPanel(this.infoItemTab);
        }
    }

    @Override
    public void on_graphRadioButton_toggled(ChangeEvent e) {
        if (this.getGraphRadioButton().isSelected()) {
            this.graphBean.getGraphSplitPane().setDividerLocation(1.0);
            this.setViewBean(this.graphBean);
        }
    }

    @Override
    public void on_mapRadioButton_toggled(ChangeEvent e) {
        if (this.getMapRadioButton().isSelected()) {
            this.setViewBean(this.mapBean);
        }
    }

    @Override
    public void on_donneeRadioButton_toggled(ChangeEvent e) {
        if (this.getDonneeRadioButton().isSelected()) {
            this.setViewBean(this.dataBean);
        }
    }

    @Override
    public void on_resumeRadioButton_toggled(ChangeEvent e) {
        if (this.getResumeRadioButton().isSelected()) {
            this.setViewBean(this.resumeBean);
        }
    }

    public void setViewBean(JPanel bean) {
        this.setStatusOK(false);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 1;
        this.getViewPanel().removeAll();
        this.getViewPanel().add((Component)bean, c);
        this.getViewPanel().invalidate();
        this.getViewPanel().validate();
        this.getViewPanel().repaint();
        this.graphBean.getGraphSplitPane().setDividerLocation(1.0);
        this.setStatusOK(true);
    }

    @Override
    public Vector getMenuExport_menuChilds() {
        Vector<JMenuItem> result = new Vector<JMenuItem>();
        for (String name : ExportStorage.getExportNames()) {
            JMenuItem item = this.getExportMenu(name);
            result.add(item);
        }
        return result;
    }

    protected JMenuItem getExportMenu(String methodName) {
        JMenuItem result = new JMenuItem(I18n._((String)methodName));
        result.addActionListener(new ExportActionListener(methodName));
        return result;
    }

    protected class ExportActionListener
    implements ActionListener {
        private String name;

        public ExportActionListener(String name) {
            this.name = name;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                File file = FileUtil.getFile((String[])new String[]{".+.txt", I18n._((String)"isisfish.result.export.file")});
                if (file != null) {
                    BufferedWriter out = new BufferedWriter(new FileWriter(file));
                    ExportStorage storage = ExportStorage.getExport(this.name);
                    Export export = storage.getNewExportInstance();
                    export.export(ResultEdit.this.simulation, out);
                    ((Writer)out).close();
                }
            }
            catch (Exception eee) {
                log.warn((Object)"Erreur lors de l'export ", (Throwable)eee);
            }
        }
    }
}

