/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.result;

import fr.ifremer.isisfish.types.Date;
import javax.swing.table.AbstractTableModel;
import org.nuiton.math.matrix.MatrixException;
import org.nuiton.math.matrix.MatrixND;

public class MatrixInfoTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 2632133167225155487L;
    protected MatrixND matrix;

    public MatrixInfoTableModel(MatrixND mat) {
        if (mat.getNbDim() > 2) {
            throw new MatrixException("matrice with more than 2 dimension not supported.");
        }
        this.matrix = mat;
    }

    @Override
    public int getRowCount() {
        if (this.matrix == null || this.matrix.getNbDim() < 1) {
            return 0;
        }
        return this.matrix.getDim(0);
    }

    @Override
    public int getColumnCount() {
        if (this.matrix == null || this.matrix.getNbDim() < 1) {
            return 0;
        }
        return this.matrix.getDim(1) + 1;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            Object obj = this.matrix.getSemantics(0).get(row);
            if (obj instanceof Date) {
                return ((Date)obj).getMonth().toString() + " " + ((Date)obj).getYear();
            }
            return obj.toString();
        }
        if (this.matrix.getNbDim() == 1) {
            return "" + this.matrix.getValue(column - 1);
        }
        return "" + this.matrix.getValue(row, column - 1);
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return this.matrix.getDimensionName(0) + "\\" + this.matrix.getDimensionName(1);
        }
        return "" + this.matrix.getSemantics(1).get(column - 1);
    }
}

