/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.result;

import fr.ifremer.isisfish.ui.result.DataResultUI;
import fr.ifremer.isisfish.ui.result.MatrixInfoTableModel;
import java.io.File;
import java.io.FileWriter;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.util.FileUtil;

public class DataResult
extends DataResultUI {
    private static final long serialVersionUID = -4089377865270062094L;
    private static Log log = LogFactory.getLog(DataResult.class);
    protected MatrixND matrix;

    public DataResult() {
        this.init();
    }

    public MatrixND getMatrix() {
        return this.matrix;
    }

    public void setMatrix(MatrixND v) {
        this.matrix = v;
        this.reload();
    }

    public void reload() {
        this.loadDescription();
        this.loadMatrice();
    }

    public void loadDescription() {
        this.getDescriptionLabel().setText(this.getMatrix().getName());
    }

    public void loadMatrice() {
        this.getMatriceTable().setModel(new MatrixInfoTableModel(this.getMatrix()));
    }

    @Override
    public void on_exportButton_clicked() {
        String result = this.getMatrix().getName() + ";";
        try {
            File file = FileUtil.getFile((String[])new String[]{".+.csv", "CSV file"});
            if (file != null) {
                Iterator i = this.getMatrix().getSemantics(1).iterator();
                while (i.hasNext()) {
                    result = result + i.next().toString();
                    if (i.hasNext()) {
                        result = result + ";";
                        continue;
                    }
                    result = result + "\n";
                }
                int y = 0;
                Iterator i2 = this.getMatrix().getSemantics(0).iterator();
                while (i2.hasNext()) {
                    result = result + i2.next().toString() + ";";
                    for (int x = 0; x < this.getMatrix().getDim(1); ++x) {
                        result = result + this.getMatrix().getValue(y, x) + ";";
                    }
                    result = result + "\n";
                    ++y;
                }
                FileWriter writer = new FileWriter(file);
                writer.write(result);
                writer.close();
            }
        }
        catch (Exception eee) {
            log.error((Object)(":104:Error during export" + eee));
        }
    }
}

