/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.sensitivity;

import fr.ifremer.isisfish.datastore.SensitivityStorage;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityCalculator;
import fr.ifremer.isisfish.ui.util.TooltipHelper;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.nuiton.i18n.I18n;

public class SensitivityCalculatorComboRenderer
extends DefaultListCellRenderer
implements ListCellRenderer {
    private static final long serialVersionUID = -4070846632975105788L;
    protected Map<String, SensitivityCalculator> sensitivityCalculatorCache = new HashMap<String, SensitivityCalculator>();

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        String sensitivityName = (String)value;
        c.setText(sensitivityName);
        try {
            SensitivityCalculator plan = this.sensitivityCalculatorCache.get(sensitivityName);
            if (plan == null) {
                SensitivityStorage storage = SensitivityStorage.getSensitivity(sensitivityName);
                plan = storage.getNewSensitivityInstance();
                this.sensitivityCalculatorCache.put(sensitivityName, plan);
            }
            c.setToolTipText(plan.getDescription());
        }
        catch (Exception e) {
            String errorTooltip = TooltipHelper.getErrorTooltip(I18n._((String)"isisfish.error.compile.fileerror", (Object[])new Object[]{sensitivityName}));
            c.setToolTipText(errorTooltip);
        }
        return c;
    }
}

