/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.rule;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.rule.Rule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class RuleParametersTableModel
extends AbstractTableModel {
    private static Log log = LogFactory.getLog(RuleParametersTableModel.class);
    private static final long serialVersionUID = 3169786638868209920L;
    public static final String[] COLUMN_NAMES = new String[]{I18n._((String)"isisfish.common.name"), I18n._((String)"isisfish.common.value")};
    protected Rule rule;
    protected List<String> ruleParametersNames;

    public RuleParametersTableModel(Rule rule) {
        this.rule = rule;
        this.ruleParametersNames = new ArrayList<String>();
        Map<String, Class<?>> ruleParametersNamesAndTypes = RuleStorage.getParameterNames(rule);
        for (String names : ruleParametersNamesAndTypes.keySet()) {
            this.ruleParametersNames.add(names);
        }
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        return this.ruleParametersNames.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        String name = this.ruleParametersNames.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                result = name;
                break;
            }
            case 1: {
                try {
                    result = RuleStorage.getParameterValue(this.rule, name);
                }
                catch (IsisFishException e) {
                    if (!log.isErrorEnabled()) break;
                    log.debug((Object)"Can't get parameters value", (Throwable)e);
                }
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("No such column " + columnIndex);
            }
        }
        return result;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class result = null;
        switch (columnIndex) {
            case 0: {
                result = String.class;
                break;
            }
            case 1: {
                result = Object.class;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("No such column " + columnIndex);
            }
        }
        return result;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cell edition (column " + columnIndex + ") = " + value));
        }
        String name = this.ruleParametersNames.get(rowIndex);
        switch (columnIndex) {
            case 1: {
                try {
                    RuleStorage.setParameterValue(this.rule, name, value);
                }
                catch (IsisFishException e) {
                    if (!log.isErrorEnabled()) break;
                    log.error((Object)"Can't set parameter value", (Throwable)e);
                }
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Can't edit column " + columnIndex);
            }
        }
    }
}

