/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.gear;

import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Selectivity;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityTableModel;
import java.awt.Component;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class GearPopulationSelectivityModel
extends AbstractTableModel
implements TableCellRenderer,
SensitivityTableModel {
    private static Log log = LogFactory.getLog(GearPopulationSelectivityModel.class);
    private static final long serialVersionUID = 3169786638868209920L;
    public static final String[] COLUMN_NAMES = new String[]{I18n._((String)"isisfish.common.population"), I18n._((String)"isisfish.common.equation")};
    protected List<Selectivity> selectivities;

    public GearPopulationSelectivityModel() {
        this(null);
    }

    public GearPopulationSelectivityModel(List<Selectivity> selectivities) {
        this.selectivities = selectivities;
    }

    public void setSelectivities(List<Selectivity> selectivities) {
        this.selectivities = selectivities;
    }

    public List<Selectivity> getSelectivities() {
        return this.selectivities;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        int rows = 0;
        if (this.selectivities != null) {
            rows = this.selectivities.size();
        }
        return rows;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        Selectivity selectivity = this.selectivities.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                result = selectivity.getPopulation().getName();
                break;
            }
            case 1: {
                result = selectivity.getEquation();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("No such column " + columnIndex);
            }
        }
        return result;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class result = null;
        switch (columnIndex) {
            case 0: {
                result = String.class;
                break;
            }
            case 1: {
                result = Equation.class;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("No such column " + columnIndex);
            }
        }
        return result;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cell edition (column " + columnIndex + ") = " + value));
        }
        Selectivity selectivity = this.selectivities.get(rowIndex);
        switch (columnIndex) {
            case 1: {
                Equation eq = (Equation)value;
                selectivity.setEquation(null);
                selectivity.setEquation(eq);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Can't edit column " + columnIndex);
            }
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent c = null;
        switch (column) {
            case 0: {
                c = new JLabel(value.toString());
                break;
            }
            case 1: {
                Equation equation = (Equation)value;
                c = new JButton(equation.getName() + "(" + equation.getCategory() + ")");
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("No such column " + column);
            }
        }
        return c;
    }

    @Override
    public String getPropertyAtColumn(int column) {
        String result = null;
        if (column == 1) {
            result = "equation";
        }
        return result;
    }

    @Override
    public Object getBeanAtRow(int rowIndex) {
        Selectivity result = null;
        result = this.selectivities.get(rowIndex);
        return result;
    }
}

