/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.check;

import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.Port;
import fr.ifremer.isisfish.entities.Selectivity;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.entities.TargetSpecies;
import fr.ifremer.isisfish.entities.TripType;
import fr.ifremer.isisfish.entities.VesselType;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.ui.input.check.CheckResult;
import fr.ifremer.isisfish.util.EvaluatorHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;

public class CheckRegion {
    public static void check(Object parent, String name, Equation eq, CheckResult result) {
        if (eq == null) {
            result.addError(parent, I18n._((String)"isisfish.error.invalid.nullequation", (Object[])new Object[]{name}));
        } else if (0 != EvaluatorHelper.check(eq.getJavaInterface(), eq.getContent(), null)) {
            result.addError(eq, I18n._((String)"isisfish.error.invalid.equation"));
        }
    }

    public static void check(TargetSpecies capturabilite, CheckResult result) {
        CheckRegion.check(capturabilite, "TargetFactorEquation", capturabilite.getTargetFactorEquation(), result);
    }

    public static void check(PopulationGroup classPop, CheckResult result) {
        if (classPop.getMeanWeight() < 0.0) {
            result.addError(classPop, I18n._((String)"isisfish.error.invalid.mean.weight"));
        }
        if (classPop.getMeanWeight() == 0.0) {
            result.addWarning(classPop, I18n._((String)"isisfish.error.not.null.mean.weight"));
        }
    }

    public static void check(Gear engin, CheckResult result) {
        Collection<Selectivity> selectivites;
        if ("".equals(engin.getName())) {
            result.addWarning(engin, I18n._((String)"isisfish.error.empty.name"));
        }
        if ("".equals(engin.getEffortUnit())) {
            result.addWarning(engin, I18n._((String)"isisfish.error.empty.unit"));
        }
        if ((selectivites = engin.getPopulationSelectivity()).size() == 0) {
            result.addWarning(engin, I18n._((String)"isisfish.error.empty.selectivity"));
        } else {
            for (Selectivity selectivity : selectivites) {
                CheckRegion.check(selectivity, result);
            }
        }
        if (engin.getPossibleValue() == null) {
            result.addWarning(engin, I18n._((String)"isisfish.error.invalid.range"));
        }
        if ("".equals(engin.getParameterName())) {
            result.addInfo(engin, I18n._((String)"isisfish.error.empty.params.name"));
        }
    }

    public static void check(MetierSeasonInfo infoSaisonMetier, CheckResult result) {
        Collection<TargetSpecies> especeCaptus;
        if (infoSaisonMetier.getZone() == null || infoSaisonMetier.getZone().size() == 0) {
            result.addWarning(infoSaisonMetier, I18n._((String)"isisfish.error.no.sector"));
        }
        if ((especeCaptus = infoSaisonMetier.getSpeciesTargetSpecies()).size() == 0) {
            result.addInfo(infoSaisonMetier, I18n._((String)"isisfish.error.empty.species"));
        } else {
            for (TargetSpecies i : especeCaptus) {
                CheckRegion.check(i, result);
            }
        }
    }

    public static boolean isEmptyMatrix(MatrixND mat) {
        boolean result = true;
        MatrixIterator i = mat.iterator();
        while (result && i.next()) {
            result = false;
        }
        return result;
    }

    public static boolean isNullMatrix(MatrixND mat) {
        boolean result = true;
        if (mat != null) {
            MatrixIterator i = mat.iterator();
            while (result && i.next()) {
                result = i.getValue() == 0.0;
            }
        }
        return result;
    }

    public static boolean isNegativeMatrix(MatrixND mat) {
        boolean result = true;
        MatrixIterator i = mat.iterator();
        while (result && i.next()) {
            result = i.getValue() < 0.0;
        }
        return result;
    }

    public static double sumMatrix(MatrixND mat) {
        double result = 0.0;
        MatrixIterator i = mat.iterator();
        while (i.next()) {
            result += i.getValue();
        }
        return result;
    }

    public static void check(PopulationSeasonInfo infoSaisonPop, CheckResult result) {
        if (infoSaisonPop.getUseEquationMigration()) {
            CheckRegion.check(infoSaisonPop, "MigrationEquation", infoSaisonPop.getMigrationEquation(), result);
            CheckRegion.check(infoSaisonPop, "Emigration", infoSaisonPop.getEmigrationEquation(), result);
            CheckRegion.check(infoSaisonPop, "ImmigrationEquation", infoSaisonPop.getImmigrationEquation(), result);
        } else {
            if (CheckRegion.isEmptyMatrix(infoSaisonPop.getMigrationMatrix())) {
                result.addInfo(infoSaisonPop, I18n._((String)"isisfish.error.empty.migration"));
            } else if (CheckRegion.isNullMatrix(infoSaisonPop.getMigrationMatrix())) {
                result.addInfo(infoSaisonPop, I18n._((String)"isisfish.error.empty.migration"));
            } else if (CheckRegion.isNegativeMatrix(infoSaisonPop.getMigrationMatrix())) {
                result.addError(infoSaisonPop, I18n._((String)"isisfish.error.migration.negative"));
            }
            if (CheckRegion.isEmptyMatrix(infoSaisonPop.getEmigrationMatrix())) {
                result.addInfo(infoSaisonPop, I18n._((String)"isisfish.error.empty.emigration"));
            } else if (CheckRegion.isNullMatrix(infoSaisonPop.getEmigrationMatrix())) {
                result.addInfo(infoSaisonPop, I18n._((String)"isisfish.error.empty.emigration"));
            } else if (CheckRegion.isNegativeMatrix(infoSaisonPop.getEmigrationMatrix())) {
                result.addError(infoSaisonPop, I18n._((String)"isisfish.error.emigration.negative"));
            }
            if (CheckRegion.isEmptyMatrix(infoSaisonPop.getImmigrationMatrix())) {
                result.addInfo(infoSaisonPop, I18n._((String)"isisfish.error.empty.immigration"));
            } else if (CheckRegion.isNullMatrix(infoSaisonPop.getImmigrationMatrix())) {
                result.addInfo(infoSaisonPop, I18n._((String)"isisfish.error.empty.immigration"));
            } else if (CheckRegion.isNegativeMatrix(infoSaisonPop.getImmigrationMatrix())) {
                result.addError(infoSaisonPop, I18n._((String)"isisfish.error.immigration.negative"));
            }
        }
    }

    public static void check(Cell maille, CheckResult result) {
        if ("".equals(maille.getName())) {
            result.addWarning(maille, I18n._((String)"isisfish.error.empty.name"));
        }
    }

    public static void check(Species metaPop, CheckResult result) {
        Collection<Population> pops = metaPop.getPopulation();
        if (pops.size() == 0) {
            result.addWarning(metaPop, I18n._((String)"isisfish.error.empty.population"));
        } else {
            for (Population pop : pops) {
                CheckRegion.check(pop, result);
            }
        }
        if ("".equals(metaPop.getName())) {
            result.addInfo(metaPop, I18n._((String)"isisfish.error.empty.species.name"));
        }
        if ("".equals(metaPop.getScientificName())) {
            result.addInfo(metaPop, I18n._((String)"isisfish.error.empty.scientific.name"));
        }
        if ("".equals(metaPop.getCodeRubbin())) {
            result.addInfo(metaPop, I18n._((String)"isisfish.error.empty.code.rubbin"));
        }
    }

    public static void check(Metier metier, CheckResult result) {
        List<MetierSeasonInfo> infoSaisons;
        if ("".equals(metier.getName())) {
            result.addWarning(metier, I18n._((String)"isisfish.error.empty.name"));
        }
        if ((infoSaisons = metier.getMetierSeasonInfo()).size() == 0) {
            result.addWarning(metier, I18n._((String)"isisfish.error.empty.season"));
        } else {
            HashSet<Month> months = new HashSet<Month>();
            for (MetierSeasonInfo info : infoSaisons) {
                if (!Collections.disjoint(months, info.getMonths())) {
                    result.addError(info, I18n._((String)"isisfish.error.overlap.season"));
                }
                months.addAll(info.getMonths());
                CheckRegion.check(info, result);
            }
        }
        if (metier.getGear() == null) {
            result.addError(metier, I18n._((String)"isisfish.error.undefined.gear"));
        } else {
            CheckRegion.check(metier.getGear(), result);
        }
        try {
            if (!metier.getGear().getPossibleValue().contains(metier.getGearParameterValue())) {
                result.addWarning(metier, I18n._((String)"isisfish.error.invalid.values.params"));
            }
        }
        catch (Exception e) {
            result.addWarning(metier, I18n._((String)"isisfish.error.invalid.values.params"));
        }
    }

    public static void check(Population pop, CheckResult result) {
        List<PopulationSeasonInfo> infoSaisons;
        if ("".equals(pop.getName())) {
            result.addWarning(pop, I18n._((String)"isisfish.error.empty.name"));
        }
        if ("".equals(pop.getGeographicId())) {
            result.addInfo(pop, I18n._((String)"isisfish.error.empty.id.geographic"));
        }
        if (pop.getMaturityGroup() == null) {
            result.addInfo(pop, I18n._((String)"isisfish.error.not.null.class.grown"));
        }
        CheckRegion.check(pop, "Growth", pop.getGrowth(), result);
        CheckRegion.check(pop, "GrowthReverse", pop.getGrowthReverse(), result);
        List<PopulationGroup> classes = pop.getPopulationGroup();
        if (classes.size() == 0) {
            result.addWarning(pop, I18n._((String)"isisfish.error.undefined.classes"));
        } else {
            for (PopulationGroup group : classes) {
                CheckRegion.check(group, result);
            }
        }
        if (pop.getMonthGapBetweenReproRecrutement() < 0) {
            result.addWarning(pop, I18n._((String)"isisfish.error.invalid.interval.reproduction.recruitment"));
        }
        if (CheckRegion.isNullMatrix(pop.getMappingZoneReproZoneRecru())) {
            result.addWarning(pop, I18n._((String)"isisfish.error.undefined.correspondence.zones.reproduction.recruitment"));
        }
        if (pop.getPopulationZone() == null || pop.getPopulationZone().size() == 0) {
            result.addWarning(pop, I18n._((String)"isisfish.error.undefined.zone.population"));
        }
        if (pop.getRecruitmentZone() == null || pop.getRecruitmentZone().size() == 0) {
            result.addWarning(pop, I18n._((String)"isisfish.error.undefined.zone.recruitment"));
        }
        if (pop.getReproductionZone() == null || pop.getReproductionZone().size() == 0) {
            result.addWarning(pop, I18n._((String)"isisfish.error.undefined.zone.reproduction"));
        }
        if ((infoSaisons = pop.getPopulationSeasonInfo()).size() == 0) {
            result.addWarning(pop, I18n._((String)"isisfish.error.empty.season"));
        } else {
            HashSet<Month> months = new HashSet<Month>();
            for (PopulationSeasonInfo info : infoSaisons) {
                if (!Collections.disjoint(months, info.getMonths())) {
                    result.addError(info, I18n._((String)"isisfish.error.overlap.season"));
                }
                months.addAll(info.getMonths());
                CheckRegion.check(info, result);
            }
        }
        CheckRegion.check(pop, "Price", pop.getPrice(), result);
        CheckRegion.check(pop, "MeanWeight", pop.getMeanWeight(), result);
        CheckRegion.check(pop, "ReproductionEquation", pop.getReproductionEquation(), result);
        CheckRegion.check(pop, "NaturalDeathRate", pop.getNaturalDeathRate(), result);
        if (CheckRegion.sumMatrix(pop.getRecruitmentDistribution()) != 1.0) {
            result.addWarning(pop, I18n._((String)"isisfish.error.invalid.distribution.recruitment"));
        }
    }

    public static void check(FisheryRegion region, CheckResult result) {
        List<Zone> secteurs;
        if ("".equals(region.getName())) {
            result.addWarning(region, I18n._((String)"isisfish.error.empty.name"));
        }
        if ((secteurs = region.getZone()).size() == 0) {
            result.addWarning(region, I18n._((String)"isisfish.error.undefined.sector"));
        } else {
            for (Zone zone : secteurs) {
                CheckRegion.check(zone, result);
            }
        }
        List<Cell> mailles = region.getCell();
        if (mailles.size() == 0) {
            result.addWarning(region, I18n._((String)"isisfish.error.undefined.mesh"));
        } else {
            for (Cell cell : mailles) {
                CheckRegion.check(cell, result);
            }
        }
        List<Species> metaPops = region.getSpecies();
        if (metaPops.size() == 0) {
            result.addWarning(region, I18n._((String)"isisfish.error.undefined.meta.population"));
        } else {
            for (Species species : metaPops) {
                CheckRegion.check(species, result);
            }
        }
        List<Metier> metiers = region.getMetier();
        if (metiers.size() == 0) {
            result.addWarning(region, I18n._((String)"isisfish.error.undefined.meta.population"));
        } else {
            for (Metier metier : metiers) {
                CheckRegion.check(metier, result);
            }
        }
        List<Strategy> strategies = region.getStrategy();
        if (strategies.size() == 0) {
            result.addWarning(region, I18n._((String)"isisfish.error.undefined.stategy"));
        } else {
            for (Strategy strategy : strategies) {
                CheckRegion.check(strategy, result);
            }
        }
    }

    public static void check(Zone secteur, CheckResult result) {
        if ("".equals(secteur.getName())) {
            result.addWarning(secteur, I18n._((String)"isisfish.error.empty.name"));
        }
        if (secteur.getCell().size() == 0) {
            result.addWarning(secteur, I18n._((String)"isisfish.error.undefined.mesh.sector"));
        }
    }

    public static void check(Selectivity selectivite, CheckResult result) {
    }

    public static void check(Strategy strategy, CheckResult result) {
        if ("".equals(strategy.getName())) {
            result.addWarning(strategy, I18n._((String)"isisfish.error.empty.name"));
        }
        CheckRegion.check(strategy.getSetOfVessels(), result);
        List<StrategyMonthInfo> smi = strategy.getStrategyMonthInfo();
        if (smi.size() != 12) {
            result.addWarning(strategy, I18n._((String)"isisfish.error.undefined.stategy.months"));
        } else {
            for (StrategyMonthInfo info : smi) {
                CheckRegion.check(info, result);
            }
        }
    }

    public static void check(SetOfVessels sov, CheckResult result) {
        Collection<EffortDescription> efforts;
        CheckRegion.check(sov.getPort(), result);
        if (sov.getNumberOfVessels() < 0) {
            result.addWarning(sov, I18n._((String)"isisfish.error.invalid.number"));
        }
        if (sov.getFixedCosts() < 0.0) {
            result.addWarning(sov, I18n._((String)"isisfish.error.invalid.costs.fix"));
        }
        if ((efforts = sov.getPossibleMetiers()).size() == 0) {
            result.addWarning(sov, I18n._((String)"isisfish.error.not.possible.metier"));
        } else {
            for (EffortDescription effort : efforts) {
                CheckRegion.check(effort, result);
            }
        }
    }

    public static void check(EffortDescription effort, CheckResult result) {
    }

    public static void check(StrategyMonthInfo smi, CheckResult result) {
    }

    public static void check(VesselType vesselType, CheckResult result) {
    }

    public static void check(TripType tripType, CheckResult result) {
    }

    public static void check(Port port, CheckResult result) {
    }
}

