/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.ui.SaveVerifier;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.InputUI;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityTabUI;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;

public class InputSaveVerifier
implements SaveVerifier {
    private static Log log = LogFactory.getLog(InputSaveVerifier.class);
    protected JButton currentNewButton = null;
    protected JButton currentDeleteButton = null;
    protected JButton currentSaveButton = null;
    protected JButton currentCancelButton = null;
    protected ActionListener saveListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            InputSaveVerifier.this.topiaSave();
        }
    };
    protected ActionListener cancelListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            InputSaveVerifier.this.topiaCancel();
        }
    };
    protected ActionListener newListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            InputSaveVerifier.this.topiaCreate();
        }
    };
    protected ActionListener deleteListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            InputSaveVerifier.this.topiaRemove();
        }
    };
    protected String type = null;
    protected boolean editable = false;
    protected boolean changed = false;
    protected NavigationTreeModel.NavigationTreeNode currentNode = null;
    protected String currentOnglet = null;
    protected TopiaContext isisContext = null;
    protected HashMap<String, TopiaEntity> currentEntities = new HashMap();
    protected HashSet<InputContentUI> currentPanels = new HashSet();
    protected InputUI rootUI;
    protected SensitivityTabUI sensUI;

    @Override
    public int checkEdit() {
        int response = 1;
        if (this.editable && this.changed) {
            response = this.askUser(I18n._((String)"isisfish.message.page.modified"));
            if (response == 1) {
                this.topiaCancel();
            } else if (response == 0) {
                this.topiaSave();
            }
        }
        return response;
    }

    protected int askUser(String message) {
        int response = JOptionPane.showConfirmDialog(this.rootUI, message, I18n._((String)"isisfish.input.menu.commit"), 1, 2);
        return response;
    }

    protected void topiaChanged() {
        this.changed = true;
        this.setPanelsActifs();
        this.setEnabled(this.currentSaveButton, true);
        this.setEnabled(this.currentCancelButton, true);
        this.setEnabled(this.currentNewButton, false);
        this.setEnabled(this.currentDeleteButton, false);
    }

    protected void noModif() {
        this.changed = false;
        this.setPanelsActifs();
        this.setEnabled(this.currentSaveButton, false);
        this.setEnabled(this.currentCancelButton, false);
        this.setEnabled(this.currentNewButton, true);
        this.setEnabled(this.currentDeleteButton, this.editable);
    }

    protected void setEnabled(Component c, boolean enabled) {
        if (c != null) {
            c.setEnabled(enabled);
        }
    }

    protected void topiaRemove() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"remove called");
        }
        String msg = "";
        try {
            boolean doDelete;
            TopiaEntity topiaEntity = (TopiaEntity)this.currentNode.getJAXXContextValue((JAXXContext)this.rootUI);
            List allWillBeRemoved = topiaEntity.getComposite();
            if (allWillBeRemoved.size() > 0) {
                String label = I18n._((String)"isisfish.message.delete.object", (Object[])new Object[]{topiaEntity.toString()});
                String text = "";
                for (TopiaEntity e : allWillBeRemoved) {
                    text = text + ClassUtils.getShortClassName(e.getClass()) + " - " + e.toString() + "\n";
                }
                int resp = this.showTextAreaConfirmationMessage(null, label, text, I18n._((String)"isisfish.message.delete.entities"), 0);
                doDelete = resp == 0;
            } else {
                String text = I18n._((String)"isisfish.message.confirm.delete.object", (Object[])new Object[]{topiaEntity.toString()});
                int resp = JOptionPane.showConfirmDialog(null, text, I18n._((String)"isisfish.message.delete.entity"), 0);
                boolean bl = doDelete = resp == 0;
            }
            if (doDelete) {
                topiaEntity.delete();
                this.isisContext.commitTransaction();
                msg = I18n._((String)"isisfish.message.remove.finished");
            } else {
                msg = I18n._((String)"isisfish.message.remove.canceled");
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can't remove entity: " + this.currentEntities.get(0)), (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.input.removeentity"), eee);
        }
        this.rootUI.setStatusMessage(msg);
        this.noModif();
        String path = this.currentNode.getParent().getContextPath();
        this.rootUI.setTreeModel();
        this.rootUI.setTreeSelection(path);
    }

    protected int showTextAreaConfirmationMessage(Component parent, String labelMessage, String textMessage, String title, int option) {
        JLabel labelForMessage = new JLabel(labelMessage);
        JTextArea areaForMessage = new JTextArea(textMessage);
        areaForMessage.setEditable(false);
        areaForMessage.setAutoscrolls(true);
        JScrollPane spMessage = new JScrollPane(areaForMessage);
        spMessage.setPreferredSize(new Dimension(500, 100));
        int response = JOptionPane.showConfirmDialog(parent, new Object[]{labelForMessage, spMessage}, title, option);
        return response;
    }

    protected void topiaCreate() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create called for " + this.type));
        }
        try {
            String name = this.type + "_new";
            Method method = MethodUtils.getAccessibleMethod(IsisFishDAOHelper.class, (String)("get" + this.type + "DAO"), TopiaContext.class);
            TopiaDAO dao = (TopiaDAO)method.invoke(null, this.isisContext);
            TopiaEntity entity = dao.create(new Object[]{"name", name});
            entity.update();
            this.isisContext.commitTransaction();
            String path = this.currentNode.getParent().getContextPath() + "/" + entity.getTopiaId();
            if (!this.editable) {
                path = this.currentNode.getContextPath() + "/" + entity.getTopiaId();
            }
            this.rootUI.setTreeModel();
            this.rootUI.setTreeSelection(path);
            this.rootUI.setStatusMessage(I18n._((String)"isisfish.message.creation.finished"));
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create entity", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.input.createentity"), eee);
        }
    }

    protected void topiaSave() {
        block6: {
            try {
                this.noModif();
                for (TopiaEntity t : this.currentEntities.values()) {
                    t.update();
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("updating : " + t));
                }
                this.isisContext.commitTransaction();
                this.rootUI.repaintNode(this.currentNode.getContextPath());
                this.rootUI.setStatusMessage(I18n._((String)"isisfish.message.save.finished"));
            }
            catch (TopiaException eee) {
                try {
                    this.isisContext.rollbackTransaction();
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Can't save entity", (Throwable)eee);
                    }
                    ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.input.saveentity"), eee);
                }
                catch (TopiaException eee2) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error((Object)"Can't save or rollback entity", (Throwable)eee2);
                }
            }
        }
    }

    protected void topiaCancel() {
        try {
            this.noModif();
            this.isisContext.rollbackTransaction();
            Map canceledEntity = (Map)this.currentEntities.clone();
            this.currentEntities.clear();
            for (Map.Entry currentEntity : canceledEntity.entrySet()) {
                TopiaEntity t = this.isisContext.findByTopiaId(((TopiaEntity)currentEntity.getValue()).getTopiaId());
                this.rootUI.repaintNode(this.currentNode.getContextPath());
                this.rootUI.setTreeSelection(this.currentNode.getContextPath());
                String key = (String)currentEntity.getKey();
                this.addCurrentEntity(t, key);
            }
            this.refreshAll();
            this.rootUI.setStatusMessage(I18n._((String)"isisfish.message.cancel.finished"));
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't cancel modification in region", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.input.cancelentity"), eee);
        }
    }

    protected void setPanelsActifs() {
        for (InputContentUI panel : this.currentPanels) {
            panel.setActif(this.editable);
        }
    }

    public void refreshAll() {
        HashSet panelsToRefresh = (HashSet)this.currentPanels.clone();
        for (InputContentUI panel : panelsToRefresh) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Verifier refresh ui : " + panel));
            }
            panel.refresh();
            panel.setActif(this.editable);
        }
    }

    public void addCurrentEntity(TopiaEntity currentEntity, String key) {
        if (currentEntity != null) {
            this.editable = true;
            this.isisContext = currentEntity.getTopiaContext();
            currentEntity.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("PropertyChanged : " + evt.getPropertyName() + " New Value : " + evt.getNewValue()));
                    }
                    InputSaveVerifier.this.topiaChanged();
                }
            });
            this.currentEntities.put(key, currentEntity);
            this.setPanelsActifs();
        }
    }

    public void addCurrentEntity(TopiaEntity currentEntity) {
        if (currentEntity != null) {
            this.addCurrentEntity(currentEntity, currentEntity.getTopiaId());
        }
    }

    public void reset() {
        this.removeAllEntity();
        this.removeAllPanels();
        this.currentCancelButton = null;
        this.currentDeleteButton = null;
        this.currentNewButton = null;
        this.currentSaveButton = null;
        this.currentOnglet = null;
        this.currentNode = null;
    }

    public void removeAllEntity() {
        this.currentEntities.clear();
        this.editable = false;
        this.noModif();
        this.setPanelsActifs();
    }

    public void addCurrentPanel(InputContentUI ... panels) {
        for (InputContentUI ui : panels) {
            this.editable = !this.currentEntities.isEmpty();
            this.currentPanels.add(ui);
            if (this.rootUI == null) {
                ui.setSensitivity(true);
                ui.setLayer(true);
            }
            ui.refresh();
            ui.setActif(this.editable);
        }
    }

    public void removeAllPanels() {
        this.currentPanels.clear();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setSaveButton(JButton saveButton) {
        this.setSaveButton(saveButton, true);
    }

    public void setSaveButton(JButton saveButton, Boolean listener) {
        if (listener.booleanValue()) {
            saveButton.removeActionListener(this.saveListener);
            saveButton.addActionListener(this.saveListener);
        }
        saveButton.setEnabled(this.changed);
        saveButton.setText(I18n._((String)"isisfish.common.save"));
        this.currentSaveButton = saveButton;
    }

    public void setNewButton(JButton saveButton, String name) {
        this.setNewButton(saveButton, name, true);
    }

    public void setNewButton(JButton newButton, String t, Boolean listener) {
        if (listener.booleanValue()) {
            newButton.removeActionListener(this.newListener);
            newButton.addActionListener(this.newListener);
        }
        newButton.setText(I18n._((String)"isisfish.common.new"));
        newButton.setEnabled(!this.changed);
        this.type = t;
        this.currentNewButton = newButton;
    }

    public void setCancelButton(JButton cancelButton) {
        cancelButton.removeActionListener(this.cancelListener);
        cancelButton.addActionListener(this.cancelListener);
        cancelButton.setText(I18n._((String)"isisfish.common.cancel"));
        cancelButton.setEnabled(this.changed);
        this.currentCancelButton = cancelButton;
    }

    public void setDeleteButton(JButton deleteButton) {
        this.setDeleteButton(deleteButton, true);
    }

    public void setDeleteButton(JButton deleteButton, boolean listener) {
        if (listener) {
            deleteButton.removeActionListener(this.deleteListener);
            deleteButton.addActionListener(this.deleteListener);
        }
        deleteButton.setEnabled(this.editable);
        deleteButton.setText(I18n._((String)"isisfish.common.remove"));
        this.currentDeleteButton = deleteButton;
    }

    public TopiaContext getIsisContext() {
        return this.isisContext;
    }

    public Collection<TopiaEntity> getCurrentEntities() {
        return this.currentEntities.values();
    }

    public <E extends TopiaEntity> E getEntity(Class<E> clazz, String key) {
        return (E)this.currentEntities.get(key);
    }

    public <E extends TopiaEntity> E getEntity(Class<E> clazz) {
        for (TopiaEntity te : this.currentEntities.values()) {
            if (!clazz.isInstance(te)) continue;
            return (E)te;
        }
        return null;
    }

    public String getCurrentOnglet() {
        return this.currentOnglet;
    }

    public NavigationTreeModel.NavigationTreeNode getCurrentNode() {
        return this.currentNode;
    }

    public void setIsisContext(TopiaContext isisContext) {
        this.isisContext = isisContext;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setCurrentOnglet(String currentOnglet) {
        this.currentOnglet = currentOnglet;
    }

    public void setCurrentNode(NavigationTreeModel.NavigationTreeNode currentNode) {
        this.currentNode = currentNode;
    }

    protected void setRootPanel(InputUI inputUI) {
        this.rootUI = inputUI;
    }

    public SensitivityTabUI getSensPanel() {
        return this.sensUI;
    }

    public void setSensPanel(SensitivityTabUI sensUI) {
        this.sensUI = sensUI;
    }
}

