/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.datastore.FormuleStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.datastore.update.ImportFromV2;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.CellDAO;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.EffortDescriptionDAO;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Formule;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.MetierSeasonInfoDAO;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationDAO;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.PopulationSeasonInfoDAO;
import fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl;
import fr.ifremer.isisfish.entities.Selectivity;
import fr.ifremer.isisfish.entities.SelectivityDAO;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.SpeciesDAO;
import fr.ifremer.isisfish.entities.TargetSpecies;
import fr.ifremer.isisfish.entities.TargetSpeciesDAO;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.mexico.export.RegionExplorer;
import fr.ifremer.isisfish.mexico.export.RegionExportFactorXML;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.ui.input.EquationEditorPaneUI;
import fr.ifremer.isisfish.ui.input.InputUI;
import fr.ifremer.isisfish.ui.input.check.CheckRegion;
import fr.ifremer.isisfish.ui.input.check.CheckResult;
import fr.ifremer.isisfish.ui.input.check.CheckResultFrame;
import fr.ifremer.isisfish.ui.simulator.filter.SimulationFilterUtil;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import fr.ifremer.isisfish.util.CellPointcomparator;
import java.awt.Component;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.util.FileUtil;
import org.nuiton.widget.SwingUtil;
import org.nuiton.widget.editor.Editor;

public class InputAction {
    private static Log log = LogFactory.getLog(InputAction.class);

    public File importRegion() {
        File file = null;
        try {
            file = FileUtil.getFile((String[])new String[]{".*.zip$", I18n._((String)"isisfish.message.import.region.zipped")});
            if (file != null) {
                RegionStorage.importZip(file);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't import region", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.region.import"), eee);
        }
        return file;
    }

    public File importRegionAndRename() {
        File file = null;
        try {
            file = FileUtil.getFile((String[])new String[]{".*.zip$", I18n._((String)"isisfish.message.import.region.zipped")});
            if (file != null) {
                String newName = JOptionPane.showInputDialog(I18n._((String)"isisfish.message.name.imported.region"));
                RegionStorage.importAndRenameZip(file, newName);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't import region", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.region.import"), eee);
        }
        return file;
    }

    public File importV2Region() {
        File file = null;
        try {
            file = FileUtil.getFile((String[])new String[]{".*.xml$", I18n._((String)"isisfish.message.import.region.xml")});
            if (file != null) {
                new ImportFromV2(true).importXML(file);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't import region", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.region.import"), eee);
        }
        return file;
    }

    public String importRegionFromSimulation() {
        String regionName;
        String simulationName;
        try {
            simulationName = SimulationFilterUtil.selectSimulation(SimulationStorage.getSimulationNames());
            if (simulationName == null) {
                return null;
            }
        }
        catch (Exception eee) {
            String msg = I18n._((String)"isisfish.error.no.select.simulation");
            if (log.isWarnEnabled()) {
                log.warn((Object)msg, (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.no.select.simulation"), eee);
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("simulation used " + simulationName));
        }
        if ((regionName = JOptionPane.showInputDialog(I18n._((String)"isisfish.message.import.region.name"), (Object)("region from " + simulationName))) == null || "".equals(regionName)) {
            return null;
        }
        if (RegionStorage.getRegionNames().contains(regionName)) {
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("new region name " + regionName));
        }
        try {
            SimulationStorage.getSimulation(simulationName).extractRegion(regionName);
        }
        catch (StorageException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't extract region", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.region.import"), eee);
        }
        return regionName;
    }

    public File exportRegion(RegionStorage regionStorage) {
        File file = null;
        try {
            file = FileUtil.getFile((String[])new String[]{".*.zip$", I18n._((String)"isisfish.message.import.region.zipped")});
            if (!file.getAbsolutePath().endsWith(".zip")) {
                file = new File(file.getAbsolutePath() + ".zip");
            }
            if (file != null) {
                int resp = 0;
                if (file.exists()) {
                    resp = JOptionPane.showConfirmDialog(null, I18n._((String)"isisfish.message.file.overwrite"));
                }
                if (resp == 0) {
                    regionStorage.createZip(file);
                }
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't export region", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.region.export"), eee);
        }
        return file;
    }

    public String copyRegion(RegionStorage regionStorage) {
        String newName = null;
        try {
            newName = JOptionPane.showInputDialog(I18n._((String)"isisfish.message.new.region.name"));
            if (!StringUtils.isEmpty((String)newName)) {
                File zip = regionStorage.createZip();
                RegionStorage.importAndRenameZip(zip, newName);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't copy region", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.region.copy"), eee);
        }
        return newName;
    }

    public boolean removeRegion(RegionStorage regionStorage, boolean cvsDelete) {
        boolean result = false;
        try {
            int resp = JOptionPane.showConfirmDialog(null, I18n._((String)"isisfish.message.confirm.remove.region", (Object[])new Object[]{regionStorage.getName()}));
            if (resp == 0) {
                regionStorage.delete(cvsDelete);
                result = true;
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't remove region", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.region.remove"), eee);
        }
        return result;
    }

    public String commitRegionInCVS(RegionStorage regionStorage) {
        String result = null;
        try {
            String msg = regionStorage.getCommentForNextCommit();
            JTextArea text = new JTextArea(msg);
            int resp = JOptionPane.showOptionDialog(null, new JScrollPane(text), I18n._((String)"isisfish.commit.message"), 2, 3, null, null, null);
            if (resp == 0) {
                regionStorage.commit(text.getText());
                regionStorage.clearCommentForNextCommit();
                result = I18n._((String)"isisfish.message.region.commited");
            } else {
                result = I18n._((String)"isisfish.message.commit.region.canceled");
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't export region", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.region.commit"), eee);
        }
        return result;
    }

    public FisheryRegion loadRegion(InputUI ui, String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("loadRegion : " + name));
        }
        FisheryRegion region = null;
        try {
            RegionStorage regionStorage = null;
            TopiaContext isisContext = null;
            if (name != null && !" ".equals(name)) {
                regionStorage = RegionStorage.getRegion(name);
                isisContext = regionStorage.getStorage().beginTransaction();
                region = RegionStorage.getFisheryRegion(isisContext);
                ui.setContextValue(regionStorage);
                ui.setContextValue(isisContext);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't load region", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.region.load"), eee);
        }
        return region;
    }

    public void newRegion(String name) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"newRegion called");
        }
        try {
            if ("".equals(name)) {
                // empty if block
            }
            if (RegionStorage.getRegionNames().contains(name)) {
                // empty if block
            }
            RegionStorage.create(name);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create region", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.region.create"), eee);
        }
    }

    public Object saveAsModel(String category, String language, String content) {
        try {
            String name = JOptionPane.showInputDialog(I18n._((String)"isisfish.message.saveModel.dialog"));
            if (name != null) {
                FormuleStorage storage = FormuleStorage.createFormule(category, name, language);
                storage.setContent(content);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't save equation as model", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.equation.savemodel"), eee);
        }
        return null;
    }

    public Object openEditor(String category, String name, Class javaInterface, String content, Editor editor) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"openEditor");
        }
        try {
            EquationEditorPaneUI pane = new EquationEditorPaneUI();
            pane.setEquation(category, name, javaInterface, content);
            pane.setVisible(true);
            if (pane.isOk() && editor != null) {
                editor.setText(pane.getEditor().getText());
            }
            pane.dispose();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't open editor", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.equation.openeditor"), eee);
        }
        return null;
    }

    protected List<Formule> getFormules(TopiaContext isisContext, String name) {
        return FormuleStorage.getFormules(isisContext, name);
    }

    public Object addSelectivity(Population pop, String equation, Gear gear) {
        try {
            SelectivityDAO dao = IsisFishDAOHelper.getSelectivityDAO(pop.getTopiaContext());
            Selectivity selectivity = (Selectivity)dao.create(new Object[0]);
            selectivity.setGear(gear);
            selectivity.setPopulation(pop);
            selectivity.getEquation().setContent(equation);
            selectivity.update();
            gear.addPopulationSelectivity(selectivity);
            gear.update();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't add selectivity", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.input.addentity", (Object[])new Object[]{"Selectivity"}), eee);
        }
        return null;
    }

    public Object removeSelectivity(Gear gear, Selectivity selectivity) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("removeSelectivity called: " + selectivity));
        }
        try {
            if (gear != null && selectivity != null) {
                gear.removePopulationSelectivity(selectivity);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't remove TargetSpecies", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.input.removeentity", (Object[])new Object[]{"Selectivity"}), eee);
        }
        return null;
    }

    public Object addTargetSpecies(Metier metier, MetierSeasonInfo m, Species species, String targetFactorEquationContent, boolean primaryCatch) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("addTargetSpecies called: " + metier + " " + species + " " + primaryCatch + " " + targetFactorEquationContent));
        }
        try {
            String targetFactorEquationName = metier.getName() + "-" + species.getName() + "(" + m.getFirstMonth() + "-" + m.getLastMonth() + ")";
            TargetSpeciesDAO dao = IsisFishDAOHelper.getTargetSpeciesDAO(metier.getTopiaContext());
            TargetSpecies targetSpecies = (TargetSpecies)dao.create(new Object[0]);
            targetSpecies.setSpecies(species);
            targetSpecies.getTargetFactorEquation().setName(targetFactorEquationName);
            targetSpecies.getTargetFactorEquation().setContent(targetFactorEquationContent);
            targetSpecies.setPrimaryCatch(primaryCatch);
            m.addSpeciesTargetSpecies(targetSpecies);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't add TargetSpecies", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.input.addentity", (Object[])new Object[]{"TargetSpecies"}), eee);
        }
        return null;
    }

    public Object removeTargetSpecies(MetierSeasonInfo m, TargetSpecies targetSpecies) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeTargetSpecies called: " + targetSpecies));
        }
        try {
            if (targetSpecies != null) {
                m.removeSpeciesTargetSpecies(targetSpecies);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't remove TargetSpecies", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.input.removeentity", (Object[])new Object[]{"TargetSpecies"}), eee);
        }
        return null;
    }

    public void addEffortDescription(SetOfVessels setOfVessels, Metier metier) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("addEffortDescription called: " + setOfVessels + " metier: " + metier));
        }
        try {
            EffortDescriptionDAO effortDescriptionPS = IsisFishDAOHelper.getEffortDescriptionDAO(metier.getTopiaContext());
            EffortDescription effortDescription = (EffortDescription)effortDescriptionPS.create(new Object[0]);
            effortDescription.setSetOfVessels(setOfVessels);
            effortDescription.setPossibleMetiers(metier);
            effortDescription.update();
            setOfVessels.addPossibleMetiers(effortDescription);
            setOfVessels.update();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create EffortDescription", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.input.addentity", (Object[])new Object[]{"EffortDescription"}), eee);
        }
    }

    public Object removeEffortDescription(SetOfVessels sov, EffortDescription effort) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"removeEffortDescription called");
        }
        try {
            sov.removePossibleMetiers(effort);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can't remove entity: " + effort), (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.input.removeentity", (Object[])new Object[]{"EffortDescription"}), eee);
        }
        return null;
    }

    public Species getSpeciesByTopiaId(TopiaContext context, String topiaId) {
        Species result;
        block2: {
            result = null;
            try {
                SpeciesDAO dao = IsisFishDAOHelper.getSpeciesDAO(context);
                result = (Species)dao.findByTopiaId(topiaId);
            }
            catch (TopiaException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't get species", (Throwable)e);
            }
        }
        return result;
    }

    public Population createPopulation(TopiaContext context, Species species) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"createPopulation called");
        }
        try {
            String name = "Population_new";
            PopulationDAO dao = IsisFishDAOHelper.getPopulationDAO(context);
            Population pop = (Population)dao.create(new Object[0]);
            pop.setName(name);
            species.addPopulation(pop);
            pop.setSpecies(species);
            species.update();
            pop.update();
            return pop;
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create Population", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.input.addentity", (Object[])new Object[]{"Population"}), eee);
            return null;
        }
    }

    public PopulationSeasonInfo createPopulationSeasonInfo(Population pop) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createSeasonInfo called");
        }
        PopulationSeasonInfo seasonInfo = null;
        try {
            PopulationSeasonInfoDAO dao = IsisFishDAOHelper.getPopulationSeasonInfoDAO(pop.getTopiaContext());
            seasonInfo = (PopulationSeasonInfo)dao.create(new Object[0]);
            seasonInfo.setFirstMonth(Month.MONTH[0]);
            seasonInfo.setLastMonth(Month.MONTH[3]);
            pop.addPopulationSeasonInfo(seasonInfo);
            seasonInfo.setPopulation(pop);
            seasonInfo.setSimpleLengthChangeMatrix(true);
            MatrixND matrix = ((PopulationSeasonInfoImpl)seasonInfo).createNoSpacializedChangeGroupMatrix();
            seasonInfo.setLengthChangeMatrix(matrix);
            seasonInfo.update();
            pop.update();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create PopulationSeasonInfo", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.input.removeentity", (Object[])new Object[]{"PopulationSeasonInfo"}), eee);
        }
        return seasonInfo;
    }

    public void removePopulationSeasonInfo(Population pop, PopulationSeasonInfo populationSeasonInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removePopulationSeasonInfo called");
        }
        try {
            pop.removePopulationSeasonInfo(populationSeasonInfo);
            pop.update();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't remove PopulationSeasonInfo", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.input.removeentity", (Object[])new Object[]{"PopulationSeasonInfo"}), eee);
        }
    }

    public void createMetierSeasonInfo(Metier metier) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createMetierSeasonInfo called");
        }
        try {
            MetierSeasonInfoDAO metierSeasonInfoPS = IsisFishDAOHelper.getMetierSeasonInfoDAO(metier.getTopiaContext());
            MetierSeasonInfo metierSeasonInfo = (MetierSeasonInfo)metierSeasonInfoPS.create(new Object[0]);
            metierSeasonInfo.setFirstMonth(Month.MONTH[0]);
            metierSeasonInfo.setLastMonth(Month.MONTH[3]);
            metier.addMetierSeasonInfo(metierSeasonInfo);
            metierSeasonInfo.update();
            metier.update();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create MetierSeasonInfo", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.input.addentity", (Object[])new Object[]{"MetierSeasonInfo"}), eee);
        }
    }

    public void removeMetierSeasonInfo(Metier metier, MetierSeasonInfo info) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removeMetierSeasonInfo called");
        }
        try {
            metier.removeMetierSeasonInfo(info);
            metier.update();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't remove MetierSeasonInfo", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.input.addentity", (Object[])new Object[]{"MetierSeasonInfo"}), eee);
        }
    }

    public Object createRecruitmentDistribution(Population pop) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("createRecruitmentDistributionon called: " + pop));
        }
        try {
            int num;
            block10: {
                String val = JOptionPane.showInputDialog(I18n._((String)"isisfish.message.recruitment.number.month"));
                num = -1;
                if (val != null && !"".equals(val)) {
                    try {
                        num = Integer.parseInt(val);
                    }
                    catch (RuntimeException eee) {
                        if (!log.isWarnEnabled()) break block10;
                        log.warn((Object)("Can't parse val: " + val), (Throwable)eee);
                    }
                }
            }
            if (num > 0) {
                ArrayList<String> sem = new ArrayList<String>(num);
                for (int i = 0; i < num; ++i) {
                    sem.add(I18n._((String)"isisfish.common.month", (Object[])new Object[]{i}));
                }
                MatrixND newMat = MatrixFactory.getInstance().create(new List[]{sem});
                MatrixND mat = pop.getRecruitmentDistribution();
                if (mat != null) {
                    newMat.paste(mat);
                }
                pop.setRecruitmentDistribution(newMat);
                pop.update();
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't remove RecruitmentDistribution", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.input.removeentity", (Object[])new Object[]{"RecruitmentDistribution"}), eee);
        }
        return null;
    }

    public Object addMigration(PopulationSeasonInfo info, PopulationGroup group, Zone departure, Zone arrival, double coeff) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"addMigration called");
        }
        try {
            MatrixND mat = info.getMigrationMatrix().copy();
            mat.setValue((Object)group, (Object)departure, (Object)arrival, coeff);
            info.setMigrationMatrix(mat);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't add migration", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.input.addentity", (Object[])new Object[]{"Migration"}), eee);
        }
        return null;
    }

    public Object addEmigration(PopulationSeasonInfo info, PopulationGroup group, Zone departure, double coeff) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"addEmigration called");
        }
        try {
            MatrixND mat = info.getEmigrationMatrix().copy();
            mat.setValue((Object)group, (Object)departure, coeff);
            info.setEmigrationMatrix(mat);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't add emigration", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.input.addentity", (Object[])new Object[]{"Emigration"}), eee);
        }
        return null;
    }

    public Object addImmigration(PopulationSeasonInfo info, PopulationGroup group, Zone arrival, double coeff) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"addImmigration called");
        }
        try {
            MatrixND mat = info.getImmigrationMatrix().copy();
            mat.setValue((Object)group, (Object)arrival, coeff);
            info.setImmigrationMatrix(mat);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't add immigration", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.input.addentity", (Object[])new Object[]{"Immigration"}), eee);
        }
        return null;
    }

    public void addMap(FisheryRegion fisheryRegion) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"AddMap called");
        }
        String[] fileFormats = new String[]{".*\\.shp", "ESRI Shapefiles (.shp)", ".*\\.dcw", "Digital Chart of the World (.dcw)", ".*\\.vpf", "Vector Product Format (.vpf)", ".*\\.vmap", "Vector Map (.vmap)", ".*\\.cadrg", "Compressed ARC Digitized Raster Graphics (.cadrg)", ".*\\.cib", "Controlled Image Base (.cib)", ".*\\.rpf", "Raster Product Format (.rpf)", ".*\\.mif", "MapInfo (.mif)", ".*\\.e00", "ArcInfo (.e00)"};
        File inputMap = FileUtil.getFile((String[])fileFormats);
        try {
            if (inputMap != null) {
                String filename = inputMap.getName();
                RegionStorage regionStorage = RegionStorage.getRegion(fisheryRegion.getName());
                File destDir = regionStorage.getMapRepository();
                File destMap = new File(destDir, filename);
                FileUtil.copy((File)inputMap, (File)destMap);
                List<String> maps = fisheryRegion.getMapFileList();
                maps.add(filename);
                fisheryRegion.setMapFileList(maps);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can't copy map file for : " + inputMap), (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.region.addmap"), eee);
        }
    }

    public void removeMap(FisheryRegion fisheryRegion, Object[] selectedMaps) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"removeMap called");
        }
        try {
            List<String> maps = fisheryRegion.getMapFileList();
            RegionStorage regionStorage = RegionStorage.getRegion(fisheryRegion.getName());
            File mapDir = regionStorage.getMapRepository();
            for (Object selectedMap : selectedMaps) {
                String mapName = (String)selectedMap;
                maps.remove(mapName);
                File mapFile = new File(mapDir, mapName);
                mapFile.delete();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing map file : " + mapFile));
                }
                if (!mapName.endsWith(".shp")) continue;
                String indexName = mapName.replaceAll("\\.shp$", ".ssx");
                File indexFile = new File(mapDir, indexName);
                indexFile.delete();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Removing index file : " + indexFile));
            }
            fisheryRegion.setMapFileList(maps);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't remove map", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.region.removemap"), eee);
        }
    }

    public void loadCellFile(String cellFile) {
        if (log.isWarnEnabled()) {
            log.warn((Object)"loadCell called but not implemented");
        }
    }

    public void saveFisheryRegion(FisheryRegion fisheryRegion) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"save called");
        }
        try {
            TopiaContext isisContext = fisheryRegion.getTopiaContext();
            int latNumber = Math.round((fisheryRegion.getMaxLatitude() - fisheryRegion.getMinLatitude()) / fisheryRegion.getCellLengthLatitude());
            int lonNumber = Math.round((fisheryRegion.getMaxLongitude() - fisheryRegion.getMinLongitude()) / fisheryRegion.getCellLengthLongitude());
            boolean progresscpt = false;
            CellPointcomparator cellPointcomparator = new CellPointcomparator();
            CellDAO cellPS = IsisFishDAOHelper.getCellDAO(isisContext);
            List cells = cellPS.findAll();
            Collections.sort(cells, cellPointcomparator);
            Point2D.Float point = new Point2D.Float();
            for (float lati = fisheryRegion.getMinLatitude(); lati < fisheryRegion.getMaxLatitude(); lati += fisheryRegion.getCellLengthLatitude()) {
                lati = Math.round(lati * 1000.0f);
                lati /= 1000.0f;
                for (float longi = fisheryRegion.getMinLongitude(); longi < fisheryRegion.getMaxLongitude(); longi += fisheryRegion.getCellLengthLongitude()) {
                    longi = (float)Math.round(longi * 1000.0f) / 1000.0f;
                    point.setLocation(lati, longi);
                    int position = Collections.binarySearch(cells, point, cellPointcomparator);
                    if (position >= 0) {
                        cells.remove(position);
                        continue;
                    }
                    Cell cell = (Cell)cellPS.create(new Object[0]);
                    cell.setName("La" + lati + "Lo" + longi);
                    cell.setLatitude(lati);
                    cell.setLongitude(longi);
                    cell.setLand(false);
                    cell.update();
                }
            }
            fisheryRegion.update();
            progresscpt = false;
            for (Cell cell : cells) {
                cellPS.delete(cell);
            }
            isisContext.commitTransaction();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n._((String)"isisfish.error.region.save"), (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.region.save"), eee);
        }
    }

    public void checkFisheryRegion(FisheryRegion fisheryRegion) {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)"check called: ");
            }
            CheckResult result = new CheckResult();
            CheckRegion.check(fisheryRegion, result);
            CheckResultFrame dialog = new CheckResultFrame();
            dialog.setCheckResult(result);
            SwingUtil.center((Component)dialog);
            dialog.setVisible(true);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n._((String)"isisfish.error.region.check"), (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.region.check"), eee);
        }
    }

    public void exportRegionSensitivityFactors(InputUI parentComponent, FisheryRegion fisheryRegion) {
        try {
            File exportFile = FileUtil.getFile((String)I18n._((String)"isisfish.input.sensitivity.export.title"), (String)I18n._((String)"isisfish.common.ok"), (Component)parentComponent, (String[])new String[]{".*\\.xml", "XML Files"});
            if (!exportFile.getAbsolutePath().endsWith(".xml")) {
                exportFile = new File(exportFile.getAbsolutePath() + ".xml");
            }
            if (exportFile != null) {
                parentComponent.setStatusMessage(I18n._((String)"isisfish.input.sensitivity.export.running"), true);
                RegionExplorer explorer = new RegionExplorer();
                RegionExportFactorXML exportXML = new RegionExportFactorXML(exportFile);
                explorer.explore(fisheryRegion, exportXML);
                parentComponent.setStatusMessage(I18n._((String)"isisfish.input.sensitivity.export.complete"));
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Export action canceled");
                }
                parentComponent.setStatusMessage(I18n._((String)"isisfish.input.sensitivity.export.cancel"));
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n._((String)"isisfish.error.sensitivity.export"), (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.sensitivity.export"), eee);
        }
    }
}

