/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.config;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.ui.config.SSHLauncherConfigUI;
import fr.ifremer.isisfish.ui.input.InputAction;
import fr.ifremer.isisfish.util.ssh.InvalidPassphraseException;
import fr.ifremer.isisfish.util.ssh.SSHAgent;
import fr.ifremer.isisfish.util.ssh.SSHException;
import fr.ifremer.isisfish.util.ssh.SSHUserInfo;
import fr.ifremer.isisfish.util.ssh.SSHUtils;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SSHLauncherConfigAction {
    private static Log log = LogFactory.getLog(InputAction.class);
    protected SSHLauncherConfigUI configUI;
    protected String currentSSHserver;
    protected String currentSSHUsername;
    protected File currentSSHKey;
    protected String currentSSHUserhome;
    protected String currentSSHDatapath;
    protected String currentSSHIsisHome;
    protected String currentSSHTempPath;
    protected String currentSSHJavaPath;
    protected String currentSSHPbsBinPath;
    protected String currentSSHPbsQsubOptions;
    protected String currentSSHMaxThreads;
    protected String currentSSHControlInterval;

    public SSHLauncherConfigAction(SSHLauncherConfigUI configUI) {
        this.configUI = configUI;
    }

    public void resetSSHConfiguration() {
        this.configUI.getSshServerField().setText(IsisFish.config.getSimulatorSshServer());
        this.configUI.getUsernameField().setText(IsisFish.config.getSimulatorSshUsername());
        this.configUI.getSshKeyField().setText(IsisFish.config.getSSHPrivateKeyFilePath().getAbsolutePath());
        this.configUI.getSshUserhomeField().setText(IsisFish.config.getSimulatorSshUserHome());
        this.configUI.getSshDatapathField().setText(IsisFish.config.getSimulatorSshDataPath());
        this.configUI.getSshIsisHomeField().setText(IsisFish.config.getSimulatorSshIsisHome());
        this.configUI.getSshTemppathField().setText(IsisFish.config.getSimulatorSshTmpPath());
        this.configUI.getSshJavaPathField().setText(IsisFish.config.getSimulatorSshJavaPath());
        this.configUI.getSshPbsBinPathField().setText(IsisFish.config.getSimulatorSshPbsBinPath());
        this.configUI.getSshPbsQsubOptionsField().setText(IsisFish.config.getSimulatorSshPbsQsubOptions());
        this.configUI.getSshControlIntervalField().setText(String.valueOf(IsisFish.config.getSimulatorSshControlCheckInterval()));
        this.configUI.getSshMaxThreadsField().setText(String.valueOf(IsisFish.config.getSimulatorSshMaxThreads()));
        this.doCheck();
    }

    protected void configurationChanged() {
        this.configUI.setConnected(false);
        this.configUI.getMessageLabel().setText("");
        this.configUI.getStatusFreeDatabaseLabel().setText(I18n._((String)"isisfish.simulator.ssh.configuration.freespace.label", (Object[])new Object[]{"isis-database", "0"}));
        this.configUI.getStatusFreeTempLabel().setText(I18n._((String)"isisfish.simulator.ssh.configuration.freespace.label", (Object[])new Object[]{"isis-tmp", "0"}));
    }

    public void doCheck() {
        this.configurationChanged();
        this.currentSSHserver = this.configUI.getSshServerField().getText().trim();
        if (this.currentSSHserver.isEmpty()) {
            this.setColor(true, this.configUI.getSshServerField());
        } else {
            this.setColor(false, this.configUI.getSshServerField());
        }
        this.currentSSHUsername = this.configUI.getUsernameField().getText().trim();
        if (!this.currentSSHUsername.matches("\\w+")) {
            this.setColor(true, this.configUI.getUsernameField());
        } else {
            this.setColor(false, this.configUI.getUsernameField());
        }
        this.currentSSHKey = new File(this.configUI.getSshKeyField().getText().trim());
        if (!this.currentSSHKey.isFile()) {
            this.setColor(true, this.configUI.getSshKeyField());
        } else {
            this.configUI.getSshKeyButton().setEnabled(false);
            this.configUI.getSshKeyField().setEnabled(false);
            this.setColor(false, this.configUI.getSshKeyField());
        }
        this.currentSSHDatapath = this.configUI.getSshDatapathField().getText().trim();
        if (this.currentSSHDatapath.isEmpty()) {
            this.setColor(true, this.configUI.getSshDatapathField());
        } else {
            this.setColor(false, this.configUI.getSshDatapathField());
        }
        this.currentSSHIsisHome = this.configUI.getSshIsisHomeField().getText().trim();
        if (this.currentSSHIsisHome.isEmpty()) {
            this.setColor(true, this.configUI.getSshIsisHomeField());
        } else {
            this.setColor(false, this.configUI.getSshIsisHomeField());
        }
        this.currentSSHTempPath = this.configUI.getSshTemppathField().getText().trim();
        if (this.currentSSHTempPath.isEmpty()) {
            this.setColor(true, this.configUI.getSshTemppathField());
        } else {
            this.setColor(false, this.configUI.getSshTemppathField());
        }
        this.currentSSHJavaPath = this.configUI.getSshJavaPathField().getText().trim();
        if (this.currentSSHJavaPath.isEmpty()) {
            this.setColor(true, this.configUI.getSshJavaPathField());
        } else {
            this.setColor(false, this.configUI.getSshJavaPathField());
        }
        this.currentSSHPbsBinPath = this.configUI.getSshPbsBinPathField().getText().trim();
        if (this.currentSSHPbsBinPath.isEmpty()) {
            this.setColor(true, this.configUI.getSshPbsBinPathField());
        } else {
            this.setColor(false, this.configUI.getSshPbsBinPathField());
        }
        this.currentSSHPbsQsubOptions = this.configUI.getSshPbsQsubOptionsField().getText().trim();
        this.currentSSHMaxThreads = this.configUI.getSshMaxThreadsField().getText().trim();
        if (!this.currentSSHMaxThreads.matches("\\d+")) {
            this.setColor(true, this.configUI.getSshMaxThreadsField());
        } else {
            this.setColor(false, this.configUI.getSshMaxThreadsField());
        }
        this.currentSSHControlInterval = this.configUI.getSshControlIntervalField().getText().trim();
        if (!this.currentSSHControlInterval.matches("\\d+")) {
            this.setColor(true, this.configUI.getSshControlIntervalField());
        } else {
            this.setColor(false, this.configUI.getSshControlIntervalField());
        }
    }

    public void saveSSHConfiguration() {
        IsisFish.config.setSimulatorSshServer(this.currentSSHserver);
        IsisFish.config.setSimulatorSshUsername(this.currentSSHUsername);
        IsisFish.config.setSSHPrivateKeyFilePath(this.currentSSHKey);
        IsisFish.config.setSimulatorSshUserHome(this.currentSSHUserhome);
        IsisFish.config.setSimulatorSshDataPath(this.currentSSHDatapath);
        IsisFish.config.setSimulatorSshIsisHome(this.currentSSHIsisHome);
        IsisFish.config.setSimulatorSshTmpPath(this.currentSSHTempPath);
        IsisFish.config.setSimulatorSshJavaPath(this.currentSSHJavaPath);
        IsisFish.config.setSimulatorSshPbsBinPath(this.currentSSHPbsBinPath);
        IsisFish.config.setSimulatorSshPbsQsubOptions(this.currentSSHPbsQsubOptions);
        IsisFish.config.setSimulatorSshControlCheckInterval(Integer.parseInt(this.currentSSHControlInterval));
        IsisFish.config.setSimulatorSshMaxThreads(Integer.parseInt(this.currentSSHMaxThreads));
        IsisFish.config.saveForUser(new String[0]);
        this.configUI.dispose();
    }

    public void cancelSSHConfiguration() {
        this.configUI.dispose();
    }

    public void testSSHConfiguration() {
        JSch jsch = new JSch();
        String host = this.currentSSHserver;
        int port = 22;
        String sPort = null;
        try {
            if (host.indexOf(58) > 0) {
                sPort = host.substring(host.indexOf(58) + 1);
                port = Integer.parseInt(sPort);
                host = host.substring(0, host.indexOf(58));
            }
            boolean sshKeyUsed = false;
            if (this.currentSSHKey.canRead()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n._((String)"Ssh key found '%s' will be used to connect to", (Object[])new Object[]{this.currentSSHKey.getAbsoluteFile(), host}));
                }
                jsch.addIdentity(this.currentSSHKey.getAbsolutePath());
                sshKeyUsed = true;
            } else if (log.isInfoEnabled()) {
                log.info((Object)I18n._((String)"Can't read ssh key : %s", (Object[])new Object[]{this.currentSSHKey}));
            }
            Session session = jsch.getSession(this.currentSSHUsername, host, port);
            SSHUserInfo ui = new SSHUserInfo();
            if (sshKeyUsed) {
                String passphrase = null;
                passphrase = SSHAgent.getAgent().getPassphrase(this.currentSSHKey);
                ui.setPassphrase(passphrase);
                this.setTestMessage(I18n._((String)"isisfish.simulator.ssh.configuration.connectingpk"), false);
            } else {
                this.setTestMessage(I18n._((String)"isisfish.simulator.ssh.configuration.connecting"), false);
            }
            session.setUserInfo((UserInfo)ui);
            session.connect(10000);
            this.setTestMessage(I18n._((String)"isisfish.simulator.ssh.configuration.connectionok"), false);
            this.currentSSHUserhome = this.getUserHomeDirectory(session);
            this.configUI.getSshUserhomeField().setText(this.currentSSHUserhome);
            String databaseSize = this.getFolderSize(session, this.currentSSHDatapath);
            String temppathSize = this.getFolderSize(session, this.currentSSHTempPath);
            this.configUI.getStatusFreeDatabaseLabel().setText(I18n._((String)"isisfish.simulator.ssh.configuration.freespace.label", (Object[])new Object[]{this.currentSSHDatapath, databaseSize}));
            this.configUI.getStatusFreeTempLabel().setText(I18n._((String)"isisfish.simulator.ssh.configuration.freespace.label", (Object[])new Object[]{this.currentSSHTempPath, temppathSize}));
            session.disconnect();
            this.configUI.setConnected(true);
        }
        catch (NumberFormatException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't connect", (Throwable)e);
            }
            this.setTestMessage(I18n._((String)"isisfish.error.simulation.remote.wrongportvalue", (Object[])new Object[]{sPort}), true);
        }
        catch (JSchException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't connect", (Throwable)e);
            }
            this.setTestMessage(I18n._((String)"isisfish.simulator.ssh.configuration.connectionerror", (Object[])new Object[]{e.getMessage()}), true);
        }
        catch (SSHException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't connect", (Throwable)e);
            }
            this.setTestMessage(I18n._((String)"isisfish.simulator.ssh.configuration.connectionerror", (Object[])new Object[]{e.getMessage()}), true);
        }
        catch (InvalidPassphraseException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't connect", (Throwable)e);
            }
            this.setTestMessage(I18n._((String)"isisfish.simulator.ssh.configuration.invalidpassphrase"), true);
        }
    }

    protected String getUserHomeDirectory(Session session) throws SSHException {
        String command = "pwd";
        StringWriter output = new StringWriter();
        int exit = SSHUtils.exec(session, command, output);
        if (exit != 0) {
            throw new SSHException(I18n._((String)"Command '%s' fail to execute", (Object[])new Object[]{command}));
        }
        String out = ((Object)output).toString();
        return out;
    }

    protected String getFolderSize(Session session, String path) throws SSHException {
        String command = "du -hs \"" + path + "\"";
        StringWriter output = new StringWriter();
        SSHUtils.exec(session, command, output);
        String out = ((Object)output).toString();
        out = out.split("\\s+")[0];
        return out;
    }

    public void clearDatabase() {
        this.clearFolder(this.currentSSHDatapath);
    }

    public void clearTempDirectory() {
        this.clearFolder(this.currentSSHTempPath);
    }

    protected void clearFolder(String path) {
        if (StringUtils.isEmpty((String)path) || path.trim().equals(".")) {
            throw new IllegalArgumentException("Can't delete directory : " + path);
        }
        int response = JOptionPane.showConfirmDialog(this.configUI, I18n._((String)"isisfish.simulator.ssh.configuration.freespace.confirmdelete", (Object[])new Object[]{path}), I18n._((String)"isisfish.common.confirm"), 0, 2);
        if (response == 0) {
            JSch jsch = new JSch();
            String host = this.currentSSHserver;
            int port = 22;
            String sPort = null;
            try {
                if (host.indexOf(58) > 0) {
                    sPort = host.substring(host.indexOf(58) + 1);
                    port = Integer.parseInt(sPort);
                    host = host.substring(0, host.indexOf(58));
                }
                boolean sshKeyUsed = false;
                if (this.currentSSHKey.canRead()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)I18n._((String)"Ssh key found '%s' will be used to connect to", (Object[])new Object[]{this.currentSSHKey.getAbsoluteFile(), host}));
                    }
                    jsch.addIdentity(this.currentSSHKey.getAbsolutePath());
                    sshKeyUsed = true;
                } else if (log.isInfoEnabled()) {
                    log.info((Object)I18n._((String)"Can't read ssh key : %s", (Object[])new Object[]{this.currentSSHKey}));
                }
                Session session = jsch.getSession(this.currentSSHUsername, host, port);
                SSHUserInfo ui = new SSHUserInfo();
                if (sshKeyUsed) {
                    String passphrase = null;
                    passphrase = SSHAgent.getAgent().getPassphrase(this.currentSSHKey);
                    ui.setPassphrase(passphrase);
                }
                session.setUserInfo((UserInfo)ui);
                session.connect(10000);
                String command = "rm -rf \"" + path + "\"";
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing folder with command : " + command));
                }
                StringWriter output = new StringWriter();
                int exit = SSHUtils.exec(session, command, output);
                String databaseSize = this.getFolderSize(session, this.currentSSHDatapath);
                String temppathSize = this.getFolderSize(session, this.currentSSHTempPath);
                this.configUI.getStatusFreeDatabaseLabel().setText(I18n._((String)"isisfish.simulator.ssh.configuration.freespace.label", (Object[])new Object[]{this.currentSSHDatapath, databaseSize}));
                this.configUI.getStatusFreeTempLabel().setText(I18n._((String)"isisfish.simulator.ssh.configuration.freespace.label", (Object[])new Object[]{this.currentSSHTempPath, temppathSize}));
                session.disconnect();
                session.disconnect();
                if (exit != 0) {
                    throw new SSHException(I18n._((String)"Command '%s' fail to execute", (Object[])new Object[]{command}));
                }
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't connect", (Throwable)e);
                }
                this.setTestMessage(I18n._((String)"isisfish.simulator.ssh.configuration.connectionerror", (Object[])new Object[]{e.getMessage()}), true);
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"Delete action canceled by user");
        }
    }

    protected void generateSSHKey() {
        block7: {
            if (this.currentSSHKey.exists()) {
                throw new IllegalArgumentException("Can't overwrite ssh key");
            }
            try {
                if (this.currentSSHKey.getParentFile() != null && !this.currentSSHKey.getParentFile().exists()) {
                    this.currentSSHKey.getParentFile().mkdirs();
                }
                JSch jsch = new JSch();
                KeyPair kpair = KeyPair.genKeyPair((JSch)jsch, (int)2, (int)2048);
                kpair.writePrivateKey(this.currentSSHKey.getAbsolutePath());
                kpair.writePublicKey(this.currentSSHKey.getAbsolutePath() + ".pub", this.currentSSHUsername + "@forIsisFish");
                if (log.isInfoEnabled()) {
                    log.info((Object)("Finger print: " + kpair.getFingerPrint()));
                }
                kpair.dispose();
            }
            catch (JSchException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't make ssh key", (Throwable)e);
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"Can't make ssh key", (Throwable)e);
            }
        }
        this.doCheck();
    }

    protected void setColor(boolean invalid, JComponent component) {
        component.setForeground(invalid ? Color.RED : Color.BLACK);
    }

    protected void setTestMessage(String message, boolean error) {
        this.configUI.getMessageLabel().setForeground(error ? Color.RED : Color.GREEN.darker());
        this.configUI.getMessageLabel().setText(message);
    }
}

