/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.sensitivity.domain;

import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;

public class EquationContinuousDomain
extends ContinuousDomain<Double, Double> {
    private static final long serialVersionUID = -2037768174807839046L;
    protected String variableName;
    protected String operator;
    protected Double coefficient;
    protected Double referenceValue;
    protected Double value;

    public String toString() {
        String result = "variableName=" + this.variableName + " operator=" + this.operator + " coefficient=" + this.coefficient + " referenceValue=" + this.referenceValue + " value=" + this.value;
        return result;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Double getCoefficient() {
        return this.coefficient;
    }

    public void setCoefficient(Double coefficient) {
        this.coefficient = coefficient;
    }

    public Double getReferenceValue() {
        return this.referenceValue;
    }

    public void setReferenceValue(Double referenceValue) {
        this.referenceValue = referenceValue;
    }

    @Override
    public double getMinBound() {
        return 0.0;
    }

    @Override
    public double getMaxBound() {
        return 1.0;
    }

    @Override
    public Double getValueForIdentifier(Double identifier) {
        this.value = identifier;
        if (this.operator.equals("+")) {
            return this.referenceValue + (this.referenceValue + this.coefficient) * (2.0 * this.value - 1.0);
        }
        if (this.operator.equals("-")) {
            return this.referenceValue + (this.referenceValue - this.coefficient) * (2.0 * this.value - 1.0);
        }
        if (this.operator.equals("*")) {
            return this.referenceValue + this.referenceValue * this.coefficient * (2.0 * this.value - 1.0);
        }
        if (this.operator.equals("/")) {
            return this.referenceValue + this.referenceValue / this.coefficient * (2.0 * this.value - 1.0);
        }
        return identifier;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    @Override
    public EquationContinuousDomain clone() {
        EquationContinuousDomain cloned = new EquationContinuousDomain();
        cloned.setCardinality(this.cardinality);
        cloned.setMaxBound(this.maxBound);
        cloned.setMinBound(this.minBound);
        cloned.setCoefficient(this.coefficient);
        cloned.setOperator(this.operator);
        cloned.setValue(this.value);
        cloned.setReferenceValue(this.referenceValue);
        cloned.setVariableName(this.variableName);
        return cloned;
    }
}

