/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.sensitivity;

import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.visitor.FactorVisitor;
import java.io.Serializable;

public class Factor<E extends Serializable, F extends Serializable>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1643804268013964453L;
    protected String name;
    protected String comment;
    protected Domain<E, F> domain;
    protected E value;
    protected String path;

    protected Factor() {
    }

    public Factor(String name) {
        this();
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Domain<E, F> getDomain() {
        return this.domain;
    }

    public void setDomain(Domain<E, F> domain) {
        this.domain = domain;
    }

    public E getValue() {
        return this.value;
    }

    public void setValue(E value) {
        this.value = value;
    }

    public void setValueForIdentifier(F valueIdentifier) {
        this.value = this.domain.getValueForIdentifier(valueIdentifier);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void accept(FactorVisitor visitor) {
        visitor.start(this);
        visitor.visit(this, this.domain);
        visitor.end(this);
    }

    public Object clone() {
        Factor<E, F> f = new Factor<E, F>();
        f.domain = this.domain.clone();
        f.name = this.name;
        f.path = this.path;
        f.value = this.value;
        return f;
    }

    public String toString() {
        return this.name;
    }
}

