/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.launcher;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.launcher.SimulationItem;
import fr.ifremer.isisfish.simulator.launcher.SimulationMonitor;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulatorLauncher;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SimulationJob
implements Runnable,
Comparable<SimulationJob> {
    protected static Log log = LogFactory.getLog(SimulationJob.class);
    protected transient String id;
    protected Set<PostAction> postActions = new HashSet<PostAction>();
    protected SimulationService simulationService;
    protected SimulationJob parentJob;
    protected SimulationItem item;
    protected int priority;
    protected SimulatorLauncher launcher;
    protected boolean onlyCheckControl;

    public SimulationJob(SimulationService simulationService, SimulationItem item, int priority) {
        this(simulationService, null, item, priority);
    }

    public SimulationJob(SimulationService simulationService, SimulationJob parentJob, SimulationItem item, int priority) {
        this.simulationService = simulationService;
        this.parentJob = parentJob;
        this.item = item;
        this.priority = priority;
    }

    public void addPostAction(PostAction postAction) {
        this.postActions.add(postAction);
    }

    public void removePostAction(PostAction postAction) {
        this.postActions.remove(postAction);
    }

    public Set<PostAction> getPostActions() {
        return this.postActions;
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.getItem().getControl().getId();
        }
        return this.id;
    }

    public void stop() {
        if (this.simulationService.cancel(this)) {
            this.simulationService.fireStopEvent(this);
        }
        this.item.getControl().setStopSimulationRequest(true);
    }

    public void restart() {
        this.simulationService.restart(this);
    }

    public SimulationJob getParentJob() {
        return this.parentJob;
    }

    public SimulationItem getItem() {
        return this.item;
    }

    public void setLauncher(SimulatorLauncher launcher) {
        this.launcher = launcher;
    }

    public SimulatorLauncher getLauncher() {
        return this.launcher;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setOnlyCheckControl(boolean onlyCheckControl) {
        this.onlyCheckControl = onlyCheckControl;
    }

    @Override
    public int compareTo(SimulationJob o) {
        int result = this.priority - o.priority;
        if (result == 0) {
            String secondString;
            String firstString;
            if (this.getId().matches(".*_\\d+") && o.getId().matches(".*_\\d+") && (result = (firstString = this.getId().substring(0, this.getId().lastIndexOf("_"))).compareTo(secondString = o.getId().substring(0, o.getId().lastIndexOf("_")))) == 0) {
                int firstNumber = Integer.parseInt(this.getId().substring(this.getId().lastIndexOf("_") + 1));
                int secondNumber = Integer.parseInt(o.getId().substring(o.getId().lastIndexOf("_") + 1));
                result = firstNumber - secondNumber;
            }
            if (result == 0) {
                result = this.getId().compareTo(o.getId());
            }
        }
        return result;
    }

    @Override
    public void run() {
        block9: {
            try {
                SimulationControl control = this.item.getControl();
                String id = control.getId();
                if (control.isStopSimulationRequest() || this.getParentJob() != null && this.getParentJob().getItem().getControl().isStopSimulationRequest()) {
                    log.info((Object)I18n._((String)"Not start simulation %s because user ask stop", (Object[])new Object[]{id}));
                    return;
                }
                SimulationParameter param = this.item.getParameter();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Start simulation: " + id));
                }
                this.simulationService.fireStartEvent(this);
                if (!this.onlyCheckControl && this.getParentJob() == null && param.getUseAnalysePlan() && !param.isIndependentPlan()) {
                    SimulationService.PrepareSimulationJob i = new SimulationService.PrepareSimulationJob(this.simulationService, this);
                    while (!control.isStopSimulationRequest() && i.hasNext()) {
                        log.info((Object)I18n._((String)"Generate next simulation"));
                        SimulationJob subjob = i.next();
                        subjob.setLauncher(this.getLauncher());
                        subjob.run();
                        SimulationItem subItem = subjob.getItem();
                        SimulationControl subControl = subItem.getControl();
                        do {
                            Thread.sleep(2000L);
                        } while (!subControl.isStopSimulationRequest() && (subControl.getProgress() == 0L || subControl.getProgress() < subControl.getProgressMax() || !SimulationStorage.exists(subControl.getId())));
                        if (subControl.isStopSimulationRequest()) continue;
                        SimulationStorage simulation = subjob.getLauncher().getSimulationStorage(this.simulationService, subControl);
                        i.finished(subjob, simulation);
                    }
                    break block9;
                }
                SimulationMonitor.getInstance().simulationStart(this);
                if (this.onlyCheckControl) break block9;
                this.launcher.simulate(this.simulationService, this.item);
            }
            catch (Throwable eee) {
                log.warn((Object)I18n._((String)"Can't simulate %s", (Object[])new Object[]{this.item.getControl().getId()}), eee);
                if (eee instanceof RemoteException) {
                    this.simulationService.reportError(this.getLauncher(), this);
                }
                for (PostAction action : this.postActions) {
                    action.exception(this, eee);
                }
            }
        }
    }

    public static interface PostAction {
        public void finished(SimulationJob var1, SimulationStorage var2);

        public void exception(SimulationJob var1, Throwable var2);
    }
}

