/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationResultListener;
import fr.ifremer.isisfish.types.Date;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;

public class SimulationResultXML
implements SimulationResultListener {
    private static Log log = LogFactory.getLog(SimulationResultXML.class);
    protected Writer out = null;
    protected File outFilename = null;

    public SimulationResultXML() {
    }

    public SimulationResultXML(File outfilename) {
        this.setOutFilename(outfilename);
    }

    public void setOutFilename(File outfilename) {
        this.outFilename = outfilename;
    }

    public File getOutFilename() {
        return this.outFilename;
    }

    @Override
    public void afterSimulation(SimulationContext context) {
        block2: {
            try {
                this.out.write("</outData>\n");
                this.out.close();
            }
            catch (IOException eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)I18n._((String)"isisfish.error.simulation.resultXml.close", (Object[])new Object[]{eee.getMessage()}), (Throwable)eee);
            }
        }
    }

    @Override
    public void beforeSimulation(SimulationContext context) {
        block3: {
            try {
                File file = this.getOutFilename();
                if (file == null) {
                    File simulationDir = context.getSimulationStorage().getDirectory();
                    file = SimulationStorage.getSimulationResultXmlFile(simulationDir);
                    this.setOutFilename(file);
                }
                file.getParentFile().mkdirs();
                this.out = new BufferedWriter(new FileWriter(file));
                this.out.write("<outData>\n");
            }
            catch (IOException eee) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)I18n._((String)"isisfish.error.simulation.resultXml.open", (Object[])new Object[]{eee.getMessage()}), (Throwable)eee);
            }
        }
    }

    @Override
    public void addResult(SimulationContext context, Date date, String name, MatrixND mat) throws IsisFishException {
        block5: {
            try {
                this.out.write("  <m name='" + name + "' date='" + date + "'>\n");
                for (int dim = 0; dim < mat.getNbDim(); ++dim) {
                    this.out.write("    <dimension name='" + mat.getDimensionName(dim) + "' size='" + mat.getDim(dim) + "'>");
                    for (Object sem : mat.getSemantics(dim)) {
                        this.out.write("      <label>" + sem + "</label>");
                    }
                    this.out.write("    </dimension>");
                }
                MatrixIterator i = mat.iterator();
                while (i.hasNext()) {
                    this.out.write("    <d>" + i.getValue() + "</d>");
                }
                this.out.write("  </m>\n");
            }
            catch (IOException eee) {
                if (!log.isWarnEnabled()) break block5;
                log.warn((Object)I18n._((String)"isisfish.error.simulation.resultXml.write", (Object[])new Object[]{eee.getMessage()}), (Throwable)eee);
            }
        }
    }
}

