/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.MetierMonitor;
import fr.ifremer.isisfish.simulator.PopulationMonitor;
import fr.ifremer.isisfish.simulator.ResultManager;
import fr.ifremer.isisfish.simulator.RuleMonitor;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.SimulationListener;
import fr.ifremer.isisfish.simulator.SimulationResultListener;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class SimulationContext {
    private static Log log = LogFactory.getLog(SimulationContext.class);
    protected Map<String, Object> values = new HashMap<String, Object>();
    protected SimulationStorage simulation = null;
    protected SimulationControl simulationControl = null;
    protected PopulationMonitor populationMonitor = null;
    protected MetierMonitor metierMonitor = null;
    protected RuleMonitor ruleMonitor = null;
    protected ResultManager resultManager = null;
    protected Set<SimulationListener> simulationListeners = new LinkedHashSet<SimulationListener>();
    protected ClassLoader classLoader = null;
    protected File scriptDirectory;
    protected TopiaContext db = null;
    protected TopiaContext dbResult = null;
    protected Map<String, Double> contextEquationValue = new HashMap<String, Double>();
    protected Map<String, String> contextEquationOperator = new HashMap<String, String>();
    private static ThreadLocal<SimulationContext> simulationContext = new ThreadLocal<SimulationContext>(){

        @Override
        protected synchronized SimulationContext initialValue() {
            return new SimulationContext();
        }
    };

    protected SimulationContext() {
    }

    public static SimulationContext get() {
        return simulationContext.get();
    }

    public static void remove() {
        SimulationContext current = SimulationContext.get();
        current.values.clear();
        current.classLoader = null;
        simulationContext.remove();
    }

    public void addSimulationListener(SimulationListener l) {
        this.simulationListeners.add(l);
        if (l instanceof SimulationResultListener) {
            this.getResultManager().addSimulationResultListener((SimulationResultListener)l);
        }
    }

    public void closeDB() {
        block3: {
            if (this.db != null) {
                try {
                    this.db.closeContext();
                }
                catch (TopiaException eee) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"Can't close simulation topia context", (Throwable)eee);
                }
            }
        }
    }

    public void closeDBResult() {
        block3: {
            if (this.dbResult != null) {
                try {
                    this.dbResult.commitTransaction();
                    this.dbResult.closeContext();
                }
                catch (TopiaException eee) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"Can't close simulation result topia context", (Throwable)eee);
                }
            }
        }
    }

    public void removeSimulationListener(SimulationListener l) {
        this.simulationListeners.remove(l);
        if (l instanceof SimulationResultListener) {
            this.getResultManager().addSimulationResultListener((SimulationResultListener)l);
        }
    }

    public void fireBeforeSimulation() {
        for (SimulationListener l : this.simulationListeners) {
            l.beforeSimulation(this);
        }
    }

    public void fireAfterSimulation() {
        for (SimulationListener l : this.simulationListeners) {
            l.afterSimulation(this);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Object getValue(String name) {
        Object result = this.values.get(name);
        return result;
    }

    public void setValue(String name, Object value) {
        this.values.put(name, value);
    }

    public SimulationStorage getSimulationStorage() {
        return this.simulation;
    }

    public void setSimulationStorage(SimulationStorage simulation) {
        this.simulation = simulation;
    }

    public SimulationControl getSimulationControl() {
        return this.simulationControl;
    }

    public void setSimulationControl(SimulationControl simulationControl) {
        this.simulationControl = simulationControl;
    }

    public PopulationMonitor getPopulationMonitor() {
        if (this.populationMonitor == null) {
            this.populationMonitor = new PopulationMonitor();
        }
        return this.populationMonitor;
    }

    public MetierMonitor getMetierMonitor() {
        if (this.metierMonitor == null) {
            this.metierMonitor = new MetierMonitor();
        }
        return this.metierMonitor;
    }

    public RuleMonitor getRuleMonitor() {
        if (this.ruleMonitor == null) {
            this.ruleMonitor = new RuleMonitor();
        }
        return this.ruleMonitor;
    }

    public ResultManager getResultManager() {
        if (this.resultManager == null) {
            this.resultManager = new ResultManager(this);
        }
        return this.resultManager;
    }

    public TopiaContext getDB() throws TopiaException {
        if (this.db == null && this.getSimulationStorage() != null) {
            this.db = this.getSimulationStorage().getMemStorage().beginTransaction();
        }
        return this.db;
    }

    public TopiaContext getDbResult() throws TopiaException {
        if (this.dbResult == null && this.getSimulationStorage() != null) {
            this.dbResult = this.getSimulationStorage().getStorage().beginTransaction();
        }
        return this.dbResult;
    }

    public File getScriptDirectory() {
        return this.scriptDirectory;
    }

    public void setScriptDirectory(File scriptDirectory) {
        this.scriptDirectory = scriptDirectory;
    }

    public void message(String message) {
        log.info((Object)message);
        if (this.getSimulationControl() != null) {
            this.getSimulationControl().setText(message);
        }
    }

    public void setValue(String key, Double value, String operator) {
        this.contextEquationValue.put(key, value);
        this.contextEquationOperator.put(key, operator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getValueAndCompute(String key, double defaultValue) {
        double result = defaultValue;
        if (this.contextEquationValue.containsKey(key) && this.contextEquationOperator.containsKey(key)) {
            Double value = this.contextEquationValue.get(key);
            String operator = this.contextEquationOperator.get(key);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Found key '" + key + "' current value = " + value));
            }
            if ("+".equals(operator)) {
                return value + defaultValue;
            }
            if ("-".equals(operator)) {
                return value - defaultValue;
            }
            if ("*".equals(operator)) {
                return value * defaultValue;
            }
            if (!"/".equals(operator)) throw new IllegalArgumentException("Unknown operator '" + operator + "'");
            return value / defaultValue;
        }
        if (!log.isTraceEnabled()) return result;
        log.trace((Object)("No key defined for key '" + key + "' in context"));
        return result;
    }
}

