/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.types.Date;
import fr.ifremer.isisfish.types.Month;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;

public class PopulationMonitor {
    private static Log log = LogFactory.getLog(PopulationMonitor.class);
    protected List<Population> pops = null;
    protected Map<Population, MatrixND> Ns = new HashMap<Population, MatrixND>();
    protected Map<Population, Map<Date, MatrixND>> reproductions = new HashMap<Population, Map<Date, MatrixND>>();
    protected Map<Population, Map<Date, MatrixND>> discards = new HashMap<Population, Map<Date, MatrixND>>();
    protected Map<Population, MatrixND> catchs = new HashMap<Population, MatrixND>();
    protected Map<Population, MatrixND> holdCatchs = new HashMap<Population, MatrixND>();
    protected double totalHoldCatch = 0.0;

    public void init(List<Population> pops) {
        this.pops = Collections.unmodifiableList(new ArrayList<Population>(pops));
        for (Population pop : this.pops) {
            this.reproductions.put(pop, new HashMap());
            this.discards.put(pop, new HashMap());
        }
    }

    public List<Population> getPopulations() {
        return this.pops;
    }

    public double getBiomass(Species species) {
        double result = 0.0;
        for (Population pop : species.getPopulation()) {
            result += this.getBiomass(pop);
        }
        return result;
    }

    public double getBiomass(Population pop) {
        double result = 0.0;
        MatrixND n = this.getN(pop);
        if (n != null) {
            n = n.sumOverDim(1);
            MatrixIterator i = n.iterator();
            while (i.next()) {
                Object[] coord = i.getSemanticsCoordinates();
                PopulationGroup group = (PopulationGroup)coord[0];
                result += i.getValue() * group.getMeanWeight();
            }
        }
        return result;
    }

    public MatrixND getN(Population pop) {
        MatrixND result = this.Ns.get(pop);
        if (result != null) {
            result.setSemantics(0, pop.getPopulationGroup());
            result.setSemantics(1, pop.getPopulationZone());
        }
        return result;
    }

    public void setN(Population pop, MatrixND mat) {
        this.Ns.put(pop, mat);
    }

    public MatrixND getReproduction(Date date, Population pop) {
        return this.reproductions.get(pop).get(date);
    }

    public void setReproduction(Date date, Population pop, MatrixND repro) {
        this.reproductions.get(pop).put(date, repro);
    }

    public void applyReproductionMortality(Population pop) {
        for (MatrixND reproduction : this.reproductions.get(pop).values()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Matrix repro before mortality: " + reproduction));
            }
            MatrixIterator mi = reproduction.iterator();
            while (mi.next()) {
                Object[] sems = mi.getSemanticsCoordinates();
                Zone z = (Zone)sems[0];
                double coeff = pop.getNaturalDeathBirth(z);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("NaturalDeath zone " + z + "=" + coeff));
                }
                mi.setValue(mi.getValue() * Math.exp(-coeff / (double)Month.NUMBER_OF_MONTH));
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("Matrix repro after mortality: " + reproduction));
        }
    }

    public MatrixND getRecruitment(Date date, Population pop) {
        MatrixND matEtalement = pop.getRecruitmentDistribution();
        int etalement = matEtalement.getDim(0);
        MatrixND result = MatrixFactory.getInstance().create(new List[]{pop.getPopulationGroup(), pop.getPopulationZone()});
        for (int e = 0; e < etalement; ++e) {
            Date d = new Date(date.getDate() - e - pop.getMonthGapBetweenReproRecrutement());
            MatrixND repro = this.reproductions.get(pop).get(d);
            if (repro == null) continue;
            int indiceClasse = 0;
            PopulationGroup classe = pop.getPopulationGroup().get(indiceClasse);
            List<Zone> zoneRepros = pop.getReproductionZone();
            double coeff = matEtalement.getValue(e);
            MatrixND matRepro = repro.copy();
            matRepro = matRepro.mults(coeff);
            matRepro.setSemantics(0, zoneRepros);
            MatrixND mapping = pop.getMappingZoneReproZoneRecru();
            for (Zone zoneRepro : zoneRepros) {
                MatrixND submapping = mapping.getSubMatrix(0, new Object[]{zoneRepro});
                MatrixIterator i = submapping.iterator();
                while (i.hasNext()) {
                    i.next();
                    Object[] sem = i.getSemanticsCoordinates();
                    Zone zoneRecru = (Zone)sem[1];
                    double c = i.getValue();
                    result.setValue((Object)classe, (Object)zoneRecru, c * matRepro.getValue((Object)zoneRepro) + result.getValue((Object)classe, (Object)zoneRecru));
                }
            }
        }
        if (pop.getSpecies().getAgeGroupType()) {
            MatrixND N = pop.N2DToN1D(result);
            Date dateRepro = new Date(date.getDate() - pop.getMonthGapBetweenReproRecrutement());
            List<PopulationSeasonInfo> infos = pop.getPopulationSeasonInfo();
            ArrayList<PopulationSeasonInfo> usedSeasons = new ArrayList<PopulationSeasonInfo>();
            block3: while (date.after(dateRepro)) {
                dateRepro = dateRepro.next();
                Month month = dateRepro.getMonth();
                for (PopulationSeasonInfo info : infos) {
                    if (!month.equals(info.getFirstMonth())) continue;
                    usedSeasons.add(info);
                    dateRepro = new Date(dateRepro.getDate() + info.getMonths().size() - 1);
                    continue block3;
                }
            }
            for (PopulationSeasonInfo info : usedSeasons) {
                MatrixND tmp2;
                Month month = info.getFirstMonth();
                MatrixND CA = info.getGroupChangeMatrix(month);
                MatrixND MI = info.getMigrationMatrix(month, result);
                MatrixND tmp0 = N.mult(CA);
                N = tmp2 = tmp0.mult(MI);
            }
            result = pop.split2D(N);
        }
        return result;
    }

    public void holdCatch(Population pop, MatrixND catchPerStrategyMet) {
        this.catchs.put(pop, catchPerStrategyMet);
        MatrixND holdCatch = this.holdCatchs.get(pop);
        if (holdCatch == null) {
            holdCatch = MatrixFactory.getInstance().create(catchPerStrategyMet);
            this.holdCatchs.put(pop, holdCatch);
        } else {
            holdCatch.add(catchPerStrategyMet);
        }
        MatrixIterator i = catchPerStrategyMet.iterator();
        while (i.next()) {
            this.totalHoldCatch += i.getValue();
        }
    }

    public MatrixND getCatch(Population pop) {
        MatrixND result = this.catchs.get(pop);
        return result;
    }

    public MatrixND getHoldCatch(Population pop) {
        MatrixND result = this.holdCatchs.get(pop);
        return result;
    }

    public double getTotalHoldCatch(Population pop) {
        double result = this.totalHoldCatch;
        return result;
    }

    public void clearCatch() {
        this.catchs.clear();
        this.holdCatchs.clear();
        this.totalHoldCatch = 0.0;
    }

    public MatrixND getDiscard(Date date, Population pop) {
        MatrixND result = this.discards.get(pop).get(date);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiscard(Date date, Population pop, MatrixND discard) {
        Map<Date, MatrixND> oneDiscard;
        Map<Date, MatrixND> map = oneDiscard = this.discards.get(pop);
        synchronized (map) {
            MatrixND tmp = discard.copy();
            this.discards.get(pop).put(date, tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscard(Date date, Population pop, MatrixND discard) {
        Map<Date, MatrixND> oneDiscard;
        Map<Date, MatrixND> map = oneDiscard = this.discards.get(pop);
        synchronized (map) {
            MatrixND tmp = oneDiscard.get(date);
            if (tmp == null) {
                tmp = discard.copy();
                this.discards.get(pop).put(date, tmp);
            } else {
                tmp.add(discard);
            }
        }
    }
}

