/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.rule;

import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.util.ConverterUtil;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;

public class RuleHelper {
    private static final Log log = LogFactory.getLog(RuleHelper.class);

    @Deprecated
    public static void populateRule(int ruleIndex, RegionStorage region, Rule rule, Properties props) {
        RuleHelper.populateRule(ruleIndex, region.getStorage(), rule, props);
    }

    public static void populateRule(int ruleIndex, TopiaContext context, Rule rule, Properties props) {
        String ruleName = RuleStorage.getName(rule);
        String paramTag = "rule." + ruleIndex + ".parameter.";
        for (Map.Entry<String, Class<?>> entry : RuleStorage.getParameterNames(rule).entrySet()) {
            String propName = entry.getKey();
            Class<Object> type = entry.getValue();
            if (TopiaEntity.class.isAssignableFrom(type)) {
                type = TopiaEntity.class;
            }
            String valueString = "not initialized";
            try {
                valueString = props.getProperty(paramTag + propName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("About to convert rule param: " + paramTag + propName + " = " + valueString));
                }
                ConvertUtilsBean beanUtils = ConverterUtil.getConverter(context);
                Object value = beanUtils.convert(valueString, type);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Set rule param: " + paramTag + propName + " = " + value + "(" + valueString + ")"));
                }
                RuleStorage.setParameterValue(rule, propName, value);
            }
            catch (Exception eee) {
                if (!log.isWarnEnabled()) continue;
                log.info((Object)("Properties: " + props));
                log.warn((Object)("Can't reload field " + propName + " for rule " + ruleName + " with value " + valueString), (Throwable)eee);
            }
        }
    }
}

