/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.mexico.export;

import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.Port;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.TripType;
import fr.ifremer.isisfish.entities.VesselType;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.mexico.export.HorizontalEntityVisitor;
import fr.ifremer.isisfish.mexico.export.RegionExport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;

public class RegionExplorer {
    private static Log log = LogFactory.getLog(RegionExplorer.class);

    public void explore(FisheryRegion region, RegionExport regionExport) throws TopiaException {
        regionExport.beginExport();
        HorizontalEntityVisitor visitor = new HorizontalEntityVisitor(regionExport);
        for (Cell cell : region.getCell()) {
            cell.accept(visitor);
        }
        for (Zone zone : region.getZone()) {
            zone.accept(visitor);
        }
        for (Port port : region.getPort()) {
            port.accept(visitor);
        }
        for (Species species : region.getSpecies()) {
            species.accept(visitor);
        }
        for (Gear gear : region.getGear()) {
            gear.accept(visitor);
        }
        for (Metier metier : region.getMetier()) {
            metier.accept(visitor);
        }
        for (TripType tripType : region.getTripType()) {
            tripType.accept(visitor);
        }
        for (VesselType vesselType : region.getVesselType()) {
            vesselType.accept(visitor);
        }
        for (SetOfVessels setOfVessels : region.getSetOfVessels()) {
            setOfVessels.accept(visitor);
        }
        for (Strategy strategy : region.getStrategy()) {
            strategy.accept(visitor);
        }
        regionExport.endExport();
    }
}

