/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.mexico;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.mexico.xml.DesignPlanXMLVisitor;
import fr.ifremer.isisfish.mexico.xml.DomXMLParser;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.util.ConverterUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MexicoHelper {
    private static Log log = LogFactory.getLog(MexicoHelper.class);

    public static String getDesignPlanAsXML(DesignPlan designPlan) {
        DesignPlanXMLVisitor visitor = new DesignPlanXMLVisitor();
        designPlan.accept(visitor);
        String designPlanXml = visitor.getXML();
        designPlanXml = MexicoHelper.formatXML(designPlanXml);
        return designPlanXml;
    }

    public static DesignPlan getDesignPlanFromXML(File xmlFile, TopiaContext topiaContext) throws IOException {
        DesignPlan designPlan = null;
        try {
            SAXReader reader = new SAXReader();
            reader.setEncoding("utf-8");
            Document doc = reader.read(xmlFile);
            Element root = doc.getRootElement();
            designPlan = DomXMLParser.parseDesignPlan(root, topiaContext);
        }
        catch (DocumentException e) {
            throw new IOException(e);
        }
        return designPlan;
    }

    @Deprecated
    public static String formatXML(String unformattedXml) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(unformattedXml));
            org.w3c.dom.Document document = db.parse(is);
            OutputFormat format = new OutputFormat(document);
            format.setLineWidth(65);
            format.setIndenting(true);
            format.setIndent(2);
            StringWriter out = new StringWriter();
            XMLSerializer serializer = new XMLSerializer((Writer)out, format);
            serializer.serialize(document);
            return ((Object)out).toString();
        }
        catch (IOException e) {
            throw new IsisFishRuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getMatrixAsXML(MatrixND matrix) {
        if (matrix == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<mx name=\"" + matrix.getName() + "\">");
        for (int dimIndex = 0; dimIndex < matrix.getDim().length; ++dimIndex) {
            List semantics = matrix.getSemantic(dimIndex);
            buffer.append("<dimension name=\"" + matrix.getDimensionName(dimIndex) + "\" size=\"" + semantics.size() + "\">");
            for (Object semantic : semantics) {
                buffer.append("<label>");
                MexicoHelper.appendString(buffer, semantic);
                buffer.append("</label>");
            }
            buffer.append("</dimension>");
        }
        MatrixIterator mi = matrix.iterator();
        while (mi.next()) {
            buffer.append("<d>" + mi.getValue() + "</d>");
        }
        buffer.append("</mx>");
        return buffer.toString();
    }

    protected static StringBuffer appendString(StringBuffer buffer, Object o) {
        if (o == null) {
            buffer.append("null()");
        } else {
            String qualifiedName = MexicoHelper.getQualifiedName(o);
            buffer.append(qualifiedName).append("(");
            ConvertUtilsBean beanUtils = ConverterUtil.getConverter(null);
            buffer.append(beanUtils.convert(o));
            buffer.append(")");
        }
        return buffer;
    }

    public static MatrixND getMatrixFromXml(Element mxElement, TopiaContext context) {
        String name = mxElement.attributeValue("name");
        ArrayList<String> dimNames = new ArrayList<String>();
        ArrayList semantics = new ArrayList();
        List dimensionElements = mxElement.elements("dimension");
        for (Element dimensionElement : dimensionElements) {
            String dimName = dimensionElement.attributeValue("name");
            dimNames.add(dimName);
            ArrayList<Object> semantic = new ArrayList<Object>();
            List labelElements = dimensionElement.elements("label");
            for (Element labelElement : labelElements) {
                String content = labelElement.getText();
                Object value = null;
                if (content != null) {
                    content = content.trim();
                    Pattern matrixPattern = Pattern.compile("^(.*)\\((.*)\\)$");
                    Matcher matcher = matrixPattern.matcher(content);
                    if (matcher.find()) {
                        String objectType = matcher.group(1);
                        String objectString = matcher.group(2);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Looking for object : " + objectType + ":" + objectString));
                        }
                        if (!"null".equals(objectType)) {
                            ConvertUtilsBean beanUtils = ConverterUtil.getConverter(context);
                            try {
                                value = beanUtils.convert(objectString, Class.forName(objectType));
                            }
                            catch (Exception e) {
                                value = objectType + "(" + objectString + ")";
                                if (log.isWarnEnabled()) {
                                    log.warn((Object)("Can't parse '" + content + "' as valid semantic"));
                                }
                            }
                        }
                    } else if (log.isWarnEnabled()) {
                        log.warn((Object)("Can't parse '" + content + "' as valid semantic"));
                    }
                }
                semantic.add(value);
            }
            semantics.add(semantic);
        }
        MatrixND result = MatrixFactory.getInstance().create(name, semantics.toArray(new List[semantics.size()]), dimNames.toArray(new String[dimNames.size()]));
        MatrixIterator iterator = result.iterator();
        List values = mxElement.elements("d");
        for (Element value : values) {
            iterator.next();
            String text = value.getText().trim();
            double doubleValue = Double.parseDouble(text);
            iterator.setValue(doubleValue);
        }
        return result;
    }

    protected static String getQualifiedName(Object o) {
        String qualifiedName = o instanceof TopiaEntity ? TopiaEntity.class.getName() : o.getClass().getName();
        return qualifiedName;
    }
}

