/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.export;

import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.util.ConverterUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;

public class ExportHelper {
    private static Log log = LogFactory.getLog(ExportHelper.class);

    public static void doExport(SimulationStorage simulation, File destdir, List<Export> exports, File compileDir) {
        long timeStart = System.currentTimeMillis();
        for (Export export : exports) {
            long time;
            String exportName;
            block3: {
                exportName = ExportStorage.getName(export);
                time = System.currentTimeMillis();
                try {
                    ExportHelper.exportToFile(simulation, destdir, export);
                }
                catch (Exception eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)("Can't export object: " + exportName), (Throwable)eee);
                }
            }
            simulation.getInformation().addExportTime(exportName, System.currentTimeMillis() - time);
        }
        simulation.getInformation().addExportTime("All export", System.currentTimeMillis() - timeStart);
    }

    protected static void exportToFile(SimulationStorage simulation, File destdir, Export export) throws Exception {
        String filename = export.getExportFilename();
        String extension = export.getExtensionFilename();
        File file = new File(destdir, filename + extension);
        int val = 0;
        while (file.exists()) {
            file = new File(destdir, filename + extension + "_" + ++val);
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        export.export(simulation, out);
        ((Writer)out).close();
    }

    public static void populateSensitivityExport(int exportIndex, TopiaContext context, SensitivityExport export, Properties props) {
        String exportName = SensitivityExportStorage.getName(export);
        String paramTag = "sensitivityexport." + exportIndex + ".parameter.";
        for (Map.Entry<String, Class<?>> entry : SensitivityExportStorage.getParameterNames(export).entrySet()) {
            String propName = entry.getKey();
            Class<Object> type = entry.getValue();
            if (TopiaEntity.class.isAssignableFrom(type)) {
                type = TopiaEntity.class;
            }
            String valueString = "not initialized";
            try {
                valueString = props.getProperty(paramTag + propName);
                ConvertUtilsBean beanUtils = ConverterUtil.getConverter(context);
                Object value = beanUtils.convert(valueString, type);
                log.info((Object)("DEBUG: set sensitivityexport param: " + paramTag + propName + " = " + value + "(" + valueString + ")"));
                SensitivityExportStorage.setParameterValue(export, propName, value);
            }
            catch (Exception eee) {
                if (!log.isWarnEnabled()) continue;
                log.info((Object)("Properties: " + props));
                log.warn((Object)("Can't reload field " + propName + " for export " + exportName + " with value " + valueString), (Throwable)eee);
            }
        }
    }
}

