/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.EquationDAO;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.StrategyAbstract;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.entities.StrategyMonthInfoDAO;
import fr.ifremer.isisfish.equation.StrategyInactivityEquation;
import fr.ifremer.isisfish.types.Month;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;

public class StrategyImpl
extends StrategyAbstract {
    private static Log log = LogFactory.getLog(StrategyImpl.class);
    private static final long serialVersionUID = 1L;

    @Override
    public FisheryRegion getFisheryRegion() {
        try {
            FisheryRegion result = RegionStorage.getFisheryRegion(this.getTopiaContext());
            return result;
        }
        catch (StorageException eee) {
            throw new IsisFishRuntimeException(eee);
        }
    }

    @Override
    public void setName(String value) {
        super.setName(value);
        Equation eq = this.getInactivityEquation();
        if (eq != null) {
            eq.setName(this.getName());
        }
    }

    @Override
    public List<StrategyMonthInfo> getStrategyMonthInfo() {
        try {
            List<StrategyMonthInfo> result = super.getStrategyMonthInfo();
            if (result == null) {
                if (result != null) {
                    log.warn((Object)I18n._((String)"isisfish.error.strategy.order", (Object[])new Object[]{this.getName(), result.size()}));
                    this.clearStrategyMonthInfo();
                } else {
                    result = new ArrayList<StrategyMonthInfo>(Month.NUMBER_OF_MONTH);
                    this.setStrategyMonthInfo(result);
                }
                for (Month month : Month.MONTH) {
                    StrategyMonthInfoDAO dao = IsisFishDAOHelper.getStrategyMonthInfoDAO(this.getTopiaContext());
                    StrategyMonthInfo smi = (StrategyMonthInfo)dao.create(new Object[0]);
                    smi.setMonth(month);
                    smi.setStrategy(this);
                    smi.update();
                    this.addStrategyMonthInfo(smi);
                }
                this.update();
                result = super.getStrategyMonthInfo();
            }
            return result;
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't create StrategyMonthInfo", eee);
        }
    }

    @Override
    public StrategyMonthInfo getStrategyMonthInfo(Month month) {
        List<StrategyMonthInfo> smis = this.getStrategyMonthInfo();
        StrategyMonthInfo result = smis.get(month.getMonthNumber());
        if (!month.equals(result.getMonth())) {
            log.warn((Object)"StrategyMonthInfo not in month order, i take time to find good StrategyMonthInfo");
            result = null;
            for (StrategyMonthInfo smi : smis) {
                if (!month.equals(smi.getMonth())) continue;
                result = smi;
                break;
            }
        }
        return result;
    }

    @Override
    public double getInactivityDays(Month month) {
        double result;
        block5: {
            result = 0.0;
            StrategyMonthInfo info = this.getStrategyMonthInfo(month);
            if (!this.getInactivityEquationUsed()) {
                result = info.getMinInactivityDays();
            } else {
                try {
                    Equation eq = this.getInactivityEquation();
                    result = eq.evaluate("month", month, "info", info);
                }
                catch (Exception eee) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Error in inactivityDays equation");
                    }
                    if (!log.isDebugEnabled()) break block5;
                    log.debug((Object)"StackTrace", (Throwable)eee);
                }
            }
        }
        return result;
    }

    public void setInactivityEquationContent(String content) {
        try {
            Equation eq = this.getInactivityEquation();
            if (eq == null) {
                EquationDAO dao = IsisFishDAOHelper.getEquationDAO(this.getTopiaContext());
                eq = (Equation)dao.create(new Object[0]);
                eq.setCategory("Inactivity");
                eq.setJavaInterface(StrategyInactivityEquation.class);
                eq.setLanguage("java");
                this.setInactivityEquation(eq);
            }
            eq.setName(this.getName());
            String _oldValue = eq.getContent();
            this.fireOnPreWrite("content", _oldValue, content);
            eq.setContent(content);
            eq.update();
            this.fireOnPostWrite("content", _oldValue, content);
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(I18n._((String)"isisfish.change.equation"), eee);
        }
    }

    @Override
    public String toString() {
        String result = this.getName();
        return result;
    }
}

