/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.TargetSpecies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class SpeciesAbstract
extends TopiaEntityAbstract
implements Species {
    protected String name;
    protected String scientificName;
    protected String codeRubbin;
    protected int codeCEE;
    protected boolean ageGroupType;
    protected String comment;
    protected Collection<TargetSpecies> metierSeasonInfoTargetSpecies;
    protected Collection<Population> population;

    public void update() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Species.class).update((TopiaEntity)this);
    }

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Species.class).delete((TopiaEntity)this);
    }

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "name", String.class, (Object)this.name);
        visitor.visit((TopiaEntity)this, "scientificName", String.class, (Object)this.scientificName);
        visitor.visit((TopiaEntity)this, "codeRubbin", String.class, (Object)this.codeRubbin);
        visitor.visit((TopiaEntity)this, "codeCEE", Integer.TYPE, (Object)this.codeCEE);
        visitor.visit((TopiaEntity)this, "ageGroupType", Boolean.TYPE, (Object)this.ageGroupType);
        visitor.visit((TopiaEntity)this, "comment", String.class, (Object)this.comment);
        visitor.visit((TopiaEntity)this, "metierSeasonInfoTargetSpecies", Collection.class, TargetSpecies.class, this.metierSeasonInfoTargetSpecies);
        visitor.visit((TopiaEntity)this, "population", Collection.class, Population.class, this.population);
        visitor.end((TopiaEntity)this);
    }

    public List<TopiaEntity> accept() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList<Population> tmp = new ArrayList<Population>();
        TopiaDAO dao = ((TopiaContextImplementor)this.getTopiaContext()).getDAO(TargetSpecies.class);
        List findAllByProperties = dao.findAllByProperties("species", (Object)this, new Object[0]);
        if (findAllByProperties != null) {
            tmp.addAll(findAllByProperties);
        }
        if (this.getPopulation() != null) {
            tmp.addAll(this.getPopulation());
        }
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity topiaEntity : tmp) {
            if (topiaEntity == null) continue;
            result.add(topiaEntity);
            result.addAll(topiaEntity.getComposite());
        }
        return result;
    }

    @Override
    public void setName(String value) {
        String _oldValue = this.name;
        this.fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        this.fireOnPostWrite("name", _oldValue, value);
    }

    @Override
    public String getName() {
        this.fireOnPreRead("name", this.name);
        String result = this.name;
        this.fireOnPostRead("name", this.name);
        return result;
    }

    @Override
    public void setScientificName(String value) {
        String _oldValue = this.scientificName;
        this.fireOnPreWrite("scientificName", _oldValue, value);
        this.scientificName = value;
        this.fireOnPostWrite("scientificName", _oldValue, value);
    }

    @Override
    public String getScientificName() {
        this.fireOnPreRead("scientificName", this.scientificName);
        String result = this.scientificName;
        this.fireOnPostRead("scientificName", this.scientificName);
        return result;
    }

    @Override
    public void setCodeRubbin(String value) {
        String _oldValue = this.codeRubbin;
        this.fireOnPreWrite("codeRubbin", _oldValue, value);
        this.codeRubbin = value;
        this.fireOnPostWrite("codeRubbin", _oldValue, value);
    }

    @Override
    public String getCodeRubbin() {
        this.fireOnPreRead("codeRubbin", this.codeRubbin);
        String result = this.codeRubbin;
        this.fireOnPostRead("codeRubbin", this.codeRubbin);
        return result;
    }

    @Override
    public void setCodeCEE(int value) {
        int _oldValue = this.codeCEE;
        this.fireOnPreWrite("codeCEE", _oldValue, value);
        this.codeCEE = value;
        this.fireOnPostWrite("codeCEE", _oldValue, value);
    }

    @Override
    public int getCodeCEE() {
        this.fireOnPreRead("codeCEE", this.codeCEE);
        int result = this.codeCEE;
        this.fireOnPostRead("codeCEE", this.codeCEE);
        return result;
    }

    @Override
    public void setAgeGroupType(boolean value) {
        boolean _oldValue = this.ageGroupType;
        this.fireOnPreWrite("ageGroupType", _oldValue, value);
        this.ageGroupType = value;
        this.fireOnPostWrite("ageGroupType", _oldValue, value);
    }

    @Override
    public boolean getAgeGroupType() {
        this.fireOnPreRead("ageGroupType", this.ageGroupType);
        boolean result = this.ageGroupType;
        this.fireOnPostRead("ageGroupType", this.ageGroupType);
        return result;
    }

    @Override
    public void setComment(String value) {
        String _oldValue = this.comment;
        this.fireOnPreWrite("comment", _oldValue, value);
        this.comment = value;
        this.fireOnPostWrite("comment", _oldValue, value);
    }

    @Override
    public String getComment() {
        this.fireOnPreRead("comment", this.comment);
        String result = this.comment;
        this.fireOnPostRead("comment", this.comment);
        return result;
    }

    @Override
    public void addPopulation(Population population) {
        this.fireOnPreWrite("population", null, population);
        if (this.population == null) {
            this.population = new ArrayList<Population>();
        }
        population.setSpecies(this);
        this.population.add(population);
        this.fireOnPostWrite("population", this.population.size(), null, population);
    }

    @Override
    public void addAllPopulation(Collection<Population> values) {
        if (values == null) {
            return;
        }
        for (Population item : values) {
            this.addPopulation(item);
        }
    }

    @Override
    public Population getPopulationByTopiaId(String topiaId) {
        return (Population)TopiaEntityHelper.getEntityByTopiaId(this.population, (String)topiaId);
    }

    @Override
    public void setPopulation(Collection<Population> values) {
        Collection<Population> _oldValue = this.population;
        this.fireOnPreWrite("population", _oldValue, values);
        this.population = values;
        this.fireOnPostWrite("population", _oldValue, values);
    }

    @Override
    public void removePopulation(Population value) {
        this.fireOnPreWrite("population", value, null);
        if (this.population == null || !this.population.remove(value)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setSpecies(null);
        this.fireOnPostWrite("population", this.population.size() + 1, value, null);
    }

    @Override
    public void clearPopulation() {
        if (this.population == null) {
            return;
        }
        for (Population item : this.population) {
            item.setSpecies(null);
        }
        ArrayList<Population> _oldValue = new ArrayList<Population>(this.population);
        this.fireOnPreWrite("population", _oldValue, this.population);
        this.population.clear();
        this.fireOnPostWrite("population", _oldValue, this.population);
    }

    @Override
    public Collection<Population> getPopulation() {
        return this.population;
    }

    @Override
    public int sizePopulation() {
        if (this.population == null) {
            return 0;
        }
        return this.population.size();
    }

    @Override
    public boolean isPopulationEmpty() {
        int size = this.sizePopulation();
        return size == 0;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("name", (Object)this.name).append("scientificName", (Object)this.scientificName).append("codeRubbin", (Object)this.codeRubbin).append("codeCEE", this.codeCEE).append("ageGroupType", this.ageGroupType).append("comment", (Object)this.comment).toString();
        return result;
    }
}

