/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.EquationDAO;
import fr.ifremer.isisfish.entities.PopulationAbstract;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.equation.PopulationGrowth;
import fr.ifremer.isisfish.equation.PopulationGrowthReverse;
import fr.ifremer.isisfish.equation.PopulationMeanWeight;
import fr.ifremer.isisfish.equation.PopulationNaturalDeathRate;
import fr.ifremer.isisfish.equation.PopulationPrice;
import fr.ifremer.isisfish.equation.PopulationReproductionEquation;
import fr.ifremer.isisfish.types.Month;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixException;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;

public class PopulationImpl
extends PopulationAbstract {
    private static final Log log = LogFactory.getLog(PopulationImpl.class);
    private static final long serialVersionUID = 1L;

    @Override
    public void delete() throws TopiaException {
        this.getSpecies().getPopulation().remove(this);
        super.delete();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public void setName(String value) {
        super.setName(value);
        this.updateEquationName();
    }

    private void updateEquationName() {
        Equation eq = null;
        eq = this.getGrowth();
        if (eq != null) {
            eq.setName(this.getName());
        }
        if ((eq = this.getGrowthReverse()) != null) {
            eq.setName(this.getName());
        }
        if ((eq = this.getMeanWeight()) != null) {
            eq.setName(this.getName());
        }
        if ((eq = this.getNaturalDeathRate()) != null) {
            eq.setName(this.getName());
        }
        if ((eq = this.getPrice()) != null) {
            eq.setName(this.getName());
        }
        if ((eq = this.getReproductionEquation()) != null) {
            eq.setName(this.getName());
        }
    }

    public void setReproductionEquationContent(String content) {
        try {
            Equation eq = this.getReproductionEquation();
            if (eq == null) {
                EquationDAO dao = IsisFishDAOHelper.getEquationDAO(this.getTopiaContext());
                eq = (Equation)dao.create(new Object[0]);
                eq.setCategory("Reproduction");
                eq.setJavaInterface(PopulationReproductionEquation.class);
                eq.setLanguage("java");
                this.setReproductionEquation(eq);
            }
            eq.setName(this.getName());
            String _oldValue = eq.getContent();
            this.fireOnPreWrite("content", _oldValue, content);
            eq.setContent(content);
            eq.update();
            this.fireOnPostWrite("content", _oldValue, content);
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.change.equation"), eee);
        }
    }

    public void setGrowthContent(String content) {
        try {
            Equation eq = this.getGrowth();
            if (eq == null) {
                EquationDAO dao = IsisFishDAOHelper.getEquationDAO(this.getTopiaContext());
                eq = (Equation)dao.create(new Object[0]);
                eq.setCategory("Growth");
                eq.setJavaInterface(PopulationGrowth.class);
                eq.setLanguage("java");
                this.setGrowth(eq);
            }
            eq.setName(this.getName());
            String _oldValue = eq.getContent();
            this.fireOnPreWrite("content", _oldValue, content);
            eq.setContent(content);
            eq.update();
            this.fireOnPostWrite("content", _oldValue, content);
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(I18n._((String)"isisfish.change.equation"), eee);
        }
    }

    public void setGrowthReverseContent(String content) {
        try {
            Equation eq = this.getGrowthReverse();
            if (eq == null) {
                EquationDAO dao = IsisFishDAOHelper.getEquationDAO(this.getTopiaContext());
                eq = (Equation)dao.create(new Object[0]);
                eq.setCategory("GrowthReverse");
                eq.setJavaInterface(PopulationGrowthReverse.class);
                eq.setLanguage("java");
                this.setGrowthReverse(eq);
            }
            eq.setName(this.getName());
            String _oldValue = eq.getContent();
            this.fireOnPreWrite("content", _oldValue, content);
            eq.setContent(content);
            eq.update();
            this.fireOnPostWrite("content", _oldValue, content);
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.change.equation"), eee);
        }
    }

    public void setNaturalDeathRateContent(String content) {
        try {
            Equation eq = this.getNaturalDeathRate();
            if (eq == null) {
                EquationDAO dao = IsisFishDAOHelper.getEquationDAO(this.getTopiaContext());
                eq = (Equation)dao.create(new Object[0]);
                eq.setCategory("NaturalDeathRate");
                eq.setJavaInterface(PopulationNaturalDeathRate.class);
                eq.setLanguage("java");
                this.setNaturalDeathRate(eq);
            }
            eq.setName(this.getName());
            String _oldValue = eq.getContent();
            this.fireOnPreWrite("content", _oldValue, content);
            eq.setContent(content);
            eq.update();
            this.fireOnPostWrite("content", _oldValue, content);
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.change.equation"), eee);
        }
    }

    public void setMeanWeightContent(String content) {
        try {
            Equation eq = this.getMeanWeight();
            if (eq == null) {
                EquationDAO dao = IsisFishDAOHelper.getEquationDAO(this.getTopiaContext());
                eq = (Equation)dao.create(new Object[0]);
                eq.setCategory("MeanWeight");
                eq.setJavaInterface(PopulationMeanWeight.class);
                eq.setLanguage("java");
                this.setMeanWeight(eq);
            }
            eq.setName(this.getName());
            String _oldValue = eq.getContent();
            this.fireOnPreWrite("content", _oldValue, content);
            eq.setContent(content);
            eq.update();
            this.fireOnPostWrite("content", _oldValue, content);
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.change.equation"), eee);
        }
    }

    public void setPriceContent(String content) {
        try {
            Equation eq = this.getPrice();
            if (eq == null) {
                EquationDAO dao = IsisFishDAOHelper.getEquationDAO(this.getTopiaContext());
                eq = (Equation)dao.create(new Object[0]);
                eq.setCategory("Price");
                eq.setJavaInterface(PopulationPrice.class);
                eq.setLanguage("java");
                this.setPrice(eq);
            }
            eq.setName(this.getName());
            String _oldValue = eq.getContent();
            this.fireOnPreWrite("content", _oldValue, content);
            eq.setContent(content);
            eq.update();
            this.fireOnPostWrite("content", _oldValue, content);
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.change.equation"), eee);
        }
    }

    @Override
    public double getNaturalDeathBirth(Zone zone) {
        double result;
        block3: {
            result = 0.0;
            try {
                Equation eq = this.getNaturalDeathRate();
                result = eq.evaluate("pop", this, "group", null, "zone", zone);
            }
            catch (Exception eee) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Error in natural death rate equation");
                }
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"StackTrace", (Throwable)eee);
            }
        }
        return result;
    }

    @Override
    public MatrixND getNaturalDeathRateMatrix() {
        List<PopulationGroup> groups = this.getPopulationGroup();
        List<Zone> zones = this.getPopulationZone();
        MatrixND result = MatrixFactory.getInstance().create("Natural death rate", new List[]{groups, zones}, new String[]{"Groups", "Zones"});
        MatrixIterator i = result.iterator();
        while (i.hasNext()) {
            i.next();
            PopulationGroup group = (PopulationGroup)i.getSemanticsCoordinates()[0];
            Zone zone = (Zone)i.getSemanticsCoordinates()[1];
            double value = group.getNaturalDeathRate(zone);
            i.setValue(value);
        }
        return result;
    }

    @Override
    public PopulationSeasonInfo getPopulationSeasonInfo(Month month) {
        List<PopulationSeasonInfo> all = this.getPopulationSeasonInfo();
        PopulationSeasonInfo result = null;
        for (PopulationSeasonInfo psi : all) {
            if (!psi.containsMonth(month)) continue;
            result = psi;
            break;
        }
        return result;
    }

    @Override
    public double getAge(double length, PopulationGroup group) {
        double result;
        block3: {
            result = 0.0;
            try {
                Equation growth = this.getGrowthReverse();
                result = growth.evaluate("length", length, "group", group);
            }
            catch (Exception eee) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Error in get age");
                }
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"StackTrace", (Throwable)eee);
            }
        }
        return result;
    }

    @Override
    public double getLength(double age, PopulationGroup group) {
        double result;
        block3: {
            result = 0.0;
            try {
                Equation growth = this.getGrowth();
                result = growth.evaluate("age", age, "group", group);
            }
            catch (Exception eee) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Error in get length");
                }
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"StackTrace", (Throwable)eee);
            }
        }
        return result;
    }

    @Override
    public void setCapturability(MatrixND value) {
        List[] sems = value.getSemantics();
        boolean allNull = true;
        for (List l : sems) {
            for (Object o : l) {
                allNull = o == null;
            }
        }
        if (allNull) {
            List[] newsems = new List[]{this.getPopulationGroup(), this.getPopulationSeasonInfo()};
            MatrixND newmat = MatrixFactory.getInstance().create(I18n.n_((String)"isisfish.population.capturability"), newsems, new String[]{I18n.n_((String)"isisfish.population.group"), I18n.n_((String)"isisfish.population.season")});
            newmat.paste(value);
            value = newmat;
        }
        super.setCapturability(value);
    }

    @Override
    public MatrixND getCapturability() {
        MatrixND mat = super.getCapturability();
        if (this.sizePopulationGroup() == 0 || this.sizePopulationSeasonInfo() == 0) {
            log.warn((Object)"Population doesn't have population group or population season info");
            return null;
        }
        Object[] sems = new List[]{this.getPopulationGroup(), this.getPopulationSeasonInfo()};
        if (mat == null) {
            log.debug((Object)"Capturability is null, create new matrix");
            mat = MatrixFactory.getInstance().create(I18n.n_((String)"isisfish.population.capturability"), (List[])sems, new String[]{I18n.n_((String)"isisfish.population.group"), I18n.n_((String)"isisfish.population.season")});
        } else if (!Arrays.equals(mat.getSemantics(), sems)) {
            log.debug((Object)("Capturability has changed, create new matrix and copy old: " + mat.getSemantics() + " " + sems));
            MatrixND newmat = MatrixFactory.getInstance().create(I18n.n_((String)"isisfish.population.capturability"), (List[])sems, new String[]{I18n.n_((String)"isisfish.population.group"), I18n.n_((String)"isisfish.population.season")});
            boolean allNull = true;
            for (List l : mat.getSemantics()) {
                for (Object o : l) {
                    allNull = o == null;
                }
            }
            if (allNull) {
                newmat.paste(mat);
            } else {
                newmat.pasteSemantics(mat);
            }
            mat = newmat;
        }
        return mat;
    }

    @Override
    public MatrixND getMappingZoneReproZoneRecru() {
        if (this.sizeReproductionZone() == 0 || this.sizeRecruitmentZone() == 0) {
            log.warn((Object)"Population doesn't have zone reproduction or zone recruitment");
            return null;
        }
        MatrixND mat = super.getMappingZoneReproZoneRecru();
        Object[] sems = new List[]{this.getReproductionZone(), this.getRecruitmentZone()};
        if (mat == null) {
            mat = MatrixFactory.getInstance().create(I18n.n_((String)"isisfish.population.mappingZoneReproZoneRecru"), (List[])sems, new String[]{I18n.n_((String)"isisfish.population.reproduction"), I18n.n_((String)"isisfish.population.recruitment")});
        } else if (!Arrays.equals(mat.getSemantics(), sems)) {
            MatrixND newmat = MatrixFactory.getInstance().create(I18n.n_((String)"isisfish.population.mappingZoneReproZoneRecru"), (List[])sems, new String[]{I18n.n_((String)"isisfish.population.reproduction"), I18n.n_((String)"isisfish.population.recruitment")});
            newmat.paste(mat);
            mat = newmat;
        }
        return mat;
    }

    @Override
    public MatrixND N2DToN1D(MatrixND N) {
        int maxX = N.getDim(0);
        int maxY = N.getDim(1);
        MatrixND result = MatrixFactory.getInstance().create(I18n.n_((String)"isisfish.population.matrixAbundance1D"), new int[]{1, maxX * maxY});
        for (int x = 0; x < maxX; ++x) {
            for (int y = 0; y < maxY; ++y) {
                result.setValue(0, x * maxY + y, N.getValue(x, y));
            }
        }
        return result;
    }

    @Override
    public MatrixND split2D(MatrixND N) {
        List<Zone> zones = this.getPopulationZone();
        List<PopulationGroup> groups = this.getPopulationGroup();
        int nbZone = zones.size();
        MatrixND result = MatrixFactory.getInstance().create(I18n.n_((String)"isisfish.population.matrixAbundance"), new List[]{groups, zones}, new String[]{I18n.n_((String)"isisfish.population.groups"), I18n.n_((String)"isisfish.population.zones")});
        try {
            int c = 0;
            int z = 0;
            MatrixIterator mi = N.iterator();
            while (mi.next()) {
                result.setValue(c, z, mi.getValue());
                if (z + 1 == nbZone) {
                    ++c;
                }
                z = (z + 1) % nbZone;
            }
        }
        catch (MatrixException eee) {
            log.warn((Object)"MatrixException", (Throwable)eee);
        }
        return result;
    }
}

