/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Selectivity;
import fr.ifremer.isisfish.types.RangeOfValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class GearAbstract
extends TopiaEntityAbstract
implements Gear {
    protected String name;
    protected String effortUnit;
    protected double standardisationFactor;
    protected String parameterName;
    protected double cost;
    protected RangeOfValues possibleValue;
    protected String comment;
    protected Collection<Selectivity> populationSelectivity;

    public void update() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Gear.class).update((TopiaEntity)this);
    }

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Gear.class).delete((TopiaEntity)this);
    }

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "name", String.class, (Object)this.name);
        visitor.visit((TopiaEntity)this, "effortUnit", String.class, (Object)this.effortUnit);
        visitor.visit((TopiaEntity)this, "standardisationFactor", Double.TYPE, (Object)this.standardisationFactor);
        visitor.visit((TopiaEntity)this, "parameterName", String.class, (Object)this.parameterName);
        visitor.visit((TopiaEntity)this, "cost", Double.TYPE, (Object)this.cost);
        visitor.visit((TopiaEntity)this, "possibleValue", RangeOfValues.class, (Object)this.possibleValue);
        visitor.visit((TopiaEntity)this, "comment", String.class, (Object)this.comment);
        visitor.visit((TopiaEntity)this, "populationSelectivity", Collection.class, Selectivity.class, this.populationSelectivity);
        visitor.end((TopiaEntity)this);
    }

    public List<TopiaEntity> accept() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        TopiaDAO dao = ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Selectivity.class);
        List findAllByProperties = dao.findAllByProperties("gear", (Object)this, new Object[0]);
        if (findAllByProperties != null) {
            tmp.addAll(findAllByProperties);
        }
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }

    @Override
    public void setName(String value) {
        String _oldValue = this.name;
        this.fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        this.fireOnPostWrite("name", _oldValue, value);
    }

    @Override
    public String getName() {
        this.fireOnPreRead("name", this.name);
        String result = this.name;
        this.fireOnPostRead("name", this.name);
        return result;
    }

    @Override
    public void setEffortUnit(String value) {
        String _oldValue = this.effortUnit;
        this.fireOnPreWrite("effortUnit", _oldValue, value);
        this.effortUnit = value;
        this.fireOnPostWrite("effortUnit", _oldValue, value);
    }

    @Override
    public String getEffortUnit() {
        this.fireOnPreRead("effortUnit", this.effortUnit);
        String result = this.effortUnit;
        this.fireOnPostRead("effortUnit", this.effortUnit);
        return result;
    }

    @Override
    public void setStandardisationFactor(double value) {
        double _oldValue = this.standardisationFactor;
        this.fireOnPreWrite("standardisationFactor", _oldValue, value);
        this.standardisationFactor = value;
        this.fireOnPostWrite("standardisationFactor", _oldValue, value);
    }

    @Override
    public double getStandardisationFactor() {
        this.fireOnPreRead("standardisationFactor", this.standardisationFactor);
        double result = this.standardisationFactor;
        this.fireOnPostRead("standardisationFactor", this.standardisationFactor);
        return result;
    }

    @Override
    public void setParameterName(String value) {
        String _oldValue = this.parameterName;
        this.fireOnPreWrite("parameterName", _oldValue, value);
        this.parameterName = value;
        this.fireOnPostWrite("parameterName", _oldValue, value);
    }

    @Override
    public String getParameterName() {
        this.fireOnPreRead("parameterName", this.parameterName);
        String result = this.parameterName;
        this.fireOnPostRead("parameterName", this.parameterName);
        return result;
    }

    @Override
    public void setCost(double value) {
        double _oldValue = this.cost;
        this.fireOnPreWrite("cost", _oldValue, value);
        this.cost = value;
        this.fireOnPostWrite("cost", _oldValue, value);
    }

    @Override
    public double getCost() {
        this.fireOnPreRead("cost", this.cost);
        double result = this.cost;
        this.fireOnPostRead("cost", this.cost);
        return result;
    }

    @Override
    public void setPossibleValue(RangeOfValues value) {
        RangeOfValues _oldValue = this.possibleValue;
        this.fireOnPreWrite("possibleValue", _oldValue, value);
        this.possibleValue = value;
        this.fireOnPostWrite("possibleValue", _oldValue, value);
    }

    @Override
    public RangeOfValues getPossibleValue() {
        this.fireOnPreRead("possibleValue", this.possibleValue);
        RangeOfValues result = this.possibleValue;
        this.fireOnPostRead("possibleValue", this.possibleValue);
        return result;
    }

    @Override
    public void setComment(String value) {
        String _oldValue = this.comment;
        this.fireOnPreWrite("comment", _oldValue, value);
        this.comment = value;
        this.fireOnPostWrite("comment", _oldValue, value);
    }

    @Override
    public String getComment() {
        this.fireOnPreRead("comment", this.comment);
        String result = this.comment;
        this.fireOnPostRead("comment", this.comment);
        return result;
    }

    @Override
    public void addPopulationSelectivity(Selectivity value) {
        this.fireOnPreWrite("populationSelectivity", null, value);
        if (this.populationSelectivity == null) {
            this.populationSelectivity = new ArrayList<Selectivity>();
        }
        this.populationSelectivity.add(value);
        this.fireOnPostWrite("populationSelectivity", this.populationSelectivity.size(), null, value);
    }

    @Override
    public Selectivity getPopulationSelectivityByTopiaId(String topiaId) {
        return (Selectivity)TopiaEntityHelper.getEntityByTopiaId(this.populationSelectivity, (String)topiaId);
    }

    @Override
    public void addAllPopulationSelectivity(Collection<Selectivity> values) {
        if (values == null) {
            return;
        }
        for (Selectivity item : values) {
            this.addPopulationSelectivity(item);
        }
    }

    @Override
    public void setPopulationSelectivity(Collection<Selectivity> values) {
        Collection<Selectivity> _oldValue = this.populationSelectivity;
        this.fireOnPreWrite("populationSelectivity", _oldValue, values);
        this.populationSelectivity = values;
        this.fireOnPostWrite("populationSelectivity", _oldValue, values);
    }

    @Override
    public void removePopulationSelectivity(Selectivity value) {
        this.fireOnPreWrite("populationSelectivity", value, null);
        if (this.populationSelectivity == null || !this.populationSelectivity.remove(value)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("populationSelectivity", this.populationSelectivity.size() + 1, value, null);
    }

    @Override
    public void clearPopulationSelectivity() {
        if (this.populationSelectivity == null) {
            return;
        }
        ArrayList<Selectivity> _oldValue = new ArrayList<Selectivity>(this.populationSelectivity);
        this.fireOnPreWrite("populationSelectivity", _oldValue, null);
        this.populationSelectivity.clear();
        this.fireOnPostWrite("populationSelectivity", _oldValue, null);
    }

    @Override
    public Collection<Selectivity> getPopulationSelectivity() {
        return this.populationSelectivity;
    }

    @Override
    public Selectivity getPopulationSelectivity(Population value) {
        if (value == null || this.populationSelectivity == null) {
            return null;
        }
        for (Selectivity item : this.populationSelectivity) {
            if (!value.equals(item.getPopulation())) continue;
            return item;
        }
        return null;
    }

    @Override
    public int sizePopulationSelectivity() {
        if (this.populationSelectivity == null) {
            return 0;
        }
        return this.populationSelectivity.size();
    }

    @Override
    public boolean isPopulationSelectivityEmpty() {
        int size = this.sizePopulationSelectivity();
        return size == 0;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("name", (Object)this.name).append("effortUnit", (Object)this.effortUnit).append("standardisationFactor", this.standardisationFactor).append("parameterName", (Object)this.parameterName).append("cost", this.cost).append("possibleValue", (Object)this.possibleValue).append("comment", (Object)this.comment).toString();
        return result;
    }
}

