/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.CellDAO;
import fr.ifremer.isisfish.entities.FisheryRegionAbstract;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.GearDAO;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierDAO;
import fr.ifremer.isisfish.entities.Port;
import fr.ifremer.isisfish.entities.PortDAO;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.SetOfVesselsDAO;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.SpeciesDAO;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyDAO;
import fr.ifremer.isisfish.entities.TripType;
import fr.ifremer.isisfish.entities.TripTypeDAO;
import fr.ifremer.isisfish.entities.VesselType;
import fr.ifremer.isisfish.entities.VesselTypeDAO;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.entities.ZoneDAO;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.nuiton.topia.TopiaException;

public class FisheryRegionImpl
extends FisheryRegionAbstract {
    private static final long serialVersionUID = 1L;

    @Override
    public List<String> getMapFileList() {
        ArrayList<String> result = new ArrayList<String>();
        String mapfiles = this.getMapFiles();
        if (mapfiles != null) {
            String[] mapNames;
            for (String mapName : mapNames = mapfiles.split(",")) {
                if ("".equals(mapName.trim())) continue;
                result.add(mapName.trim());
            }
        }
        return result;
    }

    @Override
    public void setMapFileList(List<String> maps) {
        StringBuffer result = new StringBuffer();
        String sep = "";
        if (maps != null) {
            for (String filename : maps) {
                result.append(sep + filename);
                sep = ",";
            }
        }
        this.setMapFiles(result.toString());
    }

    @Override
    public List<String> getMapFilePath() {
        List<String> mapNames = this.getMapFileList();
        ArrayList<String> result = new ArrayList<String>();
        RegionStorage regionStorage = RegionStorage.getRegion(this.getName());
        for (String mapName : mapNames) {
            result.add(regionStorage.getMapRepository().getPath() + File.separator + mapName);
        }
        return result;
    }

    @Override
    public List<Port> getPort() {
        try {
            PortDAO dao = IsisFishDAOHelper.getPortDAO(this.getTopiaContext());
            List result = dao.findAll();
            return result;
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(eee);
        }
    }

    @Override
    public List<Cell> getCell() {
        try {
            CellDAO dao = IsisFishDAOHelper.getCellDAO(this.getTopiaContext());
            List result = dao.findAll();
            return result;
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(eee);
        }
    }

    @Override
    public List<VesselType> getVesselType() {
        try {
            VesselTypeDAO dao = IsisFishDAOHelper.getVesselTypeDAO(this.getTopiaContext());
            List result = dao.findAll();
            return result;
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(eee);
        }
    }

    @Override
    public List<Gear> getGear() {
        try {
            GearDAO dao = IsisFishDAOHelper.getGearDAO(this.getTopiaContext());
            List result = dao.findAll();
            return result;
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(eee);
        }
    }

    @Override
    public List<Metier> getMetier() {
        try {
            MetierDAO dao = IsisFishDAOHelper.getMetierDAO(this.getTopiaContext());
            List result = dao.findAll();
            return result;
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(eee);
        }
    }

    @Override
    public List<SetOfVessels> getSetOfVessels() {
        try {
            SetOfVesselsDAO dao = IsisFishDAOHelper.getSetOfVesselsDAO(this.getTopiaContext());
            List result = dao.findAll();
            return result;
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(eee);
        }
    }

    @Override
    public List<Species> getSpecies() {
        try {
            SpeciesDAO dao = IsisFishDAOHelper.getSpeciesDAO(this.getTopiaContext());
            List result = dao.findAll();
            return result;
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(eee);
        }
    }

    @Override
    public List<Strategy> getStrategy() {
        try {
            StrategyDAO dao = IsisFishDAOHelper.getStrategyDAO(this.getTopiaContext());
            List result = dao.findAll();
            return result;
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(eee);
        }
    }

    @Override
    public List<TripType> getTripType() {
        try {
            TripTypeDAO dao = IsisFishDAOHelper.getTripTypeDAO(this.getTopiaContext());
            List result = dao.findAll();
            return result;
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(eee);
        }
    }

    @Override
    public List<Zone> getZone() {
        try {
            ZoneDAO dao = IsisFishDAOHelper.getZoneDAO(this.getTopiaContext());
            List result = dao.findAll();
            return result;
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(eee);
        }
    }

    @Override
    public String toString() {
        String result = this.getName();
        return result;
    }
}

