/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore.update;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.CellDAO;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.EffortDescriptionDAO;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.GearDAO;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierDAO;
import fr.ifremer.isisfish.entities.MetierSeasonInfoDAO;
import fr.ifremer.isisfish.entities.MetierSeasonInfoImpl;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationDAO;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationGroupDAO;
import fr.ifremer.isisfish.entities.PopulationImpl;
import fr.ifremer.isisfish.entities.PopulationSeasonInfoDAO;
import fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl;
import fr.ifremer.isisfish.entities.Port;
import fr.ifremer.isisfish.entities.PortDAO;
import fr.ifremer.isisfish.entities.Selectivity;
import fr.ifremer.isisfish.entities.SelectivityDAO;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.SetOfVesselsDAO;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.SpeciesDAO;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyDAO;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.entities.StrategyMonthInfoDAO;
import fr.ifremer.isisfish.entities.TargetSpecies;
import fr.ifremer.isisfish.entities.TargetSpeciesDAO;
import fr.ifremer.isisfish.entities.TripType;
import fr.ifremer.isisfish.entities.TripTypeDAO;
import fr.ifremer.isisfish.entities.VesselType;
import fr.ifremer.isisfish.entities.VesselTypeDAO;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.entities.ZoneDAO;
import fr.ifremer.isisfish.equation.PopulationGrowthReverse;
import fr.ifremer.isisfish.equation.PopulationNaturalDeathRate;
import fr.ifremer.isisfish.equation.PopulationReproductionEquation;
import fr.ifremer.isisfish.equation.SelectivityEquation;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.RangeOfValues;
import fr.ifremer.isisfish.types.TimeUnit;
import fr.ifremer.isisfish.ui.input.EquationEditorPaneUI;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.ArrayUtil;
import org.nuiton.util.FileUtil;
import org.nuiton.util.Resource;
import org.nuiton.util.VersionNumberUtil;

public class ImportFromV2 {
    private static Log log = LogFactory.getLog(ImportFromV2.class);
    private static final String XSL_DIRECTORY = "/v2xsl";
    private static final String LAST_2_VERSION = "2.3";
    Map<String, TopiaEntity> cache = new HashMap<String, TopiaEntity>();
    Element root;
    List<String> equationId = new ArrayList<String>();
    boolean manual = true;
    Node current = null;

    public ImportFromV2(boolean manual) {
        this.manual = manual;
    }

    private File convertXML(File file) throws Exception {
        log.info((Object)"Nettoyage du fichier");
        URL cleaner = Resource.getURL((String)"/v2xsl/isis-fish-cleaner.xsl");
        File dest = File.createTempFile("isis-tmp-dbconvert", "xml");
        this.convert(file, dest, cleaner);
        file = dest;
        log.info((Object)"recherche de la version");
        String version = "0";
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        for (int i = 0; !(i >= 5 || line.contains("version=") && line.contains("<dbobjects")); ++i) {
            line = reader.readLine();
        }
        if (line.contains("version=") && line.contains("<dbobjects")) {
            version = line.replaceAll(".*?version=['\"]([0-9.]+)['\"].*", "$1");
        }
        log.info((Object)("Conversion du fichier depuis la version " + version + " vers " + LAST_2_VERSION));
        file = this.convertXML(file, version, LAST_2_VERSION);
        return file;
    }

    private File convertXML(File file, String versionStart, String versionEnd) throws Exception {
        if (VersionNumberUtil.greaterThan((String)versionStart, (String)versionEnd)) {
            throw new Exception(I18n._((String)"isisfish.error.import.recent.files"));
        }
        if (VersionNumberUtil.smallerThan((String)versionStart, (String)versionEnd)) {
            try {
                URL[] xslurl = this.getXSLFile(versionStart, versionEnd);
                if (xslurl == null) {
                    throw new Exception(I18n._((String)"isisfish.error.import.convertible"));
                }
                File dest = file;
                for (URL aXslurl : xslurl) {
                    File source = dest;
                    dest = File.createTempFile("isis-tmp-dbconvert", "xml");
                    this.convert(source, dest, aXslurl);
                }
                file = dest;
            }
            catch (Exception eee) {
                throw new Exception(I18n._((String)"isisfish.error.conversion.data"), eee);
            }
        }
        return file;
    }

    protected URL[] getXSLFile(String versionStart, String versionEnd) {
        ArrayList<URL> result = new ArrayList<URL>();
        List xslurl = Resource.getURLs((String)(".*?/v2xsl/isis-fish-" + versionStart + "_.*.xsl$"));
        while (xslurl.size() != 0) {
            URL xsl = (URL)xslurl.get(0);
            result.add(xsl);
            String end = this.getVersionEnd(xsl);
            if (VersionNumberUtil.equals((String)versionEnd, (String)end)) {
                return result.toArray(new URL[result.size()]);
            }
            xslurl = Resource.getURLs((String)(".*?/v2xsl/isis-fish-" + end + "_.*.xsl$"));
        }
        return null;
    }

    protected String getVersionEnd(URL xslurl) {
        String version = xslurl.toExternalForm();
        version = version.substring(version.lastIndexOf("_") + 1, version.length() - ".xsl".length());
        return version;
    }

    protected void convert(File sourceFile, File destFile, URL stylesheetURL) throws Exception {
        log.info((Object)("transforme data with " + stylesheetURL));
        StreamSource stylesheet = new StreamSource(stylesheetURL.openStream());
        Transformer transformer = TransformerFactory.newInstance().newTransformer(stylesheet);
        InputStream inf = new FileInputStream(sourceFile);
        if ("gz".equalsIgnoreCase(FileUtil.extension((File)sourceFile, (String[])new String[0]))) {
            inf = new GZIPInputStream(inf);
        }
        InputStreamReader in = new InputStreamReader(inf, "ISO-8859-1");
        StreamSource source = new StreamSource(in);
        FileOutputStream outf = new FileOutputStream(destFile);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)outf, "ISO-8859-1");
        StreamResult dest = new StreamResult(out);
        transformer.transform(source, dest);
        in.close();
        out.close();
    }

    protected List<Node> selectNodes(Node node, String path) {
        List list = node.selectNodes(path);
        return list;
    }

    protected List<Element> selectElements(Node node, String path) {
        List list = node.selectNodes(path);
        return list;
    }

    public void importXML(File xml) throws Exception {
        log.info((Object)("importXML from file : " + xml));
        xml = this.convertXML(xml);
        FilterInputStream in = new BufferedInputStream(new FileInputStream(xml));
        if ("gz".equalsIgnoreCase(FileUtil.extension((File)xml, (String[])new String[0]))) {
            in = new GZIPInputStream(in);
        }
        SAXReader reader = new SAXReader();
        Document doc = reader.read((InputStream)in);
        this.root = doc.getRootElement();
        List<Node> regionNames = this.selectNodes((Node)this.root, "/dbobjects/dbobject[@type='Region']/attribute[@name='nom']");
        if (regionNames.size() == 0) {
            log.error((Object)"Can't find region in XML");
        }
        for (Node regionName : regionNames) {
            String name = regionName.getText();
            if (name != null && !"".equals(name)) {
                log.info((Object)("Region found: " + name));
                if (RegionStorage.exists(name)) {
                    log.error((Object)("region already exist, can't import " + name));
                    continue;
                }
                long statTime = System.nanoTime();
                log.info((Object)"import region ...");
                RegionStorage storage = RegionStorage.create(name);
                TopiaContext context = storage.getStorage().beginTransaction();
                Element region = regionName.getParent();
                try {
                    this.importRegion(context, region);
                    this.importCells(context, region);
                    this.importZones(context, region);
                    this.importPorts(context, region);
                    this.importSpecies(context, region);
                    this.importGears(context, region);
                    this.importMetiers(context, region);
                    this.importTripTypes(context, region);
                    this.importVesselTypes(context, region);
                    this.importSetOfVessels(context, region);
                    this.importStrategies(context, region);
                }
                catch (Exception eee) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Error during import current XML was:\n" + this.current.asXML()));
                    }
                    throw eee;
                }
                long endTime = System.nanoTime();
                long time = (endTime - statTime) / 1000000L;
                log.info((Object)("Import time: " + DurationFormatUtils.formatDuration((long)time, (String)"s'.'S")));
                context.commitTransaction();
                log.info((Object)"region imported");
                if (this.manual) {
                    log.info((Object)"Ask user for manual equation conversion");
                    EquationEditorPaneUI frame = new EquationEditorPaneUI();
                    frame.setTitle(I18n._((String)"isisfish.message.import.equation.convert"));
                    for (String id : this.equationId) {
                        context = storage.getStorage().beginTransaction();
                        Equation eq = (Equation)context.findByTopiaId(id);
                        frame.setEquation(eq.getCategory(), eq.getName(), eq.getJavaInterface(), eq.getContent());
                        frame.setVisible(true);
                        if (frame.isOk()) {
                            eq.setContent(frame.getEditor().getText());
                        }
                        context.commitTransaction();
                    }
                    frame.dispose();
                }
                context.closeContext();
                continue;
            }
            log.error((Object)"Region found but name is empty, can't import it");
        }
    }

    private void importRegion(TopiaContext context, Element region) throws Exception {
        log.debug((Object)"import de la region");
        FisheryRegion region3 = RegionStorage.getFisheryRegion(context);
        this.cache.put(this.getId((Node)region), region3);
        this.current = region;
        region3.setComment(this.getStringValue((Node)region, "commentaire"));
        region3.setCellLengthLatitude(this.getFloatValue((Node)region, "pasMailleLatitude"));
        region3.setCellLengthLongitude(this.getFloatValue((Node)region, "pasMailleLongitude"));
        region3.setMaxLatitude(this.getFloatValue((Node)region, "maxLatitude"));
        region3.setMaxLongitude(this.getFloatValue((Node)region, "maxLongitude"));
        region3.setMinLatitude(this.getFloatValue((Node)region, "minLatitude"));
        region3.setMinLongitude(this.getFloatValue((Node)region, "minLongitude"));
    }

    private void importCells(TopiaContext context, Element region) throws Exception {
        List<Node> mailles = this.getListValue((Node)region, "mailles");
        log.info((Object)("import de " + mailles.size() + " mailles"));
        for (Node node : mailles) {
            Node maille = this.getElementById(node.getText());
            CellDAO dao = IsisFishDAOHelper.getCellDAO(context);
            Cell cell = (Cell)dao.create(new Object[0]);
            this.cache.put(this.getId(maille), cell);
            this.current = maille;
            cell.setName(this.getStringValue(maille, "nom"));
            cell.setLatitude(this.getFloatValue(maille, "latitude"));
            cell.setLongitude(this.getFloatValue(maille, "longitude"));
            cell.setLand(this.getBoolValue(maille, "terre"));
            cell.setComment(this.getStringValue(maille, "commentaire"));
        }
    }

    private void importZones(TopiaContext context, Element region) throws Exception {
        List<Node> secteurs = this.getListValue("SecteurSimple", "region", this.getId((Node)region));
        log.info((Object)("import de " + secteurs.size() + " zones"));
        for (Node secteur : secteurs) {
            ZoneDAO dao = IsisFishDAOHelper.getZoneDAO(context);
            Zone zone = (Zone)dao.create(new Object[0]);
            this.cache.put(this.getId(secteur), zone);
            this.current = secteur;
            zone.setName(this.getStringValue(secteur, "nom"));
            zone.setComment(this.getStringValue(secteur, "commentaire"));
            List<Node> ms = this.getListValue(secteur, "maille");
            for (Node maille : ms) {
                Cell cell = (Cell)this.cache.get(maille.getText());
                zone.addCell(cell);
            }
        }
    }

    private void importPorts(TopiaContext context, Element region) throws Exception {
        List<Node> ports = this.getListValue((Node)region, "ports");
        log.info((Object)("import de " + ports.size() + " ports"));
        for (Node node : ports) {
            Node port = this.getElementById(node.getText());
            PortDAO dao = IsisFishDAOHelper.getPortDAO(context);
            Port port3 = (Port)dao.create(new Object[0]);
            this.cache.put(this.getId(port), port3);
            this.current = port;
            port3.setName(this.getStringValue(port, "name"));
            port3.setCell((Cell)this.cache.get(this.getStringValue(port, "maille")));
            port3.setComment(this.getStringValue(port, "commentaire"));
        }
    }

    private void importSpecies(TopiaContext context, Element region) throws Exception {
        List<Node> metapopIds = this.getListValue((Node)region, "metaPopulations");
        log.info((Object)("import de " + metapopIds.size() + " Species"));
        for (Node metapopid : metapopIds) {
            Node metapop = this.getElementById(metapopid.getText());
            SpeciesDAO dao = IsisFishDAOHelper.getSpeciesDAO(context);
            Species species = (Species)dao.create(new Object[0]);
            this.cache.put(this.getId(metapop), species);
            this.current = metapop;
            species.setName(this.getStringValue(metapop, "nomEspece"));
            species.setScientificName(this.getStringValue(metapop, "nomScientifique"));
            species.setCodeCEE(this.getIntValue(metapop, "codeCEE"));
            species.setCodeRubbin(this.getStringValue(metapop, "codeRubbin"));
            species.setAgeGroupType(this.getBoolValue(metapop, "enAge"));
            species.setComment(this.getStringValue(metapop, "commentaire"));
            List<Node> popIds = this.getListValue(metapop, "population");
            log.info((Object)("import de " + popIds.size() + " Population"));
            for (Node popid : popIds) {
                Node pop = this.getElementById(popid.getText());
                PopulationDAO popdao = IsisFishDAOHelper.getPopulationDAO(context);
                PopulationImpl pop3 = (PopulationImpl)popdao.create(new Object[0]);
                this.cache.put(this.getId(pop), pop3);
                this.current = pop;
                species.addPopulation(pop3);
                pop3.setSpecies(species);
                pop3.setName(this.getStringValue(pop, "nom"));
                pop3.setGeographicId(this.getStringValue(pop, "idGeographique"));
                pop3.setPlusGroup(this.getBoolValue(pop, "classePlus"));
                pop3.setGrowthContent(this.getEquationStringValue(pop, "croissance"));
                this.convertEquation(pop3.getGrowth(), this.getStringValue(pop, "croissance"));
                pop3.setGrowthReverseContent(this.getEquationStringValue(pop, "inverseCroissance"));
                this.convertEquation(pop3.getGrowthReverse(), this.getStringValue(pop, "inverseCroissance"));
                pop3.setNaturalDeathRateContent(this.getEquationStringValue(pop, "mortaliteNaturelleEquation"));
                this.convertEquation(pop3.getNaturalDeathRate(), this.getStringValue(pop, "mortaliteNaturelleEquation"));
                pop3.setReproductionEquationContent(this.getEquationStringValue(pop, "equationReproduction"));
                this.convertEquation(pop3.getReproductionEquation(), this.getStringValue(pop, "equationReproduction"));
                pop3.setMonthGapBetweenReproRecrutement(this.getIntValue(pop, "nbMoisEntreReproRecrutement"));
                pop3.setRecruitmentDistribution(this.getMatrixValue(pop, "etalementRecrutement"));
                pop3.setComment(this.getStringValue(pop, "commentaire"));
                List<Zone> zones = this.getZoneValue(pop, "zonePopulation");
                for (Zone zone : zones) {
                    pop3.addPopulationZone(zone);
                }
                zones = this.getZoneValue(pop, "zoneRecrutement");
                for (Zone zone : zones) {
                    pop3.addRecruitmentZone(zone);
                }
                zones = this.getZoneValue(pop, "zoneReproduction");
                for (Zone zone : zones) {
                    pop3.addReproductionZone(zone);
                }
                MatrixND mat = pop3.getMappingZoneReproZoneRecru();
                if (mat != null) {
                    mat = mat.copy();
                    List<Node> mappings = this.getListValue(pop, "mappingZoneReproZoneRecru");
                    for (Node mappingId : mappings) {
                        Node mapping = this.getElementById(mappingId.getText());
                        Zone zoneRepro = (Zone)this.cache.get(this.getStringValue(mapping, "zoneReproduction"));
                        Zone zoneRecru = (Zone)this.cache.get(this.getStringValue(mapping, "zoneRecrutement"));
                        double coeff = this.getDoubleValue(mapping, "coeff");
                        mat.setValue((Object)zoneRepro, (Object)zoneRecru, coeff);
                    }
                    pop3.setMappingZoneReproZoneRecru(mat);
                }
                String eqMeanWeight = "if (group == null) return 0;\n  switch (group.getId()) {\n";
                String eqPrice = "if (group == null) return 0;\n  switch (group.getId()) {\n";
                int classMat = this.getIntValue(pop, "classeMature");
                List<Node> classes = this.getListValue(pop, "classes");
                for (Node classeId : classes) {
                    Node classe = this.getElementById(classeId.getText());
                    PopulationGroupDAO daogroup = IsisFishDAOHelper.getPopulationGroupDAO(context);
                    PopulationGroup group = (PopulationGroup)daogroup.create(new Object[0]);
                    this.cache.put(this.getId(classe), group);
                    this.current = classe;
                    pop3.addPopulationGroup(group);
                    group.setPopulation(pop3);
                    group.setId(this.getIntValue(classe, "id"));
                    group.setAge(this.getDoubleValue(classe, "age"));
                    group.setReproductionRate(this.getDoubleValue(classe, "coefficientFecondite"));
                    group.setMinLength(this.getDoubleValue(classe, "longueurMin"));
                    group.setMaxLength(this.getDoubleValue(classe, "longueurMax"));
                    group.setComment(this.getStringValue(classe, "commentaire"));
                    eqMeanWeight = eqMeanWeight + "    case " + group.getId() + ": return " + this.getStringValue(classe, "poidsMoyen") + ";\n";
                    eqPrice = eqPrice + "    case " + group.getId() + ": return " + this.getStringValue(classe, "price") + ";\n";
                    if (group.getId() != classMat) continue;
                    pop3.setMaturityGroup(group);
                }
                eqMeanWeight = eqMeanWeight + "    default: return 0;\n  }\n";
                pop3.setMeanWeightContent(eqMeanWeight);
                eqPrice = eqPrice + "    default: return 0;\n  }\n";
                pop3.setPriceContent(eqPrice);
                String seasonComment = "";
                List<Node> infoSaisons = this.getListValue(pop, "infoSaison");
                for (Node infoSaisonId : infoSaisons) {
                    PopulationGroup group;
                    Node infoSaison = this.getElementById(infoSaisonId.getText());
                    PopulationSeasonInfoDAO daoSeason = IsisFishDAOHelper.getPopulationSeasonInfoDAO(context);
                    PopulationSeasonInfoImpl season = (PopulationSeasonInfoImpl)daoSeason.create(new Object[0]);
                    this.cache.put(this.getId(infoSaison), season);
                    this.current = infoSaison;
                    pop3.addPopulationSeasonInfo(season);
                    season.setPopulation(pop3);
                    season.setGroupChange(this.getBoolValue(infoSaison, "changementClass"));
                    season.setSimpleLengthChangeMatrix(this.getBoolValue(infoSaison, "matriceChangementLongueurSimple"));
                    season.setReproduction(this.getBoolValue(infoSaison, "reproduction"));
                    season.setUseEquationMigration(this.getBoolValue(infoSaison, "useMigrationEquation"));
                    Month first = this.getFirstMonthSeason(infoSaison, "saison");
                    Month last = this.getLastMonthSeason(infoSaison, "saison");
                    season.setFirstMonth(first);
                    season.setLastMonth(last);
                    mat = season.createNoSpacializedChangeGroupMatrix();
                    if (!season.getSimpleLengthChangeMatrix()) {
                        mat = season.spacializeLengthChangeMatrix(mat);
                    }
                    mat.paste(this.getMatrixValue(infoSaison, "matriceChangementLongueur"));
                    season.setLengthChangeMatrix(mat);
                    mat = season.getReproductionDistribution().copy();
                    mat.paste(this.getMatrixValue(infoSaison, "distributionRepro"));
                    season.setReproductionDistribution(mat);
                    if (season.getUseEquationMigration()) {
                        season.setMigrationEquationContent(this.getEquationStringValue(infoSaison, "migrationEquation"));
                        this.convertEquation(season.getMigrationEquation(), this.getStringValue(infoSaison, "migrationEquation"));
                        season.setEmigrationEquationContent(this.getEquationStringValue(infoSaison, "emigrationEquation"));
                        this.convertEquation(season.getEmigrationEquation(), this.getStringValue(infoSaison, "emigrationEquation"));
                        season.setImmigrationEquationContent(this.getEquationStringValue(infoSaison, "immigrationEquation"));
                        this.convertEquation(season.getImmigrationEquation(), this.getStringValue(infoSaison, "immigrationEquation"));
                    } else {
                        mat = season.getMigrationMatrix().copy();
                        List<Node> migs = this.getListValue(infoSaison, "migration");
                        for (Node migId : migs) {
                            Node migration;
                            this.current = migration = this.getElementById(migId.getText());
                            group = (PopulationGroup)this.cache.get(this.getStringValue(migration, "classe"));
                            double coeff = this.getDoubleValue(migration, "coefficient");
                            Zone zoneDep = (Zone)this.cache.get(this.getStringValue(migration, "secteurDepart"));
                            Zone zoneArr = (Zone)this.cache.get(this.getStringValue(migration, "secteurArrivee"));
                            try {
                                mat.setValue((Object)group, (Object)zoneDep, (Object)zoneArr, coeff);
                            }
                            catch (Exception eee) {
                                log.warn((Object)("Error during migration import for " + season), (Throwable)eee);
                            }
                        }
                        season.setMigrationMatrix(mat);
                        mat = season.getEmigrationMatrix().copy();
                        List<Node> emigs = this.getListValue(infoSaison, "emigration");
                        for (Node emigId : emigs) {
                            Node emigration;
                            this.current = emigration = this.getElementById(emigId.getText());
                            PopulationGroup group2 = (PopulationGroup)this.cache.get(this.getStringValue(emigration, "classe"));
                            double coeff = this.getDoubleValue(emigration, "coefficient");
                            Zone zoneDep = (Zone)this.cache.get(this.getStringValue(emigration, "secteurDepart"));
                            try {
                                mat.setValue((Object)group2, (Object)zoneDep, coeff);
                            }
                            catch (Exception eee) {
                                log.warn((Object)("Error during emigration import for " + season), (Throwable)eee);
                            }
                        }
                        season.setEmigrationMatrix(mat);
                        mat = season.getImmigrationMatrix().copy();
                        List<Node> immigs = this.getListValue(infoSaison, "immigration");
                        for (Node immigId : immigs) {
                            Node immigration;
                            this.current = immigration = this.getElementById(immigId.getText());
                            PopulationGroup group3 = (PopulationGroup)this.cache.get(this.getStringValue(immigration, "classe"));
                            double coeff = this.getDoubleValue(immigration, "coefficient");
                            Zone zoneArr = (Zone)this.cache.get(this.getStringValue(immigration, "secteurArrivee"));
                            try {
                                mat.setValue((Object)group3, (Object)zoneArr, coeff);
                            }
                            catch (Exception eee) {
                                log.warn((Object)("Error during immigration import for " + season), (Throwable)eee);
                            }
                        }
                        season.setImmigrationMatrix(mat);
                    }
                    seasonComment = seasonComment + this.getStringValue(infoSaison, "commentaire");
                    mat = pop3.getCapturability().copy();
                    List<Node> captus = this.getListValue(infoSaison, "capturabilite");
                    for (Node captuId : captus) {
                        Node captu = this.getElementById(captuId.getText());
                        group = (PopulationGroup)this.cache.get(this.getStringValue(captu, "classe"));
                        double coeff = this.getDoubleValue(captu, "coefficient");
                        mat.setValue((Object)group, (Object)season, coeff);
                    }
                    pop3.setCapturability(mat);
                }
                pop3.setSeasonsComment(seasonComment);
            }
        }
    }

    private void importGears(TopiaContext context, Element region) throws Exception {
        List<Node> engins = this.getListValue("Engin", "region", this.getId((Node)region));
        log.info((Object)("import de " + engins.size() + " Engins"));
        for (Node engin : engins) {
            GearDAO dao = IsisFishDAOHelper.getGearDAO(context);
            Gear gear = (Gear)dao.create(new Object[0]);
            this.cache.put(this.getId(engin), gear);
            this.current = engin;
            gear.setName(this.getStringValue(engin, "nom"));
            gear.setCost(this.getDoubleValue(engin, "cost"));
            gear.setStandardisationFactor(this.getDoubleValue(engin, "facteurStandard"));
            gear.setParameterName(this.getStringValue(engin, "parametreNom"));
            gear.setEffortUnit(this.getStringValue(engin, "uniteMesureEffort"));
            gear.setPossibleValue(this.getRangeOfValues(engin, "parametreGammePossible"));
            gear.setComment(this.getStringValue(engin, "commentaire"));
            List<Node> selectivites = this.getListValue(engin, "selectivite");
            for (Node selectiviteId : selectivites) {
                Node selectivite = this.getElementById(selectiviteId.getText());
                SelectivityDAO daoSelectivity = IsisFishDAOHelper.getSelectivityDAO(context);
                Selectivity selectivity = (Selectivity)daoSelectivity.create(new Object[0]);
                this.cache.put(this.getId(selectivite), selectivity);
                this.current = selectivite;
                gear.addPopulationSelectivity(selectivity);
                selectivity.setGear(gear);
                selectivity.setPopulation((Population)this.cache.get(this.getStringValue(selectivite, "population")));
                Equation eq = selectivity.getEquation();
                eq.setContent(this.getEquationStringValue(selectivite, "equation"));
                this.convertEquation(eq, this.getStringValue(selectivite, "equation"));
                selectivity.setEquation(eq);
            }
        }
    }

    private void importMetiers(TopiaContext context, Element region) throws Exception {
        List<Node> metiers = this.getListValue((Node)region, "metiers");
        log.info((Object)("import de " + metiers.size() + " Metiers"));
        for (Node metierId : metiers) {
            Node metier = this.getElementById(metierId.getText());
            MetierDAO dao = IsisFishDAOHelper.getMetierDAO(context);
            Metier metier3 = (Metier)dao.create(new Object[0]);
            this.cache.put(this.getId(metier), metier3);
            this.current = metier;
            metier3.setName(this.getStringValue(metier, "nom"));
            metier3.setGear((Gear)this.cache.get(this.getStringValue(metier, "engin")));
            metier3.setGearParameterValue(this.getStringValue(metier, "valeurParamControlable"));
            metier3.setComment(this.getStringValue(metier, "commentaire"));
            List<Node> infoSaisons = this.getListValue(metier, "infoSaison");
            for (Node infoSaisonId : infoSaisons) {
                Node infoSaison = this.getElementById(infoSaisonId.getText());
                MetierSeasonInfoDAO daoSeason = IsisFishDAOHelper.getMetierSeasonInfoDAO(context);
                MetierSeasonInfoImpl season = (MetierSeasonInfoImpl)daoSeason.create(new Object[0]);
                this.cache.put(this.getId(infoSaison), season);
                this.current = infoSaison;
                metier3.addMetierSeasonInfo(season);
                season.setMetier(metier3);
                Month first = this.getFirstMonthSeason(infoSaison, "saison");
                Month last = this.getLastMonthSeason(infoSaison, "saison");
                season.setFirstMonth(first);
                season.setLastMonth(last);
                String commentTarget = "";
                List<Node> especesCaptus = this.getListValue(infoSaison, "especesCaptu");
                for (Node especesCaptuId : especesCaptus) {
                    Node especesCaptu = this.getElementById(especesCaptuId.getText());
                    TargetSpeciesDAO daoTarget = IsisFishDAOHelper.getTargetSpeciesDAO(context);
                    TargetSpecies target = (TargetSpecies)daoTarget.create(new Object[0]);
                    this.cache.put(this.getId(especesCaptu), target);
                    this.current = especesCaptu;
                    season.addSpeciesTargetSpecies(target);
                    target.setMetierSeasonInfo(season);
                    target.setPrimaryCatch(this.getBoolValue(especesCaptu, "capturePrimaire"));
                    target.setSpecies((Species)this.cache.get(this.getStringValue(especesCaptu, "metaPopulation")));
                    Equation eq = target.getTargetFactorEquation();
                    eq.setContent(this.getEquationStringValue(especesCaptu, "equation"));
                    this.convertEquation(eq, this.getStringValue(especesCaptu, "equation"));
                    target.setTargetFactorEquation(eq);
                    commentTarget = commentTarget + this.getStringValue(especesCaptu, "commentaire");
                }
                metier3.setCapturableSpeciesComment(commentTarget);
                List<Zone> zones = this.getZoneValue(infoSaison, "secteur");
                for (Zone zone : zones) {
                    season.addZone(zone);
                }
            }
        }
    }

    private void importTripTypes(TopiaContext context, Element region) throws Exception {
        String regionId = this.getId((Node)region);
        List<Node> tripTypes = this.getListValue("TripType", "region", this.getId((Node)region));
        log.info((Object)("import de " + tripTypes.size() + " TripTypes"));
        for (Node tripType : tripTypes) {
            TripTypeDAO dao = IsisFishDAOHelper.getTripTypeDAO(context);
            TripType tripType3 = (TripType)dao.create(new Object[0]);
            this.cache.put(this.getId(tripType), tripType3);
            this.current = tripType;
            tripType3.setName(this.getStringValue(tripType, "name"));
            tripType3.setTripDuration(new TimeUnit(0.0).setDay(this.getDoubleValue(tripType, "tripDuration")));
            tripType3.setMinTimeBetweenTrip(new TimeUnit(0.0).setDay(this.getDoubleValue(tripType, "minTimeBetweenTrip")));
            tripType3.setComment(this.getStringValue(tripType, "commentaire"));
        }
    }

    private void importSetOfVessels(TopiaContext context, Element region) throws Exception {
        List<Node> setOfVessels = this.getListValue("SetOfVessels", "region", this.getId((Node)region));
        log.info((Object)("import de " + setOfVessels.size() + " SetOfVessels"));
        for (Node sov : setOfVessels) {
            SetOfVesselsDAO dao = IsisFishDAOHelper.getSetOfVesselsDAO(context);
            SetOfVessels sov3 = (SetOfVessels)dao.create(new Object[0]);
            this.cache.put(this.getId(sov), sov3);
            this.current = sov;
            sov3.setName(this.getStringValue(sov, "name"));
            sov3.setCapitalDeprecation(this.getDoubleValue(sov, "capitalDeprecation"));
            sov3.setFixedCosts(this.getDoubleValue(sov, "fixedCosts"));
            sov3.setInterestCost(this.getDoubleValue(sov, "interestCosts"));
            sov3.setNumberOfVessels(this.getIntValue(sov, "numberOfVessels"));
            sov3.setPort((Port)this.cache.get(this.getStringValue(sov, "port")));
            sov3.setVesselCosts(this.getDoubleValue(sov, "vesselCosts"));
            sov3.setVesselType((VesselType)this.cache.get(this.getStringValue(sov, "vesselType")));
            sov3.setComment(this.getStringValue(sov, "commentaire"));
            List<Node> possibleMetiers = this.getListValue(sov, "possibleMetiers");
            log.trace((Object)("import de " + possibleMetiers.size() + " EffortDescription"));
            for (Node node : possibleMetiers) {
                Node effort = this.getElementById(node.getText());
                EffortDescriptionDAO daoEffort = IsisFishDAOHelper.getEffortDescriptionDAO(context);
                EffortDescription effort3 = (EffortDescription)daoEffort.create(new Object[0]);
                this.cache.put(this.getId(effort), effort3);
                this.current = effort;
                sov3.addPossibleMetiers(effort3);
                effort3.setSetOfVessels(sov3);
                effort3.setCrewFoodCost(this.getDoubleValue(effort, "crewFoodCost"));
                effort3.setCrewShareRate(this.getDoubleValue(effort, "crewShareRate"));
                effort3.setCrewSize(this.getIntValue(effort, "crewSize"));
                effort3.setFishingOperation(this.getIntValue(effort, "fishingOperation"));
                effort3.setFishingOperationDuration(new TimeUnit(0.0).setDay(this.getDoubleValue(effort, "fishingOperationDuration")));
                effort3.setFixedCrewSalary(this.getDoubleValue(effort, "fixedCrewSalary"));
                effort3.setGearsNumberPerOperation(this.getIntValue(effort, "gearsNumberPerOperation"));
                effort3.setLandingCosts(this.getDoubleValue(effort, "landingCosts"));
                effort3.setPossibleMetiers((Metier)this.cache.get(this.getStringValue(effort, "metier")));
                effort3.setOtherRunningCost(this.getDoubleValue(effort, "otherRunningCosts"));
                effort3.setRepairAndMaintenanceGearCost(this.getDoubleValue(effort, "repairAndMaintenanceGearCost"));
                effort3.setSetOfVessels((SetOfVessels)this.cache.get(this.getStringValue(effort, "setOfVessels")));
                effort3.setUnitCostOfFishing(this.getDoubleValue(effort, "unitCostOfFishing"));
            }
        }
    }

    private void importVesselTypes(TopiaContext context, Element region) throws Exception {
        List<Node> vesselTypes = this.getListValue("VesselType", "region", this.getId((Node)region));
        log.info((Object)("import de " + vesselTypes.size() + " VesselTypes"));
        for (Node vesselType : vesselTypes) {
            VesselTypeDAO dao = IsisFishDAOHelper.getVesselTypeDAO(context);
            VesselType vesselType3 = (VesselType)dao.create(new Object[0]);
            this.cache.put(this.getId(vesselType), vesselType3);
            this.current = vesselType;
            vesselType3.setName(this.getStringValue(vesselType, "name"));
            vesselType3.setActivityRange(this.getDoubleValue(vesselType, "activityRange"));
            vesselType3.setLength(this.getIntValue(vesselType, "length"));
            vesselType3.setMaxTripDuration(new TimeUnit(0.0).setDay(this.getDoubleValue(vesselType, "maxTripDuration")));
            vesselType3.setMinCrewSize(this.getIntValue(vesselType, "minCrewSize"));
            vesselType3.setSpeed(this.getDoubleValue(vesselType, "speed"));
            vesselType3.setUnitFuelCostOfTravel(this.getDoubleValue(vesselType, "unitFuelCostOfTravel"));
            vesselType3.setComment(this.getStringValue(vesselType, "commentaire"));
            List<Node> possibleTripTypes = this.getListValue(vesselType, "possibleTripTypes");
            for (Node node : possibleTripTypes) {
                vesselType3.addTripType((TripType)this.cache.get(node.getText()));
            }
        }
    }

    private void importStrategies(TopiaContext context, Element region) throws Exception {
        List<Node> strategies = this.getListValue((Node)region, "strategies");
        log.info((Object)("import de " + strategies.size() + " Strategies"));
        for (Node node : strategies) {
            Node strategie = this.getElementById(node.getText());
            StrategyDAO dao = IsisFishDAOHelper.getStrategyDAO(context);
            Strategy strategy = (Strategy)dao.create(new Object[0]);
            this.cache.put(this.getId(strategie), strategy);
            this.current = strategie;
            strategy.setName(this.getStringValue(strategie, "name"));
            strategy.setProportionSetOfVessels(this.getDoubleValue(strategie, "proportionSetOfVessels"));
            strategy.setSetOfVessels((SetOfVessels)this.cache.get(this.getStringValue(strategie, "setOfVessels")));
            strategy.setComment(this.getStringValue(strategie, "commentaire"));
            ArrayList<StrategyMonthInfo> allsmi = new ArrayList<StrategyMonthInfo>(12);
            List<Node> strategyMonthInfos = this.getListValue(strategie, "strategyMonthInfos");
            log.debug((Object)("import de " + strategyMonthInfos.size() + " StrategyMonthInfo for " + strategy.getName()));
            for (Node strategyMonthInfoId : strategyMonthInfos) {
                Node smi = this.getElementById(strategyMonthInfoId.getText());
                StrategyMonthInfoDAO daoSMI = IsisFishDAOHelper.getStrategyMonthInfoDAO(context);
                StrategyMonthInfo smi3 = (StrategyMonthInfo)daoSMI.create(new Object[0]);
                this.cache.put(this.getId(smi), smi3);
                this.current = smi;
                allsmi.add(smi3);
                smi3.setStrategy(strategy);
                smi3.setMonth(Month.MONTH[this.getIntValue(smi, "month")]);
                smi3.setMinInactivityDays(this.getIntValue(smi, "minInactivityDays"));
                smi3.setNumberOfTrips(this.getIntValue(smi, "numberOfTrips"));
                smi3.setTripType((TripType)this.cache.get(this.getStringValue(smi, "tripType")));
                List<Node> propStrMets = this.getListValue("PropStrMet", "strategyMonthInfo", this.getId(smi));
                log.trace((Object)("Import de " + propStrMets.size() + " propStrMets"));
                Iterator<Node> i$ = propStrMets.iterator();
                while (i$.hasNext()) {
                    Node propStrMet;
                    this.current = propStrMet = i$.next();
                    Metier metier = (Metier)this.cache.get(this.getStringValue(propStrMet, "metier"));
                    double prop = this.getDoubleValue(propStrMet, "proportion");
                    try {
                        smi3.setProportionMetier(metier, prop);
                    }
                    catch (NoSuchElementException eee) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Can't set prop for: " + this.current.asXML()));
                    }
                }
            }
            strategy.clearStrategyMonthInfo();
            strategy.addAllStrategyMonthInfo(allsmi);
        }
    }

    private List<Node> getListValue(String type, String attribute, String id) {
        List<Node> tmp = this.selectNodes((Node)this.root, "/dbobjects/dbobject[@type='" + type + "']");
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node e : tmp) {
            if (!id.equals(this.getStringValue(e, attribute))) continue;
            result.add(e);
        }
        return result;
    }

    private List<Zone> getZoneValue(Node node, String attribute) {
        ArrayList<Zone> result = new ArrayList<Zone>();
        String id = this.getStringValue(node, attribute);
        if (id.contains("fr.ifremer.db.SecteurSimpleFactory")) {
            result.add((Zone)this.cache.get(id));
        } else {
            Node metasecteur = this.getElementById(id);
            if (metasecteur != null) {
                List<Node> secteurs = this.getListValue(metasecteur, "secteur");
                for (Node secteurSimple : secteurs) {
                    result.add((Zone)this.cache.get(secteurSimple.getText()));
                }
            }
        }
        return result;
    }

    private RangeOfValues getRangeOfValues(Node node, String attribute) throws Exception {
        String paramString = this.getStringValue(node, attribute);
        SAXReader reader = new SAXReader();
        Document doc = reader.read((Reader)new StringReader(paramString));
        Element param = doc.getRootElement();
        boolean cont = "true".equalsIgnoreCase(param.attributeValue("continue"));
        String type = RangeOfValues.TYPES[0];
        String result = "";
        String sep = "";
        List<Element> values = this.selectElements((Node)param, "value");
        for (Element value : values) {
            String oldType = value.attributeValue("type");
            result = result + sep + value.getText();
            sep = cont ? "-" : ";";
            if ("String".equalsIgnoreCase(oldType)) {
                type = RangeOfValues.TYPES[0];
                continue;
            }
            if ("Double".equalsIgnoreCase(oldType) || "Float".equalsIgnoreCase(oldType)) {
                type = RangeOfValues.TYPES[2];
                continue;
            }
            type = RangeOfValues.TYPES[1];
        }
        result = type + "[" + result + "]";
        return new RangeOfValues(result);
    }

    private String getEquationStringValue(Node node, String attribute) throws Exception {
        String equation = this.getStringValue(node, attribute);
        SAXReader reader = new SAXReader();
        Document doc = reader.read((Reader)new StringReader(equation));
        Element eq = doc.getRootElement();
        String result = eq.getText();
        return result;
    }

    private void convertEquation(Equation e, String xml) {
        String content = e.getContent();
        if (content.trim().length() == 0) {
            content = "return 0;";
        } else {
            try {
                Double.parseDouble(content);
                content = "return " + content + ";";
            }
            catch (Exception eee) {
                content = content.replaceAll("^#", "//");
                content = content.replaceAll("Ln", "Math.log");
                content = content.replaceAll("Exp", "Math.exp");
                content = content.replaceAll("getNom", "getName");
                content = content.replaceAll("getNumMois()", "getMonthNumber()");
                if (e.getJavaInterface().equals(SelectivityEquation.class)) {
                    content = content.replaceAll("longueur", "group.getLength()");
                    content = content.replaceAll("getValeurParamControlable", "getGearParameterValueAsDouble");
                    content = content.replaceAll("getValeurParamControlableAsNumber", "getGearParameterValueAsDouble");
                }
                if (e.getJavaInterface().equals(PopulationGrowthReverse.class)) {
                    content = content.replaceAll("longueur", "length");
                }
                if (e.getJavaInterface().equals(PopulationNaturalDeathRate.class) || e.getJavaInterface().equals(PopulationReproductionEquation.class)) {
                    content = content.replaceAll("classe", "group");
                    content = content.replaceAll("getCoefficientFecondite", "getReproductionRate");
                    content = content.replaceAll("getPoidsMoyen", "getMeanWeight");
                }
                if (!this.manual) {
                    log.warn((Object)("Equation must be converted by you: " + xml));
                    content = "/*\n" + content + "\n*/\n";
                    content = content + "throw new Exception(\"Equation imported from isis v2. You must rewrite equation in Java:\");\n";
                } else {
                    log.debug((Object)("Equation must be converted by you: " + xml));
                }
                this.equationId.add(e.getTopiaId());
            }
        }
        e.setContent(content);
    }

    private Month getLastMonthSeason(Node node, String attribute) throws Exception {
        String seasonXML = this.getStringValue(node, attribute);
        SAXReader reader = new SAXReader();
        Document doc = reader.read((Reader)new StringReader(seasonXML));
        Element season = doc.getRootElement();
        String monthString = season.attributeValue("last");
        Month result = Month.MONTH[Integer.parseInt(monthString)];
        return result;
    }

    private Month getFirstMonthSeason(Node node, String attribute) throws Exception {
        String seasonXML = this.getStringValue(node, attribute);
        SAXReader reader = new SAXReader();
        Document doc = reader.read((Reader)new StringReader(seasonXML));
        Element season = doc.getRootElement();
        String monthString = season.attributeValue("first");
        Month result = Month.MONTH[Integer.parseInt(monthString)];
        return result;
    }

    private MatrixND getMatrixValue(Node node, String attribute) throws Exception {
        String defaultValueString;
        SAXReader reader = new SAXReader();
        String matrixString = this.getStringValue(node, attribute);
        Document doc = reader.read((Reader)new StringReader(matrixString));
        Element mat = (Element)doc.getRootElement().selectSingleNode("/object/matrix");
        if (mat == null) {
            mat = (Element)doc.getRootElement().selectSingleNode("/object/MatriceND");
        }
        if ((defaultValueString = mat.attributeValue("defaultValue")) == null) {
            defaultValueString = mat.attributeValue("defaultElem");
        }
        double defaultValue = Double.parseDouble(defaultValueString);
        int[] dim = ArrayUtil.asIntArray((String[])mat.attributeValue("dimensions").split("[,;]"));
        MatrixND result = MatrixFactory.getInstance().create(dim);
        MatrixHelper.fill((MatrixND)result, (double)defaultValue);
        List<Element> elems = this.selectElements((Node)mat, "element");
        for (Element e : elems) {
            int[] coord = ArrayUtil.asIntArray((String[])e.attributeValue("path").split(","));
            double value = Double.parseDouble(e.attributeValue("value"));
            result.setValue(coord, value);
        }
        return result;
    }

    private String getId(Node node) {
        Element e = (Element)node;
        String result = e.attributeValue("__id__");
        return result;
    }

    private Node getElementById(String id) {
        Node result = this.root.selectSingleNode("/dbobjects/dbobject[@__id__='" + id + "']");
        return result;
    }

    private boolean getBoolValue(Node node, String attribute) {
        String val = this.getStringValue(node, attribute);
        boolean result = "true".equalsIgnoreCase(val);
        return result;
    }

    private int getIntValue(Node node, String attribute) {
        String val = this.getStringValue(node, attribute);
        int result = Integer.parseInt(val);
        return result;
    }

    private double getDoubleValue(Node node, String attribute) {
        String val = this.getStringValue(node, attribute);
        double result = Double.parseDouble(val);
        return result;
    }

    private float getFloatValue(Node node, String attribute) {
        String val = this.getStringValue(node, attribute);
        float result = Float.parseFloat(val);
        return result;
    }

    private List<Node> getListValue(Node node, String attribute) {
        List result = node.selectNodes("attribute[@name='" + attribute + "']");
        return result;
    }

    private String getStringValue(Node node, String attribute) {
        String result = "";
        Node att = node.selectSingleNode("attribute[@name='" + attribute + "']");
        if (att != null) {
            result = att.getText();
        } else {
            log.warn((Object)("Can't fing attribute : '" + attribute + "' on node: " + node));
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        IsisFish.init(new String[0]);
        boolean interactif = true;
        if (args.length == 0) {
            System.out.println("Usage ImportFromV2 <xml file> [<xml file> [<xml file> ...]]");
            new ImportFromV2(interactif).importXML(new File("/usr/local/src/PROJET/lutin/isis-fish/base-a-migrer/Iroise250706.xml.gz"));
        } else {
            for (String filename : args) {
                if ("--nomanual".equals(filename)) {
                    interactif = false;
                    continue;
                }
                new ImportFromV2(interactif).importXML(new File(filename));
            }
        }
    }
}

