/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.StorageChangeEvent;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.vcs.VCS;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;
import org.nuiton.util.ListenerSet;
import org.nuiton.util.Version;

public abstract class VersionStorage {
    private static final Log log = LogFactory.getLog(VersionStorage.class);
    protected static ListenerSet<StorageChangeListener> changeListeners = new ListenerSet();
    protected File root = null;
    protected File file = null;

    protected VersionStorage(File root, File file) {
        this.root = root;
        this.file = file;
    }

    protected static File getContextDatabaseDirectory() {
        return IsisFish.config.getContextDatabaseDirectory();
    }

    protected static String getContextDatabaseCacheKey(String key) {
        String result = VersionStorage.getContextDatabaseDirectory().getAbsolutePath() + key;
        return result;
    }

    protected static VCS getVCS() {
        return IsisFish.vcs;
    }

    protected abstract void prepare();

    public File getRoot() {
        return this.root;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isOnRemote() throws VCSException {
        return VersionStorage.getVCS().isOnRemote(this.getFile());
    }

    protected boolean isVersionnableFile(File file) {
        boolean result = true;
        if (!VersionStorage.getVCS().getLocalRepository().equals(this.file)) {
            result = VersionStorage.getVCS().isVersionnableFile(file);
        }
        return result;
    }

    protected List<File> getFiles(File current, List<File> result) {
        if (this.isVersionnableFile(current)) {
            result.add(current);
            if (current.exists() && current.isDirectory()) {
                for (File child : current.listFiles()) {
                    this.getFiles(child, result);
                }
            }
        }
        return result;
    }

    protected List<File> getFiles(boolean withParent) {
        ArrayList<File> result = new ArrayList<File>();
        File current = this.getFile();
        while (withParent && current != null && !current.equals(this.getRoot())) {
            if ((current = current.getParentFile()) == null) continue;
            result.add(0, current);
        }
        this.getFiles(this.getFile(), result);
        return result;
    }

    public void add(String msg) throws VCSException {
        this.prepare();
        List<File> files = this.getFiles(true);
        files.remove(IsisFish.config.getDatabaseDirectory());
        if (log.isDebugEnabled()) {
            log.debug((Object)("files to add: " + files));
        }
        VersionStorage.getVCS().add(files, msg);
    }

    public void delete(boolean vcsDelete) throws StorageException {
        if (vcsDelete) {
            List<File> files = this.getFiles(false);
            if (log.isDebugEnabled()) {
                log.debug((Object)("About to delete : " + files));
            }
            try {
                VersionStorage.getVCS().delete(files, I18n._((String)"isisfish.versionStorage.removed"));
            }
            catch (VCSException eee) {
                throw new StorageException(I18n._((String)"isisfish.error.delete.vcs.files"), eee);
            }
        }
        if (this.getFile().isDirectory()) {
            FileUtil.deleteRecursively((File)this.getFile());
        } else {
            this.getFile().delete();
        }
    }

    public void commit(String msg) throws VCSException {
        this.add(msg);
    }

    public void update() throws VCSException {
        this.prepare();
        VersionStorage.getVCS().update(this.getFile(), true);
    }

    public boolean isUpToDate() throws VCSException {
        this.prepare();
        return VersionStorage.getVCS().isUpToDate(this.getFile());
    }

    public static void checkout(File destDir, String module) throws VCSException {
        Version tag = IsisConfig.getApiVersion();
        if (!VersionStorage.getVCS().isTag(tag)) {
            tag = null;
        }
        File file = new File(destDir, module);
        VersionStorage.getVCS().update(file, true);
    }

    public static List<String> getStorageNames(File directory) {
        ArrayList<String> result = new ArrayList<String>();
        if (directory.exists()) {
            for (File f : directory.listFiles()) {
                if (!VersionStorage.getVCS().isVersionnableFile(f)) continue;
                result.add(f.getName());
            }
        }
        Collections.sort(result);
        return result;
    }

    public static List<String> getRemoteStorageNames(File directory) {
        List<String> result = null;
        try {
            result = VersionStorage.getVCS().getFileList(directory);
        }
        catch (VCSException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Error during connection to VCS server", (Throwable)e);
            }
            result = new ArrayList<String>();
        }
        Collections.sort(result);
        return result;
    }

    protected static void fireDataChanged(StorageChangeEvent event) {
        block2: {
            try {
                changeListeners.fire("versionDataChanged", (Object)event);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't fire data change event", (Throwable)e);
            }
        }
    }

    public static void addStorageChangeListener(StorageChangeListener listener) {
        changeListeners.add((Object)listener);
    }

    public static void removeStorageChangeListener(StorageChangeListener listener) {
        changeListeners.remove((Object)listener);
    }
}

