/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.util.Docable;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SensitivityExportStorage
extends ExportStorage
implements Docable {
    private static Log log = LogFactory.getLog(SensitivityExportStorage.class);
    public static final String SENSITIVITY_EXPORT_PATH = "sensitivityexports";
    public static final String SENSITIVITY_EXPORT_TEMPLATE = "templates/script/sensitivityexport.ftl";
    private static Map<String, SensitivityExportStorage> sensitivityExportsCache = new ReferenceMap();

    protected SensitivityExportStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name);
    }

    public static File getSensitivityExportDirectory() {
        File result = new File(SensitivityExportStorage.getContextDatabaseDirectory(), SENSITIVITY_EXPORT_PATH);
        result.mkdirs();
        return result;
    }

    public SensitivityExport getNewSensitivityExportInstance() throws IsisFishException {
        Object result = this.getNewInstance();
        return (SensitivityExport)result;
    }

    public static SensitivityExportStorage getSensitivityExport(String name) {
        String cacheName = SensitivityExportStorage.getContextDatabaseCacheKey(name);
        SensitivityExportStorage result = sensitivityExportsCache.get(cacheName);
        if (result == null) {
            result = new SensitivityExportStorage(SensitivityExportStorage.getContextDatabaseDirectory(), SensitivityExportStorage.getSensitivityExportDirectory(), name);
            sensitivityExportsCache.put(cacheName, result);
        }
        return result;
    }

    public static List<String> getSensitivityExportNames() {
        File dir = SensitivityExportStorage.getSensitivityExportDirectory();
        return SensitivityExportStorage.getStorageNames(dir);
    }

    public static void checkout() throws VCSException {
        SensitivityExportStorage.checkout(IsisFish.config.getDatabaseDirectory(), SENSITIVITY_EXPORT_PATH);
    }
}

