/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.util.Doc;
import fr.ifremer.isisfish.util.DocHelper;
import fr.ifremer.isisfish.util.Docable;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class RuleStorage
extends JavaSourceStorage
implements Docable {
    private static Log log = LogFactory.getLog(RuleStorage.class);
    public static final String RULE_PATH = "rules";
    public static final String RULE_TEMPLATE = "templates/script/rule.ftl";
    private static Map<String, RuleStorage> rulesCache = new ReferenceMap();

    protected RuleStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name);
    }

    public static File getRuleDirectory() {
        File result = new File(RuleStorage.getContextDatabaseDirectory(), RULE_PATH);
        result.mkdirs();
        return result;
    }

    public static List<String> getRuleNames() {
        File dir = RuleStorage.getRuleDirectory();
        return RuleStorage.getStorageNames(dir);
    }

    public static RuleStorage getRule(String name) {
        String cacheName = RuleStorage.getContextDatabaseCacheKey(name);
        RuleStorage result = rulesCache.get(cacheName);
        if (result == null) {
            result = new RuleStorage(RuleStorage.getContextDatabaseDirectory(), RuleStorage.getRuleDirectory(), name);
            rulesCache.put(cacheName, result);
        }
        return result;
    }

    public Rule getNewRuleInstance() throws IsisFishException {
        Object result = this.getNewInstance();
        return (Rule)result;
    }

    public Map<String, Class<?>> getParameterNames() throws IsisFishException {
        Map<String, Class<?>> result = null;
        try {
            if (0 == this.compile(false, null)) {
                Rule rule = this.getNewRuleInstance();
                result = RuleStorage.getParameterNames(rule);
            }
        }
        catch (Exception eee) {
            log.info((Object)I18n._((String)"isisfish.error.compiled.parameter"), (Throwable)eee);
        }
        if (result == null) {
            try {
                log.fatal((Object)"FIXME a faire recherche des parametre dans le source");
                throw new IsisFishException(I18n._((String)"isisfish.error.source.parameter"));
            }
            catch (Exception eee) {
                throw new IsisFishException(I18n._((String)"isisfish.error.source.parameter"), eee);
            }
        }
        return result;
    }

    public static Map<String, Class<?>> getParameterNames(Rule rule) {
        LinkedHashMap result = new LinkedHashMap();
        for (Field field : rule.getClass().getFields()) {
            if (!field.getName().startsWith("param_")) continue;
            result.put(field.getName().substring("param_".length()), field.getType());
        }
        return result;
    }

    public static Object getParameterValue(Rule rule, String name) throws IsisFishException {
        if (rule == null || name == null || "".equals(name)) {
            return null;
        }
        try {
            String fieldName = "param_" + name;
            Field field = rule.getClass().getDeclaredField(fieldName);
            return field.get(rule);
        }
        catch (IllegalAccessException eee) {
            throw new IsisFishException("Can't get rule parameter: " + name, eee);
        }
        catch (NoSuchFieldException eee) {
            throw new IsisFishException("Can't get rule parameter: " + name, eee);
        }
    }

    public static void setParameterValue(Rule rule, String name, Object value) throws IsisFishException {
        try {
            String fieldName = "param_" + name;
            Field field = rule.getClass().getDeclaredField(fieldName);
            field.set(rule, value);
        }
        catch (IllegalAccessException eee) {
            throw new IsisFishException("Can't modify rule parameter: " + name + " with '" + value + "'(" + ObjectUtils.identityToString((Object)value) + ")", eee);
        }
        catch (NoSuchFieldException eee) {
            throw new IsisFishException("Can't modify rule parameter: " + name + " with '" + value + "'(" + ObjectUtils.identityToString((Object)value) + ")", eee);
        }
        catch (IllegalArgumentException eee) {
            throw new IsisFishException("Can't modify rule parameter: " + name + " with '" + value + "'(" + ObjectUtils.identityToString((Object)value) + ")", eee);
        }
    }

    public static String getParamAsString(Rule rule) throws IsisFishException {
        StringBuffer result = new StringBuffer();
        for (String name : RuleStorage.getParameterNames(rule).keySet()) {
            Object value = RuleStorage.getParameterValue(rule, name);
            result.append(name).append(" : ").append(value);
            result.append("\n");
        }
        return result.toString();
    }

    public static void checkout() throws VCSException {
        RuleStorage.checkout(IsisFish.config.getDatabaseDirectory(), RULE_PATH);
    }

    public static List<String> getNewRuleNames() {
        List<String> result = RuleStorage.getRuleNames();
        result.removeAll(RuleStorage.getRemoteRuleNames());
        return result;
    }

    public static List<String> getRemoteRuleNames() {
        File dir = RuleStorage.getRuleDirectory();
        return RuleStorage.getRemoteStorageNames(dir);
    }

    public static List<String> getNewRemoteRuleNames() {
        List<String> result = RuleStorage.getRemoteRuleNames();
        result.removeAll(RuleStorage.getRuleNames());
        return result;
    }

    @Override
    public Doc getClassDoc() {
        Doc result = null;
        try {
            Class<?> klazz = this.getCodeClass();
            result = DocHelper.getClassDoc(klazz);
        }
        catch (IsisFishException e) {
            log.warn((Object)I18n._((String)"isisfish.error.not.found.code", (Object[])new Object[]{this}));
        }
        return result;
    }

    @Override
    public Doc getFieldDoc(String fieldName) {
        Doc result = null;
        try {
            Class<?> klazz = this.getCodeClass();
            result = DocHelper.getFieldDoc(klazz, fieldName);
        }
        catch (Exception e) {
            log.warn((Object)I18n._((String)"isisfish.error.not.found.field", (Object[])new Object[]{fieldName, this}));
        }
        return result;
    }

    public Doc getParamDoc(String paramName) {
        Doc doc = this.getFieldDoc("param_" + paramName);
        return doc;
    }

    @Override
    public String getDescription() {
        String result = null;
        try {
            Rule rule = this.getNewRuleInstance();
            result = rule == null ? null : rule.getDescription();
        }
        catch (Exception e) {
            log.warn((Object)I18n._((String)"isisfish.error.not.found.description", (Object[])new Object[]{this}));
        }
        return result;
    }
}

