/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.util.CompileHelper;
import fr.ifremer.isisfish.util.Doc;
import fr.ifremer.isisfish.util.DocHelper;
import fr.ifremer.isisfish.util.JavadocHelper;
import java.io.File;
import java.io.PrintWriter;
import org.apache.commons.lang.ClassUtils;
import org.nuiton.i18n.I18n;

public abstract class JavaSourceStorage
extends CodeSourceStorage {
    protected static final String PARAM_PREFIX = "param_";

    protected JavaSourceStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name, ".java");
    }

    public String getFQN() {
        String root = this.getRoot().getAbsolutePath();
        String path = this.getFile().getParentFile().getAbsolutePath();
        String packageName = path.substring(1 + root.length()).replace(File.separatorChar, '.');
        String result = packageName + "." + this.getName();
        if (result.endsWith(".java")) {
            result = result.substring(0, result.length() - ".java".length());
        }
        return result;
    }

    public static String getName(Object instance) {
        return ClassUtils.getShortClassName((Object)instance, null);
    }

    public int compile(boolean force, PrintWriter out) {
        return CompileHelper.compile(this, IsisFish.config.getCompileDirectory(), force, out);
    }

    public int doJavadoc(boolean force, PrintWriter out) {
        int result = JavadocHelper.generateJavadoc(this, IsisFish.config.getJavadocDirectory(), force, out);
        return result;
    }

    public Class<?> getCodeClass() throws IsisFishException {
        String fqn = this.getFQN();
        this.compile(false, null);
        Class result = CompileHelper.loadClass(fqn);
        if (result == null) {
            throw new IsisFishException(I18n._((String)"isisfish.error.load.class", (Object[])new Object[]{fqn}));
        }
        return result;
    }

    public Object getNewInstance() throws IsisFishException {
        Object result;
        Class<?> clazz = this.getCodeClass();
        try {
            result = clazz.newInstance();
        }
        catch (InstantiationException eee) {
            throw new IsisFishException("Can't instanciate class: " + clazz.getName(), eee);
        }
        catch (IllegalAccessException eee) {
            throw new IsisFishException("Can't instanciate class: " + clazz.getName(), eee);
        }
        return result;
    }

    public static Doc getParameterDoc(Object object, String paramName) {
        Doc result = DocHelper.getFieldDoc(object.getClass(), PARAM_PREFIX + paramName);
        return result;
    }
}

