/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.aspect;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.simulator.SimulationContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.aspectwerkz.annotation.After;
import org.codehaus.aspectwerkz.annotation.AfterThrowing;
import org.codehaus.aspectwerkz.annotation.Aspect;
import org.codehaus.aspectwerkz.annotation.Before;
import org.codehaus.aspectwerkz.annotation.Expression;
import org.codehaus.aspectwerkz.definition.Pointcut;
import org.codehaus.aspectwerkz.joinpoint.JoinPoint;
import org.codehaus.aspectwerkz.joinpoint.MethodSignature;

@Aspect(value="perJVM")
public class Trace {
    private static Log log = LogFactory.getLog(Trace.class);
    private static List<Trace> instances = new ArrayList<Trace>();
    @Expression(value="execution(* scripts..*(..)) || execution(* simulators..*(..)) || execution(* rules..*(..))  || execution(* analyseplans..*(..))  || execution(* formules..*(..))")
    Pointcut executeMethod;

    public Trace() {
        instances.add(this);
    }

    protected fr.ifremer.isisfish.util.Trace getTrace() {
        SimulationContext context = SimulationContext.get();
        fr.ifremer.isisfish.util.Trace result = (fr.ifremer.isisfish.util.Trace)context.getValue(fr.ifremer.isisfish.util.Trace.class.getName());
        if (result == null) {
            throw new IsisFishRuntimeException("No trace object found in context");
        }
        return result;
    }

    @Before(value="executeMethod")
    public void traceBeforeExecute(JoinPoint jp) {
        this.getTrace().traceBefore();
    }

    @AfterThrowing(type="Exception", pointcut="executeMethod")
    public void traceAfterThrowingExecute(JoinPoint jp) {
        this.traceAfterExecute(jp);
    }

    @After(value="executeMethod")
    public void traceAfterExecute(JoinPoint jp) {
        Method method = ((MethodSignature)jp.getSignature()).getMethod();
        this.getTrace().traceAfterCall(method);
    }

    public static String printStatistiqueAndClear() {
        StringBuffer result = new StringBuffer();
        for (Trace trace : instances) {
            result.append(trace.getTrace().printStatisticAndClear());
        }
        instances.clear();
        return result.toString();
    }
}

