/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.actions;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.KeyPair;
import fr.ifremer.isisfish.IsisConfig;
import java.io.File;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VCSAction {
    private static Log log = LogFactory.getLog(VCSAction.class);
    protected IsisConfig config = null;

    public VCSAction(IsisConfig config) {
        this.config = config;
    }

    public void sshCreateKey(boolean force) throws Exception {
        File f = this.config.getSSHPrivateKeyFilePath();
        if (f.exists() && !force) {
            log.error((Object)("the private key already exist " + f + ", use option [force] to overwrite"));
            return;
        }
        if (f.getParentFile() != null && !f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Generate ssh key to " + f));
        }
        JSch jsch = new JSch();
        KeyPair kpair = KeyPair.genKeyPair((JSch)jsch, (int)2, (int)2048);
        kpair.writePrivateKey(f.getAbsolutePath());
        kpair.writePublicKey(f.getAbsolutePath() + ".pub", this.config.getUserName() + "@forIsisFish");
        if (log.isInfoEnabled()) {
            log.info((Object)("Finger print: " + kpair.getFingerPrint()));
        }
        kpair.dispose();
    }

    public void vcsUpdate() throws Exception {
    }

    public void vcsAdd(File ... file) throws Exception {
        log.info((Object)("file*:" + Arrays.toString(file)));
        throw new UnsupportedOperationException("to be done...");
    }

    public void vcsRemove(File ... file) throws Exception {
        log.info((Object)("file*:" + Arrays.toString(file)));
        throw new UnsupportedOperationException("to be done...");
    }

    public void vcsCommit(File ... file) throws Exception {
        log.info((Object)("file*:" + Arrays.toString(file)));
        throw new UnsupportedOperationException("to be done...");
    }
}

