/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish;

import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.IsisTray;
import fr.ifremer.isisfish.cron.CronService;
import fr.ifremer.isisfish.datastore.AnalysePlanStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.FormuleStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.datastore.ScriptStorage;
import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.datastore.SensitivityStorage;
import fr.ifremer.isisfish.datastore.SimulatorStorage;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.types.Date;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.RangeOfValues;
import fr.ifremer.isisfish.types.TimeUnit;
import fr.ifremer.isisfish.ui.WelcomeUI;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import fr.ifremer.isisfish.util.DateConverter;
import fr.ifremer.isisfish.util.MonthConverter;
import fr.ifremer.isisfish.util.RangeOfValuesConverter;
import fr.ifremer.isisfish.util.StringConverter;
import fr.ifremer.isisfish.util.TimeUnitConverter;
import fr.ifremer.isisfish.vcs.VCS;
import fr.ifremer.isisfish.vcs.VCSActionEvent;
import fr.ifremer.isisfish.vcs.VCSException;
import fr.ifremer.isisfish.vcs.VCSFactory;
import fr.ifremer.isisfish.vcs.VetoableActionListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.DoubleBigVector;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.util.FileUtil;
import org.nuiton.util.LocaleConverter;
import org.nuiton.util.Version;
import org.nuiton.widget.SwingUtil;

public class IsisFish {
    private static Log log = LogFactory.getLog(IsisFish.class);
    public static IsisConfig config = null;
    public static VCS vcs = null;

    public static void quit() {
        System.exit(0);
    }

    public static void main(String ... args) {
        try {
            System.setSecurityManager(null);
            IsisFish.init(args);
            if (log.isDebugEnabled()) {
                log.debug((Object)I18n._((String)"isisfish.launch.init.done", (Object[])new Object[]{config.getElapsedTimeAsString()}));
            }
            config.doAction(0);
            IsisFish.initLookAndFeel();
            try {
                IsisFish.initVCS();
            }
            catch (Exception eee) {
                log.warn((Object)I18n._((String)"Error during vcs initialisation"), (Throwable)eee);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)I18n._((String)"isisfish.launching", (Object[])new Object[]{config.getElapsedTimeAsString()}));
            }
            config.doAction(1);
            IsisFish.doNuitonMigration();
            IsisFish.launchUI();
            config.doAction(2);
            IsisFish.startCronService();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Global IsisFish exception", (Throwable)e);
            }
            IsisFish.quit();
        }
        catch (LinkageError e) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)"Linkage error detected", (Throwable)e);
            }
            FileUtil.deleteRecursively((File)config.getCompileDirectory());
            JOptionPane.showMessageDialog(null, I18n._((String)"isisfish.error.linkageerror.message"), I18n._((String)"isisfish.error.linkageerror.title"), 0);
            IsisFish.quit();
        }
    }

    protected static void startCronService() {
        if (config.isPerformCron()) {
            CronService cronService = new CronService();
            cronService.start();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void doNuitonMigration() {
        if (config.isPerformMigration()) {
            File[] folders = new File[]{AnalysePlanStorage.getAnalysePlanDirectory(), ExportStorage.getExportDirectory(), FormuleStorage.getFormuleDirectory(), RuleStorage.getRuleDirectory(), ScriptStorage.getScriptDirectory(), SensitivityStorage.getSensitivityDirectory(), SensitivityExportStorage.getSensitivityExportDirectory(), SimulatorStorage.getSimulatorDirectory()};
            try {
                HashMap filesToMigrate = new HashMap();
                for (File folder : folders) {
                    filesToMigrate.putAll(FileUtil.grep((String)"org\\.codelutin\\.", (File)folder, (String)".*\\.java", (String)"ISO-8859-1"));
                }
                if (filesToMigrate == null || filesToMigrate.isEmpty()) return;
                boolean migrationOption = true;
                if (config.isLaunchUI()) {
                    String migratedFiles = "";
                    String separator = "";
                    for (File fileToMigrate : filesToMigrate.keySet()) {
                        migratedFiles = migratedFiles + separator + fileToMigrate.toString();
                        separator = "\n";
                    }
                    JLabel labelModifiedFiles = new JLabel(I18n._((String)"isisfish.misc.nuitonmigration"));
                    JTextArea areaModifiedFiles = new JTextArea(migratedFiles);
                    areaModifiedFiles.setEditable(false);
                    areaModifiedFiles.setAutoscrolls(true);
                    JScrollPane sp = new JScrollPane(areaModifiedFiles);
                    sp.setPreferredSize(new Dimension(500, 100));
                    migrationOption = IsisFish.ask(new Component[]{labelModifiedFiles, sp});
                }
                if (!migrationOption) return;
                if (log.isInfoEnabled()) {
                    log.info((Object)"Starting nuiton.org migration for user scripts :");
                }
                for (File fileToMigrate : filesToMigrate.keySet()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)(" migrate file : " + fileToMigrate.getAbsolutePath()));
                    }
                    FileUtil.sed((String)"org\\.codelutin\\.", (String)"org.nuiton.", (File)fileToMigrate, (String)"ISO-8859-1");
                }
                return;
            }
            catch (IOException eee) {
                if (!log.isErrorEnabled()) return;
                log.error((Object)"Can't to nuiton migration", (Throwable)eee);
                return;
            }
        } else {
            if (!log.isInfoEnabled()) return;
            log.info((Object)I18n._((String)"Skip data migration (disabled)"));
        }
    }

    private static void initLookAndFeel() throws InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
            if (!"Nimbus".equals(laf.getName())) continue;
            try {
                UIManager.setLookAndFeel(laf.getClassName());
            }
            catch (ClassNotFoundException e) {
                log.warn((Object)"Can't install nimbus");
            }
        }
    }

    public static void init(String ... args) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Starting Isis-Fish with args : " + Arrays.toString(args)));
            log.info((Object)("Date: " + SimpleDateFormat.getInstance().format(new java.util.Date())));
            log.info((Object)("Java version: " + System.getProperty("java.runtime.version")));
            log.info((Object)("Java VM: " + System.getProperty("java.vm.name")));
            log.info((Object)("System arch: " + System.getProperty("os.arch")));
            log.info((Object)("R_HOME: " + System.getenv("R_HOME")));
            log.info((Object)("R.type: " + System.getProperty("R.type")));
            log.info((Object)("PATH: " + System.getenv("PATH")));
        }
        IsisFish.initConvertersAndMatrixFactory();
        Runtime.getRuntime().addShutdownHook(new IsisQuitHook());
        config = new IsisConfig();
        config.parse(args);
        I18n.init((Locale)config.getLocale());
    }

    protected static boolean ask(Object msg) {
        boolean result = true;
        int value = JOptionPane.showConfirmDialog(null, msg);
        if (value == 2) {
            IsisFish.quit();
        }
        result = value == 0;
        return result;
    }

    protected static void switchToNoneVCS() {
        log.info((Object)I18n._((String)"Switch repository type to none"));
        config.setOption(IsisConfig.Option.VCS_TYPE.key, "none");
        config.saveForUser(new String[0]);
        vcs = VCSFactory.createVCS(config);
    }

    public static void initVCS() throws VCSException {
        if (config.isLaunchUI() && config.isPerformVcsUpdate()) {
            vcs = VCSFactory.createVCS(config);
            VCSActionAsker asker = new VCSActionAsker();
            vcs.addVetoableActionListener(asker);
            File local = config.getDatabaseDirectory();
            if (log.isInfoEnabled()) {
                log.info((Object)I18n._((String)"Check state of local repository: %s", (Object[])new Object[]{local}));
            }
            if (local.exists() && !vcs.isValidLocalRepository()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n._((String)"Local repository exists but it's not valide for current vcs: %s", (Object[])new Object[]{config.getOption("vcs.type")}));
                }
                if (IsisFish.ask(I18n._((String)"isisfish.vcs.init.wrongprotocol", (Object[])new Object[]{local}))) {
                    File localBackup = new File(local.getParentFile(), local.getName() + "-" + new SimpleDateFormat("yyyy-mm-dd-HH-mm-ss").format(new java.util.Date()));
                    if (log.isInfoEnabled()) {
                        log.info((Object)I18n._((String)"Rename data directory to %s", (Object[])new Object[]{localBackup}));
                    }
                    if (!local.renameTo(localBackup)) {
                        throw new IsisFishRuntimeException("Can't rename local repository that don't use svn");
                    }
                } else {
                    IsisFish.switchToNoneVCS();
                }
            }
            if (!local.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n._((String)"Local repository don't exist"));
                }
                if (!vcs.isConnected()) {
                    ErrorHelper.showErrorDialog(I18n._((String)"isisfish.vcs.init.notfoundcantdownload", (Object[])new Object[]{IsisConfig.getApiVersion()}), null);
                } else {
                    Version tag = IsisConfig.getApiVersion();
                    if (!vcs.isTag(tag)) {
                        tag = null;
                    }
                    vcs.checkout(tag, false);
                    AnalysePlanStorage.checkout();
                    ExportStorage.checkout();
                    FormuleStorage.checkout();
                    RuleStorage.checkout();
                    ScriptStorage.checkout();
                    SimulatorStorage.checkout();
                    SensitivityStorage.checkout();
                    SensitivityExportStorage.checkout();
                    vcs.update(new File(local, "simulations"), false);
                    vcs.update(new File(local, "regions"), false);
                    try {
                        RegionStorage.checkout("DemoRegion");
                    }
                    catch (TopiaException eee) {
                        log.warn((Object)"Can't checkout DemoRegion", (Throwable)eee);
                    }
                }
            }
            if (!local.exists()) {
                throw new IsisFishRuntimeException("Can't find local repository");
            }
            if (vcs.isConnected()) {
                vcs.cleanup(null);
                vcs.checkProtocol();
                List<File> filesInClonflict = null;
                if (vcs.getTag().startsWith("branches")) {
                    log.info((Object)I18n._((String)"Use branches, switch not needed"));
                } else {
                    Version tag = IsisConfig.getApiVersion();
                    filesInClonflict = vcs.isTag(tag) ? vcs.setTag(tag) : vcs.setTag(null);
                    if (filesInClonflict != null && !filesInClonflict.isEmpty()) {
                        IsisFish.warnFileListDialog(I18n._((String)"isisfish.error.warning.title"), I18n._((String)"isisfish.vcs.switchtag.warningconflict"), filesInClonflict);
                    }
                }
                filesInClonflict = vcs.checkFileStatus();
                if (filesInClonflict != null && !filesInClonflict.isEmpty()) {
                    IsisFish.warnFileListDialog(I18n._((String)"isisfish.error.warning.title"), I18n._((String)"isisfish.vcs.update.warningconflict"), filesInClonflict);
                }
            }
            vcs.remoteVetoableActionListener(asker);
        } else {
            config.setOption("vcs.type", "none");
            vcs = VCSFactory.createVCS(config);
        }
    }

    protected static void warnFileListDialog(String dialogTitle, String labelTitle, List<File> conflictFiles) {
        String conflictFilesString = "";
        String separator = "";
        for (File file : conflictFiles) {
            conflictFilesString = conflictFilesString + separator + file.toString();
            separator = "\n";
        }
        JLabel labelModifiedFiles = new JLabel(labelTitle);
        JTextArea areaModifiedFiles = new JTextArea(conflictFilesString);
        areaModifiedFiles.setEditable(false);
        areaModifiedFiles.setAutoscrolls(true);
        JScrollPane sp = new JScrollPane(areaModifiedFiles);
        sp.setPreferredSize(new Dimension(500, 100));
        JOptionPane.showMessageDialog(null, new Component[]{labelModifiedFiles, sp}, dialogTitle, 2);
    }

    public static void launchUI() {
        if (config.isLaunchUI()) {
            WelcomeUI welcome;
            block5: {
                SimulationService.getService();
                IsisTray.getInstance();
                welcome = new WelcomeUI();
                welcome.setDefaultCloseOperation(0);
                welcome.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        ((WelcomeUI)e.getSource()).close();
                    }
                });
                try {
                    InputStream imageStream = WelcomeUI.class.getResourceAsStream("/images/simulation.gif");
                    BufferedImage image = ImageIO.read(imageStream);
                    welcome.setIconImage(image);
                }
                catch (IOException ex) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)"Can't set frame icon", (Throwable)ex);
                }
            }
            SwingUtil.center((Component)welcome);
            welcome.setVisible(true);
        } else if (log.isInfoEnabled()) {
            log.info((Object)I18n._((String)"isisfish.message.launchui.notlaunch"));
        }
    }

    protected static void initConvertersAndMatrixFactory() {
        ConvertUtils.register((Converter)new LocaleConverter(), Locale.class);
        ConvertUtils.register((Converter)new DateConverter(), Date.class);
        ConvertUtils.register((Converter)new MonthConverter(), Month.class);
        ConvertUtils.register((Converter)new TimeUnitConverter(), TimeUnit.class);
        ConvertUtils.register((Converter)new RangeOfValuesConverter(), RangeOfValues.class);
        ConvertUtils.register((Converter)new StringConverter(), String.class);
        MatrixFactory.setDefaultVectorClass(DoubleBigVector.class);
    }

    static class VCSActionAsker
    implements VetoableActionListener {
        VCSActionAsker() {
        }

        @Override
        public boolean canDoAction(VCS vcs, VCSActionEvent action, File ... files) {
            boolean result = true;
            if (action == VCSActionEvent.SWITCH_PROTOCOL) {
                result = IsisFish.ask(I18n._((String)"isisfish.vcs.switchprotocol.confirm"));
                if (!result) {
                    vcs.setWriteable(false);
                }
            } else if (action == VCSActionEvent.SWITCH) {
                result = IsisFish.ask(I18n._((String)"isisfish.vcs.switchversion.confirm", (Object[])new Object[]{IsisConfig.getVersion()}));
                if (!result) {
                    vcs.setWriteable(false);
                }
            } else if (action == VCSActionEvent.UPDATE_REPOSITORY) {
                String modifiedFiles = "";
                String separator = "";
                for (File file : files) {
                    modifiedFiles = modifiedFiles + separator + file.toString();
                    separator = "\n";
                }
                JLabel labelModifiedFiles = new JLabel(I18n._((String)"isisfish.vcs.updaterepository.confirm"));
                JTextArea areaModifiedFiles = new JTextArea(modifiedFiles);
                areaModifiedFiles.setEditable(false);
                areaModifiedFiles.setAutoscrolls(true);
                JScrollPane sp = new JScrollPane(areaModifiedFiles);
                sp.setPreferredSize(new Dimension(500, 100));
                result = IsisFish.ask(new Component[]{labelModifiedFiles, sp});
            }
            return result;
        }
    }

    public static class IsisQuitHook
    extends Thread {
        @Override
        public void run() {
            try {
                config.doAction(3);
            }
            catch (Exception eee) {
                log.info((Object)"Error in quit daemon", (Throwable)eee);
            }
        }
    }
}

