/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.actions.ExportAction;
import fr.ifremer.isisfish.actions.ImportAction;
import fr.ifremer.isisfish.actions.OtherAction;
import fr.ifremer.isisfish.actions.SimulationAction;
import fr.ifremer.isisfish.actions.VCSAction;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.launcher.InProcessSimulatorLauncher;
import fr.ifremer.isisfish.simulator.launcher.SSHSimulatorLauncher;
import fr.ifremer.isisfish.simulator.launcher.SubProcessSimulationLauncher;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.util.StringUtil;
import org.nuiton.util.Version;

public class IsisConfig
extends ApplicationConfig {
    private static Log log = LogFactory.getLog(IsisConfig.class);
    public static final int STEP_AFTER_INIT = 0;
    public static final int STEP_AFTER_INIT_VCS = 1;
    public static final int STEP_AFTER_UI = 2;
    public static final int STEP_BEFORE_EXIT = 3;
    protected static final Version version = new Version(new int[]{3, 3, 0, 6});
    protected static final Version databaseVersion = new Version(new int[]{version.getNumber(0), version.getNumber(1)});
    protected static final Version apiVersion = new Version(new int[]{version.getNumber(0), version.getNumber(1), version.getNumber(2)});
    public static final String COPYRIGHT_TEXT = "Version " + IsisConfig.getVersion() + " IFREMER-MAERHA \u00a9 2000-2010";
    public static final String CONFIG_FILENAME = "isis-config-" + version.getNumber(0);
    public static final String SEP = ",";
    public static final String REPORT_EMAIL = "isis-fish-bugreport@lists.labs.libre-entreprise.org";
    protected transient File backupSessionDirectory = null;
    protected long startingTime = System.currentTimeMillis();

    public static Version getVersionNumber() {
        return version;
    }

    public static String getVersion() {
        String result = version.toString();
        return result;
    }

    public static Version getDatabaseVersion() {
        return databaseVersion;
    }

    public static Version getApiVersion() {
        return apiVersion;
    }

    public IsisConfig() {
        for (Option option : Option.values()) {
            this.setDefaultOption(option.key, option.defaultValue);
        }
        for (Enum enum_ : Action.values()) {
            for (String alias : ((Action)enum_).aliases) {
                this.addActionAlias(alias, ((Action)enum_).action);
            }
        }
    }

    public File getDatabaseDirectory() {
        File result = this.getOptionAsFile(Option.DATABASE_DIRECTORY.key);
        return result;
    }

    public File getContextDatabaseDirectory() {
        SimulationContext simContext = SimulationContext.get();
        File scriptDirectory = simContext.getScriptDirectory();
        if (scriptDirectory == null) {
            scriptDirectory = this.getDatabaseDirectory();
        }
        return scriptDirectory;
    }

    public String getDatabaseLockMode() {
        String result = this.getOption(Option.DATABASE_LOCK_MODE.key);
        return result;
    }

    public File getCompileDirectory() {
        File result = this.getOptionAsFile(Option.COMPILATION_DIRECTORY.key);
        SimulationContext simContext = SimulationContext.get();
        SimulationControl control = simContext.getSimulationControl();
        if (control != null) {
            result = new File(result, control.getId());
        }
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public File getMonitoringDirectory() {
        File result = this.getOptionAsFile(Option.MONITORING_DIRECTORY.key);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public File getJavadocDirectory() {
        File result = this.getOptionAsFile(Option.JAVADOC_DIRECTORY.key);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public Locale getLocale() {
        String value = this.getOption(Option.LOCALE.key);
        Locale result = (Locale)ConvertUtils.convert((String)value, Locale.class);
        return result;
    }

    public void setLocale(String locale) {
        this.setOption(Option.LOCALE.key, locale);
    }

    public String getEncoding() {
        String result = this.getOption(Option.ENCODING.key);
        return result;
    }

    public String getSmtpServer() {
        String result = this.getOption(Option.SMTP_SERVER.key);
        return result;
    }

    public String getUserName() {
        String result = this.getOption(Option.USER_NAME.key);
        return result;
    }

    public String getUserMail() {
        String result = this.getOption(Option.USER_MAIL.key);
        return result;
    }

    public String getSimulatorClassfile() {
        String result = this.getOption(Option.SIMULATOR_CLASSFILE.key);
        return result;
    }

    public void setSimulatorClassfile(String value) {
        this.setOption(Option.SIMULATOR_CLASSFILE.key, value);
    }

    public String getSimulatorSshServer() {
        String result = this.getOption(Option.SIMULATOR_SSH_SERVER.key);
        return result;
    }

    public void setSimulatorSshServer(String sshServer) {
        this.setOption(Option.SIMULATOR_SSH_SERVER.key, sshServer);
    }

    public String getSimulatorSshUsername() {
        String result = this.getOption(Option.SIMULATOR_SSH_USER_NAME.key);
        return result;
    }

    public void setSimulatorSshUsername(String username) {
        this.setOption(Option.SIMULATOR_SSH_USER_NAME.key, username);
    }

    public String getSimulatorSshDataPath() {
        String result = this.getOption(Option.SIMULATOR_SSH_DATAPATH.key);
        return result;
    }

    public void setSimulatorSshDataPath(String datapath) {
        this.setOption(Option.SIMULATOR_SSH_DATAPATH.key, datapath);
    }

    public String getSimulatorSshUserHome() {
        String result = this.getOption(Option.SIMULATOR_SSH_USER_HOME.key);
        return result;
    }

    public void setSimulatorSshUserHome(String userhome) {
        this.setOption(Option.SIMULATOR_SSH_USER_HOME.key, userhome);
    }

    public String getSimulatorSshIsisHome() {
        String result = this.getOption(Option.SIMULATOR_SSH_ISIS_HOME.key);
        return result;
    }

    public void setSimulatorSshIsisHome(String isishome) {
        this.setOption(Option.SIMULATOR_SSH_ISIS_HOME.key, isishome);
    }

    public String getSimulatorSshTmpPath() {
        String result = this.getOption(Option.SIMULATOR_SSH_TMPPATH.key);
        return result;
    }

    public void setSimulatorSshTmpPath(String sshtemppath) {
        this.setOption(Option.SIMULATOR_SSH_TMPPATH.key, sshtemppath);
    }

    public String getSimulatorSshPbsBinPath() {
        String result = this.getOption(Option.SIMULATOR_SSH_PBSBINPATH.key);
        return result;
    }

    public void setSimulatorSshPbsBinPath(String path) {
        this.setOption(Option.SIMULATOR_SSH_PBSBINPATH.key, path);
    }

    public String getSimulatorSshPbsQsubOptions() {
        String result = this.getOption(Option.SIMULATOR_SSH_PBSQSUBOPTIONS.key);
        return result;
    }

    public void setSimulatorSshPbsQsubOptions(String options) {
        this.setOption(Option.SIMULATOR_SSH_PBSQSUBOPTIONS.key, options);
    }

    public String getSimulatorSshJavaPath() {
        String result = this.getOption(Option.SIMULATOR_SSH_JAVAPATH.key);
        return result;
    }

    public void setSimulatorSshJavaPath(String path) {
        this.setOption(Option.SIMULATOR_SSH_JAVAPATH.key, path);
    }

    public int getSimulatorSshControlCheckInterval() {
        int result = this.getOptionAsInt(Option.SIMULATOR_SSH_CONTROLCHECKINTERVAL.key);
        return result;
    }

    public void setSimulatorSshControlCheckInterval(int interval) {
        this.setOption(Option.SIMULATOR_SSH_CONTROLCHECKINTERVAL.key, String.valueOf(interval));
    }

    public int getSimulatorSshMaxThreads() {
        int result = this.getOptionAsInt(Option.SIMULATOR_SSH_MAXTHREADS.key);
        return result;
    }

    public void setSimulatorSshMaxThreads(int max) {
        this.setOption(Option.SIMULATOR_SSH_MAXTHREADS.key, String.valueOf(max));
    }

    public File getSSHPrivateKeyFilePath() {
        File result = this.getOptionAsFile(Option.SSH_KEY_FILE.key);
        return result;
    }

    public void setSSHPrivateKeyFilePath(File sshFile) {
        this.setOption(Option.SSH_KEY_FILE.key, sshFile.getAbsolutePath());
    }

    public boolean isLaunchUI() {
        boolean result = this.getOptionAsBoolean(Option.LAUNCH_UI.key);
        return result;
    }

    public boolean isPerformMigration() {
        boolean result = this.getOptionAsBoolean(Option.PERFORM_MIGRATION.key);
        return result;
    }

    public boolean isPerformVcsUpdate() {
        boolean result = this.getOptionAsBoolean(Option.PERFORM_VCS_UPDATE.key);
        return result;
    }

    public boolean isPerformCron() {
        boolean result = this.getOptionAsBoolean(Option.PERFORM_CRON.key);
        return result;
    }

    public void setSimulatorLauncher(String value) {
        this.setOption(Option.SIMULATOR_LAUNCHER.key, value);
    }

    public boolean isSimulationShowOnlyError() {
        Boolean result = this.getOptionAsBoolean(Option.SIMULATION_SHOW_ONLY_ERROR.key);
        return result;
    }

    public String getDefaultExportNames() {
        String result = this.getOption(Option.DEFAULT_EXPORT_NAMES.key);
        return result;
    }

    public void setDefaultExportNames(List<String> exportNames) {
        StringBuilder sb = new StringBuilder();
        for (String exportName : exportNames) {
            sb.append(SEP).append(exportName);
        }
        String value = sb.toString();
        if (value.length() > 0) {
            value = value.substring(1);
        }
        this.setOption(Option.DEFAULT_EXPORT_NAMES.key, value);
        this.saveForUser(new String[0]);
    }

    public List<String> getDefaultExportNamesAsList() {
        ArrayList<String> result = null;
        String exportNamesList = this.getDefaultExportNames();
        if (exportNamesList != null) {
            result = new ArrayList<String>();
            String[] exportNames = StringUtil.split((String)exportNamesList, (String)SEP);
            result.addAll(Arrays.asList(exportNames));
        }
        return result;
    }

    public String getDefaultMapFilename() {
        String result = this.getOption(Option.DEFAULT_MAP_FILENAME.key);
        return result;
    }

    public String getDefaultResultNames() {
        String result = this.getOption(Option.DEFAULT_RESULT_NAMES.key);
        return result;
    }

    public void setDefaultResultNames(List<String> resultNames) {
        StringBuilder sb = new StringBuilder();
        for (String resultName : resultNames) {
            sb.append(SEP).append(resultName);
        }
        String value = sb.toString();
        if (value.length() > 0) {
            value = value.substring(1);
        }
        this.setOption(Option.DEFAULT_RESULT_NAMES.key, value);
        this.saveForUser(new String[0]);
    }

    public List<String> getDefaultResultNamesAsList() {
        ArrayList<String> result = null;
        String resultNamesList = this.getDefaultResultNames();
        if (resultNamesList != null) {
            result = new ArrayList<String>();
            String[] resultNames = StringUtil.split((String)resultNamesList, (String)SEP);
            result.addAll(Arrays.asList(resultNames));
        }
        return result;
    }

    public String getDefaultTagValue() {
        String result = this.getOption(Option.DEFAULT_TAG_VALUE.key);
        return result;
    }

    public void setDefaultTagValues(Map<String, String> tagValues) {
        StringBuilder sb = new StringBuilder(" ");
        for (Map.Entry<String, String> entry : tagValues.entrySet()) {
            sb.append(SEP).append('\"').append(entry.getKey()).append("\":\"").append(entry.getValue()).append('\"');
        }
        String value = sb.toString().trim();
        this.setOption(Option.DEFAULT_TAG_VALUE.key, value.isEmpty() ? "" : value.substring(1));
        this.saveForUser(new String[0]);
    }

    public Map<String, String> getDefaultTagValueAsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        String tagValuesList = this.getDefaultTagValue();
        if (tagValuesList != null) {
            String[] tagValues;
            for (String tagValue : tagValues = StringUtil.split((String)tagValuesList, (String)SEP)) {
                String[] tagAndValue = StringUtil.split((String)tagValue, (String)":");
                String tag = tagAndValue[0].trim();
                tag = tag.substring(1, tag.length() - 1);
                String value = tagAndValue[1].trim();
                value = value.substring(1, value.length() - 1);
                result.put(tag, value);
            }
        }
        return result;
    }

    public String getJavadocURL() {
        String result = this.getOption(Option.JAVADOC_URL.key);
        return result;
    }

    public File getBackupDirectory() {
        File result = this.getOptionAsFile(Option.BACKUP_DIRECTORY.key);
        return result;
    }

    public long getStartingTime() {
        return this.startingTime;
    }

    public String getElapsedTimeAsString() {
        long diff = System.currentTimeMillis() - this.getStartingTime();
        String result = DurationFormatUtils.formatDuration((long)diff, (String)"s'.'S");
        return result;
    }

    public File getBackupSessionDirectory() {
        if (this.backupSessionDirectory == null) {
            long time = this.getStartingTime();
            String path = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date(time));
            this.backupSessionDirectory = new File(this.getBackupDirectory(), path);
            if (!this.backupSessionDirectory.exists()) {
                this.backupSessionDirectory.mkdirs();
            }
        }
        return this.backupSessionDirectory;
    }

    public ClassLoader getScriptClassLoader() {
        SimulationContext simContext = SimulationContext.get();
        ClassLoader result = simContext.getClassLoader();
        if (result == null) {
            File f = this.getCompileDirectory();
            try {
                URL[] cp = new URL[]{f.toURI().toURL()};
                ClassLoader parent = Thread.currentThread().getContextClassLoader();
                result = new URLClassLoader(cp, parent);
            }
            catch (MalformedURLException eee) {
                throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.load.classloader", (Object[])new Object[]{f, eee.getMessage()}), eee);
            }
        }
        return result;
    }

    public void parse(String[] args) throws ArgumentsParserException {
        super.parse(args);
        boolean mustSave = false;
        String[] keys = new String[]{"compileDirectory", Option.COMPILATION_DIRECTORY.key, "defaultBackupDirectory", Option.BACKUP_DIRECTORY.key, "defaultExportNames", Option.DEFAULT_EXPORT_NAMES.key, "defaultMapFile", Option.DEFAULT_MAP_FILENAME.key, "defaultResultNames", Option.DEFAULT_RESULT_NAMES.key, "defaultSimulator", Option.SIMULATOR_CLASSFILE.key, "defaultTagValue", Option.DEFAULT_TAG_VALUE.key, "javadocURL", Option.JAVADOC_URL.key, "locale", Option.LOCALE.key, "simulationShowOnlyError", Option.SIMULATION_SHOW_ONLY_ERROR.key, "simulationShowOnlyQueue", null, "smtpServer", Option.SMTP_SERVER.key, "userMail", Option.USER_MAIL.key, "userName", Option.USER_NAME.key, "vcs.keyFile", Option.SSH_KEY_FILE.key, "vcs.keyFile", Option.SSH_KEY_FILE.key, "vcs.ssh.keyFile", Option.SSH_KEY_FILE.key, "vcs.localDatabasePath", Option.DATABASE_DIRECTORY.key, "localSimulator", null, "vcs.databaseVersion", null, "vcs.hostName", null, "vcs.noPassPhrase", null, "vcs.remoteDatabase", null, "vcs.remotePath", null, "vcs.type", null, "vcs.typeRepo", null, "vcs.useSshConnexion", null, "vcs.userName", null, "version", null, "projectName", null, "simulationReportMail", null};
        if (log.isInfoEnabled()) {
            log.info((Object)"Check configuration change");
        }
        int i = 0;
        while (i < keys.length) {
            String value;
            String newKey;
            String oldKey;
            if ((oldKey = keys[i++]).equals(newKey = keys[i++]) || (value = this.getOption(oldKey)) == null) continue;
            mustSave = true;
            this.homefile.remove(oldKey);
            if (newKey == null) continue;
            this.setOption(newKey, value);
        }
        if (mustSave) {
            this.saveForUser(new String[0]);
            if (log.isInfoEnabled()) {
                log.info((Object)"Config file migration done");
            }
        }
        if (log.isDebugEnabled()) {
            this.printConfig();
        }
    }

    public static enum Action {
        HELP(I18n._((String)"Show help"), OtherAction.class.getName() + "#help", "-h", "--help"),
        VERSION(I18n._((String)"Show version"), OtherAction.class.getName() + "#version", "-v", "--version"),
        IMPORT_ANALYSE_PLAN(I18n._((String)""), ImportAction.class.getName() + "#importAnalysePlan", "--importAnalysePlan"),
        IMPORT_EXPORT(I18n._((String)""), ImportAction.class.getName() + "#importExport", "--importExport"),
        IMPORT_RULE(I18n._((String)""), ImportAction.class.getName() + "#importRule", "--importRule"),
        IMPORT_SCRIPT(I18n._((String)"Import one java file script source"), ImportAction.class.getName() + "#importScript", "--importScript"),
        IMPORT_SIMULATOR(I18n._((String)""), ImportAction.class.getName() + "#importSimulator", "--importSimulator"),
        IMPORT_FORMULA(I18n._((String)""), ImportAction.class.getName() + "#importFormula", "--importFormula"),
        IMPORT_REGION(I18n._((String)""), ImportAction.class.getName() + "#importRegion", "--importRegion"),
        IMPORT_REGION_AND_RENAME(I18n._((String)""), ImportAction.class.getName() + "#importRegionAndRename", "--importRegionAndRename"),
        IMPORT_SIMULATION(I18n._((String)""), ImportAction.class.getName() + "#importSimulation", "--importSimulation"),
        IMPORT_SCRIPT_MODULE(I18n._((String)"Import zipped file containing all scripts directory structure"), ImportAction.class.getName() + "#importScriptModule", "--importScriptModule"),
        LIST_ANALYSE_PLAN(I18n._((String)""), ExportAction.class.getName() + "#listAnalysePlan", "--listAnalysePlan"),
        LIST_EXPORT(I18n._((String)""), ExportAction.class.getName() + "#listExport", "--listExport"),
        LIST_RULE(I18n._((String)""), ExportAction.class.getName() + "#listRule", "--listRule"),
        LIST_SCRIPT(I18n._((String)""), ExportAction.class.getName() + "#listScript", "--listScript"),
        LIST_SIMULATOR(I18n._((String)""), ExportAction.class.getName() + "#listSimulator", "--listSimulator"),
        LIST_FORMULA(I18n._((String)""), ExportAction.class.getName() + "#listFormula", "--listFormula"),
        LIST_REGION(I18n._((String)""), ExportAction.class.getName() + "#listRegion", "--listRegion"),
        LIST_SIMULATION(I18n._((String)""), ExportAction.class.getName() + "#listSimulation", "--listSimulation"),
        EXPORT_ANALYSE_PLAN(I18n._((String)""), ExportAction.class.getName() + "#exportAnalysePlan", "--exportAnalysePlan"),
        EXPORT_EXPORT(I18n._((String)""), ExportAction.class.getName() + "#exportExport", "--exportExport"),
        EXPORT_RULE(I18n._((String)""), ExportAction.class.getName() + "#exportRule", "--exportRule"),
        EXPORT_SCRIPT(I18n._((String)""), ExportAction.class.getName() + "#exportScript", "--exportScript"),
        EXPORT_SIMULATOR(I18n._((String)""), ExportAction.class.getName() + "#exportSimulator", "--exportSimulator"),
        EXPORT_FORMULA(I18n._((String)""), ExportAction.class.getName() + "#exportFormula", "--exportFormula"),
        EXPORT_REGION(I18n._((String)""), ExportAction.class.getName() + "#exportRegion", "--exportRegion"),
        EXPORT_SIMULATION(I18n._((String)""), ExportAction.class.getName() + "#exportSimulation", "--exportSimulation"),
        VCS_SSH_CREATE_KEY(I18n._((String)""), VCSAction.class.getName() + "#sshCreateKey", "--sshCreateKey"),
        VCS_UPDATE(I18n._((String)""), VCSAction.class.getName() + "#vcsUpdate", "--vcsUpdate"),
        VCS_ADD(I18n._((String)""), VCSAction.class.getName() + "#vcsAdd", "--vcsAdd"),
        VCS_REMOVE(I18n._((String)""), VCSAction.class.getName() + "#vcsRemove", "--vcsRemove"),
        VCS_COMMIT(I18n._((String)""), VCSAction.class.getName() + "#vcsCommit", "--vcsCommit"),
        SIMULATE_WITH_REGION(I18n._((String)""), SimulationAction.class.getName() + "#simulateWithRegion", "--simulateWithRegion"),
        SIMULATE_WITH_SIMULATION(I18n._((String)""), SimulationAction.class.getName() + "#simulateWithSimulation", "--simulateWithSimulation"),
        SIMULATE_WITH_SIMULATION_AND_SCRIPT(I18n._((String)""), SimulationAction.class.getName() + "#simulateWithSimulationAndScript", "--simulateWithSimulationAndScript"),
        SIMULATE_REMOTELLY(I18n._((String)""), SimulationAction.class.getName() + "#simulateRemotelly", "--simulateRemotelly"),
        SIMULATE_REMOTELLY_WITH_PRESCRIPT(I18n._((String)""), SimulationAction.class.getName() + "#simulateRemotellyWithPreScript", "--simulateRemotellyWithPreScript");

        public String description;
        public String action;
        public String[] aliases;

        private Action(String description, String action, String ... aliases) {
            this.description = description;
            this.action = action;
            this.aliases = aliases;
        }
    }

    public static enum Option implements ApplicationConfig.OptionDef
    {
        COMPILATION_DIRECTORY("compilation.directory", I18n._((String)"isisfish.config.main.compileDirectory.description"), ApplicationConfig.getUserHome() + File.separator + "isis-build"),
        MONITORING_DIRECTORY("monitoring.directory", I18n._((String)"isisfish.config.main.monitoringDirectory.description"), ApplicationConfig.getUserHome() + File.separator + "isis-monitoring"),
        JAVADOC_DIRECTORY("javadoc.directory", I18n._((String)"isisfish.config.main.javadocDirectory.description"), ApplicationConfig.getUserHome() + File.separator + "isis-docs"),
        CONFIG_FILE("config.file", I18n._((String)"isisfish.config.main.configFileName.description"), CONFIG_FILENAME),
        BACKUP_DIRECTORY("backup.directory", I18n._((String)"isisfish.config.main.defaultBackupDirectory.description"), ApplicationConfig.getUserHome() + File.separator + "isis-backup"),
        DEFAULT_EXPORT_NAMES("default.export.names", I18n._((String)"isisfish.config.main.defaultExportNames.description"), ""),
        DEFAULT_RESULT_NAMES("default.result.names", I18n._((String)"isisfish.config.main.defaultResultNames.description"), ""),
        DEFAULT_MAP_FILENAME("default.map.filename", I18n._((String)"isisfish.config.main.defaultMapFile.description"), "maps/vmap_area_thin.shp"),
        DEFAULT_TAG_VALUE("default.tagvalue", I18n._((String)"isisfish.config.main.defaultTagValue.description"), ""),
        ENCODING("encoding", I18n._((String)"isisfish.config.main.encoding.description"), "UTF-8"),
        JAVADOC_URL("javadoc.url", I18n._((String)"isisfish.config.main.javadocURL.description"), "http://isis-fish.labs.libre-entreprise.org/isis-fish/apidocs/"),
        SIMULATOR_CLASSFILE("simulator.classfile", I18n._((String)"isisfish.config.main.defaultSimulator.description"), "DefaultSimulator.java"),
        SIMULATOR_LAUNCHER("simulation.launcher.3", I18n._((String)"isisfish.config.main.localSimulator.description"), InProcessSimulatorLauncher.class.getName()),
        SIMULATOR_LAUNCHER2("simulation.launcher.1", I18n._((String)"isisfish.config.main.subSimulator.description"), SubProcessSimulationLauncher.class.getName()),
        SIMULATOR_LAUNCHER_REMOTE("simulation.launcher.2", I18n._((String)"isisfish.config.main.remoteCaparmor.description"), SSHSimulatorLauncher.class.getName()),
        SIMULATOR_SSH_SERVER("simulation.ssh.server", I18n._((String)"isisfish.config.main.simulation.ssh.server.description"), "caparmor"),
        SIMULATOR_SSH_USER_NAME("simulation.ssh.username", I18n._((String)"isisfish.config.main.simulation.ssh.username.description"), ""),
        SIMULATOR_SSH_USER_HOME("simulation.ssh.userhome", I18n._((String)"isisfish.config.main.simulation.ssh.userhome.description"), ""),
        SIMULATOR_SSH_DATAPATH("simulation.ssh.datapath", I18n._((String)"isisfish.config.main.simulation.ssh.datapath.description"), "isis-database-3"),
        SIMULATOR_SSH_ISIS_HOME("simulation.ssh.isis.home", I18n._((String)"isisfish.config.main.simulation.ssh.isis.home.description"), "/home3/caparmor/poussin/isis-fish-" + IsisConfig.getApiVersion()),
        SIMULATOR_SSH_TMPPATH("simulation.ssh.tmppath", I18n._((String)"isisfish.config.main.simulation.ssh.tmppath.description"), "isis-tmp"),
        SIMULATOR_SSH_JAVAPATH("simulation.ssh.javapath", I18n._((String)"isisfish.config.main.simulation.ssh.javapath.description"), "/home3/caparmor/poussin/jdk/bin/java"),
        SIMULATOR_SSH_PBSBINPATH("simulation.ssh.pbsbinpath", I18n._((String)"isisfish.config.main.simulation.ssh.pbsbinpath.description"), "/usr/pbs/bin"),
        SIMULATOR_SSH_PBSQSUBOPTIONS("simulation.ssh.pbsqsuboptions", I18n._((String)"isisfish.config.main.simulation.ssh.pbsqsuboptions.description"), "-m n"),
        SIMULATOR_SSH_CONTROLCHECKINTERVAL("simulation.ssh.control.check.interval", I18n._((String)"isisfish.config.main.simulation.ssh.control.check.interval.description"), "120"),
        SIMULATOR_SSH_MAXTHREADS("simulation.ssh.max.threads", I18n._((String)"isisfish.config.main.simulation.ssh.max.threads.description"), "1"),
        LOCALE("locale", I18n._((String)"isisfish.config.main.locale.description"), "fr_FR"),
        SIMULATION_SHOW_ONLY_ERROR("simulationShowOnlyError", I18n._((String)"isisfish.config.main.simulationShowOnlyError.description"), "false"),
        LAUNCH_UI("launch.ui", I18n._((String)"isisfish.config.main.launchUI.description"), "true"),
        PERFORM_MIGRATION("perform.migration", I18n._((String)"isisfish.config.main.performmigration.description"), "true"),
        PERFORM_VCS_UPDATE("perform.vcsupdate", I18n._((String)"isisfish.config.main.performvcsupdate.description"), "true"),
        PERFORM_CRON("perform.cron", I18n._((String)"isisfish.config.main.performcron.description"), "true"),
        DATABASE_DIRECTORY("database.directory", I18n._((String)"isisfish.config.vcs.localDatabasePath.description"), ApplicationConfig.getUserHome() + File.separator + "isis-database-3"),
        DATABASE_LOCK_MODE("database.lockmode", I18n._((String)"isisfish.config.database.lockmode.description"), "file"),
        SSH_KEY_FILE("ssh.key.file", I18n._((String)"isisfish.config.ssh.key.file.description"), ApplicationConfig.getUserHome() + File.separator + ".ssh" + File.separator + "isis_rsa"),
        VCS_TYPE("vcs.type", I18n._((String)"isisfish.config.vcs.type.description"), "svn"),
        VCS_PROTOCOL("vcs.protocol", I18n._((String)"isisfish.config.vcs.useSshConnexion.description"), "svn"),
        VCS_USER_NAME("vcs.username", I18n._((String)"isisfish.config.vcs.userName.description"), ""),
        VCS_USER_PASSWORD("vcs.password", I18n._((String)"isisfish.config.vcs.userPassword.description"), ""),
        VCS_HOST_NAME("vcs.hostName", I18n._((String)"isisfish.config.vcs.hostName.description"), "labs.libre-entreprise.org"),
        VCS_PATH("vcs.path", I18n._((String)"isisfish.config.vcs.remotePath.description"), "/svnroot/isis-fish-data/"),
        USER_NAME("user.name", I18n._((String)"isisfish.config.main.userName.description"), System.getProperty("user.name")),
        SMTP_SERVER("smtpServer", I18n._((String)"isisfish.config.main.smtpServer.description"), "smtp"),
        USER_MAIL("userMail", I18n._((String)"isisfish.config.main.userMail.description"), Option.USER_NAME.key + "@" + Option.VCS_HOST_NAME.key);

        public final String key;
        public final String description;
        public final String defaultValue;

        private Option(String key, String description, String defaultValue) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getDescription() {
            return this.description;
        }

        public String getKey() {
            return this.key;
        }

        public Class<?> getType() {
            return String.class;
        }

        public boolean isFinal() {
            return false;
        }

        public boolean isTransient() {
            return false;
        }
    }
}

