/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.ui.simulator.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.ui.WelcomePanelUI;
import fr.ifremer.isisfish.ui.models.export.ExportNameListModel;
import javax.swing.event.ListSelectionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExportUI extends jaxx.runtime.swing.Table implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(fr.ifremer.isisfish.ui.simulator.ExportUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TO28TQRAeO3GMExtCHiDxUhLc0JyBBolE4RGIiGUDikGKcMPat4k3Wt8uu3PJ0SAkWoRSUdAAPSU9QpRUtPwHhPgHzN5d/ECWyBW3p7n5vvm+mdlPvyBnDSzusijyTBig6HKvemtr60Frl7fxDrdtIzQqA8mTyUK2CVN+L24RLjZrDl5J4ZU11dUq4MEAerkGkxafS247nCPCfIJoW1tp9MLLkQ7NIVtPzCi2D39+Zw/8lx+zAJEmVeNkYeF/qL6D8RpkhY8wQ5X2WEWyYIdkGBHskM6Si61JZu191uXP4AXkazChmSEyhKWjW405YnykEfLlR6wl+WWES9vGE9uGdzmdVthtYTteKDwruqFkxODdjbQy+HhD6xg/gVAqVxtto6R8yAJ+BeG0Exl5dp80ewO/XHqhh5qXwmLD0SaMax2lLEc4O9SqlIRmXqN0By32GArl6u0QUQVXEWaHaibhtJ5xP4mS5un159lveKYJORNSGGG62R/9JoWSoafRmCCOvn/1bu/t5y/XDyc8RjVKQykDC0kd10ZpblC4EieSsYYoZKXO9HITCpZL2uZ4W+cGBDTSMIkg/pMO5jmYd4/ZDkFz+Z9fv516+mMMsuswKRXz15nL34ACdgy5VNKP9I2bsZLi/jF6TztNCMU2l3KTBz43JAuOr/gM2UJLBD51bzUiy3MDlns6vh+8rp97c/7aoe1MIuuftL713BOYEIEUAY9XOt3WkSs8pS0PfdXfylF7mnHntE4X70z8vjDKXynpqFBBXflxicUodMdSrNp9lY9MNo48ors1s5JYWWBIl7EVIl8dzTlLnH8Bp7CwwLkEAAA=";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected jaxx.runtime.swing.JAXXList listSimulExportChoose;
    private javax.swing.JButton $JButton2;
    private javax.swing.JScrollPane $JScrollPane1;
    private fr.ifremer.isisfish.ui.simulator.ExportUI $Table0 = this;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();

    /* begin raw body code */    
    
        protected SimulAction getSimulAction() {
            return getContextValue(SimulAction.class);
        }
        
        public void refresh() {
    
            // FIXME listen for export modification here
    
            // fill export
            setListSimulExportChooseModel();
        }
    
        protected void setListSimulExportChooseModel() {
            java.util.List<String> availableExports = getSimulAction().getExportNames();
            java.util.List<String> userExports = getSimulAction().getSimulationParameter().getExportNames();
            // userExports = intersection(userExports,availableExports)
            userExports.retainAll(availableExports);
    
            ExportNameListModel exportModel = new ExportNameListModel(availableExports);
            listSimulExportChoose.setModel(exportModel);
            
            for (String userExport : userExports) {
                int index = availableExports.indexOf(userExport);
                listSimulExportChoose.addSelectionInterval(index, index);
            }
        }
    
        protected void saveSimulationExports(ListSelectionEvent event) {
            // Set exports (this can save empty list (not a big deal))
            Object[] values = listSimulExportChoose.getSelectedValues();
            java.util.List<String> exportNames = new LinkedList<String>();
            for (Object o : values) {
                exportNames.add((String) o);
            }
            getSimulAction().getSimulationParameter().setExportNames(exportNames);
            
            if (log.isDebugEnabled()) {
                log.debug("Set exports in simulation : " + exportNames);
            }
        }
        
        protected void saveConfigExports() {
            // Set exports (this can save empty list (not a big deal))
            Object[] values = listSimulExportChoose.getSelectedValues();
            java.util.List<String> exportNames = new LinkedList<String>();
            for (Object o : values) {
                exportNames.add((String) o);
            }
            getSimulAction().getSimulationParameter().setExportNames(exportNames);
            
            getSimulAction().saveExport();
            setInfoText(_("isisfish.export.saved"));
        }
        
        protected void setInfoText(String txt) {
            // TODO remove getParentContainer use
            WelcomePanelUI root = getParentContainer(WelcomePanelUI.class);
            root.setStatusMessage(txt);
        }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public ExportUI() {
        $initialize();
    }

    public ExportUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        
    }

    public void removeDataBinding(String $binding) {
        
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton2(java.awt.event.ActionEvent event) {
        saveConfigExports();
    }

    public void doValueChanged__on__listSimulExportChoose(javax.swing.event.ListSelectionEvent event) {
        saveSimulationExports(event);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public jaxx.runtime.swing.JAXXList getListSimulExportChoose() {
        return listSimulExportChoose;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected javax.swing.JButton get$JButton2() {
        return $JButton2;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected fr.ifremer.isisfish.ui.simulator.ExportUI get$Table0() {
        return $Table0;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $Table0.add($JScrollPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        $JScrollPane1.getViewport().add(listSimulExportChoose);
        
        
        listSimulExportChoose.setCellRenderer((new fr.ifremer.isisfish.ui.models.export.ExportNameListRenderer()));
        listSimulExportChoose.setSelectionMode((javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        $JScrollPane1 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane1", $JScrollPane1);
        $JScrollPane1.setName("$JScrollPane1");
        
        createListSimulExportChoose();
        
        $JButton2 = new javax.swing.JButton();
        $objectMap.put("$JButton2", $JButton2);
        $JButton2.setName("$JButton2");
        $JButton2.setText(_("isisfish.common.saveNextSimulation"));
        $JButton2.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $Table0, "doActionPerformed__on__$JButton2"));
        
        $Table0.setName("$Table0");
        
        
        refresh();
        $completeSetup();
    }

    protected void createListSimulExportChoose() {
        listSimulExportChoose = new jaxx.runtime.swing.JAXXList();
        $objectMap.put("listSimulExportChoose", listSimulExportChoose);
        listSimulExportChoose.setName("listSimulExportChoose");
        listSimulExportChoose.addListSelectionListener((javax.swing.event.ListSelectionListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ListSelectionListener.class, "valueChanged", $Table0, "doValueChanged__on__listSimulExportChoose"));
    }

}
