/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.sensitivity;

import fr.ifremer.isisfish.ui.sensitivity.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import fr.ifremer.isisfish.ui.result.ResultAction;
import jaxx.runtime.JAXXInitialContext;
import fr.ifremer.isisfish.ui.input.InputAction;
import fr.ifremer.isisfish.ui.input.InputSaveVerifier;
import fr.ifremer.isisfish.ui.simulator.ParamsUI;
import fr.ifremer.isisfish.ui.simulator.ResultChoiceUI;
import fr.ifremer.isisfish.ui.simulator.AdvancedParamsUI;
import fr.ifremer.isisfish.ui.simulator.ExportUI;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityTabUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SensitivityUI extends javax.swing.JPanel implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(fr.ifremer.isisfish.ui.sensitivity.SensitivityUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVPW8TQRBdm9ix43zHJBIfUoA0NOeEFJGSCAiGgI0NIQYpwg1r3zre6Hy37O45lwYh0SKUioIG6CnpEaKkouU/IMQ/YPZ8vg/byIlwcXeefe/tvJm72U+/UEJwdOkAO47GbVPSFtGKW3t7D2sHpC5vE1HnlEmLo84vFkfxKsroflxIdKVaUvScR8/lrRazTGKG2BslNCbkkUFEkxAp0dkOoy5EruKHNxxm866an8wgtQ9/fseP9Zcf4wg5DLLKgoXFYazAwUgJxaku0Szs1MY5A5v7kAan5j7kOaFieQML8QC3yHP0Ao2WUJJhDmISXT65VVfD5TtMotRScQebxFiWaLnBNdrgpEXgLqhoUNHUbKoJYgoqaZvKI60SPD8pMObqJCUaF7RlG2Vi2rcwlyircnU0cQipa0UvrKBpn5H2GRLN9MEVaNzHJgWt4DaB9vQBC5K0FGrKB6cELYB5LtX/bHRtKmTlMa7BO7IQUYRYjeiqHtFkU1Bm3BJPChJd/VeRlB0MddZ2PKziLvgS09GtldTq6ertsqKi2RA037QsQbgSXjudsM+MiqeIo8p4MtN3PGxUYpITYRsSNqB1ooRyQ4V2I4yeGmK9jc266lC3HStDBbd6OFHJhVBNKqRumYATrvL66YoYJke3SC9B5wpmw1qR6FxkGHTeOm+V9ROuqcDKgIXVnoVMt1Ww3rM0E21BP2Cut6j9EPhsAnOhZY7mXD8wLrVgXAbzLFZFCW5DGFpXDSbrLoQ6M9WLugJu9P2rd+23n7+sdweoOgMmIpDQvIeBxrjFCJdUbTHVmZq2pEaujNlGFWYMMeCwcA+DbCiBiheGJEDfnT6aomn3sGgCNTH68+u3+Wc/zqD4NhozLKxvY4UvoLRsQj2blqE77MZNN5PxwxRcp1VOMKkMfGTZMI8nN3Us8WKNmjr0+LoDZrMhs34G349fly+8ubjWNRzrJNQDC0wnnqIkNQ1qEves8I6BgWdDhgli61Yw7gcdADF1H2Ner/Pu9e4gZyOSOOBrdrOz+yKWcDDVbEnAmyLdd5NXT2VXc3qopgo/UpfdwQpz/60wfwJfmdD3rEDFwVLnQeove26975QIAAA=";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected fr.ifremer.isisfish.ui.simulator.AdvancedParamsUI advancedParamsUI;
    protected jaxx.runtime.swing.TabInfo advancedParamsUITab;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected fr.ifremer.isisfish.ui.simulator.ExportUI exportUI;
    protected jaxx.runtime.swing.TabInfo exportUITab;
    protected fr.ifremer.isisfish.ui.simulator.ParamsUI paramsUI;
    protected fr.ifremer.isisfish.ui.simulator.ResultChoiceUI resultChoiceUI;
    protected jaxx.runtime.swing.TabInfo resultChoiceUITab;
    protected jaxx.runtime.swing.TabInfo secondPassUITab;
    protected fr.ifremer.isisfish.ui.sensitivity.SensitivityChooserUI sensitivityChooserUI;
    protected fr.ifremer.isisfish.ui.sensitivity.SensitivitySecondPassUI sensitivitySecondPassUI;
    protected fr.ifremer.isisfish.ui.sensitivity.SensitivityTabUI sensitivityTabUI;
    protected javax.swing.JTabbedPane sensitivityTabs;
    protected javax.swing.JMenuItem siImport;
    protected javax.swing.JMenuItem siSave;
    protected javax.swing.JMenu simulMenu;
    protected javax.swing.JMenuBar simulMenuBar;
    private fr.ifremer.isisfish.ui.sensitivity.SensitivityUI $JPanel0 = this;
    private jaxx.runtime.swing.TabInfo $TabInfo1;
    private jaxx.runtime.swing.TabInfo $TabInfo2;
    private jaxx.runtime.swing.TabInfo $TabInfo3;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();

    /* begin raw body code */    
            
            public void selTab(int i) {
                sensitivityTabs.setSelectedIndex(i);
            }
            public void refresh(){
                paramsUI.refresh();
            }
            
            // TODO duplicated code (simulUI, Params UI, SensitivityUI)
            protected void importSimulation() {
                JFileChooser fc = new JFileChooser();
                int returnVal = fc.showOpenDialog(null);
    
                if (returnVal == JFileChooser.APPROVE_OPTION) {
                    File file = fc.getSelectedFile();
                    //This is where a real application would open the file.
                    getContextValue(SimulAction.class).importSimulation(file);
                    refresh();
                }
            }
            // TODO duplicated code (simulUI, Params UI, SensitivityUI)
            protected void saveSimulation() {
                JFileChooser fc = new JFileChooser();
                int returnVal = fc.showSaveDialog(null);
    
                if (returnVal == JFileChooser.APPROVE_OPTION) {
                    File file = fc.getSelectedFile();
                    //This is where a real application would open the file.
                    getContextValue(SimulAction.class).saveSimulation(file);
                }
            }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public SensitivityUI() {
        $initialize();
    }

    public SensitivityUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        
    }

    public void removeDataBinding(String $binding) {
        
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__siImport(java.awt.event.ActionEvent event) {
        importSimulation();
    }

    public void doActionPerformed__on__siSave(java.awt.event.ActionEvent event) {
        saveSimulation();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public fr.ifremer.isisfish.ui.simulator.AdvancedParamsUI getAdvancedParamsUI() {
        return advancedParamsUI;
    }

    public jaxx.runtime.swing.TabInfo getAdvancedParamsUITab() {
        return advancedParamsUITab;
    }

    public fr.ifremer.isisfish.ui.simulator.ExportUI getExportUI() {
        return exportUI;
    }

    public jaxx.runtime.swing.TabInfo getExportUITab() {
        return exportUITab;
    }

    public fr.ifremer.isisfish.ui.simulator.ParamsUI getParamsUI() {
        return paramsUI;
    }

    public fr.ifremer.isisfish.ui.simulator.ResultChoiceUI getResultChoiceUI() {
        return resultChoiceUI;
    }

    public jaxx.runtime.swing.TabInfo getResultChoiceUITab() {
        return resultChoiceUITab;
    }

    public jaxx.runtime.swing.TabInfo getSecondPassUITab() {
        return secondPassUITab;
    }

    public fr.ifremer.isisfish.ui.sensitivity.SensitivityChooserUI getSensitivityChooserUI() {
        return sensitivityChooserUI;
    }

    public fr.ifremer.isisfish.ui.sensitivity.SensitivitySecondPassUI getSensitivitySecondPassUI() {
        return sensitivitySecondPassUI;
    }

    public fr.ifremer.isisfish.ui.sensitivity.SensitivityTabUI getSensitivityTabUI() {
        return sensitivityTabUI;
    }

    public javax.swing.JTabbedPane getSensitivityTabs() {
        return sensitivityTabs;
    }

    public javax.swing.JMenuItem getSiImport() {
        return siImport;
    }

    public javax.swing.JMenuItem getSiSave() {
        return siSave;
    }

    public javax.swing.JMenu getSimulMenu() {
        return simulMenu;
    }

    public javax.swing.JMenuBar getSimulMenuBar() {
        return simulMenuBar;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.sensitivity.SensitivityUI get$JPanel0() {
        return $JPanel0;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo3() {
        return $TabInfo3;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $JPanel0.add(simulMenuBar, BorderLayout.NORTH);
        $JPanel0.add(sensitivityTabs, BorderLayout.CENTER);
        
        addChildrenToSimulMenuBar();
        addChildrenToSimulMenu();
        addChildrenToSensitivityTabs();
        
        
        
        paramsUI.setSensitivity((true));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createSimulMenuBar();
        createSimulMenu();
        createSiSave();
        createSiImport();
        createSensitivityTabs();
        createParamsUI();
        createSensitivityTabUI();
        createSensitivityChooserUI();
        createExportUI();
        createResultChoiceUI();
        createAdvancedParamsUI();
        createSensitivitySecondPassUI();
        
        $TabInfo1 = new jaxx.runtime.swing.TabInfo();
        $objectMap.put("$TabInfo1", $TabInfo1);
        $TabInfo1.setTitle(_("isisfish.params.title"));
        
        $TabInfo2 = new jaxx.runtime.swing.TabInfo();
        $objectMap.put("$TabInfo2", $TabInfo2);
        $TabInfo2.setTitle(_("isisfish.sensitivity.title"));
        
        $TabInfo3 = new jaxx.runtime.swing.TabInfo();
        $objectMap.put("$TabInfo3", $TabInfo3);
        $TabInfo3.setTitle(_("isisfish.sensitivityChooser.title"));
        
        createExportUITab();
        createResultChoiceUITab();
        createAdvancedParamsUITab();
        createSecondPassUITab();
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout((new BorderLayout()));
        
        
        $completeSetup();
    }

    protected void addChildrenToSensitivityTabs() {
        if (!allComponentsCreated) {
            return;
        }
        sensitivityTabs.add(paramsUI);
        sensitivityTabs.add(sensitivityTabUI);
        sensitivityTabs.add(sensitivityChooserUI);
        sensitivityTabs.add(exportUI);
        sensitivityTabs.add(resultChoiceUI);
        sensitivityTabs.add(advancedParamsUI);
        sensitivityTabs.add(sensitivitySecondPassUI);
        $TabInfo1.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(sensitivityTabs, 0));
        sensitivityTabs.setTitleAt(0, _("isisfish.params.title"));
        $TabInfo2.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(sensitivityTabs, 1));
        sensitivityTabs.setTitleAt(1, _("isisfish.sensitivity.title"));
        $TabInfo3.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(sensitivityTabs, 2));
        sensitivityTabs.setTitleAt(2, _("isisfish.sensitivityChooser.title"));
        exportUITab.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(sensitivityTabs, 3));
        sensitivityTabs.setTitleAt(3, _("isisfish.export.title"));
        resultChoiceUITab.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(sensitivityTabs, 4));
        sensitivityTabs.setTitleAt(4, _("isisfish.resultChoice.title"));
        advancedParamsUITab.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(sensitivityTabs, 5));
        sensitivityTabs.setTitleAt(5, _("isisfish.advancedParameters.title"));
        secondPassUITab.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(sensitivityTabs, 6));
        sensitivityTabs.setTitleAt(6, _("isisfish.sensitivity.secondpass.title"));
    }

    protected void addChildrenToSimulMenu() {
        if (!allComponentsCreated) {
            return;
        }
        simulMenu.add(siSave);
        simulMenu.add(siImport);
    }

    protected void addChildrenToSimulMenuBar() {
        if (!allComponentsCreated) {
            return;
        }
        simulMenuBar.add(simulMenu);
    }

    protected void createAdvancedParamsUI() {
        advancedParamsUI =  new fr.ifremer.isisfish.ui.simulator.AdvancedParamsUI(this);
        $objectMap.put("advancedParamsUI", advancedParamsUI);
        advancedParamsUI.removeDataBinding("$Table0.name");
        
        advancedParamsUI.setName("advancedParamsUI");
    }

    protected void createAdvancedParamsUITab() {
        advancedParamsUITab = new jaxx.runtime.swing.TabInfo();
        $objectMap.put("advancedParamsUITab", advancedParamsUITab);
        advancedParamsUITab.setTitle(_("isisfish.advancedParameters.title"));
    }

    protected void createExportUI() {
        exportUI =  new fr.ifremer.isisfish.ui.simulator.ExportUI(this);
        $objectMap.put("exportUI", exportUI);
        exportUI.removeDataBinding("$Table0.name");
        
        exportUI.setName("exportUI");
    }

    protected void createExportUITab() {
        exportUITab = new jaxx.runtime.swing.TabInfo();
        $objectMap.put("exportUITab", exportUITab);
        exportUITab.setTitle(_("isisfish.export.title"));
    }

    protected void createParamsUI() {
        paramsUI =  new fr.ifremer.isisfish.ui.simulator.ParamsUI(this);
        $objectMap.put("paramsUI", paramsUI);
        paramsUI.removeDataBinding("$Table0.name");
        
        paramsUI.setName("paramsUI");
        paramsUI.removeDataBinding("$Table0.sensitivity");
    }

    protected void createResultChoiceUI() {
        resultChoiceUI =  new fr.ifremer.isisfish.ui.simulator.ResultChoiceUI(this);
        $objectMap.put("resultChoiceUI", resultChoiceUI);
        resultChoiceUI.removeDataBinding("$JPanel0.name");
        
        resultChoiceUI.setName("resultChoiceUI");
    }

    protected void createResultChoiceUITab() {
        resultChoiceUITab = new jaxx.runtime.swing.TabInfo();
        $objectMap.put("resultChoiceUITab", resultChoiceUITab);
        resultChoiceUITab.setTitle(_("isisfish.resultChoice.title"));
    }

    protected void createSecondPassUITab() {
        secondPassUITab = new jaxx.runtime.swing.TabInfo();
        $objectMap.put("secondPassUITab", secondPassUITab);
        secondPassUITab.setTitle(_("isisfish.sensitivity.secondpass.title"));
    }

    protected void createSensitivityChooserUI() {
        sensitivityChooserUI =  new fr.ifremer.isisfish.ui.sensitivity.SensitivityChooserUI(this);
        $objectMap.put("sensitivityChooserUI", sensitivityChooserUI);
        sensitivityChooserUI.removeDataBinding("$Table0.name");
        
        sensitivityChooserUI.setName("sensitivityChooserUI");
    }

    protected void createSensitivitySecondPassUI() {
        sensitivitySecondPassUI =  new fr.ifremer.isisfish.ui.sensitivity.SensitivitySecondPassUI(this);
        $objectMap.put("sensitivitySecondPassUI", sensitivitySecondPassUI);
        sensitivitySecondPassUI.removeDataBinding("$Table0.name");
        
        sensitivitySecondPassUI.setName("sensitivitySecondPassUI");
    }

    protected void createSensitivityTabUI() {
        sensitivityTabUI =  new fr.ifremer.isisfish.ui.sensitivity.SensitivityTabUI(new JAXXInitialContext().add(new InputAction()).add(new SensitivityAction()).add(new InputSaveVerifier()).add(this));
        $objectMap.put("sensitivityTabUI", sensitivityTabUI);
        sensitivityTabUI.removeDataBinding("$JPanel0.name");
        
        sensitivityTabUI.setName("sensitivityTabUI");
    }

    protected void createSensitivityTabs() {
        sensitivityTabs = new javax.swing.JTabbedPane();
        $objectMap.put("sensitivityTabs", sensitivityTabs);
        sensitivityTabs.setName("sensitivityTabs");
    }

    protected void createSiImport() {
        siImport = new javax.swing.JMenuItem();
        $objectMap.put("siImport", siImport);
        siImport.setName("siImport");
        siImport.setText(_("isisfish.simulation.menu.import"));
        siImport.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__siImport"));
    }

    protected void createSiSave() {
        siSave = new javax.swing.JMenuItem();
        $objectMap.put("siSave", siSave);
        siSave.setName("siSave");
        siSave.setText(_("isisfish.simulation.menu.save"));
        siSave.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__siSave"));
    }

    protected void createSimulMenu() {
        simulMenu = new javax.swing.JMenu();
        $objectMap.put("simulMenu", simulMenu);
        simulMenu.setName("simulMenu");
        simulMenu.setText(_("isisfish.simulation.menu.simulation"));
    }

    protected void createSimulMenuBar() {
        simulMenuBar = new javax.swing.JMenuBar();
        $objectMap.put("simulMenuBar", simulMenuBar);
        simulMenuBar.setName("simulMenuBar");
    }

}
