/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.script;

import fr.ifremer.isisfish.ui.script.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptUI extends javax.swing.JPanel implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(fr.ifremer.isisfish.ui.script.ScriptUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "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";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected javax.swing.JTextArea actionLogArea;
    protected javax.swing.JPanel buttonBar;
    protected javax.swing.JButton buttonScriptCheck;
    protected javax.swing.JButton buttonScriptCommit;
    protected javax.swing.JButton buttonScriptCopy;
    protected javax.swing.JButton buttonScriptCut;
    protected javax.swing.JButton buttonScriptEval;
    protected javax.swing.JButton buttonScriptExport;
    protected javax.swing.JButton buttonScriptNew;
    protected javax.swing.JButton buttonScriptPaste;
    protected javax.swing.JButton buttonScriptSave;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected org.nuiton.widget.editor.Editor editor;
    protected java.lang.Boolean fileSelected;
    protected java.lang.Boolean javaFileSelected;
    protected javax.swing.JMenuItem miCheckSyntax;
    protected javax.swing.JMenuItem miCommitVCS;
    protected javax.swing.JMenuItem miCopy;
    protected javax.swing.JMenuItem miCut;
    protected javax.swing.JMenuItem miDelete;
    protected javax.swing.JMenuItem miDeleteVCS;
    protected javax.swing.JMenuItem miDiffVCS;
    protected javax.swing.JMenuItem miEvaluate;
    protected javax.swing.JMenuItem miExport;
    protected javax.swing.JMenuItem miGenerateJavadoc;
    protected javax.swing.JMenuItem miImport;
    protected javax.swing.JMenuItem miNewAnalysePlan;
    protected javax.swing.JMenuItem miNewEquationModel;
    protected javax.swing.JMenuItem miNewExport;
    protected javax.swing.JMenuItem miNewRule;
    protected javax.swing.JMenuItem miNewScript;
    protected javax.swing.JMenuItem miNewSensitivity;
    protected javax.swing.JMenuItem miNewSensitivityExport;
    protected javax.swing.JMenuItem miNewSimulator;
    protected javax.swing.JMenuItem miPaste;
    protected javax.swing.JMenuItem miSave;
    protected javax.swing.JMenuItem miShowJavadoc;
    protected javax.swing.JMenuItem miUpdateVCS;
    protected fr.ifremer.isisfish.ui.script.ScriptAction scriptAction;
    protected javax.swing.JMenuBar scriptMenuBar;
    protected javax.swing.JMenu scriptNewMenu;
    protected javax.swing.JMenu scriptTxtCode;
    protected javax.swing.JMenu scriptTxtEdit;
    protected javax.swing.JMenu scriptTxtFile;
    protected javax.swing.JMenu scriptTxtVCS;
    protected jaxx.runtime.swing.JAXXComboBox scriptTypeChoice;
    protected java.lang.Boolean singleFileSelected;
    protected java.lang.Boolean textSelected;
    protected jaxx.runtime.swing.JAXXTree tree;
    private fr.ifremer.isisfish.ui.script.ScriptUI $JPanel0 = this;
    private javax.swing.JPanel $JPanel5;
    private javax.swing.JScrollPane $JScrollPane7;
    private javax.swing.JScrollPane $JScrollPane9;
    private javax.swing.JSeparator $JSeparator1;
    private javax.swing.JSeparator $JSeparator2;
    private javax.swing.JSeparator $JSeparator3;
    private javax.swing.JSeparator $JSeparator4;
    private javax.swing.JSplitPane $JSplitPane6;
    private javax.swing.JSplitPane $JSplitPane8;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource20 = new jaxx.runtime.DataBindingListener($JPanel0, "miSave.enabled");
    private java.beans.PropertyChangeListener $DataSource23 = new jaxx.runtime.DataBindingListener($JPanel0, "miExport.enabled");
    private java.beans.PropertyChangeListener $DataSource25 = new jaxx.runtime.DataBindingListener($JPanel0, "miDelete.enabled");
    private java.beans.PropertyChangeListener $DataSource27 = new jaxx.runtime.DataBindingListener($JPanel0, "miCut.enabled");
    private java.beans.PropertyChangeListener $DataSource29 = new jaxx.runtime.DataBindingListener($JPanel0, "miCopy.enabled");
    private java.beans.PropertyChangeListener $DataSource31 = new jaxx.runtime.DataBindingListener($JPanel0, "miPaste.enabled");
    private java.beans.PropertyChangeListener $DataSource34 = new jaxx.runtime.DataBindingListener($JPanel0, "miDiffVCS.enabled");
    private java.beans.PropertyChangeListener $DataSource37 = new jaxx.runtime.DataBindingListener($JPanel0, "miCheckSyntax.enabled");
    private java.beans.PropertyChangeListener $DataSource39 = new jaxx.runtime.DataBindingListener($JPanel0, "miEvaluate.enabled");
    private java.beans.PropertyChangeListener $DataSource45 = new jaxx.runtime.DataBindingListener($JPanel0, "buttonScriptSave.enabled");
    private java.beans.PropertyChangeListener $DataSource49 = new jaxx.runtime.DataBindingListener($JPanel0, "buttonScriptCut.enabled");
    private java.beans.PropertyChangeListener $DataSource51 = new jaxx.runtime.DataBindingListener($JPanel0, "buttonScriptCopy.enabled");
    private java.beans.PropertyChangeListener $DataSource53 = new jaxx.runtime.DataBindingListener($JPanel0, "buttonScriptPaste.enabled");
    private java.beans.PropertyChangeListener $DataSource55 = new jaxx.runtime.DataBindingListener($JPanel0, "buttonScriptCheck.enabled");
    private java.beans.PropertyChangeListener $DataSource57 = new jaxx.runtime.DataBindingListener($JPanel0, "buttonScriptEval.enabled");

    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public ScriptUI() {
        $initialize();
    }

    public ScriptUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("miSave.enabled".equals($binding)) {
                addPropertyChangeListener("singleFileSelected", $DataSource20);
        
        } else if ("miExport.enabled".equals($binding)) {
                addPropertyChangeListener("fileSelected", $DataSource23);
        
        } else if ("miDelete.enabled".equals($binding)) {
                addPropertyChangeListener("singleFileSelected", $DataSource25);
        
        } else if ("miCut.enabled".equals($binding)) {
                addPropertyChangeListener("textSelected", $DataSource27);
        
        } else if ("miCopy.enabled".equals($binding)) {
                addPropertyChangeListener("textSelected", $DataSource29);
        
        } else if ("miPaste.enabled".equals($binding)) {
                addPropertyChangeListener("singleFileSelected", $DataSource31);
        
        } else if ("miDiffVCS.enabled".equals($binding)) {
                addPropertyChangeListener("singleFileSelected", $DataSource34);
        
        } else if ("miCheckSyntax.enabled".equals($binding)) {
                addPropertyChangeListener("javaFileSelected", $DataSource37);
        
        } else if ("miEvaluate.enabled".equals($binding)) {
                addPropertyChangeListener("javaFileSelected", $DataSource39);
        
        } else if ("buttonScriptSave.enabled".equals($binding)) {
                addPropertyChangeListener("singleFileSelected", $DataSource45);
        
        } else if ("buttonScriptCut.enabled".equals($binding)) {
                addPropertyChangeListener("textSelected", $DataSource49);
        
        } else if ("buttonScriptCopy.enabled".equals($binding)) {
                addPropertyChangeListener("textSelected", $DataSource51);
        
        } else if ("buttonScriptPaste.enabled".equals($binding)) {
                addPropertyChangeListener("singleFileSelected", $DataSource53);
        
        } else if ("buttonScriptCheck.enabled".equals($binding)) {
                addPropertyChangeListener("javaFileSelected", $DataSource55);
        
        } else if ("buttonScriptEval.enabled".equals($binding)) {
                addPropertyChangeListener("javaFileSelected", $DataSource57);
        
        }
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("miSave.enabled".equals($dest)) {
            miSave.setEnabled((isSingleFileSelected()));
            } else if ("miExport.enabled".equals($dest)) {
            miExport.setEnabled((isFileSelected()));
            } else if ("miDelete.enabled".equals($dest)) {
            miDelete.setEnabled((isSingleFileSelected()));
            } else if ("miCut.enabled".equals($dest)) {
            miCut.setEnabled((isTextSelected()));
            } else if ("miCopy.enabled".equals($dest)) {
            miCopy.setEnabled((isTextSelected()));
            } else if ("miPaste.enabled".equals($dest)) {
            miPaste.setEnabled((isSingleFileSelected()));
            } else if ("miDiffVCS.enabled".equals($dest)) {
            miDiffVCS.setEnabled((isSingleFileSelected()));
            } else if ("miCheckSyntax.enabled".equals($dest)) {
            miCheckSyntax.setEnabled((isJavaFileSelected()));
            } else if ("miEvaluate.enabled".equals($dest)) {
            miEvaluate.setEnabled((isJavaFileSelected()));
            } else if ("buttonScriptSave.enabled".equals($dest)) {
            buttonScriptSave.setEnabled((isSingleFileSelected()));
            } else if ("buttonScriptCut.enabled".equals($dest)) {
            buttonScriptCut.setEnabled((isTextSelected()));
            } else if ("buttonScriptCopy.enabled".equals($dest)) {
            buttonScriptCopy.setEnabled((isTextSelected()));
            } else if ("buttonScriptPaste.enabled".equals($dest)) {
            buttonScriptPaste.setEnabled((isSingleFileSelected()));
            } else if ("buttonScriptCheck.enabled".equals($dest)) {
            buttonScriptCheck.setEnabled((isJavaFileSelected()));
            } else if ("buttonScriptEval.enabled".equals($dest)) {
            buttonScriptEval.setEnabled((isJavaFileSelected()));
            }} finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("miSave.enabled".equals($binding)) {
                removePropertyChangeListener("singleFileSelected", $DataSource20);
        
        } else if ("miExport.enabled".equals($binding)) {
                removePropertyChangeListener("fileSelected", $DataSource23);
        
        } else if ("miDelete.enabled".equals($binding)) {
                removePropertyChangeListener("singleFileSelected", $DataSource25);
        
        } else if ("miCut.enabled".equals($binding)) {
                removePropertyChangeListener("textSelected", $DataSource27);
        
        } else if ("miCopy.enabled".equals($binding)) {
                removePropertyChangeListener("textSelected", $DataSource29);
        
        } else if ("miPaste.enabled".equals($binding)) {
                removePropertyChangeListener("singleFileSelected", $DataSource31);
        
        } else if ("miDiffVCS.enabled".equals($binding)) {
                removePropertyChangeListener("singleFileSelected", $DataSource34);
        
        } else if ("miCheckSyntax.enabled".equals($binding)) {
                removePropertyChangeListener("javaFileSelected", $DataSource37);
        
        } else if ("miEvaluate.enabled".equals($binding)) {
                removePropertyChangeListener("javaFileSelected", $DataSource39);
        
        } else if ("buttonScriptSave.enabled".equals($binding)) {
                removePropertyChangeListener("singleFileSelected", $DataSource45);
        
        } else if ("buttonScriptCut.enabled".equals($binding)) {
                removePropertyChangeListener("textSelected", $DataSource49);
        
        } else if ("buttonScriptCopy.enabled".equals($binding)) {
                removePropertyChangeListener("textSelected", $DataSource51);
        
        } else if ("buttonScriptPaste.enabled".equals($binding)) {
                removePropertyChangeListener("singleFileSelected", $DataSource53);
        
        } else if ("buttonScriptCheck.enabled".equals($binding)) {
                removePropertyChangeListener("javaFileSelected", $DataSource55);
        
        } else if ("buttonScriptEval.enabled".equals($binding)) {
                removePropertyChangeListener("javaFileSelected", $DataSource57);
        
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__buttonScriptCheck(java.awt.event.ActionEvent event) {
        getScriptAction().checkScript();
    }

    public void doActionPerformed__on__buttonScriptCommit(java.awt.event.ActionEvent event) {
        getScriptAction().commitScript();
    }

    public void doActionPerformed__on__buttonScriptCopy(java.awt.event.ActionEvent event) {
        getScriptAction().copy();
    }

    public void doActionPerformed__on__buttonScriptCut(java.awt.event.ActionEvent event) {
        getScriptAction().cut();
    }

    public void doActionPerformed__on__buttonScriptEval(java.awt.event.ActionEvent event) {
        getScriptAction().evaluateScript();
    }

    public void doActionPerformed__on__buttonScriptExport(java.awt.event.ActionEvent event) {
        getScriptAction().exportScript();
    }

    public void doActionPerformed__on__buttonScriptNew(java.awt.event.ActionEvent event) {
        getScriptAction().newScript();
    }

    public void doActionPerformed__on__buttonScriptPaste(java.awt.event.ActionEvent event) {
        getScriptAction().paste();
    }

    public void doActionPerformed__on__buttonScriptSave(java.awt.event.ActionEvent event) {
        getScriptAction().saveScript();
    }

    public void doActionPerformed__on__miCheckSyntax(java.awt.event.ActionEvent event) {
        getScriptAction().checkScript();
    }

    public void doActionPerformed__on__miCommitVCS(java.awt.event.ActionEvent event) {
        getScriptAction().commitScript();
    }

    public void doActionPerformed__on__miCopy(java.awt.event.ActionEvent event) {
        getScriptAction().copy();
    }

    public void doActionPerformed__on__miCut(java.awt.event.ActionEvent event) {
        getScriptAction().cut();
    }

    public void doActionPerformed__on__miDelete(java.awt.event.ActionEvent event) {
        getScriptAction().deleteScript(false);
    }

    public void doActionPerformed__on__miDeleteVCS(java.awt.event.ActionEvent event) {
        getScriptAction().deleteScript(true);
    }

    public void doActionPerformed__on__miDiffVCS(java.awt.event.ActionEvent event) {
        getScriptAction().diffScript();
    }

    public void doActionPerformed__on__miEvaluate(java.awt.event.ActionEvent event) {
        getScriptAction().evaluateScript();
    }

    public void doActionPerformed__on__miExport(java.awt.event.ActionEvent event) {
        getScriptAction().exportScript();
    }

    public void doActionPerformed__on__miGenerateJavadoc(java.awt.event.ActionEvent event) {
        getScriptAction().generateScriptJavadoc();
    }

    public void doActionPerformed__on__miImport(java.awt.event.ActionEvent event) {
        getScriptAction().importScript();
    }

    public void doActionPerformed__on__miNewAnalysePlan(java.awt.event.ActionEvent event) {
        getScriptAction().newScript(ScriptAction.ScriptMapping.AnalysePlan);
    }

    public void doActionPerformed__on__miNewEquationModel(java.awt.event.ActionEvent event) {
        getScriptAction().newScript(ScriptAction.ScriptMapping.EquationModel);
    }

    public void doActionPerformed__on__miNewExport(java.awt.event.ActionEvent event) {
        getScriptAction().newScript(ScriptAction.ScriptMapping.Export);
    }

    public void doActionPerformed__on__miNewRule(java.awt.event.ActionEvent event) {
        getScriptAction().newScript(ScriptAction.ScriptMapping.Rule);
    }

    public void doActionPerformed__on__miNewScript(java.awt.event.ActionEvent event) {
        getScriptAction().newScript(ScriptAction.ScriptMapping.Script);
    }

    public void doActionPerformed__on__miNewSensitivity(java.awt.event.ActionEvent event) {
        getScriptAction().newScript(ScriptAction.ScriptMapping.Sensitivity);
    }

    public void doActionPerformed__on__miNewSensitivityExport(java.awt.event.ActionEvent event) {
        getScriptAction().newScript(ScriptAction.ScriptMapping.SensitivityExport);
    }

    public void doActionPerformed__on__miNewSimulator(java.awt.event.ActionEvent event) {
        getScriptAction().newScript(ScriptAction.ScriptMapping.Simulator);
    }

    public void doActionPerformed__on__miPaste(java.awt.event.ActionEvent event) {
        getScriptAction().paste();
    }

    public void doActionPerformed__on__miSave(java.awt.event.ActionEvent event) {
        getScriptAction().saveScript();
    }

    public void doActionPerformed__on__miShowJavadoc(java.awt.event.ActionEvent event) {
        getScriptAction().showScriptJavadoc();
    }

    public void doActionPerformed__on__miUpdateVCS(java.awt.event.ActionEvent event) {
        getScriptAction().updateScript();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JTextArea getActionLogArea() {
        return actionLogArea;
    }

    public javax.swing.JPanel getButtonBar() {
        return buttonBar;
    }

    public javax.swing.JButton getButtonScriptCheck() {
        return buttonScriptCheck;
    }

    public javax.swing.JButton getButtonScriptCommit() {
        return buttonScriptCommit;
    }

    public javax.swing.JButton getButtonScriptCopy() {
        return buttonScriptCopy;
    }

    public javax.swing.JButton getButtonScriptCut() {
        return buttonScriptCut;
    }

    public javax.swing.JButton getButtonScriptEval() {
        return buttonScriptEval;
    }

    public javax.swing.JButton getButtonScriptExport() {
        return buttonScriptExport;
    }

    public javax.swing.JButton getButtonScriptNew() {
        return buttonScriptNew;
    }

    public javax.swing.JButton getButtonScriptPaste() {
        return buttonScriptPaste;
    }

    public javax.swing.JButton getButtonScriptSave() {
        return buttonScriptSave;
    }

    public org.nuiton.widget.editor.Editor getEditor() {
        return editor;
    }

    public java.lang.Boolean getFileSelected() {
        return fileSelected;
    }

    public java.lang.Boolean getJavaFileSelected() {
        return javaFileSelected;
    }

    public javax.swing.JMenuItem getMiCheckSyntax() {
        return miCheckSyntax;
    }

    public javax.swing.JMenuItem getMiCommitVCS() {
        return miCommitVCS;
    }

    public javax.swing.JMenuItem getMiCopy() {
        return miCopy;
    }

    public javax.swing.JMenuItem getMiCut() {
        return miCut;
    }

    public javax.swing.JMenuItem getMiDelete() {
        return miDelete;
    }

    public javax.swing.JMenuItem getMiDeleteVCS() {
        return miDeleteVCS;
    }

    public javax.swing.JMenuItem getMiDiffVCS() {
        return miDiffVCS;
    }

    public javax.swing.JMenuItem getMiEvaluate() {
        return miEvaluate;
    }

    public javax.swing.JMenuItem getMiExport() {
        return miExport;
    }

    public javax.swing.JMenuItem getMiGenerateJavadoc() {
        return miGenerateJavadoc;
    }

    public javax.swing.JMenuItem getMiImport() {
        return miImport;
    }

    public javax.swing.JMenuItem getMiNewAnalysePlan() {
        return miNewAnalysePlan;
    }

    public javax.swing.JMenuItem getMiNewEquationModel() {
        return miNewEquationModel;
    }

    public javax.swing.JMenuItem getMiNewExport() {
        return miNewExport;
    }

    public javax.swing.JMenuItem getMiNewRule() {
        return miNewRule;
    }

    public javax.swing.JMenuItem getMiNewScript() {
        return miNewScript;
    }

    public javax.swing.JMenuItem getMiNewSensitivity() {
        return miNewSensitivity;
    }

    public javax.swing.JMenuItem getMiNewSensitivityExport() {
        return miNewSensitivityExport;
    }

    public javax.swing.JMenuItem getMiNewSimulator() {
        return miNewSimulator;
    }

    public javax.swing.JMenuItem getMiPaste() {
        return miPaste;
    }

    public javax.swing.JMenuItem getMiSave() {
        return miSave;
    }

    public javax.swing.JMenuItem getMiShowJavadoc() {
        return miShowJavadoc;
    }

    public javax.swing.JMenuItem getMiUpdateVCS() {
        return miUpdateVCS;
    }

    public fr.ifremer.isisfish.ui.script.ScriptAction getScriptAction() {
        return scriptAction;
    }

    public javax.swing.JMenuBar getScriptMenuBar() {
        return scriptMenuBar;
    }

    public javax.swing.JMenu getScriptNewMenu() {
        return scriptNewMenu;
    }

    public javax.swing.JMenu getScriptTxtCode() {
        return scriptTxtCode;
    }

    public javax.swing.JMenu getScriptTxtEdit() {
        return scriptTxtEdit;
    }

    public javax.swing.JMenu getScriptTxtFile() {
        return scriptTxtFile;
    }

    public javax.swing.JMenu getScriptTxtVCS() {
        return scriptTxtVCS;
    }

    public jaxx.runtime.swing.JAXXComboBox getScriptTypeChoice() {
        return scriptTypeChoice;
    }

    public java.lang.Boolean getSingleFileSelected() {
        return singleFileSelected;
    }

    public java.lang.Boolean getTextSelected() {
        return textSelected;
    }

    public jaxx.runtime.swing.JAXXTree getTree() {
        return tree;
    }

    public java.lang.Boolean isFileSelected() {
        return fileSelected !=null && fileSelected;
    }

    public java.lang.Boolean isJavaFileSelected() {
        return javaFileSelected !=null && javaFileSelected;
    }

    public java.lang.Boolean isSingleFileSelected() {
        return singleFileSelected !=null && singleFileSelected;
    }

    public java.lang.Boolean isTextSelected() {
        return textSelected !=null && textSelected;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setFileSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.fileSelected;
        this.fileSelected = newValue;
        firePropertyChange("fileSelected", oldValue, newValue);
    }

    public void setJavaFileSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.javaFileSelected;
        this.javaFileSelected = newValue;
        firePropertyChange("javaFileSelected", oldValue, newValue);
    }

    public void setScriptAction(fr.ifremer.isisfish.ui.script.ScriptAction newValue) {
        fr.ifremer.isisfish.ui.script.ScriptAction oldValue = this.scriptAction;
        this.scriptAction = newValue;
        firePropertyChange("scriptAction", oldValue, newValue);
    }

    public void setSingleFileSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.singleFileSelected;
        this.singleFileSelected = newValue;
        firePropertyChange("singleFileSelected", oldValue, newValue);
    }

    public void setTextSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.textSelected;
        this.textSelected = newValue;
        firePropertyChange("textSelected", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.script.ScriptUI get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JPanel get$JPanel5() {
        return $JPanel5;
    }

    protected javax.swing.JScrollPane get$JScrollPane7() {
        return $JScrollPane7;
    }

    protected javax.swing.JScrollPane get$JScrollPane9() {
        return $JScrollPane9;
    }

    protected javax.swing.JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected javax.swing.JSeparator get$JSeparator2() {
        return $JSeparator2;
    }

    protected javax.swing.JSeparator get$JSeparator3() {
        return $JSeparator3;
    }

    protected javax.swing.JSeparator get$JSeparator4() {
        return $JSeparator4;
    }

    protected javax.swing.JSplitPane get$JSplitPane6() {
        return $JSplitPane6;
    }

    protected javax.swing.JSplitPane get$JSplitPane8() {
        return $JSplitPane8;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $JPanel0.add(scriptMenuBar, BorderLayout.NORTH);
        $JPanel0.add($JPanel5, BorderLayout.CENTER);
        
        addChildrenToScriptMenuBar();
        addChildrenToScriptTxtFile();
        addChildrenToScriptNewMenu();
        
        
        addChildrenToScriptTxtEdit();
        addChildrenToScriptTxtVCS();
        
        addChildrenToScriptTxtCode();
        
        $JPanel5.add(buttonBar, BorderLayout.NORTH);
        $JPanel5.add($JSplitPane6, BorderLayout.CENTER);
        
        addChildrenToButtonBar();
        $JSplitPane6.add($JScrollPane7, JSplitPane.LEFT);
        $JSplitPane6.add($JSplitPane8, JSplitPane.RIGHT);
        
        $JScrollPane7.getViewport().add(tree);
        
        $JSplitPane8.add(editor, JSplitPane.LEFT);
        $JSplitPane8.add($JScrollPane9, JSplitPane.RIGHT);
        
        $JScrollPane9.getViewport().add(actionLogArea);
        
        scriptNewMenu.setIcon((jaxx.runtime.Util.createImageIcon("script.png")));
        miNewScript.setIcon((jaxx.runtime.Util.createImageIcon("script.png")));
        miNewSimulator.setIcon((jaxx.runtime.Util.createImageIcon("script.png")));
        miNewExport.setIcon((jaxx.runtime.Util.createImageIcon("script.png")));
        miNewRule.setIcon((jaxx.runtime.Util.createImageIcon("script.png")));
        miNewAnalysePlan.setIcon((jaxx.runtime.Util.createImageIcon("script.png")));
        miNewSensitivity.setIcon((jaxx.runtime.Util.createImageIcon("script.png")));
        miNewSensitivityExport.setIcon((jaxx.runtime.Util.createImageIcon("script.png")));
        miNewEquationModel.setIcon((jaxx.runtime.Util.createImageIcon("script.png")));
        applyDataBinding("miSave.enabled");
        miSave.setIcon((jaxx.runtime.Util.createImageIcon("script_save.png")));
        miImport.setIcon((jaxx.runtime.Util.createImageIcon("page_white_compressed.png")));
        applyDataBinding("miExport.enabled");
        miExport.setIcon((jaxx.runtime.Util.createImageIcon("page_white_compressed.png")));
        applyDataBinding("miDelete.enabled");
        miDelete.setIcon((jaxx.runtime.Util.createImageIcon("script_delete.png")));
        applyDataBinding("miCut.enabled");
        miCut.setIcon((jaxx.runtime.Util.createImageIcon("cut.png")));
        applyDataBinding("miCopy.enabled");
        miCopy.setIcon((jaxx.runtime.Util.createImageIcon("page_copy.png")));
        applyDataBinding("miPaste.enabled");
        miPaste.setIcon((jaxx.runtime.Util.createImageIcon("page_paste.png")));
        miCommitVCS.setIcon((jaxx.runtime.Util.createImageIcon("database_go.png")));
        applyDataBinding("miDiffVCS.enabled");
        miUpdateVCS.setIcon((jaxx.runtime.Util.createImageIcon("database_refresh.png")));
        miDeleteVCS.setIcon((jaxx.runtime.Util.createImageIcon("database_delete.png")));
        applyDataBinding("miCheckSyntax.enabled");
        miCheckSyntax.setIcon((jaxx.runtime.Util.createImageIcon("script_code_red.png")));
        applyDataBinding("miEvaluate.enabled");
        miEvaluate.setIcon((jaxx.runtime.Util.createImageIcon("script_gear.png")));
        scriptTypeChoice.setModel((new ScriptTypesComboModel()));
        buttonScriptNew.setIcon((jaxx.runtime.Util.createImageIcon("script.png")));
        applyDataBinding("buttonScriptSave.enabled");
        buttonScriptSave.setIcon((jaxx.runtime.Util.createImageIcon("script_save.png")));
        buttonScriptExport.setIcon((jaxx.runtime.Util.createImageIcon("page_white_compressed.png")));
        buttonScriptCommit.setIcon((jaxx.runtime.Util.createImageIcon("database_go.png")));
        applyDataBinding("buttonScriptCut.enabled");
        buttonScriptCut.setIcon((jaxx.runtime.Util.createImageIcon("cut.png")));
        applyDataBinding("buttonScriptCopy.enabled");
        buttonScriptCopy.setIcon((jaxx.runtime.Util.createImageIcon("page_copy.png")));
        applyDataBinding("buttonScriptPaste.enabled");
        buttonScriptPaste.setIcon((jaxx.runtime.Util.createImageIcon("page_paste.png")));
        applyDataBinding("buttonScriptCheck.enabled");
        buttonScriptCheck.setIcon((jaxx.runtime.Util.createImageIcon("script_code_red.png")));
        applyDataBinding("buttonScriptEval.enabled");
        buttonScriptEval.setIcon((jaxx.runtime.Util.createImageIcon("script_gear.png")));
        tree.setCellRenderer((new fr.ifremer.isisfish.ui.script.model.ScriptTreeCellRenderer()));
        tree.setModel((new fr.ifremer.isisfish.ui.script.model.ScriptTreeModel()));
        actionLogArea.setFont((new Font("Monospaced", Font.PLAIN, 12)));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createScriptAction();
        createFileSelected();
        createSingleFileSelected();
        createTextSelected();
        createJavaFileSelected();
        createScriptMenuBar();
        createScriptTxtFile();
        createScriptNewMenu();
        createMiNewScript();
        createMiNewSimulator();
        createMiNewExport();
        createMiNewRule();
        createMiNewAnalysePlan();
        createMiNewSensitivity();
        createMiNewSensitivityExport();
        createMiNewEquationModel();
        createMiSave();
        
        $JSeparator1 = new javax.swing.JSeparator();
        $objectMap.put("$JSeparator1", $JSeparator1);
        $JSeparator1.setName("$JSeparator1");
        
        createMiImport();
        createMiExport();
        
        $JSeparator2 = new javax.swing.JSeparator();
        $objectMap.put("$JSeparator2", $JSeparator2);
        $JSeparator2.setName("$JSeparator2");
        
        createMiDelete();
        createScriptTxtEdit();
        createMiCut();
        createMiCopy();
        createMiPaste();
        createScriptTxtVCS();
        createMiCommitVCS();
        createMiDiffVCS();
        createMiUpdateVCS();
        
        $JSeparator3 = new javax.swing.JSeparator();
        $objectMap.put("$JSeparator3", $JSeparator3);
        $JSeparator3.setName("$JSeparator3");
        
        createMiDeleteVCS();
        createScriptTxtCode();
        createMiCheckSyntax();
        createMiEvaluate();
        
        $JSeparator4 = new javax.swing.JSeparator();
        $objectMap.put("$JSeparator4", $JSeparator4);
        $JSeparator4.setName("$JSeparator4");
        
        createMiGenerateJavadoc();
        createMiShowJavadoc();
        
        $JPanel5 = new javax.swing.JPanel();
        $objectMap.put("$JPanel5", $JPanel5);
        $JPanel5.setName("$JPanel5");
        $JPanel5.setLayout((new BorderLayout()));
        
        createButtonBar();
        createScriptTypeChoice();
        createButtonScriptNew();
        createButtonScriptSave();
        createButtonScriptExport();
        createButtonScriptCommit();
        createButtonScriptCut();
        createButtonScriptCopy();
        createButtonScriptPaste();
        createButtonScriptCheck();
        createButtonScriptEval();
        
        $JSplitPane6 = new javax.swing.JSplitPane();
        $objectMap.put("$JSplitPane6", $JSplitPane6);
        $JSplitPane6.setName("$JSplitPane6");
        $JSplitPane6.setDividerLocation(250);
        $JSplitPane6.setOneTouchExpandable(true);
        $JSplitPane6.setOrientation(1);
        
        $JScrollPane7 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane7", $JScrollPane7);
        $JScrollPane7.setName("$JScrollPane7");
        
        createTree();
        
        $JSplitPane8 = new javax.swing.JSplitPane();
        $objectMap.put("$JSplitPane8", $JSplitPane8);
        $JSplitPane8.setName("$JSplitPane8");
        $JSplitPane8.setOneTouchExpandable(true);
        $JSplitPane8.setOrientation(0);
        $JSplitPane8.setResizeWeight(0.75);
        
        createEditor();
        
        $JScrollPane9 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane9", $JScrollPane9);
        $JScrollPane9.setName("$JScrollPane9");
        
        createActionLogArea();
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout((new BorderLayout()));
        
        
        getScriptAction().postInit();
        $completeSetup();
    }

    protected void addChildrenToButtonBar() {
        if (!allComponentsCreated) {
            return;
        }
        buttonBar.add(scriptTypeChoice);
        buttonBar.add(buttonScriptNew);
        buttonBar.add(buttonScriptSave);
        buttonBar.add(buttonScriptExport);
        buttonBar.add(buttonScriptCommit);
        buttonBar.add(buttonScriptCut);
        buttonBar.add(buttonScriptCopy);
        buttonBar.add(buttonScriptPaste);
        buttonBar.add(buttonScriptCheck);
        buttonBar.add(buttonScriptEval);
    }

    protected void addChildrenToScriptMenuBar() {
        if (!allComponentsCreated) {
            return;
        }
        scriptMenuBar.add(scriptTxtFile);
        scriptMenuBar.add(scriptTxtEdit);
        scriptMenuBar.add(scriptTxtVCS);
        scriptMenuBar.add(scriptTxtCode);
    }

    protected void addChildrenToScriptNewMenu() {
        if (!allComponentsCreated) {
            return;
        }
        scriptNewMenu.add(miNewScript);
        scriptNewMenu.add(miNewSimulator);
        scriptNewMenu.add(miNewExport);
        scriptNewMenu.add(miNewRule);
        scriptNewMenu.add(miNewAnalysePlan);
        scriptNewMenu.add(miNewSensitivity);
        scriptNewMenu.add(miNewSensitivityExport);
        scriptNewMenu.add(miNewEquationModel);
    }

    protected void addChildrenToScriptTxtCode() {
        if (!allComponentsCreated) {
            return;
        }
        scriptTxtCode.add(miCheckSyntax);
        scriptTxtCode.add(miEvaluate);
        scriptTxtCode.add($JSeparator4);
        scriptTxtCode.add(miGenerateJavadoc);
        scriptTxtCode.add(miShowJavadoc);
    }

    protected void addChildrenToScriptTxtEdit() {
        if (!allComponentsCreated) {
            return;
        }
        scriptTxtEdit.add(miCut);
        scriptTxtEdit.add(miCopy);
        scriptTxtEdit.add(miPaste);
    }

    protected void addChildrenToScriptTxtFile() {
        if (!allComponentsCreated) {
            return;
        }
        scriptTxtFile.add(scriptNewMenu);
        scriptTxtFile.add(miSave);
        scriptTxtFile.add($JSeparator1);
        scriptTxtFile.add(miImport);
        scriptTxtFile.add(miExport);
        scriptTxtFile.add($JSeparator2);
        scriptTxtFile.add(miDelete);
    }

    protected void addChildrenToScriptTxtVCS() {
        if (!allComponentsCreated) {
            return;
        }
        scriptTxtVCS.add(miCommitVCS);
        scriptTxtVCS.add(miDiffVCS);
        scriptTxtVCS.add(miUpdateVCS);
        scriptTxtVCS.add($JSeparator3);
        scriptTxtVCS.add(miDeleteVCS);
    }

    protected void createActionLogArea() {
        actionLogArea = new javax.swing.JTextArea();
        $objectMap.put("actionLogArea", actionLogArea);
        actionLogArea.setName("actionLogArea");
        actionLogArea.setColumns(15);
        actionLogArea.setLineWrap(true);
        actionLogArea.setWrapStyleWord(true);
        actionLogArea.setEditable(false);
    }

    protected void createButtonBar() {
        buttonBar = new javax.swing.JPanel();
        $objectMap.put("buttonBar", buttonBar);
        buttonBar.setName("buttonBar");
        buttonBar.setLayout((new GridLayout()));
    }

    protected void createButtonScriptCheck() {
        buttonScriptCheck = new javax.swing.JButton();
        $objectMap.put("buttonScriptCheck", buttonScriptCheck);
        buttonScriptCheck.setName("buttonScriptCheck");
        buttonScriptCheck.setText(_("isisfish.script.check"));
        buttonScriptCheck.setToolTipText(_("isisfish.script.check.tooltip"));
        buttonScriptCheck.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__buttonScriptCheck"));
    }

    protected void createButtonScriptCommit() {
        buttonScriptCommit = new javax.swing.JButton();
        $objectMap.put("buttonScriptCommit", buttonScriptCommit);
        buttonScriptCommit.setName("buttonScriptCommit");
        buttonScriptCommit.setEnabled(false);
        buttonScriptCommit.setText(_("isisfish.script.commit"));
        buttonScriptCommit.setToolTipText(_("isisfish.script.commit.tooltip"));
        buttonScriptCommit.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__buttonScriptCommit"));
    }

    protected void createButtonScriptCopy() {
        buttonScriptCopy = new javax.swing.JButton();
        $objectMap.put("buttonScriptCopy", buttonScriptCopy);
        buttonScriptCopy.setName("buttonScriptCopy");
        buttonScriptCopy.setText(_("isisfish.script.copy"));
        buttonScriptCopy.setToolTipText(_("isisfish.script.copy.tooltip"));
        buttonScriptCopy.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__buttonScriptCopy"));
    }

    protected void createButtonScriptCut() {
        buttonScriptCut = new javax.swing.JButton();
        $objectMap.put("buttonScriptCut", buttonScriptCut);
        buttonScriptCut.setName("buttonScriptCut");
        buttonScriptCut.setText(_("isisfish.script.cut"));
        buttonScriptCut.setToolTipText(_("isisfish.script.cut.tooltip"));
        buttonScriptCut.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__buttonScriptCut"));
    }

    protected void createButtonScriptEval() {
        buttonScriptEval = new javax.swing.JButton();
        $objectMap.put("buttonScriptEval", buttonScriptEval);
        buttonScriptEval.setName("buttonScriptEval");
        buttonScriptEval.setText(_("isisfish.script.evaluate"));
        buttonScriptEval.setToolTipText(_("isisfish.script.evaluate.tooltip"));
        buttonScriptEval.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__buttonScriptEval"));
    }

    protected void createButtonScriptExport() {
        buttonScriptExport = new javax.swing.JButton();
        $objectMap.put("buttonScriptExport", buttonScriptExport);
        buttonScriptExport.setName("buttonScriptExport");
        buttonScriptExport.setEnabled(false);
        buttonScriptExport.setText(_("isisfish.script.export"));
        buttonScriptExport.setToolTipText(_("isisfish.script.export.tooltip"));
        buttonScriptExport.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__buttonScriptExport"));
    }

    protected void createButtonScriptNew() {
        buttonScriptNew = new javax.swing.JButton();
        $objectMap.put("buttonScriptNew", buttonScriptNew);
        buttonScriptNew.setName("buttonScriptNew");
        buttonScriptNew.setText(_("isisfish.script.new"));
        buttonScriptNew.setToolTipText(_("isisfish.script.new.tooltip"));
        buttonScriptNew.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__buttonScriptNew"));
    }

    protected void createButtonScriptPaste() {
        buttonScriptPaste = new javax.swing.JButton();
        $objectMap.put("buttonScriptPaste", buttonScriptPaste);
        buttonScriptPaste.setName("buttonScriptPaste");
        buttonScriptPaste.setText(_("isisfish.script.paste"));
        buttonScriptPaste.setToolTipText(_("isisfish.script.paste.tooltip"));
        buttonScriptPaste.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__buttonScriptPaste"));
    }

    protected void createButtonScriptSave() {
        buttonScriptSave = new javax.swing.JButton();
        $objectMap.put("buttonScriptSave", buttonScriptSave);
        buttonScriptSave.setName("buttonScriptSave");
        buttonScriptSave.setText(_("isisfish.script.save"));
        buttonScriptSave.setToolTipText(_("isisfish.script.save.tooltip"));
        buttonScriptSave.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__buttonScriptSave"));
    }

    protected void createEditor() {
        editor = new org.nuiton.widget.editor.Editor();
        $objectMap.put("editor", editor);
        editor.setName("editor");
    }

    protected void createFileSelected() {
        fileSelected = false;
        $objectMap.put("fileSelected", fileSelected);
    }

    protected void createJavaFileSelected() {
        javaFileSelected = false;
        $objectMap.put("javaFileSelected", javaFileSelected);
    }

    protected void createMiCheckSyntax() {
        miCheckSyntax = new javax.swing.JMenuItem();
        $objectMap.put("miCheckSyntax", miCheckSyntax);
        miCheckSyntax.setName("miCheckSyntax");
        miCheckSyntax.setText(_("isisfish.script.menu.checkSyntax"));
        miCheckSyntax.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miCheckSyntax"));
    }

    protected void createMiCommitVCS() {
        miCommitVCS = new javax.swing.JMenuItem();
        $objectMap.put("miCommitVCS", miCommitVCS);
        miCommitVCS.setName("miCommitVCS");
        miCommitVCS.setEnabled(false);
        miCommitVCS.setText(_("isisfish.script.menu.commit"));
        miCommitVCS.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miCommitVCS"));
    }

    protected void createMiCopy() {
        miCopy = new javax.swing.JMenuItem();
        $objectMap.put("miCopy", miCopy);
        miCopy.setName("miCopy");
        miCopy.setText(_("isisfish.script.menu.copy"));
        miCopy.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miCopy"));
    }

    protected void createMiCut() {
        miCut = new javax.swing.JMenuItem();
        $objectMap.put("miCut", miCut);
        miCut.setName("miCut");
        miCut.setText(_("isisfish.script.menu.cut"));
        miCut.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miCut"));
    }

    protected void createMiDelete() {
        miDelete = new javax.swing.JMenuItem();
        $objectMap.put("miDelete", miDelete);
        miDelete.setName("miDelete");
        miDelete.setText(_("isisfish.script.menu.deleteLocaly"));
        miDelete.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miDelete"));
    }

    protected void createMiDeleteVCS() {
        miDeleteVCS = new javax.swing.JMenuItem();
        $objectMap.put("miDeleteVCS", miDeleteVCS);
        miDeleteVCS.setName("miDeleteVCS");
        miDeleteVCS.setEnabled(false);
        miDeleteVCS.setText(_("isisfish.script.menu.deleteLocalyServer"));
        miDeleteVCS.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miDeleteVCS"));
    }

    protected void createMiDiffVCS() {
        miDiffVCS = new javax.swing.JMenuItem();
        $objectMap.put("miDiffVCS", miDiffVCS);
        miDiffVCS.setName("miDiffVCS");
        miDiffVCS.setAccelerator(null);
        miDiffVCS.setText(_("isisfish.script.menu.diff"));
        miDiffVCS.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miDiffVCS"));
    }

    protected void createMiEvaluate() {
        miEvaluate = new javax.swing.JMenuItem();
        $objectMap.put("miEvaluate", miEvaluate);
        miEvaluate.setName("miEvaluate");
        miEvaluate.setText(_("isisfish.script.menu.evaluate"));
        miEvaluate.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miEvaluate"));
    }

    protected void createMiExport() {
        miExport = new javax.swing.JMenuItem();
        $objectMap.put("miExport", miExport);
        miExport.setName("miExport");
        miExport.setText(_("isisfish.script.menu.txtExport"));
        miExport.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miExport"));
    }

    protected void createMiGenerateJavadoc() {
        miGenerateJavadoc = new javax.swing.JMenuItem();
        $objectMap.put("miGenerateJavadoc", miGenerateJavadoc);
        miGenerateJavadoc.setName("miGenerateJavadoc");
        miGenerateJavadoc.setText(_("isisfish.script.menu.javadocgenerate"));
        miGenerateJavadoc.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miGenerateJavadoc"));
    }

    protected void createMiImport() {
        miImport = new javax.swing.JMenuItem();
        $objectMap.put("miImport", miImport);
        miImport.setName("miImport");
        miImport.setEnabled(false);
        miImport.setText(_("isisfish.script.menu.txtImport"));
        miImport.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miImport"));
    }

    protected void createMiNewAnalysePlan() {
        miNewAnalysePlan = new javax.swing.JMenuItem();
        $objectMap.put("miNewAnalysePlan", miNewAnalysePlan);
        miNewAnalysePlan.setName("miNewAnalysePlan");
        miNewAnalysePlan.setText(_("isisfish.script.menu.txtNewAnalysePlan"));
        miNewAnalysePlan.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miNewAnalysePlan"));
    }

    protected void createMiNewEquationModel() {
        miNewEquationModel = new javax.swing.JMenuItem();
        $objectMap.put("miNewEquationModel", miNewEquationModel);
        miNewEquationModel.setName("miNewEquationModel");
        miNewEquationModel.setText(_("isisfish.script.menu.txtNewEquationModel"));
        miNewEquationModel.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miNewEquationModel"));
    }

    protected void createMiNewExport() {
        miNewExport = new javax.swing.JMenuItem();
        $objectMap.put("miNewExport", miNewExport);
        miNewExport.setName("miNewExport");
        miNewExport.setText(_("isisfish.script.menu.txtNewExport"));
        miNewExport.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miNewExport"));
    }

    protected void createMiNewRule() {
        miNewRule = new javax.swing.JMenuItem();
        $objectMap.put("miNewRule", miNewRule);
        miNewRule.setName("miNewRule");
        miNewRule.setText(_("isisfish.script.menu.txtNewRule"));
        miNewRule.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miNewRule"));
    }

    protected void createMiNewScript() {
        miNewScript = new javax.swing.JMenuItem();
        $objectMap.put("miNewScript", miNewScript);
        miNewScript.setName("miNewScript");
        miNewScript.setText(_("isisfish.script.menu.txtNewScript"));
        miNewScript.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miNewScript"));
    }

    protected void createMiNewSensitivity() {
        miNewSensitivity = new javax.swing.JMenuItem();
        $objectMap.put("miNewSensitivity", miNewSensitivity);
        miNewSensitivity.setName("miNewSensitivity");
        miNewSensitivity.setText(_("isisfish.script.menu.txtNewSensitivity"));
        miNewSensitivity.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miNewSensitivity"));
    }

    protected void createMiNewSensitivityExport() {
        miNewSensitivityExport = new javax.swing.JMenuItem();
        $objectMap.put("miNewSensitivityExport", miNewSensitivityExport);
        miNewSensitivityExport.setName("miNewSensitivityExport");
        miNewSensitivityExport.setText(_("isisfish.script.menu.txtNewSensitivityExport"));
        miNewSensitivityExport.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miNewSensitivityExport"));
    }

    protected void createMiNewSimulator() {
        miNewSimulator = new javax.swing.JMenuItem();
        $objectMap.put("miNewSimulator", miNewSimulator);
        miNewSimulator.setName("miNewSimulator");
        miNewSimulator.setText(_("isisfish.script.menu.txtNewSimulator"));
        miNewSimulator.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miNewSimulator"));
    }

    protected void createMiPaste() {
        miPaste = new javax.swing.JMenuItem();
        $objectMap.put("miPaste", miPaste);
        miPaste.setName("miPaste");
        miPaste.setText(_("isisfish.script.menu.paste"));
        miPaste.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miPaste"));
    }

    protected void createMiSave() {
        miSave = new javax.swing.JMenuItem();
        $objectMap.put("miSave", miSave);
        miSave.setName("miSave");
        miSave.setText(_("isisfish.script.menu.save"));
        miSave.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miSave"));
    }

    protected void createMiShowJavadoc() {
        miShowJavadoc = new javax.swing.JMenuItem();
        $objectMap.put("miShowJavadoc", miShowJavadoc);
        miShowJavadoc.setName("miShowJavadoc");
        miShowJavadoc.setText(_("isisfish.script.menu.javadocshow"));
        miShowJavadoc.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miShowJavadoc"));
    }

    protected void createMiUpdateVCS() {
        miUpdateVCS = new javax.swing.JMenuItem();
        $objectMap.put("miUpdateVCS", miUpdateVCS);
        miUpdateVCS.setName("miUpdateVCS");
        miUpdateVCS.setEnabled(false);
        miUpdateVCS.setText(_("isisfish.script.menu.update"));
        miUpdateVCS.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__miUpdateVCS"));
    }

    protected void createScriptAction() {
        scriptAction = new ScriptAction(this);
        $objectMap.put("scriptAction", scriptAction);
    }

    protected void createScriptMenuBar() {
        scriptMenuBar = new javax.swing.JMenuBar();
        $objectMap.put("scriptMenuBar", scriptMenuBar);
        scriptMenuBar.setName("scriptMenuBar");
    }

    protected void createScriptNewMenu() {
        scriptNewMenu = new javax.swing.JMenu();
        $objectMap.put("scriptNewMenu", scriptNewMenu);
        scriptNewMenu.setName("scriptNewMenu");
        scriptNewMenu.setText(_("isisfish.script.menu.new"));
    }

    protected void createScriptTxtCode() {
        scriptTxtCode = new javax.swing.JMenu();
        $objectMap.put("scriptTxtCode", scriptTxtCode);
        scriptTxtCode.setName("scriptTxtCode");
        scriptTxtCode.setText(_("isisfish.script.menu.code"));
    }

    protected void createScriptTxtEdit() {
        scriptTxtEdit = new javax.swing.JMenu();
        $objectMap.put("scriptTxtEdit", scriptTxtEdit);
        scriptTxtEdit.setName("scriptTxtEdit");
        scriptTxtEdit.setText(_("isisfish.script.menu.edit"));
    }

    protected void createScriptTxtFile() {
        scriptTxtFile = new javax.swing.JMenu();
        $objectMap.put("scriptTxtFile", scriptTxtFile);
        scriptTxtFile.setName("scriptTxtFile");
        scriptTxtFile.setText(_("isisfish.script.menu.file"));
    }

    protected void createScriptTxtVCS() {
        scriptTxtVCS = new javax.swing.JMenu();
        $objectMap.put("scriptTxtVCS", scriptTxtVCS);
        scriptTxtVCS.setName("scriptTxtVCS");
        scriptTxtVCS.setText(_("isisfish.script.menu.txtVCS"));
    }

    protected void createScriptTypeChoice() {
        scriptTypeChoice = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("scriptTypeChoice", scriptTypeChoice);
        scriptTypeChoice.setName("scriptTypeChoice");
    }

    protected void createSingleFileSelected() {
        singleFileSelected = false;
        $objectMap.put("singleFileSelected", singleFileSelected);
    }

    protected void createTextSelected() {
        textSelected = false;
        $objectMap.put("textSelected", textSelected);
    }

    protected void createTree() {
        tree = new jaxx.runtime.swing.JAXXTree();
        $objectMap.put("tree", tree);
        tree.setName("tree");
        tree.setName("tree");
        tree.setRootVisible(false);
    }

}
