/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.script;

import fr.ifremer.isisfish.ui.script.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportDialogUI extends javax.swing.JDialog implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(fr.ifremer.isisfish.ui.script.ImportDialogUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWzW8bRRSfuHUS54s2DeVDreS0FlBI14kh4iMVkKSJsHGgaoIU4Qvj3bF3mvHOdvZtsqECIXFFqCcOXABx5cgdIY49ceV/QIj/gDe7tjfrOusVzmHsvI/f/N57+37rX/4meU+R5Qc0CAzlO8A7zKhtHh5+3HzATLjLPFNxF6Qi0d9EjuQaZNbq2z0gNxt1nV7uppe3ZceVDnPOZG/UyYwHp4J5NmMA5Nkow/S88n7fvBG4vuqh9ckMQ/vx339yj62vfsoRErjIaglLKI7Kiiu4WCc5bgFZxJuOaVlQp400FHfayHNe27YF9byPaIc9JF+SqTqZdKlCMCA3spcaYoT5gQukUKrd5VTI9iqQlZYyeEuxDsNPj3st7tmGz40IwqgipoIo+pOq64Ygk0jXYSe7HJt1QJuC7UmLCSDr6Vg6fp8JHCWXTpwXgz5nSqcluAkDyNq9EIcV5NGOo53Ytsu6Q4bumrElpWDUiePmkGMVWGen48Kptl2JfZd7V50XUGhKsIc5pkohsTUgzyem7J3gzIzQpyMLgwkV/e81fbzYd833ulinTd3ARV1N0IWqhUYdeT1OKNX2TSWFuEcd9jp2LJEQuwayEsMavKZP+UY83cQg+jyWU8i8oY2lZMDi0/PUnpf18Wo/apYq0+bH7B4FG8jVJDcWYDITVrJv06WavlOsD9YSWpOxl0ybmUebQmzrz6YMcOMTOaF9SwY6fi2+Qh5t+QDSAXIlER5Zk8FzJnVMJmLX212/0sn4kKC4GLG4xNs/0SB55aMZeTZiHbqPpkiButYQILT+8PX3x9/9+ts7Pbl5Ae+YT4ScUUdcf1dJlyng+opnIo3xgYvyHnU3GqTghfsYSufSGQL7XTOSQPxoyXSa8QH1bEzNT/31+x9XP/vzAsntkhkhqbVLdXyVFMBWWKUUVuC+937IZO5kGs9LmhOQmZZUrK2k7+D2Lj/CJ7MYotMTQKEUUr2yur62srZaWalU1m99EWAPls70oE/syeNv9q59e/3NXh8mIp4DYXEv8p+SSe4I7rBQcLtaOlRgZ12P+ZaMNXOYipLB7XW7ErEZnjsja7+gmBX4OrYa0tffPiRDdy8DdL4jLaoV5E5UZJECvkSaPrB3n7pkQp8zGUALOEn+eW9tD/8/UB44jA1SaOEy3kZCaUDFDEAXAVVlTIypY3zBhWK6cMeiQItN7lioD+d0ezSkNj/UhxqOcDMDqQXqg7yvZxa+N1PQXsrEp53SpFuZEMTYCGk9GR/htUwIj1IQbmeYyzSzOIxYo3IGnEmb8bad9uhmQhH0VPqQUlMlywKw6CdYCsx6ltZEL6AI55yiRuOMetSyMJkF/P14wN2DdHHIRubnlLa8NXY54yNsIMJ/uw6N828NAAA=";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected javax.swing.JTextField archivePath;
    protected java.lang.Boolean bothEmpty;
    protected javax.swing.JButton cancelButton;
    protected javax.swing.JCheckBox checkAllCheckbox;
    protected javax.swing.JLabel conflictFilesLabel;
    protected javax.swing.JTable conflictFilesTable;
    protected fr.ifremer.isisfish.ui.script.FileSelectionTableModel conflictFilesTableModel;
    protected java.lang.Boolean conflictItemEmpty;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected javax.swing.JLabel newFilesLabel;
    protected javax.swing.JTable newFilesTable;
    protected fr.ifremer.isisfish.ui.script.FileSelectionTableModel newFilesTableModel;
    protected java.lang.Boolean newItemEmpty;
    protected javax.swing.JButton okButton;
    protected java.lang.Boolean okEnabled;
    private fr.ifremer.isisfish.ui.script.ImportDialogUI $JDialog0 = this;
    private javax.swing.JPanel $JPanel5;
    private javax.swing.JScrollPane $JScrollPane3;
    private javax.swing.JScrollPane $JScrollPane4;
    private jaxx.runtime.swing.Table $Table1;
    private jaxx.runtime.swing.Table $Table2;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource10 = new jaxx.runtime.DataBindingListener($JDialog0, "$JScrollPane4.visible");
    private java.beans.PropertyChangeListener $DataSource13 = new jaxx.runtime.DataBindingListener($JDialog0, "checkAllCheckbox.enabled");
    private java.beans.PropertyChangeListener $DataSource14 = new jaxx.runtime.DataBindingListener($JDialog0, "okButton.enabled");
    private java.beans.PropertyChangeListener $DataSource6 = new jaxx.runtime.DataBindingListener($JDialog0, "newFilesLabel.visible");
    private java.beans.PropertyChangeListener $DataSource7 = new jaxx.runtime.DataBindingListener($JDialog0, "$JScrollPane3.visible");
    private java.beans.PropertyChangeListener $DataSource9 = new jaxx.runtime.DataBindingListener($JDialog0, "conflictFilesLabel.visible");

    /* begin raw body code */
    /*public boolean isOkEnabled() {
            return (!isConflictItemEmpty() && !conflictFilesTableModel.getSelectedFiles().isEmpty()) ||
                    (!isNewItemEmpty() && !newFilesTableModel.getSelectedFiles().isEmpty());
        }*/
    
        public void refresh() {
            setConflictItemEmpty(conflictFilesTableModel.getRowCount() == 0);
            setNewItemEmpty(newFilesTableModel.getRowCount() == 0);
            setBothEmpty(isConflictItemEmpty() && isNewItemEmpty());
            
            setOkEnabled((!isConflictItemEmpty() && !conflictFilesTableModel.getSelectedFiles().isEmpty()) ||
                    (!isNewItemEmpty() && !newFilesTableModel.getSelectedFiles().isEmpty()));
        }
    
        public void doCheckAll() {
            boolean selection = checkAllCheckbox.isSelected();
            newFilesTableModel.setAllChecked(selection);
            conflictFilesTableModel.setAllChecked(selection);
        }
        
        protected void performImport() {
        	File archiveFile = new File(archivePath.getText());
        	getContextValue(ScriptAction.class).performImportScript(archiveFile, newFilesTableModel, conflictFilesTableModel);
        }
        
        protected void cancel() {
            hide();
        }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public ImportDialogUI() {
        $initialize();
    }

    public ImportDialogUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("newFilesLabel.visible".equals($binding)) {
                addPropertyChangeListener("newItemEmpty", $DataSource6);
        
        } else if ("$JScrollPane3.visible".equals($binding)) {
                addPropertyChangeListener("newItemEmpty", $DataSource7);
        
        } else if ("conflictFilesLabel.visible".equals($binding)) {
                addPropertyChangeListener("conflictItemEmpty", $DataSource9);
        
        } else if ("$JScrollPane4.visible".equals($binding)) {
                addPropertyChangeListener("conflictItemEmpty", $DataSource10);
        
        } else if ("checkAllCheckbox.enabled".equals($binding)) {
                addPropertyChangeListener("bothEmpty", $DataSource13);
        
        } else if ("okButton.enabled".equals($binding)) {
                addPropertyChangeListener("okEnabled", $DataSource14);
        
        }
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("newFilesLabel.visible".equals($dest)) {
            newFilesLabel.setVisible((!isNewItemEmpty()));
            } else if ("$JScrollPane3.visible".equals($dest)) {
            $JScrollPane3.setVisible((!isNewItemEmpty()));
            } else if ("conflictFilesLabel.visible".equals($dest)) {
            conflictFilesLabel.setVisible((!isConflictItemEmpty()));
            } else if ("$JScrollPane4.visible".equals($dest)) {
            $JScrollPane4.setVisible((!isConflictItemEmpty()));
            } else if ("checkAllCheckbox.enabled".equals($dest)) {
            checkAllCheckbox.setEnabled((!isBothEmpty()));
            } else if ("okButton.enabled".equals($dest)) {
            okButton.setEnabled((isOkEnabled()));
            }} finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("newFilesLabel.visible".equals($binding)) {
                removePropertyChangeListener("newItemEmpty", $DataSource6);
        
        } else if ("$JScrollPane3.visible".equals($binding)) {
                removePropertyChangeListener("newItemEmpty", $DataSource7);
        
        } else if ("conflictFilesLabel.visible".equals($binding)) {
                removePropertyChangeListener("conflictItemEmpty", $DataSource9);
        
        } else if ("$JScrollPane4.visible".equals($binding)) {
                removePropertyChangeListener("conflictItemEmpty", $DataSource10);
        
        } else if ("checkAllCheckbox.enabled".equals($binding)) {
                removePropertyChangeListener("bothEmpty", $DataSource13);
        
        } else if ("okButton.enabled".equals($binding)) {
                removePropertyChangeListener("okEnabled", $DataSource14);
        
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(java.awt.event.ActionEvent event) {
        cancel();
    }

    public void doActionPerformed__on__checkAllCheckbox(java.awt.event.ActionEvent event) {
        doCheckAll();
    }

    public void doMouseClicked__on__conflictFilesTable(java.awt.event.MouseEvent event) {
        refresh();
    }

    public void doMouseClicked__on__newFilesTable(java.awt.event.MouseEvent event) {
        refresh();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JTextField getArchivePath() {
        return archivePath;
    }

    public java.lang.Boolean getBothEmpty() {
        return bothEmpty;
    }

    public javax.swing.JButton getCancelButton() {
        return cancelButton;
    }

    public javax.swing.JCheckBox getCheckAllCheckbox() {
        return checkAllCheckbox;
    }

    public javax.swing.JLabel getConflictFilesLabel() {
        return conflictFilesLabel;
    }

    public javax.swing.JTable getConflictFilesTable() {
        return conflictFilesTable;
    }

    public fr.ifremer.isisfish.ui.script.FileSelectionTableModel getConflictFilesTableModel() {
        return conflictFilesTableModel;
    }

    public java.lang.Boolean getConflictItemEmpty() {
        return conflictItemEmpty;
    }

    public javax.swing.JLabel getNewFilesLabel() {
        return newFilesLabel;
    }

    public javax.swing.JTable getNewFilesTable() {
        return newFilesTable;
    }

    public fr.ifremer.isisfish.ui.script.FileSelectionTableModel getNewFilesTableModel() {
        return newFilesTableModel;
    }

    public java.lang.Boolean getNewItemEmpty() {
        return newItemEmpty;
    }

    public javax.swing.JButton getOkButton() {
        return okButton;
    }

    public java.lang.Boolean getOkEnabled() {
        return okEnabled;
    }

    public java.lang.Boolean isBothEmpty() {
        return bothEmpty !=null && bothEmpty;
    }

    public java.lang.Boolean isConflictItemEmpty() {
        return conflictItemEmpty !=null && conflictItemEmpty;
    }

    public java.lang.Boolean isNewItemEmpty() {
        return newItemEmpty !=null && newItemEmpty;
    }

    public java.lang.Boolean isOkEnabled() {
        return okEnabled !=null && okEnabled;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBothEmpty(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.bothEmpty;
        this.bothEmpty = newValue;
        firePropertyChange("bothEmpty", oldValue, newValue);
    }

    public void setConflictFilesTableModel(fr.ifremer.isisfish.ui.script.FileSelectionTableModel newValue) {
        fr.ifremer.isisfish.ui.script.FileSelectionTableModel oldValue = this.conflictFilesTableModel;
        this.conflictFilesTableModel = newValue;
        firePropertyChange("conflictFilesTableModel", oldValue, newValue);
    }

    public void setConflictItemEmpty(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.conflictItemEmpty;
        this.conflictItemEmpty = newValue;
        firePropertyChange("conflictItemEmpty", oldValue, newValue);
    }

    public void setNewFilesTableModel(fr.ifremer.isisfish.ui.script.FileSelectionTableModel newValue) {
        fr.ifremer.isisfish.ui.script.FileSelectionTableModel oldValue = this.newFilesTableModel;
        this.newFilesTableModel = newValue;
        firePropertyChange("newFilesTableModel", oldValue, newValue);
    }

    public void setNewItemEmpty(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.newItemEmpty;
        this.newItemEmpty = newValue;
        firePropertyChange("newItemEmpty", oldValue, newValue);
    }

    public void setOkEnabled(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.okEnabled;
        this.okEnabled = newValue;
        firePropertyChange("okEnabled", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.script.ImportDialogUI get$JDialog0() {
        return $JDialog0;
    }

    protected javax.swing.JPanel get$JPanel5() {
        return $JPanel5;
    }

    protected javax.swing.JScrollPane get$JScrollPane3() {
        return $JScrollPane3;
    }

    protected javax.swing.JScrollPane get$JScrollPane4() {
        return $JScrollPane4;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $JDialog0.getContentPane().add($Table1);
        
        $Table1.add($Table2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(archivePath, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JPanel5, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        $Table2.add(newFilesLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JScrollPane3, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(conflictFilesLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JScrollPane4, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        $JScrollPane3.getViewport().add(newFilesTable);
        
        $JScrollPane4.getViewport().add(conflictFilesTable);
        
        $JPanel5.add(checkAllCheckbox);
        $JPanel5.add(okButton);
        $JPanel5.add(cancelButton);
        
        applyDataBinding("newFilesLabel.visible");
        applyDataBinding("$JScrollPane3.visible");
        newFilesTable.setAutoResizeMode((JTable.AUTO_RESIZE_LAST_COLUMN));
        applyDataBinding("conflictFilesLabel.visible");
        applyDataBinding("$JScrollPane4.visible");
        conflictFilesTable.setAutoResizeMode((JTable.AUTO_RESIZE_LAST_COLUMN));
        applyDataBinding("checkAllCheckbox.enabled");
        applyDataBinding("okButton.enabled");
        newFilesLabel.setForeground((new java.awt.Color(051,102,225)));
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JDialog0", this);
        createNewFilesTableModel();
        createConflictFilesTableModel();
        createOkEnabled();
        createNewItemEmpty();
        createConflictItemEmpty();
        createBothEmpty();
        
        $Table1 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table1", $Table1);
        $Table1.setName("$Table1");
        
        $Table2 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table2", $Table2);
        $Table2.setName("$Table2");
        
        createNewFilesLabel();
        
        $JScrollPane3 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane3", $JScrollPane3);
        $JScrollPane3.setName("$JScrollPane3");
        
        createNewFilesTable();
        createConflictFilesLabel();
        
        $JScrollPane4 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane4", $JScrollPane4);
        $JScrollPane4.setName("$JScrollPane4");
        
        createConflictFilesTable();
        createArchivePath();
        
        $JPanel5 = new javax.swing.JPanel();
        $objectMap.put("$JPanel5", $JPanel5);
        $JPanel5.setName("$JPanel5");
        $JPanel5.setLayout((new GridLayout(0, 3, 2, 2)));
        
        createCheckAllCheckbox();
        createOkButton();
        createCancelButton();
        $JDialog0.setName("$JDialog0");
        $JDialog0.setModal(true);
        $JDialog0.setResizable(false);
        $JDialog0.setTitle(_("isisfish.script.import"));
        
        
        $completeSetup();
    }

    protected void createArchivePath() {
        archivePath = new javax.swing.JTextField();
        $objectMap.put("archivePath", archivePath);
        archivePath.setName("archivePath");
        archivePath.setColumns(15);
        archivePath.setEditable(false);
        jaxx.runtime.Util.setComponentHeight(archivePath,25);
    }

    protected void createBothEmpty() {
        bothEmpty = false;
        $objectMap.put("bothEmpty", bothEmpty);
    }

    protected void createCancelButton() {
        cancelButton = new javax.swing.JButton();
        $objectMap.put("cancelButton", cancelButton);
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("isisfish.script.import.cancel"));
        cancelButton.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__cancelButton"));
    }

    protected void createCheckAllCheckbox() {
        checkAllCheckbox = new javax.swing.JCheckBox();
        $objectMap.put("checkAllCheckbox", checkAllCheckbox);
        checkAllCheckbox.setName("checkAllCheckbox");
        checkAllCheckbox.setSelected(true);
        checkAllCheckbox.setText(_("isisfish.script.import.checkAll"));
        checkAllCheckbox.setToolTipText(_("isisfish.script.import.tooltip.checkAll"));
        checkAllCheckbox.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__checkAllCheckbox"));
    }

    protected void createConflictFilesLabel() {
        conflictFilesLabel = new javax.swing.JLabel();
        $objectMap.put("conflictFilesLabel", conflictFilesLabel);
        conflictFilesLabel.setName("conflictFilesLabel");
        if (conflictFilesLabel.getFont() != null) conflictFilesLabel.setFont(conflictFilesLabel.getFont().deriveFont((float) 12));
        conflictFilesLabel.setText(_("isisfish.script.import.labelOverwrite"));
        conflictFilesLabel.setForeground(new Color(255, 0, 0));
    }

    protected void createConflictFilesTable() {
        conflictFilesTable = new javax.swing.JTable();
        $objectMap.put("conflictFilesTable", conflictFilesTable);
        conflictFilesTable.setName("conflictFilesTable");
        conflictFilesTable.addMouseListener((java.awt.event.MouseListener) jaxx.runtime.Util.getEventListener(java.awt.event.MouseListener.class, "mouseClicked", $JDialog0, "doMouseClicked__on__conflictFilesTable"));
    }

    protected void createConflictFilesTableModel() {
        conflictFilesTableModel = null;
        $objectMap.put("conflictFilesTableModel", conflictFilesTableModel);
    }

    protected void createConflictItemEmpty() {
        conflictItemEmpty = false;
        $objectMap.put("conflictItemEmpty", conflictItemEmpty);
    }

    protected void createNewFilesLabel() {
        newFilesLabel = new javax.swing.JLabel();
        $objectMap.put("newFilesLabel", newFilesLabel);
        newFilesLabel.setName("newFilesLabel");
        if (newFilesLabel.getFont() != null) newFilesLabel.setFont(newFilesLabel.getFont().deriveFont((float) 12));
        newFilesLabel.setText(_("isisfish.script.import.labelAdd"));
    }

    protected void createNewFilesTable() {
        newFilesTable = new javax.swing.JTable();
        $objectMap.put("newFilesTable", newFilesTable);
        newFilesTable.setName("newFilesTable");
        newFilesTable.addMouseListener((java.awt.event.MouseListener) jaxx.runtime.Util.getEventListener(java.awt.event.MouseListener.class, "mouseClicked", $JDialog0, "doMouseClicked__on__newFilesTable"));
    }

    protected void createNewFilesTableModel() {
        newFilesTableModel = null;
        $objectMap.put("newFilesTableModel", newFilesTableModel);
    }

    protected void createNewItemEmpty() {
        newItemEmpty = false;
        $objectMap.put("newItemEmpty", newItemEmpty);
    }

    protected void createOkButton() {
        okButton = new javax.swing.JButton();
        $objectMap.put("okButton", okButton);
        okButton.setName("okButton");
        okButton.setText(_("isisfish.script.import.import"));
    }

    protected void createOkEnabled() {
        okEnabled = false;
        $objectMap.put("okEnabled", okEnabled);
    }

}
