/*
 * #%L
 * IsisFish
 * 
 * $Id: SensitivityCalculatorComboModel.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.sensitivity;

import java.util.List;

import javax.swing.DefaultComboBoxModel;

/**
 * Model pour la liste des calculateurs de sensibilite.
 *
 * @author chatellier
 * @version $Revision: 3124 $
 * 
 * Last update : $Date: 2010-11-29 19:14:09 +0100 (lun., 29 nov. 2010) $
 * By : $Author: chatellier $
 */
public class SensitivityCalculatorComboModel extends DefaultComboBoxModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    /** SensitivityCalculator names. */
    protected List<String> sensitivityCalculatorNames;

    /**
     * Empty constructor.
     */
    public SensitivityCalculatorComboModel() {
        this(null);
    }

    /**
     * Constructor with calculator list.
     * 
     * @param sensitivityCalculatorNames sensitivity calculator Names
     */
    public SensitivityCalculatorComboModel(List<String> sensitivityCalculatorNames) {
        super();
        setSensitivityCalculatorNames(sensitivityCalculatorNames);
    }

    /**
     * Get analyze plan names.
     * 
     * @return the analyze plan names
     */
    public List<String> getSensitivityCalculatorNames() {
        return sensitivityCalculatorNames;
    }

    /**
     * Set sensitivity names.
     * 
     * @param sensitivityCalculatorNames the names to set
     */
    public void setSensitivityCalculatorNames(List<String> sensitivityCalculatorNames) {
        this.sensitivityCalculatorNames = sensitivityCalculatorNames;

        // default first selected
        /* disable default selection
        if (!sensitivityCalculatorNames.isEmpty()) {
            setSelectedItem(sensitivityCalculatorNames.get(0));
        }*/
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return sensitivityCalculatorNames.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (sensitivityCalculatorNames != null) {
            size = sensitivityCalculatorNames.size();
        }
        return size;
    }
}
