/*
 * #%L
 * IsisFish
 * 
 * $Id: AnalyzePlanParametersTableCellEditor.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.analyzeplan;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import fr.ifremer.isisfish.datastore.AnalysePlanStorage;
import fr.ifremer.isisfish.simulator.AnalysePlan;
import fr.ifremer.isisfish.ui.widget.editor.ParameterTableCellEditor;

/**
 * Specific editor for rule parameters.
 *
 * @author chatellier
 * @version $Revision: 3124 $
 * 
 * Last update : $Date: 2010-11-29 19:14:09 +0100 (lun., 29 nov. 2010) $
 * By : $Author: chatellier $
 */
public class AnalyzePlanParametersTableCellEditor extends
        ParameterTableCellEditor {

    /** serialVersionUID. */
    private static final long serialVersionUID = 8211639776194497615L;

    protected AnalysePlan plan;

    protected List<Class<?>> planParametersTypes;

    /**
     * Constructor with rule parameter.
     * 
     * @param plan plan
     */
    public AnalyzePlanParametersTableCellEditor(AnalysePlan plan) {
        super();

        this.plan = plan;
        planParametersTypes = new ArrayList<Class<?>>();
        //TODO map may be sorted
        Map<String, Class<?>> planParametersNamesAndTypes = AnalysePlanStorage
                .getParameterNames(plan);
        for (Class<?> type : planParametersNamesAndTypes.values()) {
            planParametersTypes.add(type);
        }
    }

    /*
     * @see fr.ifremer.isisfish.ui.widget.editor.ParameterTableCellEditor#getType(java.lang.Object, int, int)
     */
    @Override
    protected Class<?> getType(Object value, int row, int column) {
        return planParametersTypes.get(row);
    }
}
